(function(window){
	"use strict";

window.Targeting = function() {
	/**
	 * @type {object}
	 */
	var ge_view = null;
	var user = null;

	var amqTargetingTopic = 'topic://amq.gis.topic';

	var amqTargeting;

	var oldMessageAttrId = null;
	var oldMessageAttrUsid = null;

	return {
		amqTargetingHandler: function(xmlString)
		{
			var xmlDoc;
			if (window.DOMParser) {
				var parser = new DOMParser();
				xmlDoc = parser.parseFromString(xmlString, "text/xml");
			} else {
				// Internet Explorer
				xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
				xmlDoc.async = false;
				xmlDoc.loadXML(xmlString);
			}

			if (xmlDoc.getElementsByTagName("message").length == 0)
			{
				return;
			}

			var message = xmlDoc.getElementsByTagName("message")[0];

			var type = message.getAttribute('type');
			var from = message.getAttribute('from');
			var uid = message.getAttribute('uid');

			switch (type) {
				// Incoming amqTargeting message
				case 'targetInit' :
				{
					break;
				}

				case 'targetRegister' :
				{
					if(jsTargetingLiveMode)
					{
						var uId = message.getAttribute("userId");
						var uNm = message.getAttribute("userName");
						var sId = message.getAttribute("sessionId");
						var tId = message.getAttribute("targetId");
						var tSi = message.getAttribute("targetSymbolId");

						if (jsSessionId != sId)
						{
							var params = {
								userId: uId,
								userName: uNm,
								sessionId: sId,
								objId: message.getAttribute("objId"),
								image: {
									x: parseFloat(message.getAttribute("imageX")),
									y: parseFloat(message.getAttribute("imageY"))
								},
								target: {
									id: tId,
									symbolId: tSi,
									symbolDescr: message.getAttribute("targetSymbolDescr"),
									latitude: parseFloat(message.getAttribute("targetLatitude")),
									longitude: parseFloat(message.getAttribute("targetLongitude")),
									altitude: parseFloat(message.getAttribute("targetAltitude")),
									distance: parseFloat(message.getAttribute("targetDistance")),
									type: message.getAttribute("targetType"),
									speed: parseFloat(message.getAttribute("targetSpeed")),
									course: parseFloat(message.getAttribute("targetCourse")),
									source: message.getAttribute("targetSource")
								}
							};

							if( message.getAttribute("propChange") == "undefined")
							{
								ge_view.targetingTargetSet(params);
							} else {
								ge_view.targetingChangeTargetPropDisplay(params)
							}
						}

						mx.GE.designation.targetListUpdate(message);
					}
					break;
				}

				case 'targetingUgsResponse' :
				{
					if(jsTargetingLiveMode)
					{
						//  <message type='targetingUgsResponse' time='1312917247' id='IS_1.573_Person' lat='47.7415' lon='-114.4487' target='1' speed='null' course='null' />
						var params = {
							target: {
								id: message.getAttribute("id"),
								symbolId: "SUGPESE---",
								symbolDescr: "desc",
								latitude: parseFloat(message.getAttribute("lat")),
								longitude: parseFloat(message.getAttribute("lon")),
								altitude: 0.0,
								distance: null,
								type: message.getAttribute("target"),
								speed: parseFloat(message.getAttribute("speed")), // speed: [m/s]
								course: parseFloat(message.getAttribute("course")), // course: [deg] relative to north
								source: "UGS"
							}
						};

						ge_view.targetingTargetSet(params);

						mx.GE.designation.targetListUpdate(message);
					}
					break;
				}

				case 'targetingRadarResponse' :
				{
					if(jsTargetingLiveMode)
					{
						var params = {
							target: {
								id: message.getAttribute("id"),
								symbolId: "SUGPESR---",
								symbolDescr: "desc",
								latitude: parseFloat(message.getAttribute("lat")),
								longitude: parseFloat(message.getAttribute("lon")),
								altitude: 0.0,
								distance: null,
								type: message.getAttribute("target"),
								source: "Avatar"
							}
						};

						ge_view.targetingTargetSet(params);

						mx.GE.designation.targetListUpdate(message);
					}

					break;
				}

				case 'gisTrgtAvatarResponse' :
				{
					if(jsTargetingLiveMode)
					{
						var objId = parseInt(message.getAttribute("objid"), 10);
						var altMode = "relative_to_ground";
						var lat = parseFloat(message.getAttribute("lat"));
						var lon = parseFloat(message.getAttribute("lon"));
						var alt = 5.0;

						// cameraCheckPosition(objId, altMode, lat, lon, alt);

						/*
						var params = {
							target: {
								id: message.getAttribute("id"),
								symbolId: "SUGPEVCJL-",
								symbolDescr: "desc",
								latitude: parseFloat(message.getAttribute("lat")),
								longitude: parseFloat(message.getAttribute("lon")),
								altitude: 0.0,
								distance: null,
								type: message.getAttribute("target"),
								speed: null, // speed: [m/s]
								course: null, // course: [deg] relative to north
								source: "Avatar"
							}
						};

						targetingTargetSet(params);

						message.setAttribute("userId", "-1");
						message.setAttribute("userName", "Avatar");
						message.setAttribute("sessionId", "AvatarCustomSessionID");
						message.setAttribute("targetId", message.getAttribute("id"));
						message.setAttribute("targetSymbolId", "SUGPEVCJL-");
						message.setAttribute("objId", message.getAttribute("objid"));

						mx.GE.designation.targetListUpdate(message);
						*/
					}

					break;
				}

				case 'gisTrgtMobileResponse' :
				{
					if(jsTargetingLiveMode)
					{
						var objId = parseInt(message.getAttribute("objid"), 10);
						var altMode = "relative_to_ground";
						var lat = parseFloat(message.getAttribute("lat"));
						var lon = parseFloat(message.getAttribute("lon"));
						var alt = 5.0;

						// cameraCheckPosition(objId, altMode, lat, lon, alt);

						/*
						var params = {
							target: {
								id: message.getAttribute("id"),
								symbolId: "SUGPESE---",
								symbolDescr: "desc",
								latitude: parseFloat(message.getAttribute("lat")),
								longitude: parseFloat(message.getAttribute("lon")),
								altitude: 0.0,
								distance: null,
								type: message.getAttribute("target"),
								speed: null, // speed: [m/s]
								course: null, // course: [deg] relative to north
								source: "Mobile"
							}
						};

						targetingTargetSet(params);

						message.setAttribute("userId", "-1");
						message.setAttribute("userName", "Mobile");
						message.setAttribute("sessionId", "MobileCustomSessionID");
						message.setAttribute("targetId", message.getAttribute("id"));
						message.setAttribute("targetSymbolId", "SUGPESE---");
						message.setAttribute("objId", message.getAttribute("objid"));

						mx.GE.designation.targetListUpdate(message);
						*/
					}

					break;
				}

				case 'gisTrgtRadarFov' :
				{
					if(jsTargetingLiveMode)
					{
						ge_view.targetingRadarFovSet(message);
					}

					break;
				}

				case 'amqGisPtzStompResponse' :
				{
					if(jsTargetingLiveMode)
					{
						if( (message.getAttribute("id") != oldMessageAttrId) && (message.getAttribute("usid") != oldMessageAttrUsid) ) {
							oldMessageAttrId = message.getAttribute("id");
							oldMessageAttrUsid = message.getAttribute("usid");

							//resetData();
							// usid containr requestor properties:
							// 0 => userId
							// 1 => sessionId
							// 2 => objId
							// 3 => cameraWidth
							// 4 => cameraHeight
							// 5 => clickX
							// 6 => clickY
							var jsUsid = message.getAttribute("usid").split("_");

							// get camera info
							var camera = resourceTree.getObject(jsUsid[2]);

							// now we can get any info about camera, ex.:
							// camera.attr('cam_geo_calibration')
							// camera.attr('cam_geo_lat')
							// camera.attr('cam_geo_long')
							// camera.attr('cam_geo_alt')
							// camera.attr('cam_geo_north_offset')
							// camera.attr('imagesize') // 704x480

							if (jsSessionId == jsUsid[1]) {
								if (camera.attr('CAM_GEO_CALIBRATION') == 'no')
								{
									alert(__("Object's Geo location is undefined"));
								} else {
									//gMap = new GMap();
									var gm = new GMap();
									var camLatDeg = parseFloat(camera.attr('CAM_GEO_LAT'));
									var camLongDeg = parseFloat(camera.attr('CAM_GEO_LONG'));
									var camH = parseFloat(camera.attr('CAM_GEO_ALT'));
									var resX = parseFloat(jsUsid[3]);
									var resY = parseFloat(jsUsid[4]);
									var FOV_X = parseFloat(message.getAttribute('fov'));
									var FOV_Y = FOV_X * (resY / resX);
									var camTiltDeg = parseFloat(message.getAttribute('el'));
									var camAzDeg = parseFloat(message.getAttribute('az'));
									var pixX = parseFloat(jsUsid[5]);
									var pixY = parseFloat(jsUsid[6]);
									var camZoom = message.getAttribute('zoom');
									var camFocus = message.getAttribute('focus');
									var camRange = parseFloat(message.getAttribute('range'));
									var GEO_CALIBRATOR_CONFIG = JSON.parse(camera.attr('GEO_CALIBRATOR_CONFIG'));
									if (!GEO_CALIBRATOR_CONFIG[jsUsid[2]])
									{
										break;
									}

									var homography = GEO_CALIBRATOR_CONFIG[jsUsid[2]].H;

									var parameters = {
										fovX: FOV_X,
										fovY: FOV_Y,
										tiltAngel: camTiltDeg,
										azimuthAngle: camAzDeg,
										latitude: camLatDeg,
										longitude: camLongDeg,
										height: camH, // height relative to ground
										resolution: {
											width: resX,
											height: resY
										},
										homography: homography
									};
									gm.setCameraParameters(parameters);
									gm.markTarget(pixX, pixY)
										.done(function(latitude, longitude, h0, distance){
											// success

											var params = gm.getParameters();

											params.userId = jsUserId;
											params.userName = jsUserName;
											params.sessionId = jsSessionId;
											params.objId = jsUsid[2];

											params.camera.zoom = camZoom;
											params.camera.focus = camFocus;
											params.camera.rangeFinderValue = camRange;

											params.target.id = jsTargetingCurrentId;
											params.target.symbolId = "SUZP------";
											params.target.symbolDescr = "desc";
											params.target.type = null;
											params.target.speed = null;
											params.target.course = null;
											params.target.source = "vGeoRef";

											// LRF (Laser Range Finder) section
											if(camRange > 0)
											{
												params.target.source = "LRF";

												//var lat_c = camLatDeg * Math.PI / 180.0;
												//var lon_c = camLongDeg * Math.PI / 180.0;
												var lat_c = camLatDeg;
												var lon_c = camLongDeg;
												var distance = camRange * Math.cos(camTiltDeg * Math.PI / 180.0);
												var radial = camAzDeg  * Math.PI / 180.0;
												var ptll = latlonByDistanceRadial(lat_c, lon_c, distance, radial);
												params.target.latitude = ptll[0] * 180.0 / Math.PI;
												params.target.longitude = ptll[1] * 180.0 / Math.PI;
											}

											ge_view.targetingTargetSet(params);
										});

									mx.GE.designation.targetListUpdate(message);
								}
							}
						}
					}
					break;
				}

				/*
				case 'amqGisResetArchiveResponse' :
				{
					if(jsSessionId == message.getAttribute("sid")) {
						alert("All stored GIS data was successfully deleted by:\n- me");
					} else {
						alert("All stored GIS data was successfully deleted by:\n- UserID: "+message.getAttribute("uid")+"\n- SessionID: "+message.getAttribute("sid"));
					}
					break;
				}
				*/

				case 'targetArchResponse' :
				{
					var sid = message.getAttribute("sid");

					if(jsSessionId == sid)
					{
						var msgCombined = "";

						for(var i=0; i<message.childNodes.length; i++) {
							msgCombined += message.childNodes[i].data;
						}

						ge_view.targetingArchiveTargetsShow(msgCombined);
					}

					break;
				}

				case 'targetArchSingleTrailResponse' :
				{
					var sid = message.getAttribute("sid");

					if(jsSessionId == sid)
					{
						var msgCombined = "";
						for(var i=0; i<message.childNodes.length; i++) {
							msgCombined += message.childNodes[i].data;
						}

						ge_view.targetingArchiveSingleTrailShow(msgCombined);
					}

					break;
				}

				case 'amqAnalytics' :
				{
					var objId = message.getAttribute("objid");
					var targetId = message.getAttribute("targetid");
					var camWidth = parseFloat(message.getAttribute("camwidth"));
					var camHeight = parseFloat(message.getAttribute("camheight"));
					var xcoord = parseFloat(message.getAttribute("xcoord"));
					var ycoord = parseFloat(message.getAttribute("ycoord"));

					mx.GE.designation.onCameraClick(objId, camWidth, camHeight, xcoord, ycoord, targetId);

					break;
				}

				case 'amqPingResponse' :
				{
					var attrSid = message.getAttribute("sid");

					if(jsSessionId == attrSid )
					{
						window.amqPingTimeoutSend = (new Date()).getTime();
					}
				}

				// Incoming ping request, add the person's name to your list.
				case 'ping' :
				{
					//amqTargeting.value += 'from:' + from.slice(from.length-8) + ' msg: PING \n';
					break;
				}

				case 'join' :
				{
					//if (user != null)
					//	this.sendMessage('<message type="ping" from="' + user + '"/>');
					break;
				}

				// todo: Make this more efficient by simply removing the person's name from the list.
				case 'leave':
				{
					amq.removeListener('amqTargeting', amqTargetingTopic);
					this.sendMessage('<message type="ping" from="' + user + '"/>');
					break;
				}
			}
		},

		join: function() {
			//var name = jsSessionId;
			//if (name == null || name.length == 0) {
			//	alert('AMQ -- Please enter a username!');
			//} else {
			//	user = name;
			//	amq.addListener('amqTargeting', amqTargetingTopic, amqTargetingHandler);
			//	this.sendMessage('<message type="join" from="' + user + '"/>');
			//}
		},

		leave: function() {
			this.sendMessage('<message type="leave" from="' + user + '"/>');
		},

		targetRegister: function(params)
		{
			if(jsTargetingLiveMode)
			{
				var xmlKeys = {};
				xmlKeys.type = "targetRegister";
				xmlKeys.propChange = params.propChange;
				xmlKeys.userId = params.userId;
				xmlKeys.userName = params.userName;
				xmlKeys.sessionId = params.sessionId;
				xmlKeys.propChange = params.propChange;
				xmlKeys.objId = params.objId;

				for (var child in params)
				{
					if (typeof params[child] == "object" && child != "precision")
					{
						for (var key in params[child])
						{
							if(typeof params[child][key] != "object")
							{
								if(params[child][key] != "null")
								{
									xmlKeys[child.toLowerCase() + key.substring(0, 1).toUpperCase() + key.substring(1)] = params[child][key];
								}
							} else {
								for (var obj in params[child][key])
								{
									if(params[child][key][obj] != "null")
									{
										xmlKeys[child.toLowerCase() + key.substring(0,1).toUpperCase() + key.substring(1) + obj.substring(0,1).toUpperCase() + obj.substring(1)] = params[child][key][obj];
									}
								}
							}
						}
					}
				}

				msg += '/>';

				var msg = "<message";
				for (var key in xmlKeys)
				{
					msg += " " + key + '="' + encodeURI(xmlKeys[key]) + '"';
				}
				msg += "/>";

				this.sendMessage(msg);
			}
		},

		targetArchRequest: function(eventIds, startTs, endTs) {
			var msg = '<message type="targetArchRequest" uid="'+jsUserId+'" sid="'+jsSessionId+'" timestart="'+startTs+'" timeend="'+endTs+'">';
			msg += eventIds[0];
			for (var i=1; i<eventIds.length; i++)
			{
				msg += "_"+eventIds[i];
			}
			msg += '</message>';

			this.sendMessage(msg);
		},

		targetArchSingleTrailRequest: function(eventId) {
			var msg = '<message type="targetArchSingleTrailRequest" uid="'+jsUserId+'" sid="'+jsSessionId+'" eventid="'+eventId+'"/>';
			this.sendMessage(msg);
		},

		getCameraPtzAttributes: function(usid) {
			this.sendMessage('<message type="gisPtzFbPosGetRequest" usid="'+usid+'"/>');
		},

		// my ($range, $az, $el, $obji) = ($ref->{range}, $ref->{az}, $ref->{el}, $ref->{objid});
		// <message type="amqGisPtzSet" fov='23.5' zoom="1.0" az='35.8285408' el='-10.4896568' camt='0' s2x='1'/>
		setCameraPtzPosition: function(objid, range, pan, tilt) {
			this.sendMessage('<message type="amqGisPtzSet" range="'+range+'" az="'+pan+'" el="'+tilt+'" objid="'+objid+'" sid="'+jsSessionId+'"/>');
		},

		/*
		amqGisResetArchive: function(uid, sid) {
			this.sendMessage('<message type="amqGisResetArchive" uid="'+uid+'" sid="'+sid+'" />');
		},
		*/

		amqPing: function() {
			window.amqPingTimeoutSend = null;

			this.sendMessage('<message type="amqPing" sid="'+jsSessionId+'" />');

			window.amqPingTimeoutId = window.setTimeout(function () {
				if( window.amqPingTimeoutSend == null ) {
					window.console && window.console.error('ActiveMQ communication delayed or broken.');
				}

				window.clearTimeout(window.amqPingTimeoutId);
				Targeting.amqPing();
			}, 30000);
		},

		targetingHandler: function(messageList)
		{
			messageList.forEach(function(message)
			{
				Targeting.amqTargetingHandler(message);
			});
		},

		/**
		 * @param {object} ge_view_window
		 */
		init: function(ge_view_window)
		{
			ge_view = ge_view_window;
			AMQ.subscribe(amqTargetingTopic, Targeting.targetingHandler);
		},

		stop: function()
		{
			AMQ.unsubscribe(amqTargetingTopic);
		},

		sendMessage: function(xml)
		{
			AMQ.publish(amqTargetingTopic, xml);
		}
	}
}();

})(window);
