/////////////////////////////////////////////////////////////////////////
//Group control CLASS for TIBCO GI
/////////////////////////////////////////////////////////////////////////
jsx3.Class.defineClass("mx.GroupControl", jsx3.gui.LayoutGrid, [],
function(GroupControl, GroupControl_prototype) {
//////////////////////////////////////////initalization function
GroupControl_prototype.init = function(controlInstance,activeGroup,jumpValue,isControlEnabled,isLiveModeEnabled,isArchiveModeEnabled,archive_default_startTS,archive_default_endTS){
	this.group = activeGroup;
	this.controlInstance = controlInstance;
	this.isLiveModeEnabled = false;
	this.isArchiveModeEnabled = false;
	this.isInReviewMode = false;
	this.liveRecordingState = 0;    // state of live recording: 0 - no recording, 1 - live record, 2 - saving of live record
	this.jumpValue = jumpValue;//jump value for catchUp or revert in mls
	this.archive_default_startTS = archive_default_startTS;
	this.archive_default_endTS = archive_default_endTS;
	this.dialogCloseTimeout = 2*60*1000; // 2 min
	this.lastTimestamp = 0; // last callback timestamp
	this.minContentJump = 60 * 1000; // minimum jump content interval
	this.recordTimeouts = {}; // cell id => recording process timeout

	this.allowJumpOverHolesInArchive = 0;
	this.preloadTs = null;

	//max record length
	this.maxEventLength = mx.MATRIX2.getIdentityValue("EVENTLOG_MAX_EVENT_LENGTH") * 60 * 1000;
	if (!this.maxEventLength) {
		this.maxEventLength = 30*60*1000; // default value - 30 min
	}

	this.controlDateBlock = mx.MATRIX2.getServer().getJSXByName('date').getId();
	this.controlTimeBlock = mx.MATRIX2.getServer().getJSXByName('time').getId();

	this.timeouts = {};

    this.stateBeforeSnapshot = 0;

    this.tsMonitorPeriod = 250;

	// set callbacks listener
	if(activeGroup != null){ this.group.setListener(this); }

	//setup record dialog
	var dialog_record = jsx3.GO("dialog_record");
	var headerBox = dialog_record.getDescendantOfName("header");
	headerBox.setCursor("move");
	headerBox.setCanMove(jsx3.Boolean.TRUE);
	mx.Dialog._enableMouseTracking(headerBox);
	dialog_record.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);

	var strSpeeds =
			'<data jsxid="jsxroot">' +
				'<record jsxid="1" jsxtext="' + __("1/4x", "Control") + '" />' +
				'<record jsxid="2" jsxtext="' + __("1/2x", "Control") + '" />' +
				'<record jsxid="3" jsxtext="' + __("1x", "Control") + '" />' +
				'<record jsxid="4" jsxtext="' + __("2x", "Control") + '" />' +
				'<record jsxid="5" jsxtext="' + __("4x", "Control") + '" />' +
				'<record jsxid="6" jsxtext="' + __("8x", "Control") + '" />' +
				'<record jsxid="7" jsxtext="' + __("16x", "Control") + '" />' +
				'<record jsxid="8" jsxtext="' + __("32x", "Control") + '" />' +
			'</data>';
	var speedsDoc = jsx3.xml.CDF.Document.newDocument();
	speedsDoc.loadXML(strSpeeds);
	mx.MATRIX2.getServer().Cache.setDocument('Control_SpeedsDocument', speedsDoc);

	var speeds = jsx3.GO("speedSelector");
	speeds.setEvent('jsx3.GO("layoutControlComponent").controls.changeSpeed()', jsx3.gui.Interactive.SELECT);
	speeds.setXMLId('Control_SpeedsDocument').setValue(3);
	speeds.repaint();

	this.speeds = [
		0.25,
		0.5,
		1,
		2,
		4,
		8,
		16,
		32
	];

	this.curSpeed = 1;

	/**
	 *  set button state in controls
	 */
	this.setControlButton = function(strButtonName, state, jsxEnabled) {
		var button = this.controlInstance.getDescendantOfName(strButtonName);

		var buttons = {
			revert_stepback: {
				state_1: { tip: __("Jump back", "Control button"),     img: 'back',           event: 'revert'      },
				state_2: { tip: __("Step back", "Control button"),     img: 'step_back',      event: 'stepBack'    }
			},
			play_pause: {
				state_1: { tip: __("Play", "Control button"),          img: 'play',           event: 'play'        },
				state_2: { tip: __("Pause", "Control button"),         img: 'pause',          event: 'pause'       }
			},
			catchup_stepforward: {
				state_1: { tip: __("Jump forward", "Control button"),  img: 'forward',        event: 'catchUp'     },
				state_2: { tip: __("Step forward", "Control button"),  img: 'step_forward',   event: 'stepForward' }
			},
			record: {
				state_1: { tip: __("Record", "Control button"),        img: 'record',         event: 'startRecord' },
				state_2: { tip: __("Stop record", "Control button"),   img: 'record_pressed', event: 'stopRecord'  }
			},

			saveImage:   { tip: __("Save snapshot", "Control button"), img: 'save_image',     event: 'saveImage'   },

			recAudio:    { tip: __("Record audio from microphone", "Control button"),
			                                                           img: 'mic',            event: 'mx.AR.showAudioRecordDialog();' },
			gap: {
				state_1: { tip: __("Enable jumps over holes in content", "Control button"),    img: 'gap',         event: 'toggleGaps' },
				state_2: { tip: __("Disable jumps over holes in content", "Control button"),   img: 'gap_pressed', event: 'toggleGaps'  }
			},

			sIncrease:   { tip: __("Increase speed", "Control button"), img: 'speed_more', event: 'jsx3.GO("layoutControlComponent").controls.oneStepChangeSpeed(1)' },
			sDecrease:   { tip: __("Decrease speed", "Control button"), img: 'speed_less', event: 'jsx3.GO("layoutControlComponent").controls.oneStepChangeSpeed(-1)' },
			s1x:   { tip: __("Set 1x speed", "Control button"), img: 'speed_1x', event: 'var c = jsx3.GO("layoutControlComponent").controls;c.setSpeedData(1);c.changeSpeed();' }
		};

		var data = buttons[strButtonName];
		if (state) {
			data = (state == 1) ? data.state_1 : data.state_2;
		}

		button.setTip(data.tip);
		button.setImage("images/design1/player_controls/" + data.img + ".png");
		button.setOverImage("images/design1/player_controls/" + data.img + "_hover.png");
		button.setDisabledImage("images/design1/player_controls/" + data.img + "_disabled.png");
		if (data.event.indexOf('(') != -1) {
			button.setEvent(data.event, jsx3.gui.Interactive.EXECUTE);
		} else {
			button.setEvent("mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.buttonEvent('" + data.event + "');", jsx3.gui.Interactive.EXECUTE);
		}

		button.setEnabled(jsxEnabled, false);
		button.repaint();
	};

	/**
	 * set access to control
	 */
	this.setAccess = function(isControlEnabled,isLiveModeEnabled,isArchiveModeEnabled) {
		//appLogger.info("setAccess: START");
		this.isLiveModeEnabled=isLiveModeEnabled;
		this.isArchiveModeEnabled=isArchiveModeEnabled;

		if(!isControlEnabled || !this.group) {
			this.setControlButton("play_pause", 1, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("revert_stepback", 1, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("catchup_stepforward", 1, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("record", 1, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("saveImage", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("recAudio", null, jsx3.gui.Form.STATEDISABLED);
			if(this.allowJumpOverHolesInArchive){
				this.setControlButton("gap", 2, jsx3.gui.Form.STATEDISABLED);
			}
			else{
				this.setControlButton("gap", 1, jsx3.gui.Form.STATEDISABLED);
			}

			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("s1x", null, jsx3.gui.Form.STATEDISABLED);
			jsx3.GO("speedSelector").setEnabled(jsx3.gui.Form.STATEDISABLED, true);

			this.controlInstance.getDescendantOfName("date").setText('',true);
			this.controlInstance.getDescendantOfName("time").setText('',true);
			return;
		}

		var command = this.group.getCommand();
		//appLogger.info("setAccess: command.cmd"+command.cmd);
		if(command.cmd==0 || command.cmd==1 || command.cmd==3){ // if stop or pause or playOneFrame
			this.setControlButton("play_pause", 1, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("revert_stepback", 2, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("catchup_stepforward", 2, jsx3.gui.Form.STATEENABLED);
		}else if(command.cmd==2){ // if play
			this.setControlButton("play_pause", 2, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("revert_stepback", 1, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("catchup_stepforward", 1, jsx3.gui.Form.STATEENABLED);
		}

		if((this.group.contextType == 2 && this.isInReviewMode) || this.group.contextType == 3){ // if review or archive
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("s1x", null, jsx3.gui.Form.STATEENABLED);
			jsx3.GO("speedSelector").setEnabled(jsx3.gui.Form.STATEENABLED, true);
		}
		else{ // if live
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("s1x", null, jsx3.gui.Form.STATEDISABLED);
			jsx3.GO("speedSelector").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			this.setControlButton("revert_stepback", 1, jsx3.gui.Form.STATEENABLED);

			//DE571
			this.controlInstance.getDescendantOfName("revert_stepback").setEvent("mx.MATRIX2.quickSwitch2archive(jsx3.GO(mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.group.players[0].player.id));", jsx3.gui.Interactive.EXECUTE);
			this.controlInstance.getDescendantOfName("revert_stepback").setTip(__("Quick switch to archive"));
			this.setControlButton("catchup_stepforward", 1, jsx3.gui.Form.STATEDISABLED);
		}

		//if record not finished
		if(this.getMainCell() && this.getMainCell().getAttribute('recording' == 1)){
			this.setControlButton("record", 2, jsx3.gui.Form.STATEENABLED);
		}
		else{
			this.checkRecordButton();
		}

		if((this.group.getGroupSize()-this.group.getNumOfAudioDevices())==1){//if only one player in group
			this.setControlButton("saveImage", null, jsx3.gui.Form.STATEENABLED);
			if(mx.AR.isTwoWayAudioSupported() && this.group.contextType == 2){ // if two way audio supported and we are in live mode
				this.setControlButton("recAudio", null, jsx3.gui.Form.STATEENABLED);
			}
			else{
				this.setControlButton("recAudio", null, jsx3.gui.Form.STATEDISABLED);
			}
		}
		else{ // if more than 1 player in group
			this.setControlButton("saveImage", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("recAudio", null, jsx3.gui.Form.STATEDISABLED);
		}

		if (!this.isLiveModeEnabled || !this.isArchiveModeEnabled){  // if live,archive or both not allowed
			if(this.isLiveModeEnabled && !this.isArchiveModeEnabled){ // if only live allowed
				if(this.group && this.group.contextType==3){ this.group.stop(); } // if in forbidden mode 'archive'
			}
			if(this.isArchiveModeEnabled && !this.isLiveModeEnabled){// if only archive allowed
				if(this.group && this.group.contextType==2){ this.group.stop(); } // if in forbidden mode 'live'
			}
			if(!this.isLiveModeEnabled && !this.isArchiveModeEnabled){ // if no modes allowed
				if(this.group){ this.group.stop(); }
			}
		}

		if(this.group.contextType==3){
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("s1x", null, jsx3.gui.Form.STATEENABLED);
			jsx3.GO("speedSelector").setEnabled(jsx3.gui.Form.STATEENABLED, true);

			if(this.getMainPlayer().getParameter("SKIP_GAPS") == 1){
				this.allowJumpOverHolesInArchive = 1;
				this.setControlButton("gap", 2, jsx3.gui.Form.STATEENABLED);
			}
			else{
				this.allowJumpOverHolesInArchive = 0;
				this.setControlButton("gap", 1, jsx3.gui.Form.STATEENABLED);
			}
		}
		else{
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("s1x", null, jsx3.gui.Form.STATEDISABLED);
			jsx3.GO("speedSelector").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

		//appLogger.info("setAccess: OK");
	};

	/**
	 *  toggle gaps parameter
	 */
	this.toggleGaps = function(){
		this.allowJumpOverHolesInArchive = (this.allowJumpOverHolesInArchive ? 0 : 1);

		if(this.allowJumpOverHolesInArchive){
			this.setControlButton("gap", 2, jsx3.gui.Form.STATEENABLED);
		}
		else{
			this.setControlButton("gap", 1, jsx3.gui.Form.STATEENABLED);
		}

		var command = this.group.getCommand();
		var playing = false;
		if(command.cmd == 2 && command.status == 1){
			playing = true;
		}

		// set active group players parameter
		for(var i = 0; i < this.group.players.length; i++) {
			var player = this.group.players[i].player;

			if(playing){
				var timestamp = player.getCurrentTS();
				player.stop();
			}

			player.setParameter('SKIP_GAPS', this.allowJumpOverHolesInArchive);

			if(playing){
				player.play(1, 1, timestamp);
			}
		}
	};

	/**
	 * Wrapper for control functions: play/pause, step back/forward etc.
	 * Checks if group is set and allowed actions, so we don't need to make this checks in other functions.
	 */
	this.buttonEvent = function(event) {

		// Check if group is set
		if(!this.group){
			alert(__("Group not set!"));
			return;
		}

		// Check if action is allowed
		if ( event != "saveImage" ) {
			if(!(this.group.contextType==2 && this.isLiveModeEnabled) && !(this.group.contextType==3 && this.isArchiveModeEnabled)) {
				alert(__("Action is not allowed!"));
				return;
			}
		}

		this[event].call(this);
	};

	/**
	 * play function
	 */
	this.play = function(needPlay) {
		//appLogger.info("play: START");

		needPlay = (needPlay == undefined) ? true : needPlay;
		if(needPlay) {
			if(this.curSpeed == 1){ //if speed default
				this.group.play();
			}
			else{ // if speed changed
				var command = this.group.getCommand();
				command.direction = 1;
				this.group.play(command.direction,this.curSpeed);
			}
		}

		this.setControlButton("play_pause", 2, jsx3.gui.Form.STATEENABLED);

		if((this.group.contextType==2 && this.isInReviewMode) || this.group.contextType==3){ //if 'review' or archive
			this.setControlButton("revert_stepback", 1, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("catchup_stepforward", 1, jsx3.gui.Form.STATEENABLED);
		}
		else{
			this.setControlButton("revert_stepback", 1, jsx3.gui.Form.STATEENABLED);
			//DE571
			this.controlInstance.getDescendantOfName("revert_stepback").setEvent("mx.MATRIX2.quickSwitch2archive(jsx3.GO(mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.group.players[0].player.id));", jsx3.gui.Interactive.EXECUTE);
			this.controlInstance.getDescendantOfName("revert_stepback").setTip(__("Quick switch to archive"));
			this.setControlButton("catchup_stepforward", 1, jsx3.gui.Form.STATEDISABLED);
		}

        this.runCurrentTSMonitor(true);
		//appLogger.info("play: OK");
	};

	/**
	 * pause function
	 */
	this.pause = function(needPause) {
		//appLogger.info("pause: START");
        if(this.group == null){
            return;
        }

		// if no arguments, needPause == true
		needPause = (needPause == undefined) ? true : needPause;
		if(needPause) {
			this.group.pause();
		}

		this.setControlButton("play_pause", 1, jsx3.gui.Form.STATEENABLED);

		if((this.group.contextType == 2 && this.isInReviewMode) || this.group.contextType == 3){ //if 'review' or archive
			this.setControlButton("revert_stepback", 2, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("catchup_stepforward", 2, jsx3.gui.Form.STATEENABLED);

			if(this.group.isReversePlaybackEnabled()!=true){ //if playback disabled
				this.setControlButton("revert_stepback", 2, jsx3.gui.Form.STATEDISABLED);
			}
			else{
				//revert_stepbackButton.setEnabled(jsx3.gui.Form.STATEENABLED, true);
			}
		}
		else { //if 'live'
			this.setControlButton("revert_stepback", 2, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("catchup_stepforward", 2, jsx3.gui.Form.STATEDISABLED);
		}

        this.stopCurrentTSMonitor();
		//appLogger.info("pause: OK");
	};

	/**
	 * revert function
	 */
	this.revert = function() {
		var command =  this.group.getCommand();
        var speed = 1;
		if (command.cmd == 2 && command.status == 1) {
			speed = command.speed;
		}

        if(this.group.getCurrentTS() == null || this.group.getCurrentTS() == 0){
            if(window.window.jsDebug){ appLogger.info("CONTROL.revert: Jump skipped, group.getCurrentTS() = " + this.group.getCurrentTS()); }
            return;
        }

		//if(this.group.contextType==2){ var startTS=this.group.buffer.startTS; }
		if(this.group.contextType == 3) {
			var startTS = this.group.archiveInterval.startTS;
		}
		var neededTS = this.group.getCurrentTS() - this.jumpValue;
        //if(window.jsDebug){ appLogger.info("CONTROL.revert: currentTS="+this.group.getCurrentTS()+",neededTS="+neededTS); }
		if(neededTS <= startTS){
			if(window.jsDebug){ appLogger.info("CONTROL.revert: End of interval reached!"); }
			this.extendBoundary(neededTS);
		}else{
			if(window.jsDebug){ appLogger.info("CONTROL.revert: Jump OK!"); }
			this.group.play(1, speed, neededTS);
			this.play();
		}
	};

	/**
	 * step_back function
	 */
	this.stepBack = function() {
		if(this.group.isReversePlaybackEnabled()) {
			this.group.playOneFrame(-1);
            this.runCurrentTSMonitor();
		}
		else {
			alert(__("Reverse playback disabled"));
		}
	};

	/**
	 * catch_up function
	 */
	this.catchUp = function() {
		var command =  this.group.getCommand();
		var speed = (command.cmd == 2 && command.status == 1) ? command.speed : 1;
		var endTS = (this.group.contextType==3) ? this.group.archiveInterval.endTS : this.group.buffer.endTS;
		var neededTS = this.group.getCurrentTS() + this.jumpValue;

		if(neededTS >= endTS) {
			this.group.play(1, speed, endTS - 1000);
			this.pause(false); /*alert('End of interval reached!');*/
		}
		else {
			this.group.play(1, speed, neededTS);
		}
	};

	/**
	 * step_forward function
	 */
	this.stepForward = function() {
		this.group.playOneFrame(1);
        this.runCurrentTSMonitor();
	};

	/**
	 * speed select function
	 */
	this.changeSpeed = function() {
		if(this.group == null || this.group.contextType != 3){
            return;
        }

		var speedSelector = jsx3.GO("speedSelector");
		var newSpeedId = parseInt(speedSelector.getValue());		

		var new_speed = this.speeds[newSpeedId - 1];

		var command =  this.group.getCommand();
		this.curSpeed = parseFloat(new_speed);
		
		if(jsDebug){ appLogger.info("changeSpeed: newSpeedId="+(newSpeedId-1) + ", new speed="+new_speed+", cmd="+command.cmd+", status="+command.status); }
		
		if(command.cmd == 2  && command.status == 1){
			this.group.play(1,this.curSpeed,this.group.getCurrentTS() - 0.5*1000); 
		}
	};

	/**
	 * speed data set function
	 */
	this.setSpeedData = function(newSpeed) {
		if(jsDebug){ appLogger.info("setSpeedData: newSpeed="+newSpeed); }
		var speedSelector = jsx3.GO("speedSelector");

		for(var speed in this.speeds){
			if(newSpeed == this.speeds[speed]){
				var newId = parseInt(speed) + 1;
				speedSelector.setValue(newId);
				this.curSpeed = newSpeed;
				break;
			}
		}
	};

	/**
	 * speed one step change
	 */
	this.oneStepChangeSpeed = function(direction) {
		if(jsDebug){ appLogger.info("oneStepChangeSpeed: direction="+direction); }
		var speedSelector = jsx3.GO("speedSelector");

		var newSpeedId = parseInt(speedSelector.getValue()) + 1;
		if(direction < 0){
			newSpeedId = parseInt(speedSelector.getValue()) - 1;
		}

		if(newSpeedId == 1){
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEENABLED);
		}
		else if(newSpeedId == 8){
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEDISABLED);
		}
		else{
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEENABLED);
		}

		speedSelector.setValue(newSpeedId);
		speedSelector.doEvent(jsx3.gui.Interactive.SELECT, {});
	};

    /**
	 * check record button state
	 */
	this.checkRecordButton = function() {
        //wait for stream
        if(this.group && this.group.getCurrentTS && this.group.getCurrentTS() > 0){
            this.setControlButton("record", 1, jsx3.gui.Form.STATEENABLED);
        }
        else{
            window.setTimeout(function(){ jsx3.GO('layoutControlComponent').controls.checkRecordButton(); }, 50);
        }
    };

	/**
	 * start fragment record
	 */
	this.startRecord = function(start) {
		//appLogger.info("this.group.contextType="+this.group.contextType);

		var objCell = this.getMainCell();

		if (resourceTree.getObject(this.group.players[this.getNonAudioMainPlayerPos()].player.devObjId).attr('STORAGE_POLICY') == -7) {
			alert('Cannot record video or make clip because camera has "No Archive" storage policy');
			return;
		}


		if(this.group.contextType == 2) { //if live mode
            if(window.jsDebug){ appLogger.info("CONTROL.startRecord: currentTS = "+this.group.getCurrentTS() +  ", start = "+start); }
			var cells = this.getGroupCells();
			for (var i = 0; i < cells.length; i++) {
				cells[i].setAttribute('markA', '' + (start || (this.group.getCurrentTS() - 30000)));
				cells[i].setAttribute('markB', 'null');
				cells[i].setAttribute('recording', '1');
				cells[i].getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_record.png').repaint();
			}

			this.setControlButton("record", 2, jsx3.gui.Form.STATEENABLED);
			this.closeRecordDialog();

			//set tab record indication
			if(objCell.getParent().getName() != 'pane_elogsmall'){
				var tab = objCell.getAncestorOfType(jsx3.gui.Tab);
				mx.CT.addRecDeviceToTab(tab, objCell);
			}
			this.setRecordStopTimeout(objCell);

			if (this.recordTimeouts[objCell.getId()]) {
				clearTimeout(this.recordTimeouts[objCell.getId()]);
			}
			this.processRecord(objCell);
		}
		else if(this.group.contextType == 3){ // if archive mode
			/*var markA = objCell.getAttribute('markA');
			var markB = objCell.getAttribute('markB');
			if (!markA || !markB || markA == 'null' || markB == 'null') {
				alert(__('No selection in timeline'));
				return;
			}*/
			this.setControlButton("record", 1, jsx3.gui.Form.STATEENABLED);
			this.showRecordDialog();
		}
	};

	this.processRecord = function(objCell) {
		var controls = jsx3.GO('layoutControlComponent').controls;
		if (!objCell || objCell.getAttribute('recording') != 1) {
			return;
		}

		if (objCell === controls.getMainCell()) {
			var markB = controls.group.getCurrentTS();
			mx.TIMELINE.showTimeLine('gn');
			mx.TIMELINE.setSelectedInterval(objCell.getAttribute('markA'), markB, false, false, 'gn');

			// cannot place hairline strictly on markB, because of timeline behaviour
			mx.TIMELINE.setTime(markB - 5000, false, 'gn');

		}

		setTimeout(function() {
			controls.processRecord(objCell);
		}, 1000);
	};

	/**
	 * stop fragment record
	 */
	this.stopRecord = function() {
		this.setControlButton("record", 1, jsx3.gui.Form.STATEENABLED);

		var cells = this.getGroupCells();
		for (var i=0; i<cells.length; i++) {
			cells[i].setAttribute('recording', '0');
			cells[i].getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_record_stop.png').repaint();
		}

		this.liveRecordingState = 2;
		this.pause();

		//set tab record indication
		var objCell = this.getMainCell();
		objCell.setAttribute('markB', this.group.getCurrentTS());
		if(objCell.getParent().getName() != 'pane_elogsmall'){
			var tab = objCell.getAncestorOfType(jsx3.gui.Tab);
			mx.CT.removeRecDeviceFromTab(tab, objCell);
		}
		this.removeRecordStopTimeout(objCell);

		this.showRecordDialog();
	};


	/**
	 * Get Matrix cells that belong to currently active group
	 */
	this.getGroupCells = function() {
		var cells = [];
		for(var i=0; i<this.group.players.length; i++) {
			//if player camera device
			if(this.group.players[i].player.getParameter('DEVICE_TYPE')=="C"){
				cells.push(jsx3.GO(this.group.players[i].player.id));
			}
		}
		return cells;
	};

	this.getNonAudioMainPlayerPos = function() {
		//check non-audio main player position
		var mainPlayerPosition = 0;
		for(var i=0; i<this.group.players.length; i++){
			//if player camera device
			if(this.group.players[i].player.getParameter('DEVICE_TYPE')=="C"){
				var objCell = this.controlInstance.getServer().getJSXById(this.group.players[i].player.id);
				mainPlayerPosition = parseInt(objCell.getAttribute('mainPlayerPosition'));
				break;
			}
		}

		//if player not in group
		if(this.group.players[mainPlayerPosition]===undefined
		|| this.group.players[mainPlayerPosition].player.getParameter('DEVICE_TYPE')=="A") {
			mainPlayerPosition = this.detectMainPlayerPos();
			//if active recording
			var objCell = this.controlInstance.getServer().getJSXById(this.group.players[mainPlayerPosition].player.id);
			var markA = objCell.getAttribute("markA");
			var markB = objCell.getAttribute("markB");

			for(var i=0; i<this.group.players.length; i++){
				//if player camera device
				if(this.group.players[i].player.getParameter('DEVICE_TYPE')=="C"){
					var objCell = this.controlInstance.getServer().getJSXById(this.group.players[i].player.id);
					objCell.setAttribute('mainPlayerPosition', mainPlayerPosition);
				}
			}
		}

		return mainPlayerPosition;
	};

	/**
	 * get cell of main non-audio player
	 */
	this.getMainCell = function() {
		return jsx3.GO(this.getMainPlayer().id);
	};

    this.getMainPlayer = function() {
		if(this.group && this.group.players){
			return this.group.players[this.getNonAudioMainPlayerPos()].player;
		}
		return null;
    };

	/**
	 * find new main player
	 */
	this.detectMainPlayerPos = function() {
		if(!this.group || !this.group.players)
			return;

		var mainPlayerPosition = 0;
		//appLogger.info("this.group.players.length="+this.group.players.length);
		for(var i=0; i<this.group.players.length; i++){
			//if player camera device
			if(this.group.players[i].player.getParameter('DEVICE_TYPE')=="C"){
				mainPlayerPosition = i;
				break;
			}
		}

		return mainPlayerPosition;
	};


	/**
	 * show record dialog
	 */
	this.showRecordDialog = function() {
		var dialog_record = jsx3.GO("dialog_record");
		var ts_from = null;
		var ts_to = null;

		var objCell = this.getMainCell();

		if(!isNaN(objCell.getAttribute('markA'))){
			if(window.jsDebug){ appLogger.info("CONTROL.showRecordDialog1: markA="+objCell.getAttribute('markA')+", markB="+objCell.getAttribute('markB')); }
			ts_from = parseInt(objCell.getAttribute('markA'));
			ts_to = parseInt(objCell.getAttribute('markB'));
		}
		else if(objCell.getAttribute("eventid") != "-1"){
			if(window.jsDebug){ appLogger.info("CONTROL.showRecordDialog1.1: ts_from="+objCell.getAttribute('ts_from')+", ts_to="+objCell.getAttribute('ts_to')); }
			ts_from = parseInt(objCell.getAttribute('ts_from'));
			ts_to = parseInt(objCell.getAttribute('ts_to'));
		}
		else{
			if(window.jsDebug){ appLogger.info("CONTROL.showRecordDialog2: markA="+objCell.getAttribute('markA')+", markB="+objCell.getAttribute('markB')); }
			var now = mx.MATRIX2.getServerTime();
			ts_from = now - 30000;
			ts_to = now;
		}

		dialog_record.getDescendantOfName('textboxRecordFrom').setValue(mx.TIME.timestamp2date(ts_from, false));
		dialog_record.getDescendantOfName('textboxRecordTo').setValue(mx.TIME.timestamp2date(ts_to, false));
		dialog_record.setAttribute('markA', ts_from);
		dialog_record.setAttribute('markB', ts_to);
		dialog_record.getDescendantOfName('buttonSA').setEnabled(jsx3.gui.Form.STATEENABLED, true);
		dialog_record.getDescendantOfName('buttonCE').setEnabled(jsx3.gui.Form.STATEENABLED, true);

		dialog_record.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
		if (this.timeouts['close_record_dialog']) {
			clearTimeout(this.timeouts['close_record_dialog']);
		}
		this.timeouts['close_record_dialog'] = setTimeout(this.hideRecordDialog, this.dialogCloseTimeout);
	};

	/**
	 * check record timestamps
	 */
	this.checkRecordTimestamps = function(objTextbox) {

		var buttonSA = jsx3.GO("dialog_record").getDescendantOfName('buttonSA');
		var buttonCE = jsx3.GO("dialog_record").getDescendantOfName('buttonCE');
		var textbox_from = jsx3.GO("dialog_record").getDescendantOfName('textboxRecordFrom');
		var textbox_to = jsx3.GO("dialog_record").getDescendantOfName('textboxRecordTo');

		var ts_from = mx.TIME.date2timestamp(textbox_from.getValue());
		var ts_to = mx.TIME.date2timestamp(textbox_to.getValue());

		var disableButtons = false;

		textbox_from.setBackgroundColor('#FFFFFF', true);
		textbox_to.setBackgroundColor('#FFFFFF', true);
		buttonSA.setEnabled(jsx3.gui.Form.STATEENABLED, true);
		buttonCE.setEnabled(jsx3.gui.Form.STATEENABLED, true);

		if (!ts_from) {
			textbox_from.setTip(__("Wrong date format")).setBackgroundColor('#FF4C4C', true);
			disableButtons = true;
		}
		if (!ts_to) {
			textbox_to.setTip(__("Wrong date format")).setBackgroundColor('#FF4C4C', true);
			disableButtons = true;
		}

		if (ts_to <= ts_from) {
			textbox_from.setTip(__("From date should be before To")).setBackgroundColor("#FF4C4C", true);
			textbox_to.setTip(__("From date should be before To")).setBackgroundColor("#FF4C4C", true);
			disableButtons = true;
		}

		if(disableButtons){
			buttonSA.setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			buttonCE.setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

		jsx3.sleep(function(){ objTextbox.focus(); });
		if(window.jsDebug){ appLogger.info("CONTROL.checkRecordTimestamps: ts_from="+ts_from+", ts_to="+ts_to); }
	};

	/**
	 * hide "choose action" dialog via close button
	 */
	this.hideRecordDialog = function() {
		if (this.liveRecordingState == 2) {
			this.liveRecordingState = 0;
			this.finishRecording();
		}
		this.closeRecordDialog();
	};

	/**
	 * hide "choose action" dialog via code
	 */
	this.closeRecordDialog = function() {
		jsx3.GO("dialog_record").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
		if(this.timeouts['close_record_dialog']){
			clearTimeout(this.timeouts['close_record_dialog']);
		}
	};

	/**
	 * add automatic record stop notification timeout
	 */
	this.setRecordStopTimeout = function(objCell){
		if (this.timeouts['finish_record_' + objCell.getId()]) {
			clearTimeout(this.timeouts['finish_record_' + objCell.getId()]);
		}
		this.timeouts['finish_record_' + objCell.getId()] = setTimeout(
			function() { mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.onRecordTimeout(objCell); },
			this.maxEventLength
		);
	};

	/**
	 * remove automatic record stop notification timeout
	 */
	this.removeRecordStopTimeout = function(objCell) {
		clearTimeout(this.timeouts['finish_record_' + objCell.getId()]);
		this.timeouts['finish_record_' + objCell.getId()] = null;
	};

	/**
	 * on automatic record timeout
	 */
	this.onRecordTimeout = function(objCell) {
		var recordBlock = objCell.getDescendantOfName('cell_alert');
		var alertId = 'alert_record_var'+objCell.getId();
		//if record not stoped
		if(window['finish_record_var'+objCell.getId()]){
			//appLogger.info("onRecordTimeout: 1 - "+window['finish_record_var'+objCell.getId()]);
			if(recordBlock.getAttribute("alert") && recordBlock.getAttribute("alert")=="1"){
				recordBlock.setAttribute("alert","0");
				mx.MATRIX2.setAlert(recordBlock);
			}
			else{
				recordBlock.setAttribute("alert","1");
				mx.MATRIX2.stopAlert(recordBlock);
			}

			//play sound
			mx.MATRIX2.playHTMLSound("notify");

			if(window[alertId]){ clearTimeout(window[alertId]); }
			window[alertId] = window.setTimeout(function() { mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.onRecordTimeout(objCell); }, 1000);
		}
		else{
			//appLogger.info("onRecordTimeout: 2 - "+window['finish_record_var'+objCell.getId()]);
			recordBlock.removeAttribute("alert");
			mx.MATRIX2.stopAlert(recordBlock);
			if(window[alertId]){ clearTimeout(window[alertId]); }
		}
	};


	/**
	 * clears A and B marks
	 */
	this.clearMarks = function() {
		if(this.group!=null && this.group.players[this.group.getPrimaryPlayerPos()]){
			var objCell = this.controlInstance.getServer().getJSXById(this.group.players[this.group.getPrimaryPlayerPos()].player.id);
			if(objCell){
				objCell.setAttribute('markA', 'null');
				objCell.setAttribute('markB', 'null');
			}
		}
	};

	/**
	 * show event dialog
	 */
	this.showEventDialog = function() {
		if(!this.group) {
			alert(__("Group not set!"));
			return;
		}

		var objCell = this.getMainCell();

		var dialog_record = jsx3.GO("dialog_record");
		var ts_from = mx.TIME.date2timestamp(dialog_record.getDescendantOfName('textboxRecordFrom').getValue()) || dialog_record.getAttribute('markA');
		var ts_to   = mx.TIME.date2timestamp(dialog_record.getDescendantOfName('textboxRecordTo').getValue())   || dialog_record.getAttribute('markB');

		objCell.setAttribute('markA', "" + ts_from);
		objCell.setAttribute('markB', "" + ts_to);

		this.closeRecordDialog();

		var strCreateScript = "this.getServer().getJSXByName('layoutControlComponent').controls.createEvent();";

		// show dialog
		mx.Dialog.setup('event', {
			'startts': mx.TIME.timestamp2date(ts_from),
			'endts': mx.TIME.timestamp2date(ts_to),
			'oncreate' : strCreateScript
		});
		jsx3.GO('dialog_AE').getDescendantOfName('close').setEvent('jsx3.GO("layoutControlComponent").controls.finishRecording(); mx.Dialog.close("event");', jsx3.gui.Interactive.EXECUTE);
	};


	/**
	 * event creation
	 */
	this.createEvent = function() {
		if(!this.group) {
			alert(__("Group not set!"));
			return;
		}

		var dialogInstance = mx.Dialog.getActiveDialog('event');
		var eventMenu = dialogInstance.getDescendantOfName('event_menu');
		var eventMsg = dialogInstance.getDescendantOfName('event_text');
		//var eventMgr = dialogInstance.getDescendantOfName('event_mgr');
		var eventMgr = document.getElementById('checkbox_event_mgr');

		if(eventMenu.getValue() == __("-Select type-") || eventMsg.getValue()==''){
			alert(__("You have to select 'Event type' and input the 'Message'!"));
			return;
		}

		var objCell = this.getMainCell();
		var markA = parseInt(objCell.getAttribute('markA'));
		var markB = parseInt(objCell.getAttribute('markB'));

		if((markB-markA) < 1000){
			mx.Dialog.close('event');
			alert(__("Event duration must be more than 1 second!"));
			return;
		}

		var player = this.group.players[this.getNonAudioMainPlayerPos()].player;

		//check credentials
		if(!resourceTree.cred(player.devObjId, 'a')){
			mx.Dialog.close('event');
			alert(__("Adding not allowed!\nYou don't have credentials for it!"));
			this.finishRecording();
			return;
		}
		//check witnesses
		var witnesses = [];
		if(this.group.getGroupSize()>1) {
			// Add all players except current to witnesses
			for(var i=0; i<this.group.getGroupSize(); i++){
				if(this.group.players[i].player != player && $.inArray(this.group.players[i].player.devObjId, witnesses) == -1){
					witnesses.push(this.group.players[i].player.devObjId);
				}
			}
		}
		witnesses = witnesses.join(',');
		//appLogger.info("createEvent: witnesses="+witnesses);
		//create event

		var self = this;
		mx.ELog2.createNewEvent(
			player.devObjId,
			eventMenu.getValue(),
			eventMsg.getValue(),
			eventMgr.checked ? 1 : 0,
			markA,
			markB,
			null,
			witnesses
		)
			.always(function(){
				// Clear
				mx.Dialog.close('event');
				self.finishRecording();
			});
	};


	/**
	 * clip generation
	 */
	this.generateClip = function() {
		if(!this.group){
			alert(__("Group not set!"));
			return;
		}

		var objCell = this.getMainCell();
		var player = this.group.players[this.getNonAudioMainPlayerPos()].player;

		var dialog_record = jsx3.GO("dialog_record");
		var ts_from = mx.TIME.date2timestamp(dialog_record.getDescendantOfName('textboxRecordFrom').getValue()) || dialog_record.getAttribute('markA');
		var ts_to   = mx.TIME.date2timestamp(dialog_record.getDescendantOfName('textboxRecordTo').getValue())   || dialog_record.getAttribute('markB');

		objCell.setAttribute('markA', "" + ts_from);
		objCell.setAttribute('markB', "" + ts_to);

		//if(window.jsDebug){ appLogger.info("generateClip: objC=" + cameras); }

		if(!resourceTree.cred(player.devObjId, 'D')) {
			alert(__("Not sufficient credentials to download video clip. Please contact your system administrator."));
			this.endRecording();
			return;
		}

		var strExport = "media_export.php?dev="+player.devObjId+"&";
		var audioNode = resourceTree.getObject({'belongs2devid': player.devObjId, 'type': 'audio'});
		if(audioNode) {
			strExport += "audio="+audioNode.obj + "&";
		}
		strExport += "start="+Math.round(ts_from/1000)+"&";
		strExport += "end="+Math.round(ts_to/1000);
		strExport += "&onnewchunk=parent.mx.MATRIX2.onExporterNewDataChunk";
		strExport += "&onready=parent.mx.MATRIX2.onExporterReady";

		if(window.jsDebug){ appLogger.info("generateClip: strExport="+strExport); }

		mx.MATRIX2.getServer().getJSXByName('iframeMediaExport').setSrc(strExport);
		this.closeRecordDialog();
		this.finishRecording();
	};


	this.finishRecording = function() {
		if (this.group && this.group.contextType != 3) {
			this.switch2live();
		}
	};


	/**
	 * Image save
	 */
	this.saveImage = function() {
        var videoPlayersNum = this.group.getGroupSize() - this.group.getNumOfAudioDevices();
		if(videoPlayersNum != 1) {
			alert(__("More than one video player in active group!"));
			return;
		}

        var command = this.group.getCommand();
		this.stateBeforeSnapshot = command.cmd;

		this.pause();

        var camera = resourceTree.getObject(this.group.getPlayer(0).devObjId);
        this.group.getPlayer(0).setParameter("DEVICE_NAME", camera.name);
		this.group.getPlayer(0).saveSnapshot();
	};

	/**
	 * call archive
	 */
	this.switch2archive = function() { //3 args
		if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: "+this.switch2archive.arguments.length+" args, started"); }

		var startTS, endTS, pointerTS, selectionStartTS, selectionEndTS;
		if (!this.group) {
			alert(__("Group not set!"));
			return;
		}

		this.liveRecordingState = 0;
		var i;
		// check credentials
		for(i = 0; i < this.group.players.length ; i++){ //change all headers to archive
			if(!resourceTree.cred(this.group.getPlayer(i).devObjId, 'A')) {
				alert(__("Not sufficient credentials to play the video stream.\nPlease contact your system administrator."));
				return;
			}
		}

		if(!this.isArchiveModeEnabled){
			alert(__("Archive mode not allowed!"));
			return;
		}

		//if recieved signal 'false'
		//if playing archive //removed due DE977
		if((this.switch2archive.arguments.length >= 3 && this.switch2archive.arguments[2]==false)) {
			return;
		}

		var objCell = this.getMainCell();

		if(this.switch2archive.arguments.length >= 2) {
            selectionStartTS = this.switch2archive.arguments[0];
            selectionEndTS = this.switch2archive.arguments[1];

			startTS = selectionStartTS;
			endTS = selectionStartTS + archiveBufferInterval;
            pointerTS = selectionStartTS;

			if(window.jsDebug){ appLogger.info("switch2archive: mode 1, startTS = "+startTS+", endTS="+endTS); }
            if(window.jsDebug){ appLogger.info("switch2archive: mode 1, selectionStartTS = "+selectionStartTS+" + archiveBufferInterval="+archiveBufferInterval+" = endTS="+endTS); }
		}
        else{ //if arhive interval not set, get dates from default values
				var now = null;
				$.ajax({
					url: '/api/call.php',
					data: {'function': 'getServerTime'},
					type: "GET",
					dataType: 'json',
					async: false,
					cache: false,
					success: function(data) {
						now = data["servertime"] * 1000;
					}
				});

				this.archive_default_startTS = now - quickSwitch2ArchiveInterval;
				this.archive_default_endTS = now + archiveBufferInterval;
				startTS = this.archive_default_startTS;
				endTS = this.archive_default_endTS;
				pointerTS = this.archive_default_startTS;

				if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: mode 3.2, startTS = "+startTS+":"+(new Date(startTS))+", endTS="+endTS+":"+(new Date(endTS))+", pointerTS="+pointerTS+":"+(new Date(pointerTS))); }
		}

		this.setSpeedData(1);

		//hide recorded window
		this.closeRecordDialog();

		mx.TIMELINE.timeline.clearColorScale();

		if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: set timeline position eventid="+objCell.getAttribute("eventid")); }

		// set cloud timestamp
		var player = this.group.players[0].player;
		var objid = player.devObjId;
		var dev = resourceTree.getObject(objid);
		var cloud = dev.attr('CLOUD_SEPARATOR_TS');
		if(cloud){
			mx.TIMELINE.setCloudTimestamp("gn", cloud*1000);
		}
		else{
			mx.TIMELINE.resetCloudTimestamp();
		}

		mx.TIMELINE.clearSelection("gn");
		//check event attribute
		if(objCell.getAttribute("eventid") != "-1"){
			objCell.setAttribute("stoped_on_end_boundary", "0");
			startTS = objCell.getAttribute('ts_from');
			pointerTS = objCell.getAttribute('ts_from');
			mx.TIMELINE.setDisabledSelectedInterval(pointerTS, objCell.getAttribute('ts_to'), "gn");

			mx.MATRIX2.setButtonInCellHeader(objCell, 'cell_jump2event', true);
		} else {
			if (selectionStartTS != undefined) {
				mx.TIMELINE.setSelectedInterval(selectionStartTS, selectionEndTS, false, false, 'gn');
			}
			else{
				mx.TIMELINE.clearSelection("gn", true);
			}
		}

		if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: final timestamps: pointerTS="+pointerTS+":"+(new Date(pointerTS))+",   startTS="+startTS+":"+(new Date(startTS))+", endTS="+endTS+":"+(new Date(endTS))); }

		mx.TIMELINE.setTime(pointerTS, false, 'gn');

		this.group.setContext(3, startTS, endTS);
		this.checkTimeline();
		//this.checkAvatarOnDemand();
        mx.TIMELINE.refreshTimelineContents();

		if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: context set to 3, startTS="+startTS+", endTS="+endTS); }

		if(objCell.getAttribute("eventid") != "-1"){
			if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: try to set EVENTID to " + objCell.getAttribute("eventid")); }
			this.group.getPlayer(this.getNonAudioMainPlayerPos()).setParameter("EVENTID", parseInt(objCell.getAttribute("eventid"), 10));
		}

        //if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: set text timestamps"); }

		this.controlInstance.getDescendantOfName("archTS_start").setText(mx.TIME.timestamp2date(startTS, "HH:II:SS"));
		this.controlInstance.getDescendantOfName("archTS_end").setText(mx.TIME.timestamp2date(endTS, "HH:II:SS"));

        //if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: check live mode"); }

		if(this.isLiveModeEnabled){ //if live mode allowed
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEENABLED);
			this.setControlButton("s1x", null, jsx3.gui.Form.STATEENABLED);
			jsx3.GO("speedSelector").setEnabled(jsx3.gui.Form.STATEENABLED, true);
			this.setControlButton("record", 1, jsx3.gui.Form.STATEENABLED);
			//set tab record indication
			//var playerMP = this.group.players[this.getNonAudioMainPlayerPos()].player;
			//var objCell = this.controlInstance.getServer().getJSXById(playerMP.id);
			if(objCell.getParent().getName() != 'pane_elogsmall'){
				var tab = objCell.getAncestorOfType(jsx3.gui.Tab);
				mx.CT.removeRecDeviceFromTab(tab, objCell);
			}
			this.removeRecordStopTimeout(objCell);
		}

        //if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: close audio dialog"); }

		mx.AR.closeAudioRecordDialog();

		//if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: changing headers"); }
		for(i=0;i<this.group.players.length;i++){ //change all headers to archive
			if(this.group.getPlayer(i).getParameter("isAudio")!="true" && this.controlInstance.getServer().getJSXById(this.group.getPlayer(i).id)){  //if not audio
				var objCell = this.controlInstance.getServer().getJSXById(this.group.getPlayer(i).id);
				objCell.setAttribute("player_mode", "1");
				objCell.getDescendantOfName('cell_dev_state').setAttribute("onclick","mx.MATRIX2.quickSwitch2live(jsx3.GO(this.id).getAncestorOfName('cell_blk'), false);");
				objCell.getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_archive.png').repaint();
				//--TD--> DE354:
				if(objCell.getAttribute("position_control") == "1") {
					mx.MATRIX2.setButtonInCellHeader(objCell, 'cell_joystick', false);
				}
			}
		}

		//if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: headers change OK"); }
		// DE354:
		mx.PTZ.ptzDialogHide();
		//if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: ptz hide OK"); }

		//if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: timeline check OK"); }

		var soundPlayPause = true; // true - play, false - pause
		if(isPlayInArchive){ // if flag for playing archive
			if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: PLAY"); }
			this.group.play(1, this.curSpeed, pointerTS);
			this.play();
			//if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: PLAY: direction=1, speed="+this.curSpeed+", ts="+pointerTS); }
			isPlayInArchive = false;
		}
		else{
			if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: STOP"); }

			this.group.playOneFrame(1);
			this.pause(false);
			soundPlayPause = false;
		}

		//if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: checking audio devices state"); }
		for(i=0;i<this.group.players.length;i++){ // check state of audio devices
			if(this.group.players[i].player.getParameter("isAudio")=="true"){
				var objCellTemp = this.controlInstance.getServer().getJSXById(this.group.players[i].player.getParameter("cellId"));
				var buttonSound = objCellTemp.getDescendantOfName('cell_sound');
				if(!soundPlayPause || objCellTemp.getAttribute("state")=="pause"){
					mx.MATRIX2.pauseSound(buttonSound,false);
				}
				else if(soundPlayPause || objCellTemp.getAttribute("state")=="playing"){
					mx.MATRIX2.playSound(buttonSound,false);
				}
			}
		}

        this.setControlButton("record", 1, jsx3.gui.Form.STATEENABLED);
		if(this.allowJumpOverHolesInArchive){
			this.setControlButton("gap", 2, jsx3.gui.Form.STATEENABLED);
		}
		else{
			this.setControlButton("gap", 1, jsx3.gui.Form.STATEENABLED);
		}

		if(objCell.getAttribute("eventid") != "-1"){
			this.play(false);
		}
        this.checkRecordButton();

		//if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: audio devices state check OK"); }
		if(window.jsDebug){ appLogger.info("CONTROL.switch2archive: finished"); }
	};

	/**
	 * call live
	 */
	this.switch2live = function() {
		if(!this.group){
			alert(__("Group not set!"));
			return;
		}

		if(!this.isLiveModeEnabled){
			alert(__("Live mode not allowed!"));
			return;
		}

		// check credentials
		var i;
		for(i=0;i<this.group.players.length;i++) {
			if(!resourceTree.cred(this.group.getPlayer(i).devObjId, 'L')) {
				alert(__("Not sufficient credentials to play the video stream.\nPlease contact your system administrator."));
				return;
			}
		}

		if(this.group.contextType!=2){
			this.setSpeedData(1);
			this.group.setContext(2);
		}
		if(this.isArchiveModeEnabled){ //if archive mode allowed
			this.setControlButton("sIncrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("sDecrease", null, jsx3.gui.Form.STATEDISABLED);
			this.setControlButton("s1x", null, jsx3.gui.Form.STATEDISABLED);
			jsx3.GO("speedSelector").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

		this.setControlButton("revert_stepback", 1, jsx3.gui.Form.STATEENABLED);
		//DE571
		this.controlInstance.getDescendantOfName("revert_stepback").setEvent("mx.MATRIX2.quickSwitch2archive(jsx3.GO(mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.group.players[0].player.id));", jsx3.gui.Interactive.EXECUTE);
		this.controlInstance.getDescendantOfName("revert_stepback").setTip("Quick switch to archive");
		this.setControlButton("catchup_stepforward", 1, jsx3.gui.Form.STATEDISABLED);

		this.controlInstance.getDescendantOfName("archTS_start").setText("",true);
		this.controlInstance.getDescendantOfName("archTS_end").setText("",true);

		for(i=0;i<this.group.players.length;i++) { // change all headers to live
			if(this.group.getPlayer(i).getParameter("isAudio")!="true" && this.controlInstance.getServer().getJSXById(this.group.getPlayer(i).id)){
				var objCell = this.controlInstance.getServer().getJSXById(this.group.getPlayer(i).id);
				objCell.setAttribute("player_mode", "0");
				objCell.getDescendantOfName('cell_dev_state').setAttribute("onclick","mx.MATRIX2.quickSwitch2archive(jsx3.GO(this.id).getAncestorOfName('cell_blk'), false);");
				objCell.getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_live.png').repaint();

				mx.MATRIX2.setButtonInCellHeader(objCell, 'cell_jump2event', false);
				//--TD--> DE354:
				if(objCell.getAttribute("position_control") == "1") {
					mx.MATRIX2.setButtonInCellHeader(objCell, 'cell_joystick', true);
				}
			}
		}

		var objCell = mx.MATRIX2.getServer().getJSXById(this.group.getPlayer(this.getNonAudioMainPlayerPos()).id);
		objCell.removeAttribute("manual_ts_from");
		objCell.removeAttribute("manual_ts_to");

		this.lastTimestamp = 0;

		//this.clearMarks();
		this.checkTimeline();
		this.play();

		this.setControlButton("record", 1, jsx3.gui.Form.STATEENABLED);
		this.checkRecordButton();

		if(this.allowJumpOverHolesInArchive){
			this.setControlButton("gap", 2, jsx3.gui.Form.STATEDISABLED);
		}
		else{
			this.setControlButton("gap", 1, jsx3.gui.Form.STATEDISABLED);
		}
	};

	/*this.checkAvatarOnDemand = function() {
		if (this.needArchiveOnDemand()) {
			var now = mx.MATRIX2.getServerTime();
			mx.TIMELINE.setParameters('gn', {selection: {sticky: mx.ELog2.timeline.SELECTION_STICKY_TO_TIMELINE}});
			mx.TIMELINE.setSelectedInterval(now - quickSwitch2ArchiveInterval, now, false, true, 'gn');
		}
	};
*/
	this.canArchiveOnDemand = function() {
		if (this.group.contextType != 3) {
			return false;
		}

		if (this.group === activeGroup_Cell) {
			var player = this.group.players[0].player;
			var objid = player.devObjId;
			var camera = resourceTree.getObject(objid);
			if(jsDebug){ appLogger.info("canArchiveOnDemand: AVATARID=" + camera.attr('AVATARID') + ", AV_DELIVERY=" + camera.attr('AV_DELIVERY') + ", STREAMNUM=" + player.getParameter('STREAMNUM')); }
			if (camera.attr('AVATARID'))
				return true;
		}
		return false;
	};

	/**
	 * set new group
	 *
	 * @param activeGroup group reference
	 * @param {boolean} swith2currentMode
	 * @param {boolean} isCheckTimeline
	 */
	this.setGroup = function (activeGroup, swith2currentMode, isCheckTimeline)
	{
		//appLogger.info("setGroup: START");

		if(activeGroup != null && activeGroup != this.group) {
			this.group = activeGroup;
			this.group.setListener(this);
			//appLogger.info("setGroup: group set to "+activeGroup.id);

			if(swith2currentMode){
				if(this.group.contextType == 2){
					this.switch2live();
				}
				if(this.group.contextType == 3){
					this.switch2archive();
				}
			}

            this.runCurrentTSMonitor(true);
		}
		if(isCheckTimeline){
			this.checkTimeline();
		}
		this.setAccess(true, true, true);
		//appLogger.info("setGroup: OK");
	};

	/**
	 * unset group
	 */
	this.unsetGroup = function (newGroup) {
		//appLogger.info("unsetGroup: START");
		var checkTimeline = true;
		if(newGroup != null && this.group.contextType == newGroup.contextType){
			checkTimeline = false;
		}
		if(this.group != null){
			this.clearMarks();
			this.group = null;
		}

		this.setAccess(true, true, true, true);
		this.controlInstance.getDescendantOfName('date').setText('', true);
		this.controlInstance.getDescendantOfName('time').setText('', true);
		if(checkTimeline) {
			this.checkTimeline();
		}
        this.stopCurrentTSMonitor();

		this.preloadTs = null;
		clearTimeout(window["controlContentPreload"]);
		clearTimeout(window["controlContentPreloadCheck"]);
		//appLogger.info("unsetGroup: END");
	};

    /*
    * run current timestamp monitoring
    * */
    this.runCurrentTSMonitor = function(isStartMonitor){
        if(this.group == null || !this.group.getCurrentTS){
            return;
        }

        var curTS = this.group.getCurrentTS();
        if(curTS){
            this.onNewImage(this.group, curTS);
        }

        if(isStartMonitor){
            if(window['control_curts_monitor_var']){ clearTimeout(window['control_curts_monitor_var']); }
            window['control_curts_monitor_var'] = window.setTimeout(function(){
                jsx3.GO('layoutControlComponent').controls.runCurrentTSMonitor(isStartMonitor);
            }, this.tsMonitorPeriod);
        }
        //if(window.jsDebug){ appLogger.info("CONTROL.runCurrentTSMonitor: curTS = " + curTS); }
    };

    /*
    * stop current timestamp monitoring
    * */
    this.stopCurrentTSMonitor = function(){
        if(window['control_curts_monitor_var']){ clearTimeout(window['control_curts_monitor_var']); }
        //if(window.jsDebug){ appLogger.info("CONTROL.stopCurrentTSMonitor"); }
    };


	/**
	 * set timeline visibility
	 */
	this.checkTimeline = function() {
		//appLogger.info("checkTimeline: START");
		var opened = parseInt(jsx3.GO('TopTimelineBlock').getAttribute('status'));

		if(this.group != null && (this.group.getGroupSize()-this.group.getNumOfAudioDevices()) != 0) {
			// if in live mode
			if(this.group.contextType == 2 && opened) {
				mx.TIMELINE.hideTimeLine('gn');
			}
			// if in archive mode
			if (this.group.contextType == 3) {
				mx.TIMELINE.showTimeLine('gn');
			}
		} else {
			if(opened) {
				mx.TIMELINE.hideTimeLine('gn');
			}
		}
		//appLogger.info("checkTimeline: END");
	};


/*****************************************
 *           Control callbacks
 *****************************************/

	/**
	 * set new time to control
	 */
	this.setTime = function (timestamp) {
		if(window.jsDebug){ appLogger.info("CONTROL.setTime: ts = " + timestamp + ", " + (new Date(timestamp)).toString()); }

		if(this.group != null && this.group.contextType == 3){
			this.group.setContext(3, timestamp, timestamp + 12*60*60*1000);
            this.play(true);
			/*if(timestamp > this.group.archiveInterval.startTS && timestamp < this.group.archiveInterval.endTS){
				//play from ts
				this.group.play(1, this.curSpeed, timestamp);
				this.play();

				if(window.jsDebug){ appLogger.info("CONTROL.setTime: new ts inside interval = "+timestamp); }
			}
			else{
				this.extendBoundary(timestamp);
			}*/

			this.checkSelection(timestamp);

			//if set into event, reset boundary attribute value
			var objCell = mx.MATRIX2.getServer().getJSXById(this.group.getPlayer(this.getNonAudioMainPlayerPos()).id);
			if(objCell.getAttribute("eventid") != "-1"){
				/*if(timestamp <= objCell.getAttribute("markA")){
					objCell.setAttribute("stoped_on_start_boundary", "0");
					if(window.jsDebug){ appLogger.info("CONTROL.setTime: stoped_on_start_boundary to 0"); }
				}*/
				if(timestamp <= objCell.getAttribute("ts_to")){
					objCell.setAttribute("stoped_on_end_boundary", "0");
					if(window.jsDebug){ appLogger.info("CONTROL.setTime: stoped_on_end_boundary to 0"); }
				}
			}
		}
		//if(window.jsDebug){ appLogger.info("CONTROL.setTime: END"); }
	};

    /*
     * extend archive interval
     * timestamp - new boundary timestamp
     */
    this.extendBoundary = function(timestamp){
        if(timestamp < this.group.archiveInterval.startTS){
            if(window.jsDebug){ appLogger.info("CONTROL.extendBoundary: set context to 3, moving START boundary to "+timestamp+", old = "+this.group.archiveInterval.startTS); }
            this.group.setContext(3, timestamp, this.group.archiveInterval.endTS);
            this.play(true);
        }
        else if(timestamp > this.group.archiveInterval.endTS){
            if(window.jsDebug){ appLogger.info("CONTROL.extendBoundary: set context to 3, moving END boundary to "+timestamp+", old = "+this.group.archiveInterval.endTS); }
            this.group.setContext(3, this.group.archiveInterval.startTS, timestamp);
            this.play(true);
        }
    };

      /*
     * check and reposition time due to selection
     * timestamp - new timestamp
     */
    this.checkSelection = function(timestamp){
        var objCell = jsx3.GO(this.group.getPlayer(this.getNonAudioMainPlayerPos()).id);
        var corrected = false;

        var ts_from = /*objCell.getAttribute("markA") || */objCell.getAttribute("ts_from");
        var ts_to = /*objCell.getAttribute("markB") || */objCell.getAttribute("ts_to");
        //if(window.jsDebug){ appLogger.info("CONTROL.checkSelection: ts_from = "+ts_from+", ts_to="+ts_to); }
        //check if selection exists
        if(ts_from && ts_to){
            //if simple archive selection
            if(objCell.getAttribute("eventid") == "-1"){
                //if moved out of boundaries move it back
                if(timestamp < ts_from){
                    this.group.playOneFrameTS(parseInt(ts_from));
                    corrected = true;
                    if(window.jsDebug){ appLogger.info("CONTROL.checkSelection: playOneFrameTS tsA = "+timestamp+", date="+(new Date(timestamp))); }
                }
                else if(timestamp > ts_to){
                    this.group.playOneFrameTS(parseInt(ts_to));
                    corrected = true;
                    if(window.jsDebug){ appLogger.info("CONTROL.checkSelection: playOneFrameTS tsB = "+timestamp+", date="+(new Date(timestamp))); }
                }
            }
            //if event
            else{
                //stop in the end
                //if(window.jsDebug){ appLogger.info("CONTROL.checkSelection: playOneFrameTS check event ts = "+timestamp+", markA="+objCell.getAttribute("markA")+", markB="+objCell.getAttribute("markB")+", stoped_on_start_boundary"+objCell.getAttribute("stoped_on_start_boundary")+", stoped_on_end_boundary"+objCell.getAttribute("stoped_on_end_boundary")); }
                /*if(timestamp > objCell.getAttribute("markA") - 500 && timestamp < objCell.getAttribute("markA") + 500 && objCell.getAttribute("stoped_on_start_boundary") == 0){
                    this.group.playOneFrameTS(parseInt(objCell.getAttribute("markA")));
                    objCell.setAttribute("stoped_on_start_boundary", "1");
                    corrected = true;
                    if(window.jsDebug){ appLogger.info("CONTROL.checkSelection: playOneFrameTS start of event tsA = "+timestamp+", date="+(new Date(timestamp))); }

                }
                else */if(timestamp > ts_to - 500 && timestamp < ts_to + 500 && objCell.getAttribute("stoped_on_end_boundary") == 0){
                    this.group.playOneFrameTS(parseInt(ts_to));
                    objCell.setAttribute("stoped_on_end_boundary", "1");
                    corrected = true;
                    if(window.jsDebug){ appLogger.info("CONTROL.checkSelection: playOneFrameTS end of event tsB = "+timestamp+", date="+(new Date(timestamp))); }
                }
            }
        }
        return corrected;
    };

	/*
	 * onNewImage callback
	 */
	this.onNewImage = function(objGroup, timestamp) {
		timestamp = parseInt(timestamp);

		if(objGroup!=this.group || !timestamp)
			return;

		if(typeof(timestamp) == 'string'){
			timestamp = parseInt(timestamp);
		}

		//if archive move timeline
		if(this.group.contextType == 3){
			//if(window.jsDebug){ appLogger.info("CONTROL.onNewImage: this.group.contextType="+this.group.contextType+", timestamp="+timestamp+", diff="+Math.abs(this.lastTimestamp - timestamp)); }
			var diff = Math.abs(this.lastTimestamp - timestamp);
			if(diff > 1000){
				if (mx.CT.getActiveTab().getAttribute("curType") == 'motion') {
					var cellId = mx.CT.getActiveTab().getFirstChild().getFirstChild().getId();
					var timeline = $('#' + cellId).data('model').timeline;
					timeline.setTime(timestamp, false);
				} else {
					this.checkSelection(timestamp);
					mx.TIMELINE.setTime(timestamp, false, 'gn');
				}
				this.lastTimestamp = timestamp;
			}

			if(mx.TIMELINE.lastTimeRequest == null && diff > this.minContentJump && diff != this.lastTimestamp){
				//if(window.jsDebug){ appLogger.info("CONTROL.onNewImage: this.lastTimestamp="+this.lastTimestamp+", timestamp="+timestamp); }
				//if(window.jsDebug){ appLogger.info("CONTROL.onNewImage: diff="+diff+", this.minContentJump="+this.minContentJump+", mx.TIMELINE.lastTimeRequest="+mx.TIMELINE.lastTimeRequest); }
				mx.MATRIX2.showMessage(__("Timeline"), __("Advancing to " + mx.TIME.timestamp2date(timestamp, mx.MATRIX2.getIdentityValue("NLS_LONG_DATE_FORMAT")+ " HH:II")))
			}
		}

		// pre-load content if half of previously preloaded already played
		if(this.preloadTs != null && timestamp >= this.preloadTs){
			if(window.jsDebug){ appLogger.info("---------->CONTROL.onNewImage: PRELOAD ON MIDDLE this.preloadTs="+this.preloadTs+", timestamp="+timestamp); }
			this.preloadContent(false, true);
			this.preloadTs = null;
		}

		//if(window.jsDebug){ appLogger.info("CONTROL.onNewImage: ts = "+timestamp+", date="+(new Date(timestamp))); }
		var strDate = mx.TIME.timestamp2date(timestamp).split(" ");
		var date_formatted = strDate[0];
		var time_formatted = strDate[1];

		document.getElementById(this.controlDateBlock).innerHTML = date_formatted;
		document.getElementById(this.controlTimeBlock).innerHTML = time_formatted;

		//appLogger.info("onNewImage: END");
	};

	/*
	 * onSnapshotFinish callback
	 */
	this.onSnapshotFinish = function() {
        //if state before snapshot pause was play - recover it
        if(this.stateBeforeSnapshot == 2){
            this.play(true);
        }

        this.stateBeforeSnapshot = 0;
	};

	/**
	 * onClick callback
	 */
	this.onClick = function(objPlayer, x, y, isActive) {
		if (!objPlayer)
			return;

		if (!isActive) {
			mx.MATRIX2.setSelectedGroup(mx.MATRIX2.getServer().getJSXById(objPlayer.id).getDescendantOfName("cell_select"), false, false);
			return;
		}

		//if only one player in group and playing live and not in designation mode
		if ((this.group.getGroupSize() == 1 || (this.group.getGroupSize() == 2 && this.group.getNumOfAudioDevices()==1))
			&& this.group.contextType == 2 && typeof objPlayer.playerImpl.zoom.onimageclick !== 'function') {
			//"click-on-the-screen" PTZ capability
			//if PTZ supported
			if (objPlayer.getParameter('POSITIONCTL') != 'none'){
				mx.PTZ.clickOnScreen(objPlayer,x,y);
			}
		}
	};

	/**
	 * onBufferChange callback
	 */
	this.onBufferChange = function(objGroup,startTS,endTS) {
		/*if(this.group && this.group==objGroup && this.group.contextType!=2){
            //not in use
		}*/
	};

	/**
	 * onStatusChange callback
	 */
	this.onStatusChange = function(objPlayer, command, status, errorcode) {
		if(window.jsDebug){ appLogger.info("CONTROL.onStatusChange: objPlayer="+objPlayer.id+", command="+command.cmd+", status="+status+", errorcode="+errorcode); }

		//if archive catched up live
		if(errorcode == MediaPlayer.UNKNOWNSTREAMTYPE){
			if(mx.TIMELINE.lastTimeRequest != null){
				var now = mx.MATRIX2.getServerTime();

				this.setSpeedData(1);
				this.setTime(now - 10*1000);

				//TODO remove this hack
				window.setTimeout(function(){
					mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.pause(true);
					mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.play(true);
				}, 100);

				mx.MATRIX2.showMessage(__("Timeline"), __("Requested time is in the future.<br />Repositioning to -10 seconds."));
			}
			else{
				mx.MATRIX2.showMessage(__("Timeline"), __("Reached LIVE point, auto-switching to LIVE."));
				this.switch2live();
			}
			return;
		}
		else if((errorcode == MediaPlayer.ENDOFSTREAM || errorcode == MediaPlayer.INTERNALERROR) && this.canArchiveOnDemand()){
			this.preloadContent(true, false);
			return;
		}

		// if playback stopped, NO VIDEO
		if(status != 1 && status != 2 && status != 4){
			this.pause(false);
		}
		//restore playback
		else if(command.cmd == 2 && status == 1){
			this.play(false);
		}

		if(this.group && this.group.contextType == 2 && status == 2){ //if going to 'review' mode
			alert(__("Switching to 'review' mode!"));
			this.isInReviewMode = true;
		}
		else{
			this.isInReviewMode = false;
			//TODO review mode
		}
	};

	/**
	 *  pre-load main player content
	 */
	this.preloadContent = function(pause, allowStartFromMiddle){
		if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: pause="+pause); }
		var self = this;
		if (this.group === activeGroup_Cell) {
			var player = this.group.players[0].player;

			var objId = player.devObjId;

			var curTs = mx.TIMELINE.lastTimeRequest;
			if(!curTs){
				curTs = this.lastTimestamp;
			}

			if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: objId="+objId+", curTs="+curTs); }

			var now = mx.MATRIX2.getServerTime();
			var preloadLength = 2*60*1000;
			if(!curTs){
				if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: request timestamp not found"); }
				return;
			}
			else if(curTs + 2*60*1000 >= now - 2*60*1000){
				if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: preload too close to live, load 1 min"); }
				preloadLength = 1*60*1000;
			}
			
			var streamNum = player.getParameter('STREAMNUM');
			
			// do not start request if timestamp in already requested interval
			if(!allowStartFromMiddle && mx.TIMELINE.isAODRequested(curTs, streamNum)){
				if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: request for timestamp already exists"); }
				return;
			}
			else if(allowStartFromMiddle && mx.CDM.isAODAlreadyDownloading(curTs, streamNum)){
				if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: preload interval exists"); }
				return;
			}

			var command = this.group.getCommand();
			if(pause && command.cmd == 2){
				this.pause();
			}

			var playerFrame = mx.MATRIX2.getIFrame(jsx3.GO(player.id).getDescendantOfName('iframe_player'));
			var playerWrapper = playerFrame.playerWrapper;

			var fontSize = 24;
			if(streamNum == 0){
				fontSize = 12;
			}

			playerWrapper.addText("PRELOAD_FROM_AVATAR", "Requesting video from Avatar", 5, 75, fontSize, 0xFFFFDD00);
			playerFrame.__videoPlayers[0].displayMessage("Requesting video from Avatar");

			// play after downloading
			var isDone = mx.CDM.addRequest(objId, curTs, curTs + 2*60*1000, true, streamNum, function(){
				if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: finished"); }
				clearTimeout(window["controlContentPreload"]);
				playerWrapper.removePrimitive("PRELOAD_FROM_AVATAR");
				mx.TIMELINE.refreshTimelineContents();
				if(pause){
					self.setTime(curTs + 1*1000);
					self.play();
				}
				self.preloadTs = curTs + 1*60*1000;
				if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: apply, self.preloadTs=" + self.preloadTs); }
			});

			// if request send failed
			if(!isDone){
				playerWrapper.removePrimitive("PRELOAD_FROM_AVATAR");
				if(pause && command.cmd == 2){
					this.play();
				}
				return;
			}
			else{
				mx.TIMELINE.refreshTimelineContents();
			}

			var request = mx.CDM.privateRequests[mx.CDM.privateRequests.length - 1];
			var reqId = request.data.requestid;

			// launch timeout for long waiting time
			clearTimeout(window["controlContentPreload"]);
			clearTimeout(window["controlContentPreloadCheck"]);
			window["controlContentPreload"] = window.setTimeout(function(){
				if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: timeout, reqId=" + reqId); }
				var req = mx.CDM.getRequest(reqId);
				if(req.status != "COMPLETED"){
					playerWrapper.addText("PRELOAD_FROM_AVATAR", "Content delivery takes too long", 5, 75, fontSize, 0xFFFFDD00);
					playerFrame.__videoPlayers[0].displayMessage("Content delivery takes too long");

					mx.CDM.showDownloadJobDialog(objId, curTs, streamNum);
					
					var dialog = $("#avatar_download_content_job");
					dialog.data("onTimeout", true);

					window.setTimeout(function(){
						playerWrapper.removePrimitive("PRELOAD_FROM_AVATAR");
					}, 5*1000);
				}
			}, 120*1000);

			// if request download finished in failed state
			this.onContentPreloadFail = function(){
				playerWrapper.addText("PRELOAD_FROM_AVATAR", "Content delivery failed", 5, 75, fontSize, 0xFFFFDD00);
				playerFrame.__videoPlayers[0].displayMessage("Content delivery failed");

				clearTimeout(window["controlContentPreload"]);

				mx.TIMELINE.refreshTimelineContents();
				mx.CDM.showDownloadJobDialog(objId, curTs, streamNum);

				window.setTimeout(function(){
					playerWrapper.removePrimitive("PRELOAD_FROM_AVATAR");
				}, 5*1000);
			};

			this.checkContentPreload(reqId);
		}
		if(window.jsDebug){ appLogger.info("---------->CONTROL.preloadContent: end"); }
	};

	/**
	 *  check content pre-loading state
	 */
	this.checkContentPreload = function(requestId){
		var self = this;
		clearTimeout(window["controlContentPreloadCheck"]);
		window["controlContentPreloadCheck"] = window.setTimeout(function(){
			var req = mx.CDM.getRequest(requestId);
			for(var i = 0; i < mx.CDM.privateRequests.length; i++){
				if(req && mx.CDM.privateRequests[i].data.requestid == req.requestid){
					mx.CDM.privateRequests[i].data = req;
					if(window.jsDebug){ appLogger.info("---------->CONTROL.checkContentPreload: requestId="+requestId+", data.status="+ mx.CDM.privateRequests[i].data.status); }
					mx.CDM.privateRequests[i].checkCompleted();

					if(mx.CDM.privateRequests[i].data.status == "COMPLETED" || mx.CDM.privateRequests[i].data.status == "FAILED"){
						if(mx.CDM.privateRequests[i].data.status == "COMPLETED"){
							if(window.jsDebug){ appLogger.info("---------->CONTROL.checkContentPreload: COMPLETED"); }
							// close dialog if no data changed
							var dialog = $("#avatar_download_content_job");
							if(dialog.find("#avatarDownloadJobDuration").length != 0 && dialog.data("onTimeout") && !dialog.data("changed")){
								if(window.jsDebug){ appLogger.info("---------->CONTROL.checkContentPreload: close dialog"); }
								mx.CDM.closeDownloadJobDialog();
							}
						}
						else if(mx.CDM.privateRequests[i].data.status == "FAILED"){
							self.onContentPreloadFail();
						}

						window.setTimeout(function(){
							clearTimeout(window["controlContentPreloadCheck"]);
						}, 1000);
					}
					break;
				}
			}
			self.checkContentPreload(requestId);
		}, 5*1000);
	};

	/**
	 *  on content pre-loading failed
	 */
	this.onContentPreloadFail = function(){

	};

	/**
	 * onContextChange callback
	 */
	this.onContextChange = function(objPlayer) {
		//alert('onContextChange');
	};

	/**
	 * onReversePlaybackChange callback
	 */
	this.onRPlaybackChange = function(objGroup,isReversePlybackEnabled) {
		//alert('group='+objGroup.id+' isReversePlybackEnabled='+isReversePlybackEnabled);

		if(objGroup != this.group)
			return;


		var command = this.group.getCommand();
		if(this.group.contextType==3 && (command.cmd==0 || command.cmd==1 || command.cmd==3)){ //if archive stoped
			if(isReversePlybackEnabled){ // if enabled
				this.controlInstance.getDescendantOfName("revert_stepback").setEnabled(jsx3.gui.Form.STATEENABLED, true);
			}
			else{
				//alert('not ok');
				this.controlInstance.getDescendantOfName("revert_stepback").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
				//this.setMenuItemVisibility(["back", "step_back"], false);
			}
		}
	};

	this.setAccess(isControlEnabled,isLiveModeEnabled,isArchiveModeEnabled);
	return this;
};
});
