/**
 * AlertLogHistory component, retrieves and saves history from command line
 *
 *
 * Publishes:
 * AlertLogHistory.selectLine(line) - line in the history component was selected
 *
 */


(function() {
	"use strict";

	var history = []; // History commands queue

	window.AlertLogHistory = {

		block: null, // whole history log block
		input: null, // input element containing history commands to choose from

		// Quantity of lines to remember in textarea
		rememberLines: 20,

		init: function(block) {
			this.block = block;

			this.block.html(
				'History Log:' +
				'<div class="historyListWrapper">' +
					'<ul class="historyList"></ul>' +
				'</div>'
			);

			this.input = this.block.find('ul.historyList');
			this.input.on('click', 'li', function() {
				$.Topic('AlertLogHistory.selectLine').publish($(this).text());
			});
		},

		addLine: function(line) {
			this.addLineToHistoryPool(line);
			this.updateInput();
		},

		addChanges: function(c) {

			var result = [c.shortId + ':'];

			if (c.priority) {
				result.push('Priority: ' + c.priorityName + ';');
			}
			if (c.note) {
				result.push('Note: ' + c.note + ';');
			}
			if (c.properties && c.properties.hold) {
				result.push('Holded;');
			}

			this.addLine(result.join(' '));
		},

		addLineToHistoryPool: function(line) {
			while (history.length >= this.rememberLines) {
				history.shift();
			}
			history.push({user: resourceTree.getUser().obj, line: line});
		},

		updateInput: function() {
			var i, html = '';

			for (i = history.length-1; i>=0; i--) {

				if (history[i].user == resourceTree.getUser().obj) {
					html += '<li class="own">' + history[i].line + '</li>';
				} else {
					html += '<li>' + history[i].line + '</li>';
				}
			}
			this.input.html(html);
		}
	}



})();
