
(function() {
	"use strict";

	window.AlertLogEventDialog = function(parentBlock) {
		this.parentBlock = parentBlock;
		this.event = null;
		this.device = null;

		this.parentBlock.append(
			'<div class="event_dialog dialog">' +
				'<div class="header">' +
					'<div class="title"></div>' +
					'<div class="close"></div>' +
				'</div>' +
				'<div class="content">' +
					'<div class="tabs">' +
						'<span>General</span>' +
						'<span>Details</span>' +
					'</div>' +
					'<div class="panes" style="clear: both;">' +
						'<div class="general">' +
							'<div style="width: 185px; float: left;">' +
								'<img class="snapshot" src=""/>' +
								'<div>Priority: <span class="priority"></span></div>' +
								'<div>Time: <span class="time"></span></div>' +
								'<div>Duration: <span class="duration"></span></div>' +
							'</div>' +
							'<div style="width: 200px; margin-left: 190px;">' +
								'<div><button class="acknowledge">acknowledge</button></div>' +
								'<div><button class="clear">clear</button></div>' +
								'<div><button class="play">play</button></div>' +
								'<div>System message: <span class="system_message"></span></div>' +
							'</div>' +
						'</div>' +
						'<div class="details">' +
							'<div style="width: 185px; float: left;">' +
								'<div>Priority: <select class="priority_select">' + this.getPrioritySelectorHtml() + '</select></div>' +
								'<div>Device: <select class="device_select"></select></div>' +
							'</div>' +
							'<div style="width: 200px; margin-left: 190px;">' +
								'User message: <textarea class="user_message"></textarea>' +
							'</div>' +
							'<div class="snapshots"></div>' +
						'</div>' +
					'</div>' +
				'</div>' +
			'</div>'
		);

		this.block = this.parentBlock.find('.event_dialog');
		this.blocks = {
			title: this.block.find('.title'),
			content: this.block.find('.content')
		};

		this.block.find('div.tabs').tabs('div.panes > div', {tabs: 'span'});

		this.block.overlay({
			mask: {
				color: '#ebecff',
				loadSpeed: 100,
				opacity: 0.9
			},
			top: '20%',
			oneInstance: false,
			closeOnClick: false,
			close: '.close'
		});
	};

	window.AlertLogEventDialog.prototype = {

		close: function() {
			this.block.data('overlay').close();
		},

		open: function(event) {
			this.setEvent(event);
			this.block.data('overlay').load();
		},

		setEvent: function(event) {
			this.event = event;
			this.device = this.getEventCamera();

			this.blocks.title.html(
				' Event ID: ' + this.event.data.id +
				' Device: ' + this.event.data.obj.name
			);

			this.blocks.content
				.find('.snapshot').attr('src', resourceTree.getSnapshotHref(this.device.obj, this.event.data.utc.when)).end()
				.find('.priority').html(this.event.getPriorityName()).end()
				.find('.time').html(mx.TIME.timestamp2date(this.event.data.utc.when)).end()
				.find('.duration').html(mx.TIME.formatUTCDate(this.event.data.utc.duration, 'HH?:II:SS')).end()
				.find('.system_message').html(this.event.data.msg).end()

				.find('.priority_select').val(this.event.data.priority).end()
				.find('.device_select').html(this.getDeviceSelectorHtml()).end()
				.find('.user_message').html(this.event.data.note).end()
				.find('.snapshots').html(this.getSnapshotsHtml( this.blocks.content.find('.device_select').val() ));

			this.updateButtonsView();
		},

		updateButtonsView: function() {
			this.block.find('.clear').show();
			if (!this.event.checkTag('Clearable')) {
				this.block.find('.clear').hide();
			}

			this.block.find('.acknowledge').show();
			if (!this.event.checkTag('NeedAck')) {
				this.block.find('.acknowledge').hide();
			}
		},

		getPrioritySelectorHtml: function() {
			var pr = AlertLogEvent.prototype.PRIORITIES;
			var html = '';
			for (var i in pr) {
				html += '<option value="' + i + '">' + pr[i].name + '</option>';
			}

			return html;
		},

		getDeviceSelectorHtml: function() {

			var witnesses = this.event.getWitnesses();
			var html = '';

			for (var i in witnesses) {
				if (witnesses[i].type != "D" || witnesses[i].subtype != "C")
					continue;

				html += '<option value="' + witnesses[i] + '">' + witnesses[i].name + '</option>';
			}

			return html;
		},

		getSnapshotsHtml: function(objId) {

			var time = this.event.data.utc.from;
			var html = '';

			while (time < this.event.data.utc.to) {

				html += '<span><img src="' + resourceTree.getSnapshotHref(objId, time) + '" /><span class="timestamp">' + mx.TIME.formatUTCDate(time, 'HH:II:SS') + '</span></span>';

				time += 5000;
			}

			return html;
		},

		/**
		 * Find first camera between event witnesses.
		 * Usually this is main event witness
		 *
		 * @return Object
		 */
		getEventCamera: function() {
			var witnesses = this.event.getWitnessesList();
			var device = resourceTree.getObject({'obj': witnesses, 'type': 'camera'});
			if (!device) {
				device = resourceTree.getObject({'obj': witnesses});
			}

			return device;
		}
	};

})();
