<?php
	require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

	$list = DB::select("
			    SELECT o.obj, a.val
			    FROM _objs o, _obj_attr a
				WHERE
					    o.obj=a.obj
					AND o.otype='D' AND o.subtype='V' AND o.deleted=0
					AND a.attr='TCP_IP'");

	$trusted = false;
	foreach ($list as $row) {
		if ($row["val"] === $_SERVER["REMOTE_ADDR"]) {
			$trusted = true;
			break;
		}
	}

	if (!$trusted) {
		header('HTTP/1.0 403 Forbidden');
		echo __("You are forbidden to access this page") . "\n";
		exit;
	}
?>

<!DOCTYPE html>
<html>
<head>
	<link rel="stylesheet" type="text/css" href="../../css/alertlog.css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/jquery.pubsub.js"></script>

	<script src="AlertLogFilter.js"></script>
	<script src="AlertLogEvent.js"></script>
	<script src="AlertLogModel.js"></script>
	<script src="AlertLogView.js"></script>
</head>
<body>

<header></header>

<div id="vmxAlertLog"></div>

<script>

	window.core = {
		time: {
			timestamp2date: function(timestamp, format) {
				return core.time.formatUTCDate(timestamp - (new Date().getTimezoneOffset() * 60 * 1000), format);
			},
			formatUTCDate: function(timestamp, format) {
				timestamp = parseInt(timestamp, 10);
				format = format || "MM/DD/YYYY HH:II:SS";
				var date = new Date(timestamp);

				format = format.replace('YYYY', date.getUTCFullYear());
				format = format.replace('YY',   String(date.getUTCFullYear()).substr(2));
				format = format.replace('MM',  (date.getUTCMonth()+1<10) ?  "0"+(date.getUTCMonth()+1)  : date.getUTCMonth()+1);
				format = format.replace('DD',  (date.getUTCDate()<10)    ?  "0"+date.getUTCDate()       : date.getUTCDate());

				format = format.replace('HH?:',
					date.getUTCHours() > 0
						? ((date.getUTCHours()<10) ? "0"+date.getUTCHours() : date.getUTCHours()) + ':'
						: ''
				);
				format = format.replace('II?:',
					date.getUTCMinutes() > 0
						? ((date.getUTCMinutes()<10) ? "0"+date.getUTCMinutes() : date.getUTCMinutes()) + ':'
						: ''
				);
				format = format.replace('SS?',
					date.getUTCSeconds() > 0
						? ((date.getUTCSeconds()<10) ? "0"+date.getUTCSeconds() : date.getUTCSeconds())
						: ''
				);

				format = format.replace('HH',  (date.getUTCHours()<10)   ?  "0"+date.getUTCHours()      : date.getUTCHours());
				format = format.replace('II',  (date.getUTCMinutes()<10) ?  "0"+date.getUTCMinutes()    : date.getUTCMinutes());
				format = format.replace('SS',  (date.getUTCSeconds()<10) ?  "0"+date.getUTCSeconds()    : date.getUTCSeconds());

				return format;
			}

		}
	};


	function onAppletReady() {
		setTimeout('_onAppletReady()', 100)
	}

	function _onAppletReady() {
		var view = new AlertLogView($('#vmxAlertLog'));

		var filter = new AlertLogFilter({state: 'not_cleared'});
		var model = new AlertLogModel($('#elog_client')[0]);
		model.start(filter.getModelFilter());

		$.Topic('AlertLogModel.newEvents').subscribe(function(eventList) {view.appendEvents(eventList);});
		$.Topic('AlertLogEvent.update').subscribe(function(event) {
			if (!filter.fit(event)) {
				view.removeEvent(event);
				model.removeEvent(event);
			}
		});
	}

</script>

<applet codebase='/wheels' archive='eLogClientApplet.jar,Messenger.jar,elogiface.jar,libfwiface.jar,libomiface.jar,libthrift.jar,json.jar,serviceapi.jar' code='com.videonext.skm.elog.client.applet.eLogClientApplet.class' id='elog_client' width='1' height='1' mayscript>
	<param name='codebase_lookup' value='false'/>
	<param name='OnAppletReady' value='onAppletReady'/>
	<param name='MaxQueueSize' value='40'/>
	<param name='LOGLEVEL' value='ERROR'/>
	<hr/>
	Your browser does not support Java.
	Please download <a href='http://java.com:80/en/download/manual.jsp'>last version of JRE</a> for your platform
	<hr/>
</applet>

</body>
</html>
