
(function() {
	"use strict";

	/**
	 * @class
	 * Main object for Operator Alert Log Area;
	 * Wrapper and mediator for all AlertLog modules
	 */
	window.AlertLog = {

		/**
		 * inits Operator AlertLog Area and all modules
		 */
		init: function() {

			var self = this;

			if (!$('#elog_client')[0] || typeof $('#elog_client')[0].setEventFilter != 'function') {
				setTimeout(function() {self.init()}, 500);
				return;
			}

			$('body').append(
				'<div id="AlertLog">' +
					'<div class="alertHeader">Alert Management</div>' +

					'<select>' +
						'<option value="all">All</option>' +
						'<option value="hold">Hold</option>' +
						'<option value="myhold">My hold</option>' +
					'</select>' +

					'<div class="alerts"></div>' +

					'<div style="width: 50%; float: left;">' +
						'<div id="AlertLogCommander"></div>' +
						'<div id="AlertLogHistory"></div>' +
					'</div>' +

					'<div style="width: 30%; height: 40%; margin-left: 51%;" id="AlertLogPlayer"></div>' +

					'<div class="bottom_panel">' +
						'<button class="AlertLogClose">Close</button>' +
					'</div>' +
				'</div>'
			);

			$('#AlertLog').overlay({
				mask: {
					color: '#ebecff',
					loadSpeed: 100,
					opacity: 0.9
				},
				closeOnClick: false,
				oneInstance: false,
				close: '.AlertLogClose',
				onClose: function() {self.close();}
			});

			this.block = $('#AlertLog');
			this.filter = new AlertLogFilter({state: 'not_cleared'});
			this.model = new AlertLogModel($('#elog_client')[0]);
			this.view = new AlertLogView($('#AlertLog .alerts'));
			this.commander = new AlertLogCommander($('#AlertLogCommander'), this.model);
			this.history = AlertLogHistory;
			this.player = new AlertLogPlayer($('#AlertLogPlayer'));
			this.dialog = new AlertLogEventDialog(this.block);


			AlertLogHistory.init($('#AlertLogHistory'));


			$.Topic('AlertLogModel.newEvents').subscribe(function(eventList) {self.view.appendEvents(eventList);});

			$.Topic('AlertLogEvent.update').subscribe(function(event, diff) {self.history.addChanges(diff);});
			$.Topic('AlertLogEvent.update').subscribe(function(event, diff) {
				if (diff.properties && diff.properties.hold) {
					self.view.holdEvent(event);
				}
			});
			$.Topic('AlertLogEvent.update').subscribe(function(event) {
				if (!self.filter.fit(event)) {
					self.view.removeEvent(event);
					self.model.removeEvent(event);
				}
			});

			$.Topic('AlertLogView.selectEvent').subscribe(function(event) {
				self.commander.setEventId(event.data.shortId)
			});
			$.Topic('AlertLogView.dblSelectEvent').subscribe(function(event) {
				self.dialog.open(event);
			});

			$.Topic('AlertLogView.removeEvent').subscribe(function(event) {if (self.player.getEventId() == event.data.id) self.player.clear();});

			$.Topic('AlertLogView.selectPlay').subscribe(function(event) {self.player.setEvent(event)});

			$.Topic('AlertLogFilter.update').subscribe(function(settings) {self.model.applyFilter(settings)});
		},

		/**
		 * Opens Operator AlertLog modal dialog and
		 * starts elog event notifications cycle
		 */
		open: function() {
			if (!$('#AlertLog').data('overlay')) {
				var self = this;
				setTimeout(function() {self.open()}, 100);
				return;
			}

			mx.ELog2.stopELog();
			$('#AlertLog').data('overlay').load();

			this.model.start(this.filter.getModelFilter());
		},

		/**
		 * Close Operator AlertLog modal dialog and
		 * stop elog event notifications cycle
		 */
		close: function() {
			this.model.stop();
			this.view.clearList();

			mx.ELog2.startELog();
		}
	};

	$(document).bind('keydown', 'Alt+a',function () {
		if (!$('#AlertLog').size()) {
			AlertLog.init();
		}
		AlertLog.open();
		return false;
	});

})();

(function() {
	"use strict";

	// Core functions to provide layer between core modules and other modules
	window.core = {

		time: {
			timestamp2date: function(timestamp, format) {
				return mx.TIME.timestamp2date(timestamp, format);
			},
			formatUTCDate: function(timestamp, format) {
				return mx.TIME.formatUTCDate(timestamp, format);
			}

		},

		resourceTree: {
			getObject: resourceTree.getObject,
			getObjects: resourceTree.getObjects
		}
	};
})();