<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
  <data jsxid="jsxroot" jsxtext="nodes">
    <xsl:for-each select="RESULT/NODES/NODE">
		<record jsxfilter="1">
		  <xsl:attribute name="jsxid"><xsl:value-of select="@ID"/></xsl:attribute>
		  <xsl:attribute name="jsxtext"><xsl:value-of select="@NAME"/></xsl:attribute>
		  <xsl:attribute name="jsxstatus"><xsl:value-of select="@STATUSVALUE"/></xsl:attribute>
          <xsl:attribute name="jsxerr">
            <xsl:choose>
              <xsl:when test="@STATUSVALUE[. = 0]">OK</xsl:when>
              <xsl:when test="@STATUSVALUE[. = 1]">W</xsl:when>
              <xsl:when test="@STATUSVALUE[. = 2]">E</xsl:when>
              <xsl:otherwise>?</xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:attribute name="jsxtip">
            <xsl:choose>
              <xsl:when test="@STATUSVALUE[. = 0]">All storage groups on this node have sufficient free space</xsl:when>
              <xsl:when test="@STATUSVALUE[. = 1]">The MIN free space threshold has been crossed</xsl:when>
              <xsl:when test="@STATUSVALUE[. = 2]">The EMERGENCY free space threshold has been crossed</xsl:when>
              <xsl:otherwise>Status unknown</xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		</record>
    </xsl:for-each>
  </data>
  </xsl:template>
</xsl:stylesheet>
