<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
  <data jsxid="jsxroot" jsxtext="groups">
    <xsl:for-each select="RESULT/NODES/NODE">
		<xsl:variable name="nodeName" select="@NAME"/>
		<xsl:variable name="nodeID" select="@ID"/>
    	<xsl:for-each select="GROUP">
            <record>
              <xsl:attribute name="jsxid"><xsl:value-of select="@JSXID"/></xsl:attribute>
              <xsl:attribute name="sysid"><xsl:value-of select="@ID"/></xsl:attribute>
              <xsl:attribute name="jsxstatus"><xsl:value-of select="@STATUSVALUE"/></xsl:attribute>
			  <xsl:attribute name="jsxnode"><xsl:value-of select="$nodeName"/></xsl:attribute>
			  <xsl:attribute name="jsxnodeid"><xsl:value-of select="$nodeID"/></xsl:attribute>
              <xsl:attribute name="jsxtext"><xsl:value-of select="@NAME"/></xsl:attribute>
              <xsl:attribute name="jsxtotal"><xsl:value-of select="@TOTALSPACE"/></xsl:attribute>
              <xsl:attribute name="jsxavail"><xsl:value-of select="@FREESPACE"/></xsl:attribute>
              <xsl:attribute name="jsxproj"><xsl:value-of select="@PROJSPACE"/></xsl:attribute>
              <xsl:attribute name="jsxerr">
                <xsl:choose>
                  <xsl:when test="@STATUSVALUE[. = 0]">OK</xsl:when>
                  <xsl:when test="@STATUSVALUE[. = 1]">W</xsl:when>
                  <xsl:when test="@STATUSVALUE[. = 2]">E</xsl:when>
                  <xsl:otherwise>?</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
	          <xsl:attribute name="jsxtip">
                <xsl:choose>
                  <xsl:when test="@STATUSVALUE[. = 0]">This storage group has sufficient free space</xsl:when>
                  <xsl:when test="@STATUSVALUE[. = 1]">The MIN free space threshold has been crossed</xsl:when>
                  <xsl:when test="@STATUSVALUE[. = 2]">The EMERGENCY free space threshold has been crossed</xsl:when>
                  <xsl:otherwise>Status unknown</xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
	<xsl:text>
	</xsl:text>
            </record>
	    </xsl:for-each>
    </xsl:for-each>
	<xsl:text>
</xsl:text>
  </data>
  </xsl:template>
</xsl:stylesheet>

