jsx3.require("jsx3.gui.Window");

/**
 * Package defining the logic of the Charter application.
 * Copyright Cyrill Kadomsky
 */
jsx3.Package.definePackage("ca.charter", function(charter) {

//============================ Common ================================
	charter.COMPONENT_PATH = "../../prototypes/Storage Allocation/";
	
	/**                                       
	* Returns the current date (dd/mm/yyyy)
	* @return {String} Formatted date
   	*/
	charter.getCurDate = function() {
		var d = new window.Date; 
		var s = new String;
		var s1 = new String;
		d.getDate();
		s1 = d.getDate();
		if(s1.toString().length<2) s1 = "0"+s1;
		s = "Analysis "+ s1 + "/";
		s1 = d.getMonth()+1;
		if(s1.toString().length<2) s1 = "0"+s1;
		return ( s + s1 + "/" + d.getFullYear() );
	};

	charter.setBrowserWndSize = function() {
		var w = 0, h = 0, wr, hr;
		//var pnRoot_Root = charter.APP.getJSXByName("root");
		var pnRoot = charter.APP.getJSXByName("root");
		wr = pnRoot.getWidth();
		hr = pnRoot.getHeight();
		//pnRoot_Root.recalcBox();
		//pnRoot_Root.repaint();
		pnRoot.recalcBox();
		pnRoot.repaint();
		pnRoot.setDisplay(jsx3.gui.Block.DISPLAYNONE,true);
//		alert("qqq");
		pnRoot.setDisplay(jsx3.gui.Block.DISPLAYBLOCK,true);
		pnRoot.repaintChildren();
		
		var pnAbsolute = charter.APP.getJSXByName("pnAbsolute");
		w = pnAbsolute.getWidth();
		h = pnAbsolute.getHeight();
		alert("pnAbsolute "+ w +" "+ h+"\nroot "+ wr +" "+ hr );
		pnAbsolute.setWidth(w+1);
		pnRoot_Root.recalcBox();
		pnRoot_Root.repaint();
		pnRoot.recalcBox();
		pnRoot.repaint();
		pnAbsolute.repaint();
	};
	
		
	/**
	* Returns RGB color for a fiven status string.
	* @param status {String} status name (OK|W|E)
	* @return {jsx3.vector.Fill}
	*/
	charter.getStatusColor = function(status) {
		if(status.substring(0,1)=="O") return "#038E01";
		else if(status.substring(0,1)=="W") return "#CB8104";
		else if(status.substring(0,1)=="E") return "#FF0000";
		else return "#505050";
	};

	/**
	* This function assigns a coloring function to a status matrix column 
	* Coloring function uses charter.getStatusColor() to create an RGB color.
	* @param objColumn {jsx3.gui.Matrix.Column} the column to be colored.
	*/
	charter.colorizeStatus = function(objColumn) {
		var f =
			function(element,cdfkey,matrix,matrixcolumn,rownumber,server) {
				var txt = element.innerHTML;
				element.innerHTML = "<B><FONT color="+ca.charter.getStatusColor(txt)+" >"+txt+"</FONT></B>";
			};
		objColumn.setFormatHandler(f.toString());
	};

	/**                                       
	* Count gui object's XML children (rows)
	* @param objJSX {jsx3.xml.Cacheable} Target gui object.
	* @return {int} Number of children
	*/
	charter.countXMLChildren = function( objJSX ) {
		var i = objJSX.getXML().getRootNode().getChildIterator(false), cnt = 0;
		for ( ; i.hasNext(); i.next() ) cnt++;
		return cnt;
	};
	
	/**                                       
	* Call specified method for each gui object's XML child (row)
	* @param objJSX {jsx3.xml.Cacheable} Target gui object.
	* @param funcProcess {function} Method to process rows.
	* @return {int} Number of rows processed
	*/
	charter.forEachXMLChild = function( objJSX, funcProcess ) {
		if ( funcProcess == null ) return 0;
		var i = objJSX.getXML().getRootNode().getChildIterator(false), cnt = 0;
		while ( i.hasNext() ) {
			funcProcess( i.next(), cnt );
			cnt++;
		}
		return cnt;
	};
	
	/**                                       
	* Modifies layout containing Matrix object so that all data in matrix is visible.
	* @param objMatrix {jsx3.gui.Matrix} Matrix object to be resized
	* @param nAdditionalHeight {int}  The value to be added to summary data height (allow for table header and borders)
	* @param sRowsBefore {string}   First part of layout rows attribute (before matrix container)
	* @param sRowsAfter {string}   Last part of layout rows attribute (after matrix container)
	* @return {int} Number of data rows
	*/
	charter.adjustHeight = function(objMatrix, nAdditionalHeight, sRowsBefore, sRowsAfter) {
		var nRows = 0, nHeight = 0, objPanel;
		nRows = charter.countXMLChildren( objMatrix );
		if ( nRows >= 0 ) {
			objPanel = objMatrix.getParent();
			nHeight = nAdditionalHeight+nRows*20;
			objPanel.getParent().setRows( sRowsBefore+nHeight+sRowsAfter, true );	// Resize layout
		}
		return nRows;
	};
	

//============================ Net ===================================
	charter.LOCAL = false;
	charter.HOST = "";		//192.168.0.197, 192.168.0.198
	charter.CGI = "/api/cgi-bin/report.cgi";
	
	/**
	* Resolves local path (relative to project directory)
	* @param strLocalPath {String} Request parameters
	* @return  {String} Full path
	*/
	charter.getPath = function( strLocalPath )
	{
		var path = jsx3.resolveURI("jsxuser:///JSXAPPS/Charter/"+strLocalPath);
		if( path == "JSXAPPS/Charter/"+strLocalPath ) 
		{	
			path = strLocalPath;
		}
		//alert(path);
		return path;
	};
	/**
	* Synchronously request data. Data is retrieved optionaly from server or from local file.
	* @param strRequest {String} Request parameters
	* @param strLocalPath {String} Path to local data file to be used if charter.LOCAL flag set
	* @param docID {String} Cache document ID (used to store local data)
	* @param funcHandler {function} Called to process retrieved document
	* *return {jsx3.xml.Document} Loaded cache document
	*/
	charter.doSyncRequest = function( strRequest, strLocalPath, docID, funcHandler ) {
		var doc = null;
		//try {
			if ( charter.LOCAL || strRequest == null ) {
				doc = charter.APP.getCache().getOrOpenDocument( charter.getPath(strLocalPath), docID );
			}
			else 
			{
				var req = new jsx3.net.Request(); 
				req.open("GET", ""+charter.HOST+charter.CGI+strRequest, false); 
				req.send();
				doc = charter.APP.getCache().setDocument(docID, req.getResponseXML());
				//alert( ""+charter.HOST+charter.CGI+strRequest );
				//doc = charter.APP.getCache().getOrOpenDocument( ""+charter.HOST+charter.CGI+strRequest, docID );
				//alert(doc);
			}
			if ( funcHandler != null ) funcHandler( docID );
		//}
		//catch(e) {
			//alert("Exception in charter.doSyncRequest(): \n"+e);
		//}
		return doc;
	};
	
	/**
	* Asynchronously request data. Data is retrieved optionaly from server or from local file.
	* This function affects status line, so it must be updated when data loading is over
	* @param strRequest {String} Request parameters
	* @param funcHandler {function} EVENT_ON_RESPONSE handler
	* @param strLocalPath {String} Path to local data file, used if charter.LOCAL flag set
	* @param docID {String} Cache document ID (used to store local data)
	* @param funcLocalHandler {function} Function that is called to render local data
	*/
	charter.doRequest = function( strRequest, funcHandler, strLocalPath, docID, funcLocalHandler ) {
		//alert(strRequest);
		//try {
			if( charter.LOCAL ) {
				charter.APP.getCache().openDocument( charter.getPath(strLocalPath), docID );
				if ( funcLocalHandler != null )	funcLocalHandler( docID, true );
			}
			else {
				charter.showAPPStatus( charter.APP, "Loading data..." );
				var req = new jsx3.net.Request(); 
				req.open("GET", ""+charter.HOST+charter.CGI+strRequest, true); 
				req.subscribe( jsx3.net.Request.EVENT_ON_RESPONSE, funcHandler ); 
				req.send();
			}
		//}
		//catch(e) {
			//alert("Exception: "+e);
		//}
	};
	
	/**                                       
	* EVENT_ON_TIMEOUT handler.
	* @param objEvent {jsx3.gui.Event}
	*/
	charter.onTimout = function( objEvent ) { 
		var req = objEvent.target;
		alert("Request timeout elapsed. "+req);
	};
	
	/**                                       
	* EVENT_ON_RESPONSE handler. Stores received data into docGlobal cache document.
	* @param objEvent {jsx3.gui.Event}
	*/
	charter.onResponseGlobal = function( objEvent ) { 
		var req = objEvent.target; 
		var objXML = req.getResponseXML();
		charter.showAPPStatus( charter.APP, "Ready" );
		if(!objXML.hasError()) {
			charter.APP.getCache().setDocument( "docGlobal", objXML );
			charter.refreshViewGlobal( "docGlobal", true );
		}
		else alert("Error: Responce XML parsing error");
	};
	
	/**                                       
	* EVENT_ON_RESPONSE handler. Stores received data into docUS cache document.
	* @param objEvent {jsx3.gui.Event}
	*/
	charter.onResponseUS = function( objEvent ) { 
		var req = objEvent.target; 
		var objXML = req.getResponseXML();
		charter.showAPPStatus( charter.APP, "Ready" );
		if(!objXML.hasError()) {
			charter.APP.getCache().setDocument( "docUS", objXML );
			charter.refreshViewUS( "docUS", true );
		}
		else alert("Error: Responce XML parsing error");
	};
	
	/**                                       
	* EVENT_ON_RESPONSE handler. Stores received data into docPS cache document.
	* @param objEvent {jsx3.gui.Event}
	*/
	charter.onResponsePS = function( objEvent ) { 
		var req = objEvent.target;
		var objXML = req.getResponseXML();
		charter.showAPPStatus( charter.APP, "Ready" );
		if(!objXML.hasError()) {
			charter.APP.getCache().setDocument( "docPS", objXML );
			charter.refreshViewPS( "docPS", true );
		}
		else alert("Error: Responce XML parsing error");
	};

//============================ Render ===================================
	charter.templateUS = null;	// Transformation XSL template for US diagrams data
	
	/**                                       
	* Displays cache document data in Global view. 
	* @param docID {String} Cache document ID, default "docGlobal"
	* @param bDataReloaded {boolean} Specifies whether this view's document was reloaded
	*/
	charter.refreshViewGlobal = function( docID, bDataReloaded ) {
		if ( charter.VIEW != charter.VIEW_GLOBAL ) return;
		var strDoc;
		if ( docID != null ) strDoc = docID;
		else strDoc = "docGlobal";
		if ( bDataReloaded ) { // Render groups without filer
			charter.renderGlobal( charter.APP.getJSXByName("mtGlobal"), strDoc, 24, "20,", ",*" );
			charter.renderGlobal( charter.APP.getJSXByName("mtNodes"), strDoc, -1, "", "" );
		}
		else // Apply nodes filer
			charter.nodeToggled( null );
	};
	
	/**                                       
	* Displays cache document data in Storage Group view. 
	* @param docID {String} Cache document ID, default "docUS"
	* @param bDataReloaded {boolean} Specifies whether this view's document was reloaded
	*/
	charter.refreshViewUS = function( docID, bDataReloaded ) {
		if ( charter.VIEW != charter.VIEW_US ) return;
		var strDoc;
		if ( docID != null ) strDoc = docID;
		else strDoc = "docUS";
		var objMajor = charter.APP.getJSXByName("chMajor");
		if( objMajor.instanceOf( jsx3.chart.Chart.jsxclass ) ) 
			charter.renderUSChart( objMajor, charter.APP.getJSXByName("chMinor"), strDoc );
		else charter.renderUSTable( objMajor, charter.APP.getJSXByName("chMinor"), strDoc );
	};
	
	/**                                       
	* Displays cache document data in Devices view. 
	* @param docID {String} Cache document ID, default "docPS"
	* @param bDataReloaded {boolean} Specifies whether this view's document was reloaded
	*/
	charter.refreshViewPS = function( docID, bDataReloaded ) {
		if ( charter.VIEW != charter.VIEW_PS ) return;
		var strDoc;
		if ( docID != null ) strDoc = docID;
		else strDoc = "docPS";
		charter.renderGlobal( charter.APP.getJSXByName("mtProjGroup_dev"), strDoc, 50, "20,", ",43" );
		charter.renderGlobal( charter.APP.getJSXByName("mtProjGroupSummary_dev"), strDoc, -1, "", "" );
		// Paint devices chart
		var chPSDev = charter.APP.getJSXByName("chPSDev");
		if( chPSDev != null )
			charter.renderChart( charter.APP.getJSXByName("chPSDev"), strDoc, "docPSDev_XSL", "xsl/psDevChart.xsl" );
		else alert("Error: Unable to find devices chart");
	};
	
	/**                                       
	* Makes specified Matrix object display certain cache document data. 
	* @param objMatrix {jsx3.gui.Matrix} Matrix object
	* @param strDoc {String} Cache document ID. It's assumed that document is already loaded
	*		either from file or from server, and its format corresponds to tables's XSLT
	* @param nAdditionalHeight {int}  The value to be added to summary data height (allow for table header and borders)
	* @param sRowsBefore {string}  First part of layout rows attribute (before matrix container)
	* @param sRowsAfter {string}  Last part of layout rows attribute (after matrix container)
	* @return {int} Number of data rows
	*/
	charter.renderGlobal = function( objMatrix, strDoc, nAdditionalHeight, sRowsBefore, sRowsAfter) {
		var nRows = 0;
		if( objMatrix != null )	{
			objMatrix.setXMLURL("");
			objMatrix.resetXmlCacheData();
			objMatrix.setXMLString( charter.APP.getCache().getDocument(strDoc) );
			if(nAdditionalHeight>=0) 
				nRows = charter.adjustHeight( objMatrix, nAdditionalHeight, sRowsBefore, sRowsAfter );
			objMatrix.repaintData();
			if( objMatrix.getName() == "mtGlobal" && !jsx3.util.strEmpty(charter.GROUPJSXID) )
				objMatrix.selectRecord( charter.GROUPJSXID );
		}
		else alert("Error: Unable to find matrix to display "+strDoc);
		return nRows;
	}; 
	
	/**                                       
	* Render cache document contents via chart
	* @param objChart {jsx3.chart} Target chart object
	* @param strDoc {String} Cache document ID.
	* @param strXSL {String} Cache document ID of transformation XSL.
	* @param strXSLPath {String} Path to XSL file (needed if XSL is not yet loaded).
	*/
	charter.renderChart = function( objChart, strDoc, strXSL, strXSLPath ) {
		var cache = charter.APP.getCache();
		// Get cache document containing raw data
		var doc = cache.getDocument(strDoc);
		if(doc==null) { 
			alert("Error: "+strDoc+" document not found");
			return;
		}
		// Get cache document containing transformation XSL
		var docXSL = charter.doSyncRequest( null, strXSLPath, strXSL, null );
		if( docXSL == null || docXSL.hasError() ) {
			alert("Error: Unable to load file " + strXSLPath );
			return;
		}
		//alert(docXSL); return;
		objChart.setXMLURL("");
		objChart.resetXmlCacheData();
		// Set transformation XSL for chart
		var transformers = new Array;
		transformers.push( strXSL );
		objChart.setXMLTransformers(transformers);	
		// Set XML data for chart
		objChart.setXMLString( doc );
		charter.getChartPane( objChart ).setDisplay(jsx3.gui.Block.DISPLAYBLOCK,true);
		objChart.repaint();
	}; 

	/**                                       
	* Render US cache document contents via charts
	* @param objMajorChart {jsx3.chart} Major category chart object
	* @param objMinorChart {jsx3.chart} Minor category chart object
	* @param strDoc {String} Cache document ID.
	*/
	charter.renderUSChart = function( objMajorChart, objMinorChart, strDoc ) {
		if( objMajorChart != null )	{
			// Transform source XML data for chart
			charter.renderChart( objMajorChart, strDoc, "docUS_XSL", "xsl/usGroup.xsl" );
			// Count number of items
			var cnt = charter.countXMLChildren( objMajorChart ); 
			// Check if major chart can be painted correctly. If not replace it with text label
			charter.verifyUSChart( objMajorChart, cnt, charter.strMajorCategory );

			if( objMinorChart != null ) {
				objMinorChart.getParent().setDisplay(jsx3.gui.Block.DISPLAYNONE,true);
			}
		}
		else alert("Error: Unable to find chart to display "+strDoc);
	}; 
	
	/**                                       
	* Render US cache document contents via tables
	* @param objMajorTab {String} Major category table name
	* @param objMinorTab {String} Minor category table name
	* @param strDoc {String} Cache document ID.
	*/
	charter.renderUSTable = function( objMajorTab, objMinorTab, strDoc ) {
		if( objMajorTab != null )	{
			var doc = charter.APP.getCache().getDocument(strDoc);
			if(doc==null) { 
				alert("Error: "+strDoc+" document not found");
				return;
			}
			objMajorTab.setXMLURL("");
			objMajorTab.resetXmlCacheData();
			objMajorTab.setXMLString( doc );
			charter.APP.getJSXByName( "pnMajor" ).setDisplay(jsx3.gui.Block.DISPLAYBLOCK,true);
			objMajorTab.repaint();
			if( objMinorTab != null ) {
				charter.APP.getJSXByName( "pnMinor" ).setDisplay(jsx3.gui.Block.DISPLAYNONE,true);
			}
		}
		else alert("Error: Unable to find table to display "+strDoc);
	};

//============================ Report =================================

  charter.REPORT_IN_WINDOW = true;		// Report showing in separate window
 
  charter.wndReport = null;
  charter.wndDetailedReport = null;
  charter.nWndReportVersion = 0;
  charter.REPORTWIDTH = 760;
  charter.REPORTHEIGHT = 800;
  
  charter.strDet_Node = "";
  charter.strDet_Group = "";
  charter.strDet_GroupID = "";

	/**                                       
	* Launches the appReport component in the new window. 
	* @param objJSX {jsx3.app.Model} where to load the report.
	*/
	charter.launchReport = function(objJSX) {
		var server = objJSX.getServer();
		charter.wndReport = server.getAppWindow("Storage allocation report");
		if (charter.wndReport==null) {
			charter.wndReport = server.createAppWindow("Storage allocation report");//+charter.nWndReportVersion++);
		}
		charter.wndReport.setTitle("Storage allocation report");
		charter.wndReport.setResizable(true);
		charter.wndReport.setScrollable(true);
		charter.wndReport.setWidth(charter.REPORTWIDTH);
		charter.wndReport.setHeight(charter.REPORTHEIGHT);
		charter.wndReport.subscribe(jsx3.gui.Window.DID_OPEN, charter.onReportWndOpen);
		if ( !charter.wndReport.isOpen() ) {
			charter.wndReport.open();
		}
		else {
			charter.onReportWndOpen();
		}
	};

	/**                                       
	* Launches the repGroup component in the new window. 
	*/
	charter.launchDetailedReport = function( strNode, strGroup, strGroupID ) {
		charter.wndDetailedReport = charter.APP.getAppWindow("Detailed report");
		if ( charter.wndDetailedReport==null ) {
			charter.wndDetailedReport = charter.APP.createAppWindow("Detailed report");// on group "+strGroupID+charter.nWndReportVersion++);
		}
		charter.wndDetailedReport.setTitle("Detailed report, group "+strGroup+", node "+strNode);
		charter.wndDetailedReport.setResizable(true);
		charter.wndDetailedReport.setScrollable(true);
		charter.wndDetailedReport.setWidth(charter.REPORTWIDTH);
		charter.wndDetailedReport.setHeight(charter.REPORTHEIGHT);
		charter.wndDetailedReport.subscribe(jsx3.gui.Window.DID_OPEN, charter.onDetailedReportWndOpen);
		charter.strDet_Node = strNode;
		charter.strDet_Group = strGroup;
		charter.strDet_GroupID = strGroupID;
		if ( !charter.wndDetailedReport.isOpen() ) {
			charter.wndDetailedReport.open();
		}
		else {
			charter.onDetailedReportWndOpen();
		}
	};

	/**                                       
	* DID_OPEN window event handler. Loads the appReport component to opened window.  
	*/
	charter.onReportWndOpen = function() {
		var container = charter.wndReport.getRootBlock();
		container.removeChildren();
		container.load( "components/appReport.xml", true );
		var h, nTotalHeight = 80;
		h = charter.renderGlobal( charter.APP.getJSXByName("mtProjected_rep"), "docGlobal", 24, "80,", ",80,*" );
		nTotalHeight += h*20+24+80;
		container.getServer().getJSXByName( "block_size_rep" ).setHeight( nTotalHeight+20, true );
	};

	/**                                       
	* DID_OPEN window event handler. Loads the repGroup component to opened window.  
	*/
	charter.onDetailedReportWndOpen = function() {
		var container = charter.wndDetailedReport.getRootBlock();
		container.removeChildren();
		var h, nTotalHeight = 80;
		h = charter.loadDetailed( container, charter.strDet_Node, charter.strDet_Group, charter.strDet_GroupID );
		nTotalHeight += h;
		container.getServer().getJSXByName( "block_size_rep_det" ).setHeight( nTotalHeight+20, true );
	};

	/**
	* Model event handler, called when group record is double-clicked in Global report sction.
	* @param objCheck {jsx3.app.Model} Target of the model event.
	* @param strRecordID {String} Selected record's CDF ID
	*/
	charter.onGroupReport = function( objJSX, strRecordID ) {
		var rec = objJSX.getRecordNode( strRecordID );
		if( rec != null ) {
			charter.launchDetailedReport( rec.getAttribute("jsxnode"), rec.getAttribute("jsxtext"), rec.getAttribute("sysid") );
		}
	};
	
	/**                                       
	* Loads the repGroup component to the specified jsx3.app.Model object.
	* @param objJSX {jsx3.app.Model} Where to load the report.
	* @param strNode {String} Node on which detailed report is built 
	* @param strGroup {String} Group on which detailed report is built 
	* @param n {int} Group number
	*/
	charter.loadDetailed = function ( objJSX, strNode, strGroup, strGroupID ) {
		var server = objJSX.getServer();
		var objRoot = objJSX.load( "components/repGroup.xml" );
		var objLayout = server.getJSXByName( "layout_rep_det" );
		
		var obj = objLayout.getChild( "pnHeader_rep_det" ).getChild( "txtCaption_rep_det" );
		obj.setText( "Detailed analysis, Node : " + strNode + ", storage group: " + strGroup, true);
		
		// Request data for diagrams
		charter.doSyncRequest( "?return=used_space&node=" + strNode + "&groupid=" + strGroupID +
				"&by=devices", "xml/usDevicePolicy.xml", "repUSDevice", null );
		charter.doSyncRequest( "?return=used_space&node=" + strNode + "&groupid=" + strGroupID +
				"&by=policies", "xml/usPolicyDevice.xml", "repUSPolicy", null );
		obj = objLayout.getChild( "pnCharts_rep_det" ).getChild("layout ( | )");
		charter.renderUSChart( obj.getChild("pnLeft").getChild( "chLeft_rep" ), null, "repUSDevice" );
		charter.renderUSChart( obj.getChild("pnRight").getChild( "chRight_rep" ), null, "repUSPolicy" );
		
		// Request devices data
		charter.doSyncRequest( "?return=projected_space&by=device&node="+strNode+"&groupid="+strGroupID, 
								"xml/psGroup.xml", "repPS", null );
		obj = objLayout.getChild( "pnDevices_rep_det" ).getChild("mtProjGroup_rep");
		obj.setXMLId(obj.getXMLId()+"_"+strGroupID);
		var h = charter.renderGlobal( obj, "repPS", 50, "50,220,", ",43" );
		
		obj = objLayout.getChild( "pnTotal_rep_det" ).getChild("mtProjGroupSummary_rep");
		obj.setXMLId(obj.getXMLId()+"_"+strGroupID);
		charter.renderGlobal( obj, "repPS", -1, null, null );
		
		objRoot.repaint();
		return 50+222+h*20+50+43;
	};
	
	/**                                       
	* Resizes  matrices in report (by modifying containing layouts) so that all data is visible. For report mode only. 
	*/
	charter.adjustReportSz = function() {
		var server = ca.charter.APP;
		var nRows = 0, nHeight = 0, objMatrix, objPanel;
		charter.adjustHeight( server.getJSXByName("mtProjected_rep"), 24, "80,", ",*" );
		charter.adjustHeight( server.getJSXByName("mtProjGroup_rep"), 50, "50,220,", ",43" );
	};

//============================ Interactive =================================
	charter.VIEW_GLOBAL = 0;
	charter.VIEW_US = 1;
	charter.VIEW_PS = 3;
	charter.VIEW = 0;	// Current view (Global|Storage group|Devices)
	
	charter.NODENAME == null;
	charter.GROUPNAME == null;
	charter.GROUPID == null;
	charter.GROUPJSXID == null;
	charter.REPR_CHART = 0;
	charter.REPR_TABLE = 1;
	charter.REPR = 0;	// Current representation (Charts|Tables)

	charter.DEVCHART_LOADED = false;	// If devices chart is already loaded to pnDevChart panel
	
	/**
	* Clear work area
	* @param objServer {jsx3.app.Server}  JSX architecture controller.
	*/
	charter.clearWorkArea = function( objServer ) {
		objServer.getJSXByName("pnData").removeChildren();
	};
	
	/**
	* Update the application status bar contents
	* @param objServer {jsx3.app.Server}  JSX architecture controller.
	* @param strStatusHTML {String}  New status bar inner HTML.
	*/
	charter.showAPPStatus = function( objServer, strStatusHTML ) {
		objServer.getJSXByName("txtStatus").setText(strStatusHTML,true);
	};

	/**
	* Set charter.NODENAME,	charter.GROUPNAME and charter.GROUPID if possible
	*/
	charter.getSelectedGroup = function() {
		var mtGroups = charter.APP.getJSXByName("mtGlobal");
		if( mtGroups != null ) {
			var rec = mtGroups.getRecordNode( mtGroups.getValue() );
			if( rec != null ) {
				charter.NODENAME = rec.getAttribute( "jsxnode" );
				charter.GROUPNAME = rec.getAttribute( "jsxtext" );
				charter.GROUPID = rec.getAttribute( "sysid" );
				charter.GROUPJSXID = rec.getAttribute( "jsxid" );
			}
		}
	};
	
	/**
	* Launches application view by its ID
	* @param viewID {int}  JSX architecture controller.
	* @param bReload {boolean} Specifies whether data should be loaded from server
	*/
	charter.launchView = function( viewID, bReload ) {
		var server = charter.APP;
		if( viewID == charter.VIEW_GLOBAL ) {
			charter.VIEW = viewID;
			charter.launchInteractive( server, "components/tabGlobal.xml", "Global Statistics");
		}
		else { 
			charter.getSelectedGroup();
			if( jsx3.util.strEmpty(charter.GROUPNAME) || jsx3.util.strEmpty(charter.NODENAME) ) {
				alert("You must select a storage group in Global View first");
				server.getJSXByName("st1").doShow();
				return;
			}
			charter.VIEW = viewID;
			var strCap = charter.GROUPNAME+" on node "+charter.NODENAME;
			if( charter.VIEW == charter.VIEW_US ) {
				var strComponent;
				if(charter.REPR == charter.REPR_CHART) strComponent = "components/USCharts.xml";
				else strComponent = "components/USTables.xml";
				charter.launchInteractive( server, strComponent, "Used Space in Group "+strCap);
				var objMajor = server.getJSXByName( "chMajor" );
				charter.getChartTitle( objMajor ).setText( charter.strMajorCategory + "/", true );
				if(charter.REPR == charter.REPR_CHART) {
					charter.setChartColors( objMajor, charter.strMajorCategory );
					charter.setChartColors( server.getJSXByName( "chMinor" ), charter.strMinorCategory );
				}
			}
			else if(  charter.VIEW == charter.VIEW_PS  ) {
				// Load devices table component to right pane
				charter.launchInteractive( server, "components/tabDevices.xml", "Devices in Group "+strCap);
				// Load devices chart component to left pane
				if( !charter.DEVCHART_LOADED ) {
					var pnDevChart = server.getJSXByName("pnDevChart")
					pnDevChart.removeChildren();
					pnDevChart.load("components/chartPSDev.xml"); 
					charter.DEVCHART_LOADED = true;
				}
			}
		}
		charter.refreshData( server, bReload );
	};
	
	/**                                       
	* Launch the specified component in the right pane. 
	* @param objServer {jsx3.appa.Server}  JSX architecture controller.
	* @param strComponent {String} Path to the component to launch
	* @param strCap {String} Caption to be shown in the right pane
	*/
	charter.launchInteractive = function( objServer, strComponent, strCap ) {
		charter.clearWorkArea(objServer);
		objServer.getJSXByName("pnData").load(strComponent); 
		objServer.getJSXByName("txtDataCaption").setText( strCap, true );
	};
	
	/**                                       
	* Request the current view's data from server and paint it.
	* @param objServer {jsx3.app.Server}  JSX architecture controller.
	* @param bReload {boolean} Specifies whether data should be loaded from server
	*/
	charter.refreshData = function( objServer, bReload ) {
		if( charter.VIEW == charter.VIEW_GLOBAL ) {
			if( bReload || charter.APP.getCache().getDocument("docGlobal") == null ) 
			{
				charter.changeSelGroup( null, null, null, null );
				charter.doRequest( "?return=projected_space&by=group", charter.onResponseGlobal,
					"xml/psGlobal.xml", "docGlobal", charter.refreshViewGlobal );
			}
			else charter.refreshViewGlobal( "docGlobal", false );
		}
		else if( charter.VIEW == charter.VIEW_US ) {
			if( bReload || charter.APP.getCache().getDocument("docUS") == null ) {
				charter.doRequest( "?return=used_space&node=" + charter.NODENAME + "&groupid=" + charter.GROUPID +
						"&by=" + charter.strMajorCategory + "," + charter.strMinorCategory, 
						charter.onResponseUS, "xml/usDevicePolicy.xml", "docUS", charter.refreshViewUS );
			}
			else charter.refreshViewUS( "docUS", false );
		}
		else if( charter.VIEW == charter.VIEW_PS ) {
			if( bReload || charter.APP.getCache().getDocument("docPS") == null ) {
				charter.doRequest( "?return=projected_space&by=device&node="+charter.NODENAME+"&groupid="+charter.GROUPID, 
					charter.onResponsePS, "xml/psGroup.xml", "docPS", charter.refreshViewPS );
			}
			else charter.refreshViewPS( "docPS", false );
		}
	};
	
	/**
	* Filters object's data using other object's data attribute
	* @param objJSX {jsx3.xml.Cacheable} Target object 
	* @param strForeignKey {String} Field name in filtered table, Foreign key for JOIN operation.
	*								(Primary key assumed to be "jsxid")
	* @param objFilter {jsx3.xml.Cacheable} Object containing filter data
	* @param strFilterKey {String} Field name in filter-defining table, If this field is "0", record is filtered off
	* @param objDoc {jsx3.xml.Document} Document containing full (not filtered) data for target object
	*/
	charter.filterMatrix = function( objMatrix, strForeignKey, objFilter, strFilterKey, objDoc ) {
		objMatrix.resetXmlCacheData();
		objMatrix.setXMLString( objDoc );
		var child;
		var delList = new Array;
		for( var i = objMatrix.getXML().getChildIterator(); i.hasNext(); ) {
			child = i.next();
			if( objFilter.getRecordNode( child.getAttribute( strForeignKey ) ).getAttribute(strFilterKey) == "0" )
				delList.push( child.getAttribute("jsxid") );
		}
		var rec;
		//var str = "";
		while( delList.length>0 ) {
			rec = objMatrix.deleteRecord( delList.shift(), false );
			//str += rec.getAttribute("jsxid")+": "+rec.getAttribute("jsxnode")+" -> "+rec.getAttribute("jsxtext")+"\n";
		}
		//alert(str);
	};
	
	/**
	* Model event handler, called when select-node checkbox is toggled.
	* @param objCheck {jsx3.gui.CheckBox} Target of the model event.
	*/
	charter.nodeToggled = function( objCheck ) {
		// Get nodes matrix
		var mtNodes;
		if( objCheck != null ) mtNodes = objCheck.getAncestorOfType( jsx3.gui.Matrix );
		else mtNodes = charter.APP.getJSXByName( "mtNodes" );
		if( mtNodes == null) return;
		// Get groups matrix and it's cache document
		var mtGroups = charter.APP.getJSXByName( "mtGlobal" );
		var docGroups = charter.APP.getCache().getDocument( "docGlobal" );
		if( mtNodes == null || mtGroups == null ||  docGroups == null ) return;
		// Delete unselected groups from matrix
		charter.filterMatrix( mtGroups, "jsxnodeid", mtNodes, "jsxfilter", docGroups );
		charter.adjustHeight( mtGroups, 24, "20,", ",*" );
		mtGroups.repaintData();
		if( !jsx3.util.strEmpty(charter.GROUPJSXID) ) mtGroups.selectRecord( charter.GROUPJSXID );
		// Check if new filer affected lately selected row
		if( charter.GROUPJSXID != null && mtGroups.getRecord( charter.GROUPJSXID ) == null )
		{
			charter.changeSelGroup( null, null, null, null );
		}
	};

	/**
	* Called when group selection changes.
	* @param nodeName {String} Newly selected group's node
	* @param groupName {String} Newly selected group's name
	* @param groupID {String} Newly selected group's system id
	* @param groupJSXID {String} Newly selected group's JSXID
	*/
	charter.changeSelGroup = function( nodeName, groupName, groupID, groupJSXID )
	{
		charter.NODENAME = nodeName;
		charter.GROUPNAME = groupName;
		charter.GROUPID = groupID;
		charter.GROUPJSXID = groupJSXID;
		// Deatiled views cashe documents expired
		charter.APP.getCache().clearById("docUS");
		charter.APP.getCache().clearById("docPS");
		// Disable deatiled views if group not selected
		var st2 = charter.APP.getJSXByName("st2"), st3 = charter.APP.getJSXByName("st3");
		if( groupJSXID == null ) {
			st2.setColor("#777777",true);
			st3.setColor("#777777",true);
		}
		else {
			st2.setColor("#005CBA",true);
			st3.setColor("#005CBA",true);
		}
		st2.repaint();
		st3.repaint();
	};
	
	/**
	* Model event handler, called when group record is clicked in Global View.
	* @param objCheck {jsx3.app.Model} Target of the model event.
	* @param strRecordID {String} Selected record's CDF ID
	*/
	charter.onGroupSelect = function( objJSX, strRecordID ) {
		var rec = objJSX.getRecordNode( strRecordID );
		if( rec != null ) {
			charter.changeSelGroup( rec.getAttribute("jsxnode"), rec.getAttribute("jsxtext"), 
									rec.getAttribute("sysid"), rec.getAttribute("jsxid") );
		}
	};
	
	/**
	* Model event handler, called when group record is double-clicked in Global View.
	* @param objCheck {jsx3.app.Model} Target of the model event.
	* @param strRecordID {String} Selected record's CDF ID
	*/
	charter.onGroupExecute = function( objJSX, strRecordID ) {
		var rec = objJSX.getRecordNode( strRecordID );
		if( rec != null ) {
			charter.changeSelGroup( rec.getAttribute("jsxnode"), rec.getAttribute("jsxtext"), 
									rec.getAttribute("sysid"), rec.getAttribute("jsxid") );
			charter.APP.getJSXByName( "st2" ).doShow();
		}
	};
	
	/**
	* Model event handler, triggers between Charts and Tables representation of Used Space analysis.
	* @param objSelect {jsx3.gui.Select} Select field (target of the model event).
	* @param strRecordId {String} the record id of the selected record.
	*/
	charter.onTabChartSelect = function( objSelect, strRecordId ) {
		if( strRecordId == 0 ) {
			charter.REPR = charter.REPR_CHART;
		} 
		else {
			charter.REPR = charter.REPR_TABLE;
		}
		charter.launchView( charter.VIEW_US, false );
	};

	/**
	* Returns caption object associated with US chart or table
	* @param objJSX {jsx3.app.Model} the US chart or table.
	* @return {jsx3.gui.TextBox} caption object
	*/
	charter.getChartTitle = function( objJSX ) {
		if( objJSX.instanceOf( jsx3.chart.Chart.jsxclass ) ) return objJSX.getChild( "title" );
		else return objJSX.getParent().getParent().getChild( "pnTitle" ).getChild( "title" );
	};
	
	/**
	* Returns pane containing US chart or table (pnMajor or pnMinor)
	* @param objJSX {jsx3.app.Model} the US chart or table.
	* @return {jsx3.gui.Block} pane object
	*/
	charter.getChartPane = function( objJSX ) {
		if( objJSX.instanceOf( jsx3.chart.Chart.jsxclass ) ) return objJSX.getParent();
		else return objJSX.getParent().getParent().getParent().getParent();
	};
	
	/**
	* Model event handler, loads selected series into first level chart (table) of Used Space analysis.
	* @param objSelect {jsx3.gui.Select} Select field (target of the model event).
	* @param strRecordId {String} the record id of the selected record.
	*/
	charter.onMajorSelect = function( objSelect, strRecordId ) {
		var server = objSelect.getServer();
		charter.strMajorSelectID = strRecordId;
		charter.strMajorCategory = objSelect.getRecord( strRecordId ).jsxtext.toLowerCase();
		charter.strMajorCategoryID = "0";
		server.getJSXByName( "pnMinor" ).setDisplay( jsx3.gui.Block.DISPLAYNONE, true );
		server.getJSXByName( "pnMajor" ).setDisplay( jsx3.gui.Block.DISPLAYNONE, true );
		
		var objMajor = server.getJSXByName( "chMajor" );
		charter.getChartTitle( objMajor ).setText( charter.strMajorCategory + "/", true );
		if( objMajor.instanceOf( jsx3.chart.Chart.jsxclass ) ) {
			charter.setChartColors( objMajor, charter.strMajorCategory );
		}
		charter.refreshData( charter.APP, true );
	};

	/**
	* Model event handler, loads selected series into second level chart (table) of Used Space analysis.
	* If first level and the second level coincide, the second level control collapses
	* @param objSelect {jsx3.gui.Select} Select field (target of the model event).
	* @param strRecordId {String} the record id of the selected record.
	*/
	charter.onMinorSelect = function( objSelect, strRecordId ) {
		var server = objSelect.getServer();
		charter.strMinorSelectID = strRecordId;
		charter.strMinorCategory = objSelect.getRecord(strRecordId).jsxtext.toLowerCase();
		server.getJSXByName( "pnMinor" ).setDisplay( jsx3.gui.Block.DISPLAYNONE, true );
		server.getJSXByName( "pnMajor" ).setDisplay( jsx3.gui.Block.DISPLAYNONE, true );
		var objMinor = server.getJSXByName( "chMinor" );
		if( objMinor.instanceOf( jsx3.chart.Chart.jsxclass ) ) {
			charter.setChartColors( objMinor, charter.strMinorCategory );
		}
		charter.refreshData( charter.APP, true );
		//charter.doDrillDown( server.getJSXByName( "chMajor" ), charter.strMajorCategoryID );
	};
	
	/**
	* Model event handler. Callsed when bar is selected in Device View chart. Selects this record in Device View table.
	* @param objChart {jsx3.charter.Chart} The Chart object.
	* @param strRecordId {String} Record id of the clicked record..
	*/
	charter.onChDevSelect = function( objChart, strRecordId ) {
		var objMatrix = objChart.getServer().getJSXByName("mtProjGroup_dev");
		if( objMatrix != null )
			objMatrix.selectRecord( strRecordId );
	};
	
//============================ Pie Charts ==================================
	charter.strMajorSelectID = "0";
	charter.strMinorSelectID = "1";
  	charter.strMajorCategory = "devices";
  	charter.strMinorCategory = "policies";
  	charter.strMajorCategoryID = "0";
  
  charter.pieColors = {	"devices":"#FFF5E6,#FF9B00,#DCA03F,#FFD696,#C4A674,#FFB849,#E6BA85,#EEAC44,#D8B67F,#F2C48C",
						"policies":"#F0FFDD,#8DFF00,#93CD4B,#D0FF96,#95A561,#B7FF5E,#A9CF7A,#A8EA56,#94B66B,#BDE889",
						"event_types":"#D2EAFF,#0085FF,#77BEFF,#3587D1,#41A4FF,#658CB1,#65A1D8,#73A0CA,#3B96E9,#6FB1EE",
						"volumes":"#FBEBFF,#E780FF,#C588D2,#F4C6FF,#9E80A5,#EEA5FF,#C9A4D2,#D996E8,#B291BA,#DDB4E7"};
  /**
   * A series coloring function that uses the color attribute of a CDF record to create an RGB color.
   * @param record {jsx3.xml.Entity} the CDF record.
   * @param intIndex {int}
   * @return {jsx3.vector.Fill}
   */
  charter.pieColoring = function(record, intIndex) { 
    return new jsx3.vector.Fill(record.getAttribute('color'));
  };
  
	/**
	* Changes series colors for the chart. The color scheme depends on category
	* @param objChart {jsx3.chart.Chart} the chart to modify.
	* @param strCategory {String} Name of the category
	*/
	charter.setChartColors = function( objChart, strCategory )
	{
		if( !objChart.instanceOf( jsx3.chart.Chart.jsxclass ) ) return;
		var str = charter.pieColors.devices;
		if(strCategory=="devices") str = charter.pieColors.devices;
		if(strCategory=="policies") str = charter.pieColors.policies;
		if(strCategory=="event types") str = charter.pieColors.event_types;
		if(strCategory=="volumes") str = charter.pieColors.volumes;
		objChart.colors=jsx3.chart.Ij(str);
		objChart.repaint();
	};

	/**
	* Model event handler, fills in the data in the minorCategory chart(table) depending on what was clicked in the
	* majorCategory chart.
	* @param objJSX {jsx3.chart.Chart || jsx3.gui.Matrix} the majorCategory charter (target of the model event).
	* @param strRecordId {String} Record id of the clicked record.
	* @param bCharts {Boolean} If true it's assumed that charts are used, if false tables 
	*/
	charter.doDrillDown = function(objJSX, strRecordId ) {
		var server = objJSX.getServer();
		var pnMinor = server.getJSXByName( "pnMinor" );

		if (strRecordId == null || charter.strMajorCategory==charter.strMinorCategory) {
			pnMinor.setDisplay( jsx3.gui.Block.DISPLAYNONE, true );
			return;
		}
		
		// Hide minor chart if "Free space" slice was selected
		charter.strMajorCategoryID = strRecordId;
		var objNode = objJSX.getRecordNode(strRecordId);
		if (objNode == null || strRecordId=="0" ) {
			pnMinor.setDisplay( jsx3.gui.Block.DISPLAYNONE, true );
			return;
		}
		
		// Copy data to minor chart and count its records
		var objMinor = server.getJSXByName('chMinor'), cnt = 0;
		objMinor.clearXmlData();
		for (var i = objNode.getChildIterator(); i.hasNext(); cnt++) {
			var rec = i.next().cloneNode();
			//alert(rec);
			objMinor.insertRecordNode(rec, 'jsxroot', false);
		}
		
		// Set minor chart caption
		var str = charter.strMajorCategory + "/" +
				objNode.getAttribute("name") + "/" + charter.strMinorCategory + "/";
		charter.getChartTitle( objMinor ).setText( str, true);
		
		// Check if minor chart can be painted correctly. If not replace it with text label
		if( objMinor.instanceOf( jsx3.chart.Chart.jsxclass ) )
			charter.verifyUSChart( objMinor, cnt, charter.strMinorCategory );
		else objMinor.repaint();
				
		server.getJSXByName( "pnMinor" ).setDisplay( jsx3.gui.Block.DISPLAYBLOCK, true );
	};
  
	/**
	* Checks if US chart can be painted correctly. If not the chart is replaced with text label
	* @param objChart {jsx3.chart.Chart} the target chart
	* @param nRec {int} Number of data records
	* @param strCategory {String} Category name
	* @return {Boolean} True if chart was not replaced with text label
	*/
	charter.verifyUSChart = function( objChart, nRec, strCategory ) {
		if( !objChart.instanceOf( jsx3.chart.Chart.jsxclass ) ) return;
		var objAlterText = objChart.getParent().getChild( "txtAlter" );
		if( nRec>1 ) {	// The chart will look normal
			objAlterText.setDisplay( jsx3.gui.Block.DISPLAYNONE );
			objAlterText.repaint();
			objChart.getChild( "srUS" ).setDisplay( jsx3.gui.Block.DISPLAYBLOCK );
			objChart.getChild( "legend" ).setDisplay( jsx3.gui.Block.DISPLAYBLOCK );
			objChart.repaint();
			return true;
		}
		else {			// The chart cannot display <2 records, so replace it with text label
			var str = "<br><br>No "+charter.strMinorCategory;
			if( nRec == 1 ) {
				str = "<br><br>";
				var rec = objChart.getXML().getRootNode().getFirstChild();
				if( rec != null ) {
					str += rec.getAttribute("name")+" <br>"+rec.getAttribute("value")+"MB (100%)";
				}
			}
			objChart.getChild( "srUS" ).setDisplay( jsx3.gui.Block.DISPLAYNONE );
			objChart.getChild( "legend" ).setDisplay( jsx3.gui.Block.DISPLAYNONE );
			objChart.repaint();
			var objAlterText = objChart.getParent().getChild( "txtAlter" );
			objAlterText.setText( str, true );
			objAlterText.setDisplay( jsx3.gui.Block.DISPLAYBLOCK );
			objAlterText.repaint();
			return false;
		}
	};
	
	/**
	* Model event handler, creates a spy glass span for a pie slice in Used Space pie charts.
	* @param objChart {jsx3.charter.Chart} the charter that was spied.
	* @param strRecordId {String} the record id of the spied record.
	*/
	charter.pieSpy = function(objChart, strRecordId) {
		if (strRecordId == null) return;
		var objNode = objChart.getRecordNode(strRecordId);
		var siblings = objNode.getParent().getChildNodes();
		var nVal = objNode.getAttribute('value');

		var sum = 0;
		for (var i = siblings.iterator(); i.hasNext(); ) {
			sum += parseFloat(i.next().getAttribute('value'));
		}

		return "<b>" + objNode.getAttribute('name') + "</b>: " + nVal.toString() +"MB <br>" +
			parseFloat(jsx3.util.numRound(100 * nVal / sum, 0.1).toString().substring(0,5)) + "%";
	};

  /**
   * Model event handler, creates a spy glass span for a legend entry in either the majorCategory or
   * minorCategory Charters.
   * @param objChart {jsx3.charter.Chart} the charter containing the legend that was spied.
   * @param strRecordId {String} the record id of the spied record.
   */
  charter.legendSpy = function(objChart, strRecordId) {
    if (strRecordId == null) return;
    
    var objNode = objChart.getRecordNode(strRecordId);
    var strHTML = "Including: ";
    
    for (var i = objNode.getChildNodes().iterator(); i.hasNext(); ) {
      var child = i.next();
      if (i > 0) strHTML += ", ";
      strHTML += "<b><span style='color:" + child.getAttribute('color') + ";'>" + child.getAttribute('jsxtext') + "</span></b>";
    }
    
    return strHTML;
  };

    /**
	* Model event handler, creates a spy glass span for a bar in Device View chart.
	* @param objChart {jsx3.charter.Chart} the charter that was spied.
	* @param strRecordId {String} the record id of the spied record.
	*/
	charter.barSpy = function(objChart, strRecordId) {
		if (strRecordId == null) return;
		var objNode = objChart.getRecordNode(strRecordId);
		return "<b>" + objNode.getAttribute('name') + "</b>: <br>"+
		" Total <font color=green>" + objNode.getAttribute("total") +"GB </font> <br>" +
		" Projected <font color=red>" + objNode.getAttribute("projected") +"GB </font> <br>";
	};

});
