RewriteCond %{QUERY_STRING} ^wsdl$
RewriteRule ^/axis2/services/(.*)$ /opt/sarch/api/html/proxy.php?service=$1 [L]

RewriteCond %{QUERY_STRING} ^wsdl$
RewriteRule ^/cxf/webservices/(.*)$ /opt/sarch/api/html/proxy.php?service=$1 [L]

RewriteRule ^/axis2/services/(.*)$ http://localhost:8181/cxf/webservices/$1 [P]
RewriteRule ^/cxf/(.*)$ http://localhost:8181/cxf/$1 [P]

RewriteRule ^/api/amq(.*)$ http://localhost:8181/amq/amq$1 [P]
ProxyPassReverseCookiePath /amq /api

<IfModule !mod_headers.c>
    LoadModule headers_module modules/mod_headers.so
</IfModule>

<ProxyMatch /cxf/services>
    <IfModule mod_headers.c>
        Header set Cache-Control "max-age=0, no-cache, no-store, must-revalidate"
        Header set Pragma "no-cache"
        Header set Expires "Wed, 11 Jan 1984 00:00:00 GMT"
    </IfModule>
</ProxyMatch>

LoadModule proxy_wstunnel_module modules/mod_proxy_wstunnel.so

<Location /ecf>
    ProxyPass ws://127.0.0.1:8181/ecf retry=1 min=1
    ProxyPassReverse ws://127.0.0.1:8181/ecf
</Location>
