package SM::SpindleMonitor;

use 5.008008;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use SM::SpindleMonitor ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
 spawn	
);

our $VERSION = '0.01';


# Preloaded methods go here.
use Carp qw(croak carp);
use POE;
#use Log::Log4perl "get_logger";        # we have a reference to LOG here

# CONS ------------------------------------------------------------------------
my $SMSTAT;
my $LOG;
my $DELAY;                              # delay between cycles
#----------------------------------
# MONITOR session
# test mode. sleep and count
sub spawn {    # constructor
#----------------------------------
 my ($class, %args) = @_;
 my $uuid = delete $args{ID}          || croak "ERR:ID spidle uuid required";
 $LOG     = delete $args{LOG}         || croak "ERR:LOG handler required";
 $SMSTAT  = delete $args{SMSTAT}      || croak "ERR:SMSTAT directory required";
 $DELAY   = delete $args{CYCLE}       || croak "ERR:CYCLE delay required";
 my $act  = delete $args{ACT_MONITOR} || croak "ERR:ACT_MONITOR required";
 POE::Session->create(
    inline_states => {
        _start => sub { $_[KERNEL]->alias_set('MONITOR')                },
        _stop  => sub { $LOG->info("$_[HEAP]->{sid} MONITOR is dead")   },
        Freeze => sub { 
          $LOG->info("$_[HEAP]->{sid} MONITOR is frozen");
          $_[HEAP]->{frozen}=1      
        },
        Unfreeze=>sub { 
          $LOG->info("$_[HEAP]->{sid} MONITOR starts"); 
          $_[HEAP]->{frozen}=0; 
          $_[KERNEL]->yield('Monitor');
        },
        Monitor=>sub {    
          my ( $kernel, $heap ) = @_[ KERNEL, HEAP ];
          my $session_id = $_[SESSION]->ID;
          return if $heap->{frozen};
          my $count = ++$heap->{count};
#          $LOG->debug("$heap->{sid} Monitor cycle # $count");
          #-----------------------------------------
          $_=$heap->{ACT_MONITOR}->($heap->{ID},$count);
          $kernel->post('SPINDLE',$_)   if/^(Failed|Weak|Cool|Tight)$/;
          $kernel->delay(Monitor=>$DELAY)  if $_ ne 'Failed';
        }
 
      },
   heap => {count=>0,frozen=>1,ID=>$uuid,ACT_MONITOR=>$act,
            sid=>'['.substr($uuid,0,3).'-'.substr($uuid,-3,3).']'
   }
 );
}
  

# ACTIONS =====================================================================
# suppouse to be redefined

sub act_monitor {          'Cool' }    # possible Failed|Weak|Cool|Tight


1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

SM::SpindleMonitor - Perl extension for blah blah blah

=head1 SYNOPSIS

  use SM::SpindleMonitor;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for SM::SpindleMonitor, created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head2 EXPORT

None by default.



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

A. U. Thor, E<lt>apl@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by A. U. Thor

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.


=cut
