package SM::Cloud::S3;

use 5.008008;
use strict;
use warnings;
use Carp;
use Amazon::S3;
use Data::Dumper;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
	Cloud_Init Cloud_ListBuckets Cloud_AddBucket 
	Cloud_PutFile Cloud_GetFile Cloud_DeleteFile
	Cloud_ListKeys
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	Cloud_Init Cloud_ListBuckets Cloud_AddBucket 
	Cloud_PutFile Cloud_GetFile Cloud_DeleteFile
	Cloud_ListKeys
);

our $VERSION = '0.01';

my $S3;

sub Cloud_Init {
    my ($aws_access_key_id, $aws_secret_access_key) = @_;
    
    $S3 = Amazon::S3->new({
	aws_access_key_id     => $aws_access_key_id,
        aws_secret_access_key => $aws_secret_access_key
    });
}

sub Cloud_ListBuckets {
    my @buckets;
    my $resp = $S3->buckets or croak $S3->err . ": " . $S3->errstr;
    my $bck = $resp->{buckets};
    foreach my $bucket (@$bck) {
	push @buckets, $bucket->bucket;
    }
    return @buckets;
}

sub Cloud_ListKeys {
    my ($cfg) = @_;
    croak "Must specify bucket name\n" unless defined $cfg->{bucket};
    my $rsp = $S3->list_bucket($cfg) or croak $S3->err . ": " . $S3->errstr;
    return $rsp;
}


sub Cloud_AddBucket {
    my ($name) = @_;
    $S3->add_bucket({bucket=>$name}) or croak 
	$S3->err . ": " . $S3->errstr . "\n";
}

sub Cloud_PutFile {
    my ($bucket, $path, $dst_key, $conf) = @_;
    $S3->bucket($bucket)->add_key_filename($dst_key, $path, $conf)
	or croak $S3->err . ": " . $S3->errstr;
}

sub Cloud_GetFile {
    my ($bucket, $key, $dst_path) = @_;
    $S3->bucket($bucket)->get_key_filename($key, undef, $dst_path)
	or croak $S3->err . ": " . $S3->errstr;
}

sub Cloud_DeleteFile {
    my ($bucket, $key) = @_;
    $S3->bucket($bucket)->delete_key($key)
	or croak $S3->err . ": " . $S3->errstr;
}

1;