package SM::Cloud;

use 5.008008;
use strict;
use warnings;
use Carp qw( croak );

use vars qw($VERSION);

$VERSION = '0.01';

sub import {
    my $self = shift;
    my @engines = @_;
    croak "Must specify engine to load"
	if @engines == 0;
    croak "Can't use more than one engine at once"
	if @engines > 1;
    
    my $engine = $engines[0];
    my $caller = caller();
    
    # Load cloud engine into caller's package
    my $code = "package $caller; use ".__PACKAGE__."::$engine";
    eval $code;
    croak "Couldn't load '$engine'" if $@;
}

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

SM::Cloud - Perl extension for blah blah blah

=head1 SYNOPSIS

  use SM::Cloud;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for SM::Cloud, created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head2 EXPORT

None by default.



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

Alexey, E<lt>alexey@E<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2013 by Alexey

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.10.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
