//
//  SKMService_prefpanePref.m
//  SKMService-prefpane
//
//  Created by maxim on 10/12/08.
//  Copyright (c) 2008 none. All rights reserved.
//

#import "SKMService_prefpanePref.h"
#include <sys/stat.h>
#include <pthread.h>

@implementation SKMService_prefpanePref

@synthesize authOK;
@synthesize ourStatus;
@synthesize authorizationRef;

#define CONTROL_SCRIPT "/opt/sarch/sly/Darwin/bin/control"

- (id)initWithBundle:(NSBundle *) bundle
{
	if ( (self = [super initWithBundle:bundle]) != nil )
	{		
		NSBundle *thisBundle = [NSBundle bundleForClass:[self class]];
		softwareBrand = [NSString stringWithFormat:@"%@",
						 [thisBundle objectForInfoDictionaryKey:@"SoftwareBrand"]];
		
		struct stat dummy;
		if (stat(CONTROL_SCRIPT, &dummy) != 0)
		{
			NSBeginCriticalAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Software installation was not found on this computer!",
							  nil);
			return nil;
		
		}
	}
	
	isInstalled = YES;
	return self;
}


- (void) mainViewDidLoad
{
	
	authFlags = kAuthorizationFlagDefaults;                                                                                         
	
	ourStatus = AuthorizationCreate(&authRights, kAuthorizationEmptyEnvironment,                                                    
									authFlags, &authorizationRef);
	NSLog(@"mainViewDidLoad: auth= %d", ourStatus);
	if (ourStatus != errAuthorizationSuccess)
	{
		authOK = NO;
		return;	
	}
	
    
	
}

- (void) willSelect
{
	// Initialize authorization.                                                                                 
	AuthorizationItem authItems[1];	
		
	authItems[0].name = kAuthorizationRightExecute;		// we want the right to execute
	authItems[0].value = 0;				// the path to the startup script
	authItems[0].valueLength = 0;	// length of the command
	authItems[0].flags = 0;								// no extra flags
	
	authRights.count = 1;		// we have one item
	authRights.items = authItems;	// here is the values for our item
	
	// by setting the kAuthorizationFlagExtendRights flag, we are telling
	// the security framework to bring up the authorization panel and ask for
	// our password in order to get root privelages to execute the startup script
	
	authFlags = kAuthorizationFlagInteractionAllowed | kAuthorizationFlagExtendRights;
	
	// lets find out if we are authorized
	ourStatus = AuthorizationCopyRights(authorizationRef, &authRights,
										kAuthorizationEmptyEnvironment, authFlags, NULL);
	
	authOK = (errAuthorizationSuccess==ourStatus);
	
	NSLog(@"auth= %d", authOK);	
	
	statusTimer = nil;
	
/*	
	if (![self checkDiskLayout])
	{
		NSBeginAlertSheet(
						  @"Warning!",
						  @"OK",
						  nil,
						  nil,
						  [NSApp mainWindow],
						  self,
						  nil,
						  nil,
						  self,
						  @"Current disk layout is not compatible with SKM. Please read installation notes (/opt/sarch/sly/Darwin/doc/Installer-ReadMe.rtfd)",
						  nil);
	}
*/	
	[action_button setEnabled:authOK];
	[master_ip_text setEnabled:authOK];
	[auto_start_cb setEnabled:authOK];
	[master_ip_change_button setEnabled:authOK];
	[select_patch_button setEnabled:authOK];
	[uninstall_button setEnabled:authOK];
	
	
    [self updateStatus];
    
    if ((isCLAREVISION || isSTRATUS) && [tab_view numberOfTabViewItems] == 4) {
        [tab_view removeTabViewItem:[tab_view tabViewItemAtIndex:1]];
    }
	
}

- (void) didSelect
{
	[[[self mainView] window] setTitle:
		[NSString stringWithFormat:@"%@ Surveillance Management Software", softwareBrand]];
}

- (void) willUnselect
{
	if (statusTimer) [statusTimer invalidate ];
	//AuthorizationFree(authorizationRef, kAuthorizationFlagDefaults);
}


- (void)updateGUI
{ 
	NSBundle *bundle = [NSBundle bundleForClass:[self class]];
	
	NSLog(@"Updating GUI");
	
	if (isAutostartEnabled) 
	{
		[auto_start_cb setState:NSOnState];
	}
	else
	{
		[auto_start_cb setState:NSOffState];
	}
	
    if (isCLAREVISION)
        [auto_start_cb setEnabled:NO];
    
	[master_ip_change_button setTitle:NSLocalizedString(@"Change", nil)]; 
	
	[action_button setEnabled:authOK&&([master_ip_text stringValue] != nil && [[master_ip_text stringValue] length] != 0) ];
	[master_ip_change_button setEnabled:authOK&&!isRunning&&!isCIRRUS&&!isSTRATUS];
	[master_ip_text setEnabled:authOK&&!isRunning&&!isCIRRUS&&!isSTRATUS];
	
	
	
	// parse version
	char **ap, *argv[5];
	char *dup = strdup([version cStringUsingEncoding:NSASCIIStringEncoding]);
	for (ap = argv; (*ap = strsep(&dup, "-")) != NULL;)
		if (**ap != '\0')
			if (++ap >= &argv[5])
				break;
	if (argv[2] && argv[3])
	{
		[version_text setStringValue:
			[NSString stringWithFormat: 
				@"%@ v%s (%s)", 
				softwareBrand,
				argv[2], argv[3]
		]];		
	}
	else 
	{
		[version_text setStringValue:[NSString stringWithFormat: @"%s", [version cStringUsingEncoding:NSASCIIStringEncoding]]];		
	}

	free(dup);
	
	
	if (isRunning)
	{
		[action_button setTitle:NSLocalizedString(@"Stop Software", nil)];                                                                                             
/*		[descr_text setStringValue:
				[NSString stringWithFormat: @"The SKM Server is started and configured as %s.\nTo shut the Service down, use the \"Stop Service\" button.",
				        isMaster ? "MASTER" : "NODE"]];
*/
		[descr_text setStringValue: @"The software is started\nYou can access system with the browser:"];
		[skm_url_text setHidden:NO];																				
		//[warningText setHidden:NO];                                                                                                                                 
		[[state_text cell] setTextColor: [NSColor greenColor]];                                                                                                      
		[state_text setStringValue:@"running"];                                                                                                                      
		[state_image setImage:                                                                                                                                       
		[[[NSImage alloc] initWithContentsOfFile:[bundle pathForResource:@"instance_started"                                                                      
																   ofType:@"png"]] autorelease]]; 
	}
	else
	{
		[action_button setTitle:NSLocalizedString(@"Start Software", nil)];                                                                                            
		[descr_text setStringValue:@"The software is currently stopped.\n"                                                                              
		 "To start it, use the \"Start Software\" button."];                                                                                                   
		//[warningText setHidden:YES];                                                                                                                                
		
		[skm_url_text setHidden:YES];
		[[state_text cell] setTextColor: [NSColor redColor]];                                                                                                        
		[state_text setStringValue:@"stopped"];                                                                                                                      
		[state_image setImage:                                                                                                                                       
		[[[NSImage alloc] initWithContentsOfFile:[bundle pathForResource:@"instance_stopped"                                                                      
																   ofType:@"png"]] autorelease]];     
	}
	/*
	if (storage_status)
	{
		[storage_status_text setStringValue:storage_status];
		if ([storage_status compare:@"stopped" options:NSCaseInsensitiveSearch] == NSOrderedSame)
		{	
			[[storage_status_text cell] setTextColor: [NSColor redColor]];
		}	
		else if ([storage_status compare:@"archiving" options:NSCaseInsensitiveSearch] == NSOrderedSame)
		{
			[[storage_status_text cell] setTextColor: [NSColor greenColor]];
		}
		else if ([storage_status compare:@"no-archive" options:NSCaseInsensitiveSearch] == NSOrderedSame)
		{
			[[storage_status_text cell] setTextColor: [NSColor yellowColor]];
		}
		else
		{
			[[storage_status_text cell] setTextColor: [NSColor redColor]];
		}
	}
	else
	{
		[storage_status_text setStringValue:@"unknown"];
		[[storage_status_text cell] setTextColor: [NSColor redColor]];		
	}
	*/
	
	
	[self setHyperlinkWithTextField:skm_url_text text:[NSString stringWithFormat:@"http://%@/", netname?netname:@"localhost"]
												  url:[NSString stringWithFormat:@"http://%@/", netname?netname:@"localhost"]];
	[skm_url_text setSelectable:NO];
	
	
    [self setHyperlinkWithTextField:doc_url_text text:@"Quick Start Guide" 
                                                url:@"file:///opt/sarch/sly/Darwin/doc/QuickStartGuide.pdf"];
    /*if (isCIRRUS)
		[self setHyperlinkWithTextField:doc_url_text text:@"Quick Start Guide" url:@"file:///opt/sarch/sly/Darwin/doc/QuickStartGuide.CIRRUS.pdf"];	
	else 
		[self setHyperlinkWithTextField:doc_url_text text:@"Quick Start Guide" url:@"file:///opt/sarch/skm/doc/SKM-2.6.3-Admin-Manual.pdf"];
*/
	[doc_url_text setSelectable:NO];
	
	
	[self setHyperlinkWithTextField:install_log_url_text text:@"Installation Log" url:@"file:///opt/sarch/var/log/postinstall/postinstall.log"];
	[install_log_url_text setSelectable:NO];
	
	//[skm_url_text setFont:[NSFont userFontOfSize:7.0f]];
}

- (BOOL) checkDiskLayout
{
	BOOL result = NO;

	char *args[] = {CONTROL_SCRIPT, "check_layout", NULL};
	FILE *fp = 0;
	char line[128];
	
	if (authOK)
	{
		ourStatus = AuthorizationExecuteWithPrivileges(authorizationRef,
													   "/usr/bin/sudo",												   
													   kAuthorizationFlagDefaults, args, &fp);
        
		if(ourStatus != errAuthorizationSuccess)
		{
            // alert user the startup has failed
            NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Could not get status of software.",
							  nil);
			return NO;
		}
	}
	else
	{
		fp = popen(CONTROL_SCRIPT" check_layout", "r");
		if (!fp)
		{
            NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Could not get status of software.",
							  nil);
			return NO;
		}
		
	}
	
	NSLog(@"Checking layout");
	
    while (fgets(line, sizeof line, fp)) 
	{
		NSLog(@"%s", line);
		
		if (strstr(line, "layout: ok") != 0) 
		{
			result = YES;
		}
		else if (strstr(line, "layout: failed") != 0) 
		{
			result = NO;
		}
	}
	
	pclose(fp);
	
	return result;
	
}

- (void)updateStatus
{
	char *args[] = {CONTROL_SCRIPT, "status", NULL};
	FILE *fp = 0;
	char line[128];
	   
	if (authOK)
	{
		ourStatus = AuthorizationExecuteWithPrivileges(authorizationRef,
												   "/usr/bin/sudo",												   
												   kAuthorizationFlagDefaults, args, &fp);
        
		if(ourStatus != errAuthorizationSuccess)
		{
            // alert user the startup has failed
            NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Could not get status of software.",
							  nil);
			return;
		}
	}
	else
	{
		fp = popen(CONTROL_SCRIPT" status", "r");
		if (!fp)
		{
            NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Could not get status of software.",
							  nil);
			return;
		}
	}
   
	NSLog(@"Updating satus");
	
    while (fgets(line, sizeof line, fp)) 
	{
		NSLog(@"%s", line);
			
		if (strstr(line, "autostart: yes") != 0) 
		{
			isAutostartEnabled = YES;
		}
		else if (strstr(line, "autostart: no") != 0) 
		{
			isAutostartEnabled = NO;
		}
		else if (strstr(line, "running: yes"))
		{
			isRunning = YES;
		}
		else if (strstr(line, "running: no"))
		{
			isRunning = NO;
		}	
		else if (strstr(line, "master: yes"))
		{
			isMaster = YES;
		}
		else if (strstr(line, "master: no"))
		{
			isMaster = NO;
		}	
		else if (strstr(line, "master_ip:"))
		{
			char ip[128] = {0};
			if (sscanf(line, "master_ip: %s", ip))
			{
				[master_ip_text setStringValue:[NSString stringWithCString:ip encoding:NSASCIIStringEncoding]];			
				netname = [NSString stringWithCString:ip encoding:NSASCIIStringEncoding];
			}
		}
		else if (strstr(line, "version:"))
		{
			char skm_version[128] = {0};
			if (sscanf(line, "version: %s", skm_version))
			{
				version = [NSString stringWithCString:skm_version encoding:NSASCIIStringEncoding];
				
				if (strstr(skm_version, "cirrus") != 0 || strstr(skm_version, "clarevision") != 0)
				{
                    isCIRRUS = YES;
                    isCLAREVISION = YES;
				}
                if (strstr(skm_version, "stratusx") == 0 && strstr(skm_version, "stratus") != 0 )
                {
                    isSTRATUS = YES;
                }
			}
		}		
		else if ((isCIRRUS || isSTRATUS) && strstr(line, "netname:"))
		{
			char skm_netname[128] = {0};
			if (sscanf(line, "netname: %s", skm_netname))
			{
				netname = [NSString stringWithCString:skm_netname encoding:NSASCIIStringEncoding];				
			}
		}	
/*		else if (strstr(line, "storage:"))
		{
			char storage[128] = {0};
			if (sscanf(line, "storage: %s", storage))
	        {
				storage_status = [NSString stringWithCString:storage];
			}
		}*/		
			
	}
		
	pclose(fp);
	
	[self updateGUI];
}

- (IBAction) changeMasterIP:(id)sender
{
	char *args[] = {CONTROL_SCRIPT, "change_master_ip", "", NULL};
	const char *ip =  [[master_ip_text stringValue] cStringUsingEncoding:NSASCIIStringEncoding];
	
	// do simple validation
	{
		NSString *regex = @"\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
		
		NSPredicate *regextest = [NSPredicate
								  predicateWithFormat:@"SELF MATCHES %@", regex];
		
		if ([regextest evaluateWithObject:[master_ip_text stringValue]] == NO) 
		{
			NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Incorrect IP address.",
							  nil);
			return;
			
		}
	}
	
	args[2] = (char*)ip;
	
	NSLog(@"Changing master ip to: %s", ip);
	
	ourStatus = AuthorizationExecuteWithPrivileges(authorizationRef,
												   "/usr/bin/sudo",												   
												   kAuthorizationFlagDefaults, args, 0);
	if(ourStatus != errAuthorizationSuccess)
	{
		NSBeginAlertSheet(
						  @"Error!",
						  @"OK",
						  nil,
						  nil,
						  [NSApp mainWindow],
						  self,
						  nil,
						  nil,
						  self,
						  @"Could not perform service control command.",
						  nil);
	}
	else
	{
		[master_ip_change_button setTitle:NSLocalizedString(@"Changing...", nil)]; 
		
		[action_button setEnabled:NO];
		[master_ip_change_button setEnabled:NO];
		
		[NSTimer scheduledTimerWithTimeInterval: 2
										target:self
										selector:@selector(updateStatus) 
										userInfo:nil 
										repeats:NO];
		
		
	}
	
}

- (IBAction) toggleService:(id)sender
{
		
	[action_button setTitle:NSLocalizedString(!isRunning?@"  Starting...":@"  Stopping...", nil)]; 

	[action_button setEnabled:NO];
	[master_ip_change_button setEnabled:NO];
	[master_ip_text setEnabled:NO];
		
	[NSTimer scheduledTimerWithTimeInterval: 0.1
			 target:self
		     selector:@selector(doToggleService) 
			 userInfo:nil 
			 repeats:NO];		 
}

- (void) doToggleService
{
	char *args[] = {CONTROL_SCRIPT, "start", "2>&1", NULL};
	FILE *fp = 0;
	char line[128];
	
	if (isRunning)
	{
		args[1] = "stop";
	}
	
    ourStatus = AuthorizationExecuteWithPrivileges(authorizationRef,
												   "/usr/bin/sudo",												   
												   kAuthorizationFlagDefaults, args, &fp);
	if (ourStatus != errAuthorizationSuccess)
	{
		NSBeginAlertSheet(
						  @"Error!",
						  @"OK",
						  nil,
						  nil,
						  [NSApp mainWindow],
						  self,
						  nil,
						  nil,
						  self,
						  @"Could not perform service control command.",
						  nil);
		return;
	}	
	
	NSLog(@"Toggle service");
	
    while (fgets(line, sizeof line, fp)) 
	{
		NSLog(@"%s", line);
	}
	
	pclose(fp);
	
	
	[NSTimer scheduledTimerWithTimeInterval: 3
								target:self
								selector:@selector(updateStatus) 
								userInfo:nil 
								repeats:NO];
	
}

- (IBAction) changeAutostart:(id)sender
{
	char *args[] = {CONTROL_SCRIPT, "autostart", "off", NULL};
	
	if (!isAutostartEnabled)
	{
		args[2] = "on";
	}
	
    ourStatus = AuthorizationExecuteWithPrivileges(authorizationRef,
												   "/usr/bin/sudo",												   
												   kAuthorizationFlagDefaults, args, 0);
	if(ourStatus != errAuthorizationSuccess)
	{
		NSBeginAlertSheet(
						  @"Error!",
						  @"OK",
						  nil,
						  nil,
						  [NSApp mainWindow],
						  self,
						  nil,
						  nil,
						  self,
						  @"Could not perform service control command.",
						  nil);
	}	
    
	[NSTimer scheduledTimerWithTimeInterval: 3
								target:self
								selector:@selector(updateStatus) 
								userInfo:nil 
								repeats:NO];
	
}


- (void)initSpeedSheetWithPatchFile:(NSString*)patchFile
{
	char *args[] = {CONTROL_SCRIPT, "apply_patch", "", NULL};
	FILE *fp = 0;
	char line[128];
	
	args[2] = (char*)[patchFile cStringUsingEncoding:NSASCIIStringEncoding];

	selectedPatchFile = [[NSString alloc] initWithString:patchFile];
	
	if (authOK)
	{
		ourStatus = AuthorizationExecuteWithPrivileges(authorizationRef,
													   "/usr/bin/sudo",												   
													   kAuthorizationFlagDefaults, args, &fp);
        
		if(ourStatus != errAuthorizationSuccess)
		{
            // alert user the startup has failed
            NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Could not apply patch.",
							  nil);
			return;
		}
	}
	
	NSLog(@"Getting patch info");
	BOOL applyOK = NO;
	NSString *text = @"";
    while (fgets(line, sizeof line, fp)) 
	{
		NSLog(@"%s", line);
		
		if (strstr(line, "/opt/sarch/vpatch/bin/install.root") != 0
			|| strstr(line, "/opt/sarch/vpatch/bin/vctl desc") != 0
		   ) 
		{
			continue;
		}
		if (strstr(line, "press any key to continue") != 0)
		{
			applyOK = YES;
			break;
		}
		
		text = [text stringByAppendingString:[NSString stringWithCString:line encoding:NSASCIIStringEncoding]];
	}
	
	pclose(fp);
	
	if (applyOK)
	{		
		[apply_patch_warn_text setString:text];

		[patch_apply_progress setHidden:YES];		
		
		[apply_patch_button setHidden:NO];
		[cancel_patch_button setHidden:NO];
		[done_patch_button setHidden:YES];
		
		[apply_patch_button setEnabled:YES];
		[cancel_patch_button setEnabled:YES];
		
		
		
		[NSApp beginSheet:apply_patch_speed_sheet
		   modalForWindow:[tab_view window]
		   modalDelegate:nil
		   didEndSelector:NULL
		   contextInfo:NULL];		
	}
	else
	{
		NSBeginAlertSheet(
		 @"Could not get patch information",
		 @"OK",
		 nil,
		 nil,
		 [NSApp mainWindow],
		 self,
		 nil,
		 nil,
		 self,
		 text,
		 nil);
		
		return;
	}
	
	
	
}

-(void) doApplyPatch
{
	char *args[] = {CONTROL_SCRIPT, "apply_patch", "", "silent", NULL};
	FILE *fp = 0;
	char line[128];
	
	NSLog(@"Patch file: %s", selectedPatchFile);
	
	args[2] = (char*)[selectedPatchFile cStringUsingEncoding:NSASCIIStringEncoding];
	
	if (authOK)
	{
		ourStatus = AuthorizationExecuteWithPrivileges(authorizationRef,
													   "/usr/bin/sudo",												   
													   kAuthorizationFlagDefaults, args, &fp);
        
		if(ourStatus != errAuthorizationSuccess)
		{
            // alert user the startup has failed
            NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  self,
							  nil,
							  nil,
							  self,
							  @"Could not apply patch.",
							  nil);
			return;
		}
	}
	
	NSLog(@"Applying....");
	NSString *text = @"";
    while (fgets(line, sizeof line, fp)) 
	{
		NSLog(@"%s", line);
		
		if (strstr(line, "/opt/sarch/vpatch/bin/install.root") != 0
			|| strstr(line, "/opt/sarch/vpatch/bin/vctl desc") != 0
			|| strstr(line, "press any key to continue") != 0
			|| strstr(line, "you want to continue applying patch") != 0
			) 
		{
			continue;
		}
		
		text = [text stringByAppendingString:[NSString stringWithCString:line encoding:NSASCIIStringEncoding]];
	}
	
	pclose(fp);
	
	[apply_patch_warn_text setString:text];
	
	[patch_apply_progress stopAnimation:nil];
	[patch_apply_progress setHidden:YES];
	
	
	[apply_patch_button setHidden:YES];
	[cancel_patch_button setHidden:YES];
	[done_patch_button setHidden:NO];
	
	[self updatePatchList];

}

- (IBAction)endSpeedSheet:(id)sender
{
	
	if (sender == apply_patch_button) 
	{
		NSLog(@"Applying patch");
		
		[apply_patch_button setEnabled:NO];
		[cancel_patch_button setEnabled:NO];
		
		[patch_apply_progress setHidden:NO];
		[patch_apply_progress setUsesThreadedAnimation:YES];
		[patch_apply_progress startAnimation:nil];
		
		[NSTimer scheduledTimerWithTimeInterval: 0
										 target:self
									     selector:@selector(doApplyPatch) 
									     userInfo:nil 
										 repeats:NO];
		
	}
	else
	{
		// Return to normal event handling
		[NSApp endSheet:apply_patch_speed_sheet];
		
		// Hide the sheet
		[apply_patch_speed_sheet orderOut:nil];
		
		if (!isInstalled) exit(0);
			
	}
	
}


- (IBAction) selectPatch:(id)sender
{
	NSArray *fileTypes = [NSArray arrayWithObject:@"gpg"];
	NSOpenPanel        *openPanel = [NSOpenPanel openPanel]; 
	int                selection; 
	[openPanel setAllowsMultipleSelection:NO]; 
	[openPanel setCanChooseDirectories:NO]; 
	[openPanel setCanChooseFiles:YES]; 
	[openPanel setResolvesAliases:YES]; 

	
	selection = [openPanel runModalForTypes:fileTypes]; 
	
	if(NSOKButton == selection) 
	{ 
		[self initSpeedSheetWithPatchFile:[[openPanel filenames] objectAtIndex:0]];		
	} 
}


- (void)updatePatchList
{
	char command[] = "/opt/sarch/vpatch/bin/vctl list";
	FILE *fp = 0;
	char line[128];
	
	fp = popen(command, "r");
	if (!fp)	
	{
		NSBeginAlertSheet(
						  @"Error!",
						  @"OK",
						  nil,
						  nil,
						  [NSApp mainWindow],
						  self,
						  nil,
						  nil,
						  self,
						  @"Could not get intalled updates.",
						  nil);
		return;
	}
	
	
	NSLog(@"Updating patches");
	[patches_info setString:@""];
    while (fgets(line, sizeof line, fp)) 
	{
		NSLog(@"%s", line);
		[patches_info setString:[[patches_info string] 
								 stringByAppendingString:[NSString stringWithCString:line encoding:NSASCIIStringEncoding]]];
		
	}
	
	pclose(fp);
	
}

- (void)tabView:(NSTabView *)tabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
	if (![[tabViewItem identifier] isEqualToString:@"Updates"]) return;
		
	[self updatePatchList];
	
}



void* doUninstall(void *arg)
{
	
	SKMService_prefpanePref *prefPane = (SKMService_prefpanePref*)arg;
	
	char *args[] = {CONTROL_SCRIPT, "uninstall", NULL};
	FILE *fp = 0;
	char line[128];
	
	NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];
	
	if (prefPane.authOK)
	{
		prefPane.ourStatus = AuthorizationExecuteWithPrivileges(prefPane.authorizationRef,
													   "/usr/bin/sudo",												   
													   kAuthorizationFlagDefaults, args, &fp);
        
		if(prefPane.ourStatus != errAuthorizationSuccess)
		{
            // alert user the startup has failed
            NSBeginAlertSheet(
							  @"Error!",
							  @"OK",
							  nil,
							  nil,
							  [NSApp mainWindow],
							  prefPane,
							  nil,
							  nil,
							  prefPane,
							  @"Could not uninstall package.",
							  nil);
			return NULL;
		}
	}
	
	NSLog(@"Uninstalling....");
	NSString *text = @"";
    while (fgets(line, sizeof line, fp)) 
	{
		NSLog(@"%s", line);
		
		text = [text stringByAppendingString:[NSString stringWithCString:line encoding:NSASCIIStringEncoding]];
	
		[prefPane performSelectorOnMainThread:@selector(setUninstallProgressText:) withObject:text waitUntilDone:YES];
		
	}
	
	pclose(fp);
	
	
	[prefPane performSelectorOnMainThread:@selector(doneUninstall) withObject:nil waitUntilDone:YES];
	
	[pool release];
	
	return NULL;
}



- (IBAction) uninstall:(id)sender
{
	NSBeginCriticalAlertSheet(
					  @"Uninstall",
					  @"Cancel",
					  @"OK",
					  nil,
					  [NSApp mainWindow],
					  self,
					  nil,
					  @selector(uninstallSheetDidDismiss:returnCode:contextInfo:),
					  self,
					  @"Are you sure to uninstall package completely?",
					  nil);
	
}



- (void) uninstallSheetDidDismiss:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void  *)contextInfo
{	
	if (returnCode == NSAlertAlternateReturn)
	{
		NSLog(@"Alternate button preset\n");

//		[apply_patch_warn_text setString:text];
		
		[patch_apply_progress setHidden:NO];		
		
		[apply_patch_button setHidden:YES];
		[cancel_patch_button setHidden:YES];
		[done_patch_button setHidden:YES];
		
//		[apply_patch_button setEnabled:YES];
//		[cancel_patch_button setEnabled:YES];
		
		NSRect frame = [patch_apply_progress frame];
		frame.origin.x = 20.0f;
		frame.size.width = [apply_patch_warn_text frame].size.width;
		
		[patch_apply_progress setFrame:frame];
		
		[NSApp beginSheet:apply_patch_speed_sheet
		   modalForWindow:[tab_view window]
		   modalDelegate:nil
		   didEndSelector:NULL
		   contextInfo:NULL];
		
		
		[patch_apply_progress setUsesThreadedAnimation:YES];
		[patch_apply_progress startAnimation:nil];
		
		[apply_patch_warn_text setString:@""];	
		
		/*[NSTimer scheduledTimerWithTimeInterval: 0
										 target:self
									   selector:@selector(doUninstall) 
									   userInfo:nil 
										repeats:NO];
		
		*/
		pthread_t th;
		pthread_create(&th, 0, doUninstall, self);
		pthread_detach(th);
		
	}
}

- (void) setUninstallProgressText:(id) text
{
	[apply_patch_warn_text setString:text];	
	//[apply_patch_warn_text setNeedsDisplay:YES];
}

- (void) doneUninstall
{
	//	[apply_patch_warn_text setString:text];
	
	[patch_apply_progress stopAnimation:nil];
	[patch_apply_progress setHidden:YES];
	
	
	[apply_patch_button setHidden:YES];
	[cancel_patch_button setHidden:YES];
	[done_patch_button setHidden:NO];
	
	[action_button setEnabled:NO];
	[master_ip_text setEnabled:NO];
	[auto_start_cb setEnabled:NO];
	[master_ip_change_button setEnabled:NO];
	[select_patch_button setEnabled:NO];
	[uninstall_button setEnabled:NO];
	
	
	isInstalled = NO;
	
	[done_patch_button setTitle:@"Close System Preferences"];
	
}

-(void)setHyperlinkWithTextField:(NSTextField*)inTextField text:(NSString*)text url:(NSString*)url_;
{
    // both are needed, otherwise hyperlink won't accept mousedown
    [inTextField setAllowsEditingTextAttributes: YES];
    [inTextField setSelectable: YES];
	
    NSURL* url = [NSURL URLWithString:url_];
	
    NSMutableAttributedString* string = [[NSMutableAttributedString alloc] init];
    [string appendAttributedString: [NSAttributedString hyperlinkFromString:text withURL:url]];
	
    // set the attributed string to the NSTextField
    [inTextField setAttributedStringValue: string];
}

@end
