//
//  SKMService_prefpanePref.h
//  SKMService-prefpane
//
//  Created by maxim on 10/12/08.
//  Copyright (c) 2008 none. All rights reserved.
//

#import <PreferencePanes/PreferencePanes.h>
#include <Security/Authorization.h>
#import "DSClickableURLTextField.h"

@interface SKMService_prefpanePref : NSPreferencePane 
{
	IBOutlet NSButton *auto_start_cb;
	IBOutlet NSButton *action_button;
	IBOutlet NSTextField *version_text;
	IBOutlet NSTextField *descr_text;
	IBOutlet NSTextField *state_text;
	IBOutlet DSClickableURLTextField *skm_url_text;
	IBOutlet DSClickableURLTextField *doc_url_text;
	IBOutlet DSClickableURLTextField *install_log_url_text;
	IBOutlet NSTextField *warning_text;
	IBOutlet NSImageView *state_image;
	IBOutlet NSTextField *master_ip_text;
	IBOutlet NSButton    *master_ip_change_button;
	IBOutlet NSTabView  *tab_view;
	IBOutlet NSWindow  *apply_patch_speed_sheet;
	IBOutlet NSTextView  *apply_patch_warn_text;
	IBOutlet NSButton *select_patch_button;
	IBOutlet NSButton *uninstall_button;
	IBOutlet NSButton *apply_patch_button;
	IBOutlet NSButton *cancel_patch_button;
	IBOutlet NSButton *done_patch_button;
	
	IBOutlet NSTextView *patches_info;
	IBOutlet NSProgressIndicator *patch_apply_progress;
	
	NSString *selectedPatchFile;
	
	// Security Framework variables                                                                                                 
    AuthorizationRef authorizationRef;                                                                                              
    AuthorizationRights authRights;                                                                                                 																			
    AuthorizationFlags authFlags;     
	OSStatus ourStatus;	
	NSTimer *statusTimer;
	NSString *version;
	NSString *netname;
//	NSString *storage_status;
	BOOL isRunning;
	BOOL isMaster;
	BOOL isAutostartEnabled;
	BOOL isInstalled;
	BOOL isCIRRUS;
    BOOL isCLAREVISION;
    BOOL isSTRATUS;
	BOOL authOK;
	NSString *softwareBrand;
}

@property (nonatomic, assign) BOOL authOK;
@property (nonatomic, assign) OSStatus ourStatus;
@property (nonatomic, assign) AuthorizationRef authorizationRef;

- (IBAction) changeAutostart:(id)sender;

- (IBAction) toggleService:(id)sender;

- (IBAction) changeMasterIP:(id)sender;

- (IBAction) selectPatch:(id)sender;

- (IBAction) endSpeedSheet:(id)sender;

- (IBAction) uninstall:(id)sender;

- (id) initWithBundle:(NSBundle *) bundle;

- (void) uninstallSheetDidDismiss:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void  *)contextInfo;

- (void) setUninstallProgressText:(id) text;

- (void) updateGUI;

- (void) mainViewDidLoad;

- (void) willSelect;

- (void) didSelect;

- (void) willUnselect;

- (void) updateStatus;

- (void) doToggleService;

- (void) initSpeedSheetWithPatchFile:(NSString*)patchFile;


- (void) doApplyPatch;

- (void) updatePatchList;

- (BOOL) checkDiskLayout;

// NSTabView delegates
- (void) tabView:(NSTabView *)tabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem;

-(void)setHyperlinkWithTextField:(NSTextField*)inTextField text:(NSString*)text url:(NSString*)url;

@end


@interface NSAttributedString (Hyperlink)
+(id)hyperlinkFromString:(NSString*)inString withURL:(NSURL*)aURL;
@end

@implementation NSAttributedString (Hyperlink)
+(id)hyperlinkFromString:(NSString*)inString withURL:(NSURL*)aURL
{
    NSMutableAttributedString* attrString = [[NSMutableAttributedString alloc] initWithString: inString];
    NSRange range = NSMakeRange(0, [attrString length]);
	
    [attrString beginEditing];
    [attrString addAttribute:NSLinkAttributeName value:[aURL absoluteString] range:range];
	
    // make the text appear in blue
    [attrString addAttribute:NSForegroundColorAttributeName value:[NSColor blueColor] range:range];
	
    // next make the text appear with an underline
    [attrString addAttribute:
	 NSUnderlineStyleAttributeName value:[NSNumber numberWithInt:NSSingleUnderlineStyle] range:range];
	
    [attrString endEditing];
	
    return [attrString autorelease];
}
@end
