/*
# $Id: workflow_script.js 29043 2013-07-02 18:39:11Z teetov $
#------------------------------------------------------------------------------
# Workflow
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
	function escapeXML(str)
	{
		var str2 = "";
		for (var i = 0; i < str.length; i++)
		{
			if (str.charAt(i) == '<')
				str2 += "&lt;";
			else
			if (str.charAt(i) == '>')
				str2 += "&gt;";
			else
				str2 += str.charAt(i);
		}
		return str2;
	}

	function fillWorkFlowList(list_id)
	{

		$.ajax({
			url: "call.php",
			cache: false,
			data: { 'function' : 'getWorkFlowList' },
			dataType: "json",
			beforeSend: function()
			{
				$("#workflowlist").mask();
			},
			complete: function()
			{
				$("#workflowlist").unmask();
			},
			success: function(data)
			{
				var list = eval(data);
				var data2 = new Object();
				for (var i = 0; i < list.length; i++)
				{
					data2[ list[i]["workflow"] ] = list[i]["name"];
				}
				$("#" + list_id).addOption(data2, false);
			}
		});
	}

	function fillWorkFlowParameters(workflow_id)
	{
		$.ajax({
			async: false,
			url: "call.php",
			cache: false,
			data: { 'function' : 'getWorkFlow', 'id' : workflow_id },
			dataType: "json",
			beforeSend: function()
			{
				$("#waitindicator").show();
				$("#waitindicator").mask();
			},
			complete: function()
			{
				$("#waitindicator").hide();
				$("#waitindicator").unmask();
			},
			success: function(data)
			{
				if (data != '[ ]')
				{
					var dataObj = eval(data);
					var list = dataObj[0];
					if (list["workflow"] == workflow_id)
					{
						$("div#workflow_name").text(list["name"]);
						$("input#workflow_name_edit").val(list["name"]);
						$("div#workflow_description").text(list["description"]);
						$("input#workflow_description_edit").val(list["description"]);

						// display xml in html
						var str = "<pre>" + escapeXML(list["context"]) + "</pre>";
						$("div#workflow_context").empty();
						$(str).appendTo("div#workflow_context");

						$("textarea#workflow_context_edit").get(0).value = list["context"];

						// clear eventsource workflow list
						$("#eventsourceworkflowlist").removeOption(/./);

						if (list["protected"] == 't')
						{
							fillEventSourceList(workflow_id, "eventsourceworkflowlist", true);
						} else {
							$("#editworkflow").show();
							$("#deleteworkflow").show();
							fillEventSourceList(workflow_id, "eventsourceworkflowlist", false);
						}
					}
				}
			}
		});
	}

	function fillEventSourceList(workflow_id, eventsourcelist_id, is_disabled)
	{
		$.ajax({
			url: "call.php",
			dataType: "json",
			async: true,
			cache: false,
			data: {
				'function': 'getEventSourceList'
			},
			success: function(list)
			{
				$("#" + eventsourcelist_id).html("");
				var param_disabled = '';
				if (is_disabled)
					param_disabled = 'disabled="disabled"';

				for (var i = 0; i < list.length; i++)
				{
					if ($("#" + eventsourcelist_id).attr('direction') == 'rtl')
						$('<label><font face="verdana,arial">' + list[i]["name"] + '</font><input type="checkbox" ' + param_disabled + ' name="' + list[i]["eventsource"] + '" value="' + list[i]["name"] + '"/></label><br/>').appendTo("#" + eventsourcelist_id);
					else
						$('<label><input type="checkbox" ' + param_disabled + ' name="' + list[i]["eventsource"] + '" value="' + list[i]["name"] + '"/><font face="verdana,arial">' + list[i]["name"] + '</font></label><br/>').appendTo("#" + eventsourcelist_id);
				}
				$("#" + eventsourcelist_id + " input[type='checkbox']").click(
					function()
					{
						$("#saveeventsourceworkflowlist").show();
					}
				);
				fillWorkFlowEventSourceList(workflow_id, eventsourcelist_id);
			}
		});
	}

	function fillWorkFlowEventSourceList(workflow_id, eventsourceworkflowlist_id)
	{
		$.ajax({
			url: "call.php",
			dataType: "json",
			async: true,
			cache: false,
			data: {
				'function': 'getWorkFlowEventSourceList',
				'id': workflow_id
			},
			success: function(list)
			{
				for (var i = 0; i < list.length; i++)
				{
					$("#" + eventsourceworkflowlist_id + " input[type='checkbox']").each(
						function()
						{
							if (this.name == list[i]["eventsource"])
								this.checked = true;
						}
					);
				}
			}
		});
	}

	$(document).ready(
		function()
		{
			addEvents();
			init();
		}
	);

	var is_editing = false;
	var is_adding = false;
	function init()
	{
		$("#addworkflow").show();
		$("#arrow").hide();
		$("#workflow_context_edit").height(100);
		$("#workflow_name").val("");
		$("#workflow_description").val("");
		$("#workflow_context").val("");
		$("#workflow_parameters").hide();
		$("#eventsourceworkflow_parameters").hide();
		$("#workflow_context_file_form").hide();
		$("#saveeventsourceworkflowlist").hide();
		// clear all data on screen
		$("#workflow_context").text("");
		$("#eventsourceworkflowlist").removeOption(/./);
		$("#eventsourcelist").removeOption(/./);

		$("#workflowlist").removeOption(/./);
		fillWorkFlowList("workflowlist");

		// disable button if workflow not selected
		if (String($("#workflowlist").selectedValues()[0]) == 'undefined')
		{
			$("#editworkflow").hide();
			$("#deleteworkflow").hide();
		}
		$("#saveworkflow").hide();
		$("#cancelworkflow").hide();
	}

	function saveWorkflow(workflow_context_filename)
	{
		if (is_adding)
		{
			$.post(
				"call.php",
				{	'function' : 'addWorkFlow',
					'name' : $("#workflow_name_edit").val(),
					'description' : $("#workflow_description_edit").val(),
					'context' : $("#workflow_context_edit").val(),
					'filename' : workflow_context_filename },
				function(data)
				{
					if (data.error == "")
					{
						init();
					} else {
						// show error message
						alert(__('Error: Workflow not added.') + data.error);
					}
				}
			);
		} else
		if (is_editing)
		{
			var workflow_id = $('#workflowlist').selectedValues()[0];
			$.post(
				"call.php",
				{	'function' : 'editWorkFlow',
					'id' : workflow_id,
					'name' : $("#workflow_name_edit").val(),
					'description' : $("#workflow_description_edit").val(),
					'context' : $("#workflow_context_edit").val(),
					'filename' : workflow_context_filename },
				function(data)
				{
					if (data.error == "")
					{
						init();
					} else {
						// show error message
						alert(__('Error: Workflow not changed.') + "\n" + data.error);
					}
				}
			);
		}
	}

	function addEvents()
	{
/*		//starting setting some animation when the ajax starts and completes
		$(document).ajaxStart(
			function()
			{
				$(this).show();
			}
		).ajaxComplete(
			function()
			{
				$(this).hide();
			}
		);*/

		$("#workflowlist").change(
			function()
			{
				$("#arrow").show();
				// uncheck check for uploaad context and enable edit textarea
				$("#workflow_context_file_checkbox").prop("checked", false);
				$("#workflow_context_file_form").hide();

				$("#saveeventsourceworkflowlist").hide();

				$("#workflow_context_file").val("");

				$("#workflow_context_edit").height(100);

				is_editing = false;
				is_adding = false;
				// hide divs
				$("#workflow_name_edit").hide();
				$("#workflow_description_edit").hide();
				$("#workflow_context_edit").hide();

				// enables and disables buttons
				$("#addworkflow").show();
				$("#editworkflow").hide();
				$("#deleteworkflow").hide();

				// disable buttons
				$("#saveworkflow").hide();
				$("#cancelworkflow").hide();

				$("#row_workflow_context_file").hide();

				$("#workflow_parameters").hide();

				var id = $("#workflowlist").selectedValues()[0];
				fillWorkFlowParameters(id);

				$("#workflow_parameters").slideDown("fast");
				$("#eventsourceworkflow_parameters").slideDown("fast");

				// show divs
				$("#workflow_name").show();
				$("#workflow_description").show();
				$("#workflow_context").show();
				// hide edits
				$("#workflow_name_edit").hide();
				$("#workflow_description_edit").hide();
				$("#workflow_context_edit").hide();
			}
		);
		$("#addworkflow").click(
			function()
			{
				is_editing = false;
				is_adding = true;

				$('#workflowlist').selectOptions("",false);

				$("#saveeventsourceworkflowlist").hide();
				$("#arrow").hide();

				// uncheck check for uploaad context and enable edit textarea
				$("#workflow_context_file_checkbox").prop("checked", false);
				$("#workflow_context_file_form").hide();
				$("#workflow_context_edit").prop("disabled", false);

				$("#workflow_context_file").val("");

				// hide divs
				$("#workflow_name").hide();
				$("#workflow_description").hide();
				$("#workflow_context").hide();
				// show edits
				$("#workflow_name_edit").show();
				$("#workflow_description_edit").show();
				$("#workflow_context_edit").show();

				$("#row_workflow_context_file").show();

				// hide eventsource workflow parameters
				$("#eventsourceworkflow_parameters").slideUp("fast");

				// clear values on screen
				$("#workflow_name_edit").val("");
				$("#workflow_description_edit").val("");
				$("#workflow_context_edit").val("");

				// disable buttons add, delete and edit
				$("#addworkflow").hide();
				$("#editworkflow").hide();
				$("#deleteworkflow").hide();

				// show workflow_parameters
				$("#workflow_parameters").slideDown("fast");

				// activate save button
				$("#saveworkflow").show();
				$("#cancelworkflow").show();
			}
		);

		$("#saveworkflow").click(
			function()
			{
				if (
					$.trim($("#workflow_name_edit").val()) == ""
					||
					$.trim($("#workflow_description_edit").val()) == ""
					||
					($.trim($("#workflow_context_edit").val()) == "" && !$("#workflow_context_edit").prop("disabled"))
					||
					($.trim($("#workflow_context_file").val()) == "" && $("#workflow_context_edit").prop("disabled"))
					)
				{
					alert("Please fill all fields.");
				} else {
					var filename = $.trim($("#workflow_context_file").val());
					if ( filename == "")
					{
						saveWorkflow("");
					} else {
						contextFileUploadAndSaveWorkflow(filename);
					}
				}
			}
		);
		$("#cancelworkflow").click(
			function()
			{
				init();
			}
		);

		$("#editworkflow").click(
			function()
			{
				is_editing = true;
				is_adding = false;

				// show workflow_parameters
				$("#workflow_parameters").slideDown("fast");

				$("#saveeventsourceworkflowlist").hide();

				// hide divs
				$("#workflow_name").hide();
				$("#workflow_description").hide();
				$("#workflow_context").hide();
				// show edits
				$("#workflow_name_edit").show();
				$("#workflow_description_edit").show();
				$("#workflow_context_edit").show();

				$("#row_workflow_context_file").show();

				$("#saveworkflow").show();
				$("#editworkflow").hide();
				$("#cancelworkflow").show();
			}
		);

		$("#deleteworkflow").click(
			function()
			{
				$("#saveeventsourceworkflowlist").hide();

				if(confirm(__("Are you shure you want to delete workflow?")))
				{
					var workflow_id = $('#workflowlist').selectedValues()[0];
					$.ajax({
						url: "call.php",
						async: true,
						cache: false,
						data: {
							'function': 'deleteWorkFlow',
							'id': workflow_id
						},
						success: function(data)
						{
							if (data.error == "")
							{
								// update lists
								init();
							} else {
								// show error message
								alert('Workflow not deleted.' + data.error);
							}
						}
					});
				}
			}
		);
		$("#saveeventsourceworkflowlist").click(
			function()
			{
				var list = new Array();
				$("#eventsourceworkflowlist input[type='checkbox']").each(
					function()
					{
						if (this.checked)
							list.push(this.name);
					}
				);
				var workflow_id = $('#workflowlist').selectedValues()[0];
				$.ajax({
					url: "call.php",
					async: true,
					cache: false,
					data: {
						'function': 'saveEventSourceWorkFlowList',
						'id_workflow': workflow_id,
						'eventsourceList': JSON.stringify(list)
					},
					success: function(data)
					{
						"use strict";
						if (data == "")
						{
							// all ok
							$("#saveeventsourceworkflowlist").hide();
						} else {
							// show error message
							alert(__("Cannot save eventsource workflow list at this moment.") +" " + data);
						}
					}
				});
			}
		);
		$("#workflow_context_file_checkbox").click(
			function()
			{
				if (this.checked)
				{
					$("#workflow_context_file_form").slideDown("fast");
					$("#workflow_context_edit").prop("disabled", true);
				} else {
					$("#workflow_context_file_form").slideUp("fast");
					$("#workflow_context_file").val("");
					$("#workflow_context_edit").prop("disabled", false);
				}
			}
		);

	}
	//function save
	function contextFileUploadAndSaveWorkflow()
	{
		$.ajaxFileUpload(
			{
				url : 'uploadxml.php',
				secureuri : false,
				fileElementId : 'workflow_context_file',
				//dataType : 'xml',
				dataType : 'json',
				success :	function(data, status)
							{
								if(typeof(data.error) != 'undefined')
								{
									if(data.error != '')
									{
										alert(data.error);
									} else
									{
										filename = data.filename;
										saveWorkflow(filename);
									}
								}
							},
				error :		function(data, status, e)
							{
								alert(e);
							}
			}
		);
		return false;
	}
