<?php
/*
# $Id: functions.php 29043 2013-07-02 18:39:11Z teetov $
#------------------------------------------------------------------------------
# Workflow
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once($_SERVER['APL'] . '/api/lib/php/db.php');

//if the user leaves the page or closes the browser prematurely, this will help prevent half completed statements
ignore_user_abort();

function addWorkFlow($name, $description, $context, $context_filename)
{
	$name = trim($name);
	$context_filename = escapeshellcmd($context_filename);
	if ($name == "")
	{
//		return "Workflow name must be not empty.";
		return array("error" => "Workflow name must be not empty.");
		
	}

	$queryString = sprintf("SELECT workflow FROM workflow WHERE name = %s AND deleted = '0';",
							sanitize($name));
	$list = executeQuery($queryString);
	if (!empty($list))
	{
//		return "Workflow name must be unique";
		return array("error" => "Workflow name must be unique");
	}

	$workflow_context = $context;
	// load xml from file
	
	try
	{
		if ($context_filename != "")
		{
			if ($f = fopen($context_filename, 'r'))
			{
				$workflow_context = fread($f, filesize($context_filename));
				fclose($f);
				unlink($context_filename);
			} else {
				return array("error" => "Can't open context xml config.");
	//			return "Can't open context xml config.";
			}
		}

		__insertWorkflow($name, $description, $workflow_context, $error);

		if ($error == "") {
			addToAppLog("/sdi/html/workflow/function.php", "add '$name' workflow");
		}
	} catch (Exception $e){
		$error = sprintf(__("Cannot add event policy.\n" %s), $e);
		$error_mode = 3;
	}
	return array(
		"error" => $error,
		"list" => "",
		"error_mode" => $error_mode,
		"result" => $result,
	);	
}


function editWorkFlow($id, $name, $description, $context, $context_filename)
{
	$context_filename = escapeshellcmd($context_filename);
	$name = trim($name);
	if ($name == "")
	{
		return array("error" => "Workflow name must be not empty.");
	}

	$queryString = sprintf("SELECT workflow FROM workflow WHERE name = %s AND workflow != %s AND deleted = '0';",
							sanitize($name), sanitize($id));
	$list = executeQuery($queryString);
	if (!empty($list))
	{
		return array("error" => "Workflow name must be unique");
	}

	
	try
	{
		$workflow_context = $context;
		// load xml from file
		if ($context_filename != "")
		{
			if ($f = fopen($context_filename, 'r'))
			{
				$workflow_context = fread($f, filesize($context_filename));
				fclose($f);
				unlink($context_filename);
			} else {
				return array("error" => "Can't open context xml config.");
			}
		}

		$queryString = sprintf("SELECT context FROM workflow WHERE workflow = %s", sanitize($id));
		$list = executeQuery($queryString);
		// if context not changed then update name or/and description and exit
		if ($list[0]["context"] === $context) {
			$queryString = sprintf("UPDATE workflow SET name = %s, description = %s WHERE workflow = %s AND protected = '0';",
							sanitize($name),
							sanitize($description),
							sanitize($id));
			$error = executeNotSelectQuery($queryString);

		} else {
			$newWfId = __insertWorkflow($name, $description, $workflow_context, $error);
			if ($error != "") {
				return $error;
			}

			$queryString = sprintf("UPDATE workflow SET deleted = '1' WHERE workflow = %s AND protected = '0';", sanitize($id));
			$queryString .= sprintf("UPDATE eventsourceworkflow SET workflow = %s WHERE workflow = %s;", sanitize($newWfId), sanitize($id));
			$error = executeNotSelectQuery($queryString);
		}

		if ($error == "") {
			addToAppLog("/sdi/html/workflow/function.php", "edit '$name' workflow");
		}
	} catch (Exception $e){
		$error = sprintf(__("Cannot add event policy.\n" %s), $e);
		$error_mode = 3;
	}
	return array(
		"error" => $error,
		"list" => "",
		"error_mode" => $error_mode,
		"result" => $result,
	);	
}


function deleteWorkFlow($id)
{
	$queryString = sprintf("SELECT distinct ec.eventpolicy, e.name
							FROM eventpolicycontent ec, eventpolicy e
							WHERE
							e.eventpolicy=ec.eventpolicy
							AND (ec.workflow = %s OR ec.infworkflow = %s);",
							sanitize($id),
							sanitize($id));
	$list = executeQuery($queryString);
	$epstr = '';
	if (isset($list[0]))
	{
		foreach($list as $value)
		{
			if ($epstr !== '') $epstr .= ', ';
			$epstr .= $value["name"] . ' [' . $value["eventpolicy"] . ']';
		}
		return array("error" => "The workflow couldn't be deleted till it added to next sources: " . $epstr);
	}



	$queryString = sprintf("SELECT name FROM workflow WHERE workflow = %s AND protected = '0' AND deleted = '0';",
							sanitize($id));
	$list = executeQuery($queryString);
	$name = "";
	if (isset($list[0]))
		$name = $list[0]["name"];

	$queryString = sprintf("UPDATE workflow SET deleted = '1' WHERE workflow = %s AND protected = '0';",
							sanitize($id));
	$error = executeNotSelectQuery($queryString);
	if ($error == "" && $name != "")
	{
		addToAppLog("/sdi/html/workflow/function.php", "delete '$name' workflow");
	}
	return array(
		"error" => $error
	);	
}

function addEventSourceToWorkFlow($id_workflow, $id_eventsource)
{
	$queryString = sprintf("INSERT INTO eventsourceworkflow (eventsource, workflow) VALUES (%s, %s)",
							sanitize($id_eventsource),
							sanitize($id_workflow));
	return executeNotSelectQuery($queryString);
}

function deleteEventSourceFromWorkFlow($id_workflow, $id_eventsource)
{
	$queryString = sprintf("DELETE FROM eventsourceworkflow WHERE eventsource = %s AND workflow = %s",
							sanitize($id_eventsource),
							sanitize($id_workflow));
	return executeNotSelectQuery($queryString);
}

function saveEventSourceWorkFlowList($id_workflow, $eventsourceList = array())
{
	if (!isset($eventsourceList))
	{
		$eventsourceList = array(-1);
	} else
	if (!is_array($eventsourceList))
	{
		$eventsourceList = array($eventsourceList);
	}

	$queryString = sprintf(
						"DELETE FROM eventsourceworkflow
						WHERE
							workflow = %s
						AND
							eventsource not in
								(%s)
							AND
								eventsource not in
								(
									SELECT
										eventsource
									FROM
										eventpolicycontent
									WHERE
										workflow = %s
									OR
										infworkflow = %s
								);",
						sanitize($id_workflow),
						implode(', ', array_map('sanitize', $eventsourceList)),
						sanitize($id_workflow),
						sanitize($id_workflow)
					);

	$queryString .= sprintf(
						"INSERT INTO
							eventsourceworkflow (eventsource, workflow)
						SELECT
							eventsource, %s as workflow
						FROM
						(
							SELECT
								eventsource
							FROM
								eventsource
							WHERE
								eventsource in
									(%s)
								AND
									eventsource not in
									(
										SELECT
											eventsource
										FROM
											eventsourceworkflow
										WHERE
											workflow = %s
									)
						) as eventsource;",
						sanitize($id_workflow),
						implode(', ', array_map('sanitize', $eventsourceList)),
						sanitize($id_workflow)
					);
	return executeNotSelectQuery($queryString);
}

function getEventSourceList()
{
	$queryString = "SELECT eventsource, name, description FROM eventsource ORDER BY name";
	$list = executeQuery($queryString);
	return $list;
}

function getWorkFlowEventSourceList($id)
{
	$queryString = sprintf("SELECT eventsource.eventsource, eventsource.name, eventsource.description FROM eventsource, eventsourceworkflow WHERE eventsource.eventsource = eventsourceworkflow.eventsource AND eventsourceworkflow.workflow = %s ORDER BY eventsource.name;",
							sanitize($id));
	$list = executeQuery($queryString);
	return $list;
}

function setWorkflowContext($id, $context)
{
	$queryString = sprintf(	"UPDATE workflow SET context = %s WHERE workflow = %s AND protected = '0'",
							sanitize($context),
							sanitize($id)
							);
	executeNotSelectQuery($queryString);
}

function getWorkFlowList()
{
	$queryString = "SELECT workflow, name, description, context, protected, deleted FROM workflow WHERE deleted = '0' ORDER BY name";
	$list = executeQuery($queryString);
	return $list;
}

function getWorkFlow($id)
{
	$queryString = sprintf("SELECT workflow, name, description, context, protected, deleted FROM workflow WHERE workflow = %s",
							sanitize($id));
	$list = executeQuery($queryString);
	return $list;
}

function getWorkFlowCount()
{
	$queryString = sprintf("SELECT count(workflow) FROM workflow WHERE workflow = %s AND deleted = '0'",
							sanitize($id));
	$list = executeQuery($queryString);
	return $list;
}


function __getErrorXML()
{
	$errors = libxml_get_errors();
	if (empty($errors))	{
		return '';
	} else {
		$error = $errors[0];
		/*if ($error->level < 3) {
			return '';
		}*/
		return $error->message;
	}
}


function __insertWorkflow($name, $description, $workflowContent, &$error)
{
	// validate and parse workflow content
	libxml_use_internal_errors(true);

	$dom = new DOMDocument('1.0', 'utf-8');
	if (!$dom->loadXML($workflowContent)) {
		$error = __getErrorXML();
		return 0;
	}

	if (!$dom->schemaValidate("/opt/sarch/elog/etc/workflow.xsd")) {
		$error = __getErrorXML();
		return 0;
	}

	// get max workflow and eventstate id
	$list = executeQuery("SELECT greatest(max(workflow) + 1,100) as newid FROM workflow");
	$workflowId = $list[0]["newid"];

	$list = executeQuery("SELECT greatest(max(eventstate) + 1,100) as newid FROM eventstate");
	$stateId = $list[0]["newid"];

	// insert workflow
	$queryString = sprintf(
			"INSERT INTO workflow (workflow, name, description, context, protected, deleted) VALUES (%s, %s, %s, %s, '0', '0');",
			sanitize($workflowId),
			sanitize($name),
			sanitize($description),
			sanitize($workflowContent));

	// insert states
	$nodeList = $dom->getElementsByTagName("state");
	foreach ($nodeList as $stateElement)
	{
		if ($stateElement->getAttribute('id') === 'empty'){
			continue;
		}

		$stateDescValue = 'null';
		$tagValues ='';
		$stateDescNodes = $stateElement->getElementsByTagName('statedesc');
		if ($stateDescNodes->length > 0){
			$stateDescElement = $stateDescNodes->item(0);
			// state/datamodel/data/skm:statedesc@description
			$stateDesc = $stateDescElement->getAttribute('desc');
			if (!empty($stateDesc)) {
				$stateDescValue = sanitize($stateDesc);
			}
			// state/datamodel/data/skm:statedesc@tags
			$tags = $stateDescElement->getAttribute('tags');
			if (!empty($tags)){
				$atags = preg_split('/[\s,]+/', $tags);
				foreach ($atags as $tag){
					if (!empty($tagValues)) $tagValues .=',';
					$tagValues .= sprintf('(%d,%s)', $stateId, sanitize($tag));
				}
			}
		}

		// state/datamodel/data/skm:userdirective
		$userDirectiveValue = 'null';
		$userDirectiveNodes = $stateElement->getElementsByTagName('userdirective');
		if ($userDirectiveNodes->length > 0){
			$userDirective = $userDirectiveNodes->item(0)->nodeValue;
			if (!empty($userDirective)) {
				$userDirectiveValue = sanitize($userDirective);
			}
		}

		$queryString .= sprintf(
				'INSERT INTO eventstate (eventstate, name, workflow, description, userdirective) VALUES (%d, %s, %d, %s, %s);',
				$stateId,
				sanitize($stateElement->getAttribute('id')),
				$workflowId,
				$stateDescValue,
				$userDirectiveValue);
		if (!empty($tagValues)) {
			$queryString .= 'INSERT INTO eventstatetag (eventstate, eventtag) VALUES ' . $tagValues .';';
		}

		$stateId++;
	}

	$error = executeNotSelectQuery('BEGIN; ' . $queryString . ' COMMIT;');
	if ($error !== '')	return 0;

	return $workflowId;
}
