<?php
/*
# $Id: call.php 33175 2015-10-19 00:11:28Z astarostin $
#------------------------------------------------------------------------------
# Workflow
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
include('functions.php');

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header('Content-type: application/json; charset=utf-8');

if (Identity::getAttribute("CHECK_CSRFTOKEN") == "yes"
	&&
	isset($_SERVER["HTTP_X_TOKEN"]) && !SessionManager::checkCSRFToken($_SERVER["HTTP_X_TOKEN"])
)
{
	$response = array();
	$response["error"] = "Forbidden";
	$response["code"] = 403;
	echo json_encode($response);

	exit;
}

if (isset($_POST['function']))
{
	switch ($_POST['function'])
	{
		case 'addWorkFlow':
			if (isset($_POST['name']) && isset($_POST['description']) && isset($_POST['context']) && isset($_POST['filename']))
				echo json_encode(addWorkFlow($_POST['name'], $_POST['description'], $_POST['context'], $_POST['filename']));
			exit;
			break;
		case 'editWorkFlow':
			if (isset($_POST['id']) && isset($_POST['name']) && isset($_POST['description']) && isset($_POST['context']) && isset($_POST['filename']))
				echo json_encode(editWorkFlow($_POST['id'], $_POST['name'], $_POST['description'], $_POST['context'], $_POST['filename']));
			exit;
			break;
	}
}
if (isset($_GET['function']))
{
	switch ($_GET['function'])
	{
		case 'getWorkFlowList':
			echo json_encode(getWorkFlowList());
			exit;
			break;
		case 'getWorkFlow':
			if(isset($_GET['id']))
				echo json_encode(getWorkFlow($_GET['id']));
			exit;
			break;
		case 'getEventSourceList':
			echo json_encode(getEventSourceList());
			exit;
			break;
		case 'getWorkFlowEventSourceList':
			if(isset($_GET['id']))
				echo json_encode(getWorkFlowEventSourceList($_GET['id']));
			exit;
			break;
		case 'deleteWorkFlow':
			if(isset($_GET['id']))
				echo json_encode(deleteWorkFlow($_GET['id']));
			exit;
			break;
		case 'saveEventSourceWorkFlowList':
			if (isset($_GET['id_workflow']))
				echo json_encode(saveEventSourceWorkFlowList($_GET['id_workflow'], json_decode($_GET['eventsourceList'])));
			exit;
			break;
	}
}
?>
