/**
 * @version :$
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

require(["jquery", "timeline", "log"], function($, TimeLine, Log){

	"use strict";

	/**
	 * @type {TimeLine}
	 */
	window.timeline1 = null;
	/**
	 * @type {TimeLine}
	 */
	window.timeline2 = null;
	/**
	 * @type {TimeLine}
	 */
	window.timeline3 = null;

	$(document).ready(function(){
		Log.isDebug = false;

		var isDebug = true;

		var obj = 101;

		window.timeline1 = new TimeLine({
			id: "#timeline_1",
			variableName: "timeline1",
			isDebug: isDebug
		});

		timeline1.init();

		timeline1.onLoad = function()
		{
			timeline1.setParameters({
				selection: {fixed: false},
				scale: {granularity: "min"},
				dateFormat: "DD/MM/YYYY"
			});

			$("#hide1").click(function(){
				$(".timeline_wrapper").css("visibility", "hidden");
			});

			$("#show1").click(function(){
				$(".timeline_wrapper").css("visibility", "visible");
			});

			$("#setTime1").click(function(){
				var date = new Date();
				timeline1.setTime(date.getTime(), true);
			}).click();

			$("#getTime1").click(function(){
				var time = timeline1.getTime();
				var date = new Date(time);
				var timeStr = "time " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();
				Log.warning(timeStr);
			});

			$("#setSelection1").click(function(){
				timeline1.setSelection(timeline1.time - 300000, timeline1.time + 600000, true);
			});

			$("#clearSelection1").click(function(){
				timeline1.clearSelection();
			});

			$("#getSelectionParameters1").click(function(){
				Log.info(JSON.stringify(timeline1.getSelectionParameters()));
			});

			$("#setFixedSelection1").click(function(){
				timeline1.setDisabledSelection(timeline1.time - 300000, timeline1.time + 600000);
			});

			$("#clearFixedSelection1").click(function(){
				timeline1.clearDisabledSelection();
			});

			$("#timezoneoffset1").change(function(){
				var value = parseInt($(this).val());
				var parameters = {
					timezoneOffset: {
						"2013": {
							"offsetDST": 0, "offset": value * 60, "startDST": 0, "endDST": 0
						}
					}
				};
				timeline1.setParameters(parameters);
				Log.warning(timeline1.setTime(Date.now(), false));
			});
		};

		timeline1.onGetData = function(line, beginTime, endTime, granularity)
		{
			Log.info("onGetData");

			var self = this;
			setTimeout(function(){
				var list = getData(beginTime, endTime, granularity, 1, false);
				self.setData(line, list);
			}, 0);
		};


		window.timeline2 = new TimeLine({
			id: "#timeline_2",
			variableName: "timeline2",
			isDebug: isDebug,
			oneLine: true
		});

		timeline2.init();

		timeline2.onLoad = function()
		{
			timeline2.setParameters({
				selection: {fixed: true, sticky: timeline2.SELECTION_STICKY_TO_VIEW},
				scale: {granularity: "hour"}
			});

			$("#setTime2").click(function(){
				var date = new Date();
				timeline2.setTime(date.getTime(), true);
			}).click();

			$("#setSelection2").click(function(){
				timeline2.setSelection(timeline2.time - 0.5 * 3600 * 1000, timeline2.time + 0.5 * 3600 * 1000, true);
			});

			$("#clearSelection2").click(function(){
				timeline2.clearSelection();
			});

			$("#getSelectionParameters2").click(function(){
				Log.info(JSON.stringify(timeline2.getSelectionParameters()));
			});
		};

		timeline2.onGetData = function(line, beginTime, endTime, granularity)
		{
			Log.info("onGetData");

			var list = getData(beginTime, endTime, granularity, 1, true);
			this.setData(line, list);
		};

		window.timeline3 = new TimeLine({
			id: "#timeline_3",
			variableName: "timeline3",
			isDebug: isDebug,
			withImages: true
		});

		timeline3.init();

		timeline3.onLoad = function()
		{
			timeline3.setParameters({
				selection: {fixed: false},
				scale: {granularity: "min"}
			});

			$("#setTime3").click(function(){
				var date = new Date();
				timeline3.setTime(date.getTime(), true);
			}).click();

			$("#getTime3").click(function(){
				var time = timeline3.getTime();
				var date = new Date(time);
				var timeStr = "time " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();
				Log.warning(timeStr);
			});

			$("#setSelection3").click(function(){
				timeline3.setSelection(timeline3.time - 300000, timeline3.time + 600000, true);
			});

			$("#clearSelection3").click(function(){
				timeline3.clearSelection();
			});

			$("#clearImages3").click(function(){
				timeline3.clearImages();
			});

			$("#getSelectionParameters3").click(function(){
				Log.info(JSON.stringify(timeline3.getSelectionParameters()));
			});

			$("#setScale3").click(function(){
				timeline3.setParameters({scale: {granularity: "hour"}});
			});

			$("#nextImagesPage3").click(function(){
				Log.warning(timeline3.nextImagesPage());
			});

			$("#prevImagesPage3").click(function(){
				Log.warning(timeline3.prevImagesPage());
			});
		};

		timeline3.onGetData = function(line, beginTime, endTime, granularity)
		{
			Log.info("onGetData");

			var list = getData(beginTime, endTime, granularity, 1, false);
			this.setData(line, list);
		};

		timeline3.onGetImages = function(line, beginTime, endTime)
		{
			Log.info("onGetImages");

			var getArchiveSearchList = function(obj, beginTime, endTime)
			{
				var timestampList = [];

				// midnight of current day
				var startPoint = (new Date()).setUTCHours(0, 0, 0, 0);
				var granularity = 15 * 1000;

				// Find first timestamp less than beginTime taking granularity into account
				var temp = Math.round(Math.abs(startPoint - beginTime) / granularity);
				var currTime = startPoint > beginTime ? startPoint - (temp + 1) * granularity : startPoint + temp * granularity;

				var now = (new Date()).getTime();
				var i = 0;

				while (currTime < endTime && currTime < now) {

					var timestamp = currTime + Math.round(granularity) / 2;

					timestampList.push({
						Fn: i++, // fragment number
						Tn: 0, // timestamp number in fragment
						timestamp: timestamp, // Unix time in ms
						start_time: currTime, // start time of fragment, Unix time in ms
						end_time: currTime + granularity, // end time of fragment, Unix time in ms
						url: "/storage/snapshot?objid=" + obj + "&ts=" + Math.round(timestamp / 1000) + "&downscale"
					});

					currTime += granularity;
				}

				return timestampList;
			};

			var getMotionSearchList = function(obj, beginTime, endTime, callback)
			{
				$.ajax({
					url: "/storage/motionsearch",
					dataType: "json",
					async: true,
					data: {
						objid: obj,
						start_time: Math.round(beginTime / 1000),
						end_time: Math.round(endTime / 1000),
						gridwidth: 6,
						gridheight: 5,
						gridmap: "FFFFFFFF",
						objsize: 5,
						pre_motion: 10,
						post_motion: 10,
						granularity: 15
					},
					cache: false,
					success: function(json)
					{
						if (json.error !== "")
						{
							Log.error(json.error);
						} else {
							// example
							// var json = $.parseJSON('{"debug":{"time":55.8250},"error":"","obj":{"107":{"fragment":[{"end_time":1295971802,"start_time":1295971759,"timestamp":[1295971779, 1295971780]}]}}}');
							var fragment = json.obj[obj].fragment;

							var timestampList = [];

							for (var i = 0; i < fragment.length; i++)
							{
								var fragmentTimestampList = fragment[i].timestamp;
								var start_time = fragment[i].start_time * 1000;
								var end_time = fragment[i].end_time * 1000;

								for (var j = 0; j < fragmentTimestampList.length; j++)
								{
									var timestamp = fragmentTimestampList[j];

									timestampList.push({
										Fn: i, // fragment number
										Tn: j, // timestamp number in fragment
										timestamp: timestamp * 1000, // Unix time in ms
										start_time: start_time, // start time of fragment, Unix time in ms
										end_time: end_time, // end time of fragment, Unix time in ms
										url: "/storage/snapshot?objid=" + obj + "&ts=" + timestamp + "&downscale"
									});
								}
							}

							Log.debug(JSON.stringify(timestampList));

							callback(timestampList);
						}
					}
				});
			};

			var self = this;
			getMotionSearchList(obj, beginTime, endTime, function(timestampList){
				self.setImages(line, timestampList);
			});

			//this.setImages(line, getArchiveSearchList(obj, beginTime, endTime));
		};


		timeline1.onTimeChange = timeline2.onTimeChange = timeline3.onTimeChange = function(time)
		{
			Log.info("onTimeChange");
			this.time = time;
		};

		timeline1.onSelectionChange = timeline2.onSelectionChange = timeline3.onSelectionChange = function(line, beginTime, endTime)
		{
			var wasCleared = (beginTime == null || endTime == null);
			if (wasCleared)
			{
				Log.error(line + " selection is empty");
				return;
			}

			var date = new Date();

			date.setTime(beginTime);
			var beginTimeStr = "beginTime " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();

			date.setTime(endTime);
			var endTimeStr = "endTime " + date.getFullYear() + "/" + (date.getMonth() + 1) + "/" + date.getDate() + " - " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getUTCMilliseconds();

			Log.warning(line + " " + beginTimeStr + " " + endTimeStr);
		};

		var getData = function(beginTime, endTime, granularity, multiplier, log)
		{
			log = !!log;
			var date = new Date();
			date.setTime(beginTime);

			var step = null;
			switch (granularity)
			{
				case 'year':
				break;
				case 'mon':
				break;
				case 'day':
					step = 24 * 3600;
					date.setUTCHours(0, 0, 0, 0);
				break;
				case 'hour':
					step = 3600;
					date.setUTCMinutes(0, 0, 0);
				break;
				case 'min':
					step = 60;
					date.setUTCSeconds(0, 0);
				break;
				case 'second':
					step = 1;
					date.setUTCSeconds(0, 0);
				break;
			}

			var list = [];

			if (step)
			{
				/*var now = (new Date().getTime());
				if (endTime > now)
					endTime = now;*/

				var getRow = function(step, color, borderColor)
				{
					var row = {list: {}, color: color, borderColor: borderColor, granularity: "chunk"};
					for (var timeStamp = date.getTime(); timeStamp < endTime; timeStamp += step * 1000)
					{
						if (Math.round(Math.random()))
							continue;

						if (timeStamp % (1000 * step * Math.ceil(multiplier)) !== 0)
							continue;

						// value should be >= 1
						var percentage = 0;
						if (log)
						{
							var value = Math.round(Math.random() * 1000) + 1; if (value > 1000) value = 1000;
							var log10x = Math.log(value) * Math.LOG10E;
							// we think that value <= 1000
							percentage = log10x * (100 / 3);
						} else {
							percentage = Math.round(Math.random() * 100);
						}

						row.list[timeStamp] = {
							percentage: percentage,
							url: "/storage/snapshot?objid=103&ts=" + Math.round((timeStamp / 1000)) + "&downscale",
							color: 0x83382f,
							borderColor: 0xcd2813
						};
					}

					return row;
				};

				list.push(getRow(step, 0x83382f, 0xcd2813));
				//list.push(getRow(step, 0x150475, 0x3E28B8));
			}

			return list;
		};
	});

});
