#!/usr/bin/perl
# support.cgi - create/download/display support files

use strict;
use CGI qw/escape unescape/;
#------------------------------------------------------------------------------
# Get parameters from request
my $request_method = $ENV{REQUEST_METHOD};

my $form_info='';
if ($ENV{REQUEST_METHOD} eq "GET") {
      $form_info = $ENV{QUERY_STRING};
} else {
      my $size_of_form_information = $ENV{CONTENT_LENGTH};
      read (STDIN, $form_info, $size_of_form_information);
}

my %args;
foreach(split /&/,$form_info){ $args{uc($1)} = unescape($2) if(/(\S+)=(\S+)/) }

#------------------------------------------------------------------------------
# Headers
my $ZipHeader = <<ZIP;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Content-Type: application/x-skmsupportfile;

ZIP

my $XMLHeader = <<XML;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Pragma: no-cache
Content-Type: text/xml

<?xml version="1.0"?>
XML

my $HTMLHeader = <<HTML;
CacheControl: no-store, no-cache, must-revalidate
Expires: Mon, 26 Jul 1997 05:00:00 GMT
Content-type: text/html

HTML

#------------------------------------------------------------------------------
# Global vars
my $APL = $ENV{APL} || '/opt/sarch';
my $action = $args{ACTION};
my $SupportDir = "$APL/var/sf/support";
my $SFListTable;
my $HasPendingSF = 0;

#------------------------------------------------------------------------------
# Main
for($action) {
    /create/      && do { create();      next };
    /cancel/	  && do { cancel();       next };
    /download/    && do { download();    next };
    /supportpage/ && do { supportpage(); next };
    do { supportpage() };
}

#------------------------------------------------------------------------------
# Error handling
sub error_html {
    my $err_msg = shift;
    print $HTMLHeader;
    print " <!DOCTYPE html><html><head><title>Operation failed</title>
	    <META http-equiv='Content-Style-Type' content='text/css'>
	    <link rel='stylesheet' href='/common/css/style.css' type='text/css'>
	    <\head><body>$err_msg</body></html>
	  ";
    exit;
}

sub error_xml {
    my $err_msg = shift;
    print $XMLHeader;
    print "<RETURN STATUS='ERROR' MESSAGE='$err_msg'></RETURN>\n\n";
    exit;
}

#------------------------------------------------------------------------------
# Actions
sub create {
    my $mode = $args{MODE} || 'user';
    system("sudo -u apl $APL/conf/bin/sf_collect -m $mode 1>/dev/null 2>/dev/null &");
    error_xml('Failed to start collecting!') if $? != 0; 
    print $XMLHeader;
    print "<RETURN STATUS='OK'></RETURN>\n\n";
}

sub cancel {
    system("sudo -u apl $APL/conf/bin/sf_collect -T 1>/dev/null 2>/dev/null");
    error_xml("Failed to cancel operation!") if $? != 0;
    print $XMLHeader;
    print "<RETURN STATUS='OK'></RETURN>\n\n";
}

sub download {
    my $ts = $args{TS};
    my $zip_file;
    eval {
	opendir(DH, $SupportDir) || die "Failed to open directory $SupportDir: $!";
	my @files = grep {/$ts[au]i?\.support$/} readdir(DH);
	if(@files) {
	    $zip_file = $files[0];
	}
        else {
	    die "No matching files found!";
	}
	
        open(F, "$SupportDir/$zip_file") or die "Failed to read support file!";
	print $ZipHeader;
        while($_=<F>) { print $_ }
        close F;
    };
    error_html($@) if $@;
}

sub supportpage {
    my $JSCode = <<JSCODE;
<script>

function refreshPage() {
    window.location.href = './support.cgi?action=supportpage';
}

function createRequestObject()
{
	var result = false;
	var actions = [
		function() {return new XMLHttpRequest()},
		function() {return new ActiveXObject('Msxml2.XMLHTTP')},
		function() {return new ActiveXObject('Microsoft.XMLHTTP')}
	];
	for(var i = 0; i < actions.length; i++) 
	{
		try
		{
			result = actions[i]();
			break;
		} catch (e) {}
	}
	return result;
}

function doAction(action) {
	if (action == null)
	{
		return;
	}
    var request = createRequestObject();
    if(request  == null)  { 
	alert("Failed to create request object!");
	return;
    }
    var requestString = "./support.cgi?action=" + action;
    request.open('GET', requestString, false);
    request.send(null);
    
    var response = request.responseText;
    var dom = str2xmldom(response);
    if(dom != null) {
	var status = dom.getAttribute('STATUS');
	if(status != 'OK') {
	    var err_msg = dom.getAttribute('MESSAGE');
	    if(err_msg != null) { alert(err_msg); }
	}
	
	setTimeout("refreshPage()", 2000);
    }
}

function str2xmldom(strXml){
	var doc;
	    try {
		if (window.ActiveXObject) {
            	    doc = new ActiveXObject('Microsoft.XMLDOM');
		    doc.async = 'false';
		    doc.loadXML(strXml);
		}
		else {
		        var parser = new DOMParser();
			doc = parser.parseFromString(strXml, 'text/xml');
		}
	}
	catch(e) {}
	return (doc ? (doc.documentElement ? doc.documentElement : null) : null);
}
</script>											    
JSCODE

    sf_list();
    
    my $Buttons  = "";
    unless($HasPendingSF) {
	$Buttons = <<BTNCREATE;
<input type="submit" value="Create new support file" name="BCREATE" class="btn_wide200"  onClick="doAction('create')" onMouseOver="this.className='btn_wide200_over'" onMouseOut="this.className='btn_wide200'" >
BTNCREATE
    }
    else {
	$Buttons = <<BTNREFRESH;
<input type="submit" value="Refresh page" name="BREFRESH" class="btn_wide150"  onClick="refreshPage()" onMouseOver="this.className='btn_wide150_over'" onMouseOut="this.className='btn_wide150'" >
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<input type="submit" value="Cancel operation" name="BCANCEL" class="btn_wide150"  onClick="doAction('cancel')" onMouseOver="this.className='btn_wide150_over'" onMouseOut="this.className='btn_wide150'" >
BTNREFRESH
    } #endif

    print $HTMLHeader;
    print <<SUPPORTPAGE;
<!DOCTYPE html>
<html>
<head>
<title>SKM Support</title>
<META http-equiv="Content-Style-Type" content="text/css">
<link rel="stylesheet" href="/common/css/style.css" type="text/css">
</HEAD>
<style>
p { text-align:justify}
</style>
<body>

$JSCode

<table cellspacing="0" cellpadding="0" border="0" class="border_table">
<tr>
<td class="border_top_left"></td>
<td class="border_top"></td>
<td class="border_top"></td>
<td class="border_top_right"></td>
</tr>
<tr> 
<td class="border_left"></td>
<td align="center" width="50%">
<h2 align="center">SKM Server Technical Support</h2>
<blockquote>
<p>&nbsp;&nbsp;&nbsp;&nbsp;If you experience technical difficulties using your SKM product, videoNEXT is happy to assist you and your organization resolve it. videoNEXT offers several support packages depending what suite of SKM you orginally purchased. The software package purchased determines the technical support for which you are eligible.
</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;
If your software package does not include technical support you may purchase support on an hourly basis of 150.00 USD per hour with a one hour minimum. If your system does not have a current software support package, we will ask for a valid credit card number or purchase order number prior to support of your system.
</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;In the event of technical difficulties please follow these procedures:
</p>
<ul style="text-align:left; ">
<li>Verify the problem you experience was not caused by network connectivity issues or a PC problem. Reboot your computer and try again if you are in doubt. </li>
<li>Determine whether there have been any recent software or operating system updates installed on your PC that may account for the problem you experience. Automatic Microsoft Windows updates are one of these sources. </li>
<li>Create a record of the events leading to the problem. If you experience an issue which you believe is due to SKM software, please make note of the approximate date, time and short description of the problem experienced. </li>
<li>If the issue repeats itself or is not associated to your client PC, please contact the videoNEXT support line to have it addressed.  Have the record of events available when you make the call. </li>
</ul>
<p>&nbsp;&nbsp;&nbsp;&nbsp;Support information is available at 
 <br><a href="http://www.videonext.com/index.php?page=product-support" target="_blank">http://www.videonext.com/index.php?page=product-support</a> 
</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;Phone support is available at 1-866-723-3077 (+1-703-657-1200 for international calls), option 2 for technical support, option 1 for customer service. Please let the technical support center know the following information when calling or emailing:
</p>
<ul style="text-align:left; ">
<li>your name, title and organization name</li>
<li>physical address of problem</li>
<li>email and phone information</li>
<li>software version</li>
<li>hardware configuration</li>
<li>records of events</li>
<li>primary issue</li>
<li>level of urgency (immediate, next business day, etc.)</li>
</ul>

<p>&nbsp;&nbsp;&nbsp;&nbsp;Before you call, please click the  "Get Support File" button below to create and download a file containing vital information about your system configuration and functioning. Send this file along with your record of events by email to <a href="mailto:support\@videonext.com">support\@videonext.com</a>. It is important to gather this information soon after your problem(s) occurred, so important system information will not be lost.
</p>
</blockquote>
</td>
<td align="center" valign="top">
<h2 align="center">Available support files</h2>
$SFListTable
<br><br><br>
$Buttons
</td>
<td class="border_right"></td>
</tr>
<tr>
<td class="border_bottom_left"></td>
<td class="border_bottom"></td>
<td class="border_bottom"></td>
<td class="border_bottom_right"></td>
</tr>
</table>					
</body>
</html>
SUPPORTPAGE
}

#------------------------------------------------------------------------------
# Additional routines

sub parse_status {
    my $ext = shift;
    my $status;
    for($ext) {
	/support/     && do { return 'OK'         };
	/FAIL/        && do { return 'fail'       };
	/NOSPACE/     && do { return 'nospace'    };
	/INPR/        && do { $HasPendingSF = 1; 
			      return 'inprogress' };
	/TERM/	      && do { return 'cancelled'  };
    }
}

sub sf_list {
    my $i = 0;
    my @sflist;
    
    # List support files from disk
    opendir(DH, $SupportDir);
    while(my $f = readdir(DH)) {
	chomp;
	@{$sflist[$i++]}{'timestamp', 'year', 'month', 'day', 'hour', 'min', 'mode', 'status', 'file'} = 
	    ($1, $2, $3, $4, $5, $6, $7 eq 'a'?'auto':'user', parse_status($8), $f) 
	    if $f =~ /((\d{4})(\d{2})(\d{2})_(\d{2})(\d{2}))([au])i?\.(.+)$/;
    }
    close(DH);
    
    # Display message if empty list
    unless(@sflist) {
	$SFListTable = '<br><br>No valid support files found';
	return;
    }
    
    my $header = "<table cellspacing='0' cellpadding='0' border='0' width='100%'>
			<tr>
				<td class='headertable'>Date</td>
				<td class='headertable'>UTC</td>
				<td class='headertable'>auto/user</td>
				<td class='headertable'>link</td>
			</tr>";
    my $footer = '</table>';
    
    # Put into HTML table
    $SFListTable .= "$header\n";
    my $separator = "<tr><td colspan='5' height='10'></td></tr><tr height='1px'><td class='blackaligncenter' 
		     colspan='5' align='center'></td></tr><tr><td colspan='5' height='10'></td></tr>\n";
    my $prev_el;
    foreach my $el (sort { $a->{mode} cmp $b->{mode} || $a->{timestamp} cmp $b->{timestamp} } @sflist) {
	if($prev_el && $prev_el->{mode} ne $el->{mode}) {
	    $SFListTable .= $separator;
	}
	$SFListTable .=  "<tr>\n";
	$SFListTable .= "<td>$el->{year}/$el->{month}/$el->{day}</td>\n";
	$SFListTable .= "<td>$el->{hour}:$el->{min}</td>\n";
	$SFListTable .= "<td>$el->{mode}</td>\n";
	if($el->{status} eq 'OK') {
	    $SFListTable .= 
	    "<td><a href='support.cgi/$el->{file}?action=download&amp;ts=$el->{timestamp}'><U><b><i>download</i></b></U></a></td>\n";
	}
	else {
	    $SFListTable .= "<td>$el->{status}</td>";
	}
	$SFListTable .= "</tr>\n";
	
	$prev_el = $el;
    }
    $SFListTable .= "$footer\n";
}
