/*
# $Id: backup_script.js 11677 2008-08-05 15:27:55Z starostin $
#------------------------------------------------------------------------------
# Backup editor
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
	$(document).ready(
		function()
		{
			init();
			addEvents();
		}
	);

	function init()
	{
		fillSFList();
	}

	function initafterrestore()
	{
		fillSFList();
	}

	function parseStatus(status)
	{
		switch(status) {
		    case "mspt"    : return "OK";
		    case "FAIL"    : return __("error");
		    case "NOSPACE" : return __("nospace");
		    case "INPR"    : return __("in progress");
		    case "TERM"    : return __("cancelled");
		    default        : return __("unknown");
		}
	}

	function fillSFList()
	{
		$("#sf_list tbody").empty();
		$.ajax({
			url: "call.php",
			cache: false,
			data: { 'function' : 'getSFList'},
			dataType: "json",
			beforeSend: function()
			{
				$("#sf_list").mask();
			},
			complete: function()
			{
				$("#sf_list").unmask();
			},
			success: function(data)
			{
				var hasPending = false;
				if (data == "")
				{
					// list is empty
				} else {
					var list = eval(data);
					var tbody = $("#sf_list tbody");

					for (var i=0; i<list.length; i++) {
					    if (list[i].status == 'INPR') hasPending = true;
					    var status = parseStatus(list[i].status);
					    var link = status == "OK" ?
							"<a href='" + list[i].link  +
							"'><U><b><i>"+__("download")+"</i></b></U></a>"
							: status;
					    var tr = "<tr>";
					    tr += "<td>"+list[i].date+"</td>";
					    tr += "<td>"+list[i].time+"</td>";
					    tr += "<td>"+list[i].caller+"</td>";
					    tr += "<td>"+link+"</td>";


						if (status == "OK"){
							tr += "<td> <input type='button' value='Delete' onclick='delete_sf(" +'"'+list[i].sf+'"'+")'></td>";
						}else{
							tr += "<td></td>";
						}

					    tr += "</tr>";
					    tbody.append(tr);
					}
				}

				if (hasPending) {
					$("#create").hide();
					$("#refresh").show();
					$("#cancel").show();
				}
				else {
					$("#create").show();
					$("#refresh").hide();
					$("#cancel").hide();
				}
			}
		});
	}

	function addEvents()
	{
		$("#create").click(
			function()
			{
				$.ajax({
					url: "call.php",
					cache: false,
					data: { 'function' : "create" },
					dataType: "json",
					beforeSend: function()
					{
						$("#sf_list").mask();
					},
					complete: function()
					{
						$("#sf_list").unmask();
					},
					success: function(data)
					{
						$("#sf_list").unmask();
						var list = eval(data);
						if (list[0]["error"] != "")
						{
							alert(__("Support file was not created") + "\n" + list[0]["error"]);
						} else {
							Log.warning(__("Request to create new support file was accepted"));
							window.setTimeout("init()", 1000);
						}
					}
				});
			}
		);

		$("#refresh").click(
			function()
			{
				fillSFList();
			}
		);

		$("#cancel").click(
			function()
			{
				$.ajax({
					url: "call.php",
					dataType: "json",
					async: true,
					cache: false,
					data: { 'function' : "cancel" },
					success: function(data)
					{
						var list = eval(data);
						if (list[0]["error"] != "")
						{
							alert(__("Call failed") + "\n" + list[0]["error"]);
						} else {
							Log.warning(__("Request to cancel collecting was accepted"));
							window.setTimeout("init()", 2000);
						}
					}
				});
			}
		);
	}

	function delete_sf(sf_name)
	{
		var confirm_str = __("Do you realy want to delete support file?");
		if (confirm(confirm_str)){
			$.ajax({
				url: "call.php",
				dataType: "json",
				async: true,
				cache: false,
				data: { 'function' : "delete", 'sf_file_name': sf_name},
				success: function(data)
				{
					var list = eval(data);
					if (list[0]["error"] != "")
					{
						alert(__("Call failed") + "\n" + list[0]["error"]);
					} else {
						init();
					}
				}
			});
		}
	}
