<?php
/*
# $Id: functions.php 11677 2008-08-05 15:27:55Z starostin $
#------------------------------------------------------------------------------
# Backup manager
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

//if the user leaves the page or closes the browser prematurely, this will help prevent half completed statements
ignore_user_abort();

$master_sf_dir = $_SERVER['APL'] ."/var/sf/master";
$sf_dir = $_SERVER['APL'] ."/var/sf";
$temp_dir = $_SERVER['APL'] ."/var/sf/tmp";

function getSFList()
{
	$list = array();

	global $master_sf_dir;
	$dir = $master_sf_dir;

	$pidfile = "/var/sarch/pids/master_sf_collect.pid";

	function sf_cmp($a, $b)
	{
	    return strcmp($a["cmpdate"]."_".$a["time"],$b["cmpdate"]."_".$b["time"]);
	}

	clearstatcache();

	if (is_dir($dir))
	{
		$files = scandir($dir);
		if (is_array($files))
		{
			$dateFormat = Template::convertStrDateFormatToPHPDateFormat(Identity::getAttribute("NLS_LONG_DATE_FORMAT"));
			foreach($files as $file)
			{
				if (preg_match("/(\d{4})(\d{2})(\d{2})_(\d{2})(\d{2})\.(.+)$/", $file, $regs))
				{
					// check for hanged collector process
					$status = $regs[6];
					if ($status == "INPR" && is_file($pidfile)) {
					    $contents = file_get_contents($pidfile);
					    $lines = preg_split("/\n/", $contents);
					    $pid = $lines[0];
					    $check = shell_exec(escapeshellcmd("ps -p $pid -o pid="));
					    if (! $check) {
						$status = "TERM";
						cancel();
					    }
					}
					$element = array();
					$element["sf"] = $file;
					$element["date"] = date($dateFormat, mktime(0, 0, 0, $regs[2], $regs[3], $regs[1]));
					$element["cmpdate"] = date("Ymd", mktime(0, 0, 0, $regs[2], $regs[3], $regs[1]));
					$element["time"] = "$regs[4]:$regs[5]";
					$element["caller"] = "user";
					$element["status"] = $status;
					$element["link"] = "downloadsf.php?ts=$regs[1]$regs[2]$regs[3]_$regs[4]$regs[5]";

					array_push($list, $element);
				}
			}
		}
	}

	usort($list, "sf_cmp");
	return $list;
}

function create()
{
	$list = array();

	global $backup_dir;
	$error = "";
	$master_backup_pid = "$backup_dir/master_backup.pid";

	clearstatcache();
	$command = "APL=" . $_SERVER["APL"] . " APL_VAR=" . $_SERVER["APL_VAR"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] .
	" VERSIONER_PERL_VERSION=" . $_SERVER["VERSIONER_PERL_VERSION"] .
	" sudo -u " . "apl" . " " . $_SERVER['APL'] . "/conf/bin/master_sf_collect >/dev/null 2>&1 &";
	$result = system(escapeshellcmd($command), $return_var);
	if ($return_var != 0)
	{
		$error = sprintf(__("Return value: %s"), $return_var);
	}

	$element = array();
	$element["error"] = $error;
	array_push($list, $element);

	return $list;
}

function delete($sf_file_name)
{
	global $master_sf_dir;
	
	$sf_file = "$master_sf_dir/$sf_file_name";
	$list = array();
	$error = "";
	if ($sf_file_name != "")
	{
		if (is_file($sf_file))
		{
			$result = system("rm $sf_file", $return_var);
			if ($return_var != 0)
			{
				$error = sprintf(__("Return value: %s"), $return_var);
			}
		}
	} else {
		$error = __("File does not exists");
	}

	$element = array();
	$element["error"] = $error;
	array_push($list, $element);

	return $list;	
}

function cancel()
{
	$list = array();
	$error = "";

        clearstatcache();
	$command = "APL=" . $_SERVER["APL"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] .
	" VERSIONER_PERL_VERSION=" . $_SERVER["VERSIONER_PERL_VERSION"] .
	" sudo -u " . "apl" . " " . $_SERVER['APL'] . "/conf/bin/master_sf_collect -T &>/dev/null &";
	$result = system(escapeshellcmd($command), $return_var);
	if ($return_var != 0)
	{
		$error = sprintf(__("Return value: %s"), $return_var);
	}

	$element = array();
	$element["error"] = $error;
	array_push($list, $element);

	return $list;
}

?>
