<?php
/*
# $Id: downloadsf.php 17422 2009-12-25 15:42:38Z tsibulskiy $
#------------------------------------------------------------------------------
# Return file to user
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by: Alexey Tsibulnik
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

include("functions.php");

if (isset($_GET['ts']))
{
	global $master_sf_dir, $temp_dir;
	$ts = $_GET['ts'];
	$found = false;

	if (!is_dir($master_sf_dir))
	{
		header('HTTP/1.0 404 Not Found');
		echo __("Support file was not found\n");
		exit;
	}
	else
	{
		// Find support file by its timestamp
		$files = scandir($master_sf_dir);
		if (is_array($files))
		{
			sort($files);
			foreach($files as $file)
			{
				if (preg_match("/(\d{8}_\d{4})\.(.+)$/", $file, $regs))
				{
					if ($regs[1] == $ts) {
					    $found = true;
					    $sf_file = "$master_sf_dir/$file";
					    $sf_file_name = $file;
					    break;
					}
				}
			}
		}
	}

	if (!$found || !file_exists($file = $sf_file)) {
		header('HTTP/1.0 404 Not Found');
		echo __("Support file was not found\n");
		exit;
	}


	////////////////////////////////////////////////////////////////////////////////

	set_time_limit(0);
	header('Cache-Control: private');
	header('Content-Type: application/x-force-download; name="'.$sf_file_name.'"');
	header('Content-Disposition: attachment; filename="'.$sf_file_name.'"');
	header('Content-Transfer-Encoding: binary');
	header('Accept-Ranges: bytes');

	////////////////////////////////////////////////////////////////////////////////
	$range = 0;
	if (isset($_SERVER['HTTP_RANGE']) && ($range = $_SERVER['HTTP_RANGE']))
	{
		$range = str_replace('bytes=', '', $range);
		$range = intval(str_replace('-', '', $range), 10);
		$size  = filesize($file);

		header('HTTP/1.0 206 Partial Content');
		header('Content-Length: '.($size - $range));
		header('Content-Range: bytes '.$range.'-'.($size - 1).'/'.$size);
	} else {
		header('HTTP/1.0 200 OK');
		header('Content-Length: '.filesize($file));
	}

	////////////////////////////////////////////////////////////////////////////////

	$file = fopen($file, 'rb');
	if ($file) {
	fseek($file, (int)$range);

	while (!feof($file) and !connection_status()){
		echo fread($file, (1024 * 8));
		flush();
		ob_flush();
	}
	}
	else {
	    error_log("Failed to read support file!");
	}
}
?>
