/*
# $Id: storagepolicy_script.js 27754 2013-01-24 13:00:03Z astarostin $
#------------------------------------------------------------------------------
# Storage policy
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

	$(document).ready(
		function()
		{
			init();
			addEvents();
		}
	);

	var is_editing = false;
	var is_adding = false;

// it is need to translation
	var trtxt = __("Camera will store video only if it is \"tagged\" by any Event (Motion Detection, Analytics, associated ACS event, etc..). Motion Detection is not automatically enabled in this mode. You have to specifically enable it in individual cameras");
	var trtxt = __("In this mode, Motion Detection is executed in background even if not specifically enabled in individual camera (events are not generated upon detection). Camera will store video only if motion is detected or if video is \"tagged\" by any Event (Motion Detection, Analytics, associated ACS event, etc..). If you enable Motion Detection on individual cameras, Events will be registered.");
	var trtxt = __("Storage policy with initially defined parameters");
	var trtxt = __("Events only");
	var trtxt = __("Fixed");
	var trtxt = __("Frame");
	var trtxt = __("Motions and Events");
	var trtxt = __("Range");
	var trtxt = __("Space limited");
	var trtxt = __("STD Events only");
	var trtxt = __("STD Motions and Events");
	var trtxt = __("STD Space limited");
// eof it is need to translation

	function init()
	{
		$("#addstoragepolicy").show();
		$("#editstoragepolicy").hide();
		$("#deletestoragepolicy").hide();
		$("#storagepolicy_parameters").hide();

		fillStoragePolicyList();
	}

	function fillStoragePolicyList()
	{

		$.ajax({
			url: "call.php",
			dataType: "json",
			async: true,
			cache: false,
			data: { 'function' : 'getStoragePolicyList', 'trash' : parseInt(new Date().valueOf()) },
			success: function(data)
			{
				if (data.length == 0)
				{
					// list is empty
				} else {
					var list = data;

					var storagepolicyselect = '<select size="6" class="tablestyle">';
					for (var i = 0; i < list.length; i++)
					{
						storagepolicyselect += '<option value="' + list[i]["storagepolicy"] + '">' + __(list[i]["name"]) + '</option>';
					}
					storagepolicyselect += '</selecte>';
					$("#storagepolicylist").empty();
					$(storagepolicyselect).appendTo("#storagepolicylist");

					$("#storagepolicylist select").change(onStoragePolicyListChange);
				}
			}
		});
	}

	function fillStoragePolicyParameters(storagepolicy_id, filter)
	{
		filter = filter || false;
		var data =
			$.ajax({
				url: "call.php",
				dataType: "json",
				async: false,
				cache: false,
				data: { 'function' : 'getStorageParametersList' },
				beforeSend: function()
				{
						$("#waitindicator").show();
						$("#waitindicator").mask();
				},
				complete: function()
				{
						$("#waitindicator").hide();
						$("#waitindicator").unmask();
				}
			} ).responseText;
		if (data.length != 0)
		{
			var list = $.parseJSON(data);

			// create storagepolicy_storagertntype select list
			var storagertntype_list = list['storagertntype'];
			var storagertntype_select = '<select class="singleline">';
			for (var i = 0; i < storagertntype_list.length; i++)
			{
				// temporary condition
				if (storagertntype_list[i]["storagertntype"] > 3 && filter)
					continue;
				storagertntype_select += '<option value="' + storagertntype_list[i]["storagertntype"] + '">' + __(storagertntype_list[i]["name"]) + '</option>';
			}
			storagertntype_select += "</select>";

			// create storagepolicy_frdtype select list
			var storageframedecimationtype_list = list['storageframedecimationtype'];
			var storageframedecimationtype_select = '<select class="singleline">';
			for (var i = 0; i < storageframedecimationtype_list.length; i++)
			{
				storageframedecimationtype_select += '<option value="' + storageframedecimationtype_list[i] + '">' + __(storageframedecimationtype_list[i]) + '</option>';
			}
			storageframedecimationtype_select += "</select>";

			// fill select lists
			$("#storagepolicy_storagertntype").empty();
			$(storagertntype_select).appendTo("#storagepolicy_storagertntype");
			$("#storagepolicy_storagertntype select").change(onStorageRtnTypeChange).trigger("change");

			$("#storagepolicy_frdtype").empty();
			$(storageframedecimationtype_select).appendTo("#storagepolicy_frdtype");
		} else {
			return false;
		}

		// fill parameters with data

		var data = $.ajax( {
			url: "call.php",
			dataType: "json",
			async: false,
			cache: false,
			data: { 'function' : 'getStoragePolicy', 'storagepolicy' : storagepolicy_id },
			beforeSend: function()
			{
				if (is_editing){
					$("#storagepolicy_parameters").mask();
				}else{
					$("#waitindicator").show();
					$("#waitindicator").mask();
				}
			},
			complete: function()
			{
				if (is_editing){
					$("#storagepolicy_parameters").unmask();
				}else{
					$("#waitindicator").hide();
					$("#waitindicator").unmask();
				}
			}
		} ).responseText;
		data.length == 0
		//if (data.length != 0)
		if (data != "" && data != "[]" && String(data) != 'null')
		{
			var list = $.parseJSON(data);

			if (list[0]["protected"] == 't')
			{
				$("#editstoragepolicy").hide();
				$("#deletestoragepolicy").hide();
			} else {
				$("#editstoragepolicy").show();
				$("#deletestoragepolicy").show();
			}


			$("#storagepolicy_name_edit").val(list[0]["name"]);
			$("#storagepolicy_description_edit").val(__(list[0]["description"]));
			$("#storagepolicy_preservedaysmin_edit").val(list[0]["preservedaysmin"]);
			$("#storagepolicy_preservedaysmax_edit").val(list[0]["preservedaysmax"]);
			$("#storagepolicy_frdschedule_edit").val(list[0]["frdschedule"]);

			var storagertntype_selectedIndex = list[0]['storagertntype'];
			var storageframedecimationtype_selectedIndex = list[0]['frdtype'];
			$("#storagepolicy_storagertntype select option[value='" + storagertntype_selectedIndex + "']").prop("selected", true);
			$("#storagepolicy_storagertntype select").trigger("change");
			$("#storagepolicy_frdtype select option[value='" + storageframedecimationtype_selectedIndex + "']").prop("selected", true);
		}

		return true;
	}

	function onStorageRtnTypeChange()
	{
		var storagertntype = $("#storagepolicy_storagertntype select").val();

		switch (String(storagertntype))
		{
			case '1':
				$('#frdtype_row').hide();
				$('#frdschedule_row').hide();
				$('#preservedaysmin_row').show();
				$('#preservedaysmax_row').hide();
			break;
			case '2':
				$('#frdtype_row').hide();
				$('#frdschedule_row').hide();
				$('#preservedaysmin_row').show();
				$('#preservedaysmax_row').show();
			break;
			case '4':
				$('#frdtype_row').show();
				$('#frdschedule_row').show();
				$('#preservedaysmin_row').hide();
				$('#preservedaysmax_row').hide();
			break;
			default:
				$('#frdtype_row').hide();
				$('#frdschedule_row').hide();
				$('#preservedaysmin_row').hide();
				$('#preservedaysmax_row').hide();
		}
	}

	function onStoragePolicyListChange()
	{
		$("#storagepolicy_parameters").hide();
		is_editing = false;
		is_adding = false;
		$("#addstoragepolicy").show();

		$("#editstoragepolicy").hide();
		$("#deletestoragepolicy").hide();

		$("#storagepolicy_name_edit").val("");
		$("#storagepolicy_description_edit").val("");

		var id = $("#storagepolicylist select").val();
/*
		TS deleted when dublication of colling  getStoragePolicy
//			$.get(	"call.php",
//				{ 'function' : 'getStoragePolicy', 'storagepolicy' : id, 'trash' : parseInt(new Date().valueOf()) },
*/

		if ((String(id) != 'undefined') && fillStoragePolicyParameters(id))
		{
			$("#savestoragepolicy").hide();
			$("#cancelstoragepolicy").hide();

			$("#storagepolicy_parameters input:text").each(
				function()
				{
					//this.readOnly = true;
					$(this).hide();
					$(this).next(".lbl_edit").text(__($(this).val()));

				}
			);

			$("#storagepolicy_parameters select").each(
				function()
				{
					this.disabled = true;
				}
			);
			$("#storagepolicy_parameters").slideDown("fast");
		} else {
			init();
		}
	}

	function addEvents()
	{
		//starting setting some animation when the ajax starts and completes
		$("#deletestoragepolicy").click(
			function()
			{
				if(confirm(__("Are you shure you want to delete Storage policy?")))
				{
					var id = $("#storagepolicylist select").val();

                    $.ajax({
                        url: "call.php",
                        dataType: "html",
                        async: true,
                        cache: false,
                        data: { 'function' : 'deleteStoragePolicy', 'storagepolicy' : id },
                        success: function(data)
                        {
							if (data != "")
							{
								alert("Storage policy was not deleted\n" + data);
							} else {
								init();
							}                        }
                    });

				}
			}
		);
		$("#addstoragepolicy").click(
			function()
			{
				$("#addstoragepolicy").hide();
				$("#editstoragepolicy").hide();
				$("#deletestoragepolicy").hide();

				if (fillStoragePolicyParameters(-1, true))
				{
					is_adding = true;
					is_editing = false;

					$("#storagepolicy_name_edit").val("");
					$("#storagepolicy_description_edit").val("");

					$("#savestoragepolicy").show();
					$("#cancelstoragepolicy").show();
					$("#storagepolicy_parameters input:text").each(
						function()
						{
							//$(this).removeAttr("readOnly");
							$(this).show();
							$(this).next(".lbl_edit").text('');
						}
					);
					$("#storagepolicy_parameters select").each(
						function()
						{
							$(this).prop("disabled", false);
						}
					);

					$("#storagepolicy_parameters").slideDown("fast");
				} else {
					init();
				}
			}
		);
		$("#editstoragepolicy").click(
			function()
			{
				is_adding = false;
				is_editing = true;
				$("#editstoragepolicy").hide();

				var id = $("#storagepolicylist select").val();

				if (fillStoragePolicyParameters(id, true))
				{
					$("#savestoragepolicy").show();
					$("#cancelstoragepolicy").show();
					$("#storagepolicy_parameters input:text").each(
						function()
						{
							//$(this).removeAttr("readOnly");
							$(this).show();
							$(this).next(".lbl_edit").text('');
						}
					);
					$("#storagepolicy_parameters select").each(
						function()
						{
							$(this).prop("disabled", false);
						}
					);
					$("#storagepolicy_parameters").slideDown("fast");
				} else {
					init();
				}
			}
		);
		$("#savestoragepolicy").click(
			function()
			{
				var name = $("#storagepolicy_name_edit").val();
				if ($.trim(name) == "")
				{
					alert("Please fill 'Name' field");
					return;
				}

				// temporary commented
				/*
				var frdschedule = $.trim($('input#storagepolicy_frdschedule_edit').val());
				var regexp = new RegExp("^\\d(,\\d)*$");
				if (!regexp.test(frdschedule))
				{
					alert("Frame decimation schedule must be comma separated list of integers.");
					return;
				}					*/

				var description = $("#storagepolicy_description_edit").val();

				var storagertntype = $('#storagepolicy_storagertntype select').val();
				var preservedaysmin = $.trim($('input#storagepolicy_preservedaysmin_edit').val());
				var preservedaysmax = $.trim($('input#storagepolicy_preservedaysmax_edit').val());
				var frdtype = $('#storagepolicy_frdtype select').val();

				switch (String(storagertntype))
				{
					case '1':
						frdtype = "";
						frdschedule = "";
						preservedaysmax = preservedaysmin;
					break;
					case '2':
						frdtype = "";
						frdschedule = "";
					break;
					case '4':
						preservedaysmin = preservedaysmax = 0;
					break;
					default:
						frdtype = "";
						frdschedule = "";
						preservedaysmin = preservedaysmax = 0;
				}

				switch(storagertntype)
				{
					case 1:
					case 2:
						if (preservedaysmin == "") { alert(__("Please fill 'Preserve days min' field")); return; }
						if (preservedaysmax == "") { alert(__("Please fill 'Preserve days max' field")); return; }
						if (preservedaysmin < 0) { alert(__("Field 'Preserve days min' must be greater or equal zero")); return; }
						if (preservedaysmax < 0) { alert(__("Field 'Preserve days max' must be greater or equal zero")); return; }
					break;
					case 4: break;
				};

				if (is_adding)
				{

                    $.ajax({
                        url: "call.php",
                        dataType: "html",
                        async: true,
                        cache: false,
                        data: { 'function' : 'addStoragePolicy', 'name' : name, 'description' : description, 'storagertntype' : storagertntype, 'preservedaysmin' : preservedaysmin, 'preservedaysmax' : preservedaysmax, 'frdtype' : frdtype,  'frdschedule' : frdschedule },
                        success: function(data)
                        {
							if (data != "")
							{
								alert(__("Event policy was not added") + "\n" + data);
							} else {
								init();
							}
                        }
                    });
				}
				if (is_editing)
				{
					var id = $("#storagepolicylist select").val();
                    $.ajax({
                        url: "call.php",
                        dataType: "html",
                        async: true,
                        cache: false,
                        data: { 'function' : 'editStoragePolicy', 'storagepolicy' : id, 'name' : name, 'description' : description, 'storagertntype' : storagertntype, 'preservedaysmin' : preservedaysmin, 'preservedaysmax' : preservedaysmax, 'frdtype' : frdtype,  'frdschedule' : frdschedule },
                        success: function(data)
                        {
							if (data != "")
							{
								alert(__("Event policy was not edited") + "\n" + data);
							} else {
								init();
							}
                        }
                    });
				}
			}
		);
		$("#cancelstoragepolicy").click(
			function()
			{
				init();
			}
		);
	}
