<?php
/*
# $Id: functions.php 24267 2011-10-24 14:31:10Z teetov $
#------------------------------------------------------------------------------
# Storage policy
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by: 
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once($_SERVER['APL'] . '/api/lib/php/db.php');
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

//if the user leaves the page or closes the browser prematurely, this will help prevent half completed statements
ignore_user_abort();


function getStoragePolicyList()
{
	$queryString = sprintf("SELECT storagepolicy, name, description, storagertntype, preservedaysmin, preservedaysmax, frdtype, frdschedule, protected FROM storagepolicy ORDER BY name;");
	$list = executeQuery($queryString);	
	return $list;
}

function getStoragePolicy($storagepolicy)
{
	$queryString = sprintf("SELECT storagepolicy, name, description, storagertntype, preservedaysmin, preservedaysmax, frdtype, frdschedule, protected FROM storagepolicy WHERE storagepolicy = %s;",
							sanitize($storagepolicy));							
	$list = executeQuery($queryString);	
	return $list;
}

function getStorageRtnTypeList()
{
	$queryString = sprintf("SELECT storagertntype, name, description FROM storagertntype ORDER BY name;");
	$list = executeQuery($queryString);	
	return $list;
}

function getStorageFrameDecimationTypeList()
{
	$list = array(	0 => 'FRD2',
					1 => 'FRD4',
					2 => 'FRD5',
					3 => 'FRD7');
	return $list;
}

function addStoragePolicy($name, $description, $storagertntype, $preservedaysmin, $preservedaysmax, $frdtype, $frdschedule)
{
	if (trim($preservedaysmin) == '')
		$preservedaysmin = 0;
	if (trim($preservedaysmax) == '')
		$preservedaysmax = 0;
	if ($preservedaysmin > $preservedaysmax)
	{
		return __("Preservedaysmax must be greater then preservedaysmin");
	}
	
	$name = trim($name);
	if ($name == "")
	{
		return __("Eventpolicy name must be not empty.");
	}
	
	$queryString = sprintf("SELECT storagepolicy FROM storagepolicy WHERE name = %s;",
							sanitize($name));
	$list = executeQuery($queryString);
	if (!empty($list))
	{
		return __("Storage Policy name must be unique");
	}
		
	$queryString = sprintf("INSERT INTO storagepolicy (storagepolicy, name, description, storagertntype, preservedaysmin, preservedaysmax, frdtype, frdschedule, protected) VALUES ((SELECT max(storagepolicy) + 1 FROM storagepolicy), %s, %s, %s, %s, %s, %s, %s, '0');\n",
							sanitize($name),
							sanitize($description),
							sanitize($storagertntype),
							sanitize($preservedaysmin),
							sanitize($preservedaysmax),
							sanitize($frdtype),
							sanitize($frdschedule));

	$error = executeNotSelectQuery($queryString);
	if ($error == "")
	{
		addToAppLog("/sdi/html/storagepolicy/function.php", "add '$name' storage policy");
	}
	return $error;
}

function editStoragePolicy($storagepolicy, $name, $description, $storagertntype, $preservedaysmin, $preservedaysmax, $frdtype, $frdschedule)
{
	$name = trim($name);
	if ($name == "")
	{
		return __("Eventpolicy name must be not empty.");
	}
	
	$queryString = sprintf("SELECT storagepolicy FROM storagepolicy WHERE name = %s AND storagepolicy != %s;",
							sanitize($name), sanitize($storagepolicy));
	$list = executeQuery($queryString);
	if (!empty($list))
	{
		return __("Storage Policy name must be unique");
	}
	
	if (trim($preservedaysmin) == '')
		$preservedaysmin = 0;
	if (trim($preservedaysmax) == '')
		$preservedaysmax = 0;
		
	$queryString = sprintf("UPDATE storagepolicy SET name = %s, description = %s, storagertntype = %s, preservedaysmin = %s, preservedaysmax = %s, frdtype = %s, frdschedule = %s WHERE storagepolicy = %s AND protected = '0';",
							sanitize($name),
							sanitize($description),
							sanitize($storagertntype),
							sanitize($preservedaysmin),
							sanitize($preservedaysmax),
							sanitize($frdtype),
							sanitize($frdschedule),
							sanitize($storagepolicy));
							
	$error = executeNotSelectQuery($queryString);
	if ($error == "")
	{
		addToAppLog("/sdi/html/storagepolicy/function.php", "edit '$name' storage policy");
	}
	return $error;
}

function deleteStoragePolicy($storagepolicy)
{
	$queryString = sprintf("SELECT name FROM storagepolicy WHERE storagepolicy = %s AND protected = '0';",
							sanitize($storagepolicy));	
	$list = executeQuery($queryString);
	$name = "";
	if (isset($list[0]))
		$name = $list[0]["name"];

	$queryString = sprintf("SELECT * FROM _objs, _obj_attr WHERE _objs.obj = _obj_attr.obj AND _objs.deleted<>1 AND _obj_attr.attr = 'STORAGE_POLICY' AND _obj_attr.val = %s;",
							sanitize($storagepolicy));
	$list = executeQuery($queryString);	
	if (isset($list[0]))
	{
		$obj_arr = array();
		foreach($list as $row){
			$obj_arr[] = "[".$row['obj']."] ".$row['name'];
		}
		return sprintf(__('Policy %s was not deleted because it is used by next devices: %s '),$name, implode(", ", $obj_arr));
	}
	
		
	$queryString .= sprintf("DELETE FROM storagepolicy WHERE storagepolicy = %s AND protected = '0';",
							sanitize($storagepolicy));	
							
	$error = executeNotSelectQuery($queryString);
	if ($error == "")
	{
		addToAppLog("/sdi/html/storagepolicy/function.php", "delete '$name' storage policy");
	}
	return $error;
}
?>