<?php
/*
# $Id: call.php 33175 2015-10-19 00:11:28Z astarostin $
#------------------------------------------------------------------------------
# Storage policy
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
include('functions.php');

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header('Content-type: application/json; charset=utf-8');

if (Identity::getAttribute("CHECK_CSRFTOKEN") == "yes"
	&&
	isset($_SERVER["HTTP_X_TOKEN"]) && !SessionManager::checkCSRFToken($_SERVER["HTTP_X_TOKEN"])
)
{
	$response = array();
	$response["error"] = "Forbidden";
	$response["code"] = 403;
	echo json_encode($response);

	exit;
}

if (isset($_POST['function']))
{
	switch ($_POST['function'])
	{
	}
}
if (isset($_GET['function']))
{
	switch ($_GET['function'])
	{
		case 'getStoragePolicyList':
			echo json_encode(getStoragePolicyList());
			exit;
			break;
		case 'getStorageRtnTypeList':
			echo json_encode(getStorageRtnTypeList());
			exit;
			break;
		case 'getStorageFrameDecimationTypeList':
			echo json_encode(getStorageFrameDecimationTypeList());
			exit;
			break;
		case 'getStorageParametersList':
			$list = array();
			$list['storagertntype'] = getStorageRtnTypeList();
			$list['storageframedecimationtype'] = getStorageFrameDecimationTypeList();
			echo json_encode($list);
			exit;
			break;
		case 'getStoragePolicy':
			if (isset($_GET['storagepolicy']))
				echo json_encode(getStoragePolicy($_GET['storagepolicy']));
			exit;
			break;
		case 'addStoragePolicy':
			if(isset($_GET['name']) && isset($_GET['description']) && isset($_GET['storagertntype']) && isset($_GET['preservedaysmin']) && isset($_GET['preservedaysmax']) && isset($_GET['frdtype']) && isset($_GET['frdschedule']))
			{
				echo addStoragePolicy($_GET['name'], $_GET['description'], $_GET['storagertntype'], $_GET['preservedaysmin'], $_GET['preservedaysmax'], $_GET['frdtype'], $_GET['frdschedule']);
			}
			exit;
			break;
		case 'editStoragePolicy':
			if(isset($_GET['storagepolicy']) && isset($_GET['name']) && isset($_GET['description']) && isset($_GET['storagertntype']) && isset($_GET['preservedaysmin']) && isset($_GET['preservedaysmax']) && isset($_GET['frdtype']) && isset($_GET['frdschedule']))
			{
				echo editStoragePolicy($_GET['storagepolicy'], $_GET['name'], $_GET['description'], $_GET['storagertntype'], $_GET['preservedaysmin'], $_GET['preservedaysmax'], $_GET['frdtype'], $_GET['frdschedule']);
			}
			exit;
			break;
		case 'deleteStoragePolicy':
			if(isset($_GET['storagepolicy']))
				echo deleteStoragePolicy($_GET['storagepolicy']);
			exit;
			break;
	}
}
?>
