<?php
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
?>

<html>

<!-- http://charon.dev.videonext.net/smgui/VM.html -->

<head>
<script src="/sdi/lib/js/jquery.js"></script>
<script src="/api/scripts/Gettext.js"></script>
<script src="/api/scripts/i18n.js"></script>
<script src="./js/VM.js"></script>
</head>

<body onload="addEditNodes()">



<br>

<table>
  <tr> <!-- the start of the master row -->


<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
//($_COOKIE['PHPSESSID'])?($sid="&sid=".$_COOKIE['PHPSESSID']):($sid='');

//$userId = $_SESSION[SESSION_USERID];
//$userName =$_SESSION[SESSION_USERNAME];

	$totalsQuery = "select sum(space_total) as sum_space_total, sum(space_used) as sum_space_used, sum(load_write_limit) as sum_load_total, sum (load_write) as sum_load from sm_stat;";
	$list = DB::select($totalsQuery);
	if (count($list) > 0)
	{
		$row = $list[0];
		$space_total = $row["sum_space_total"];
		$space_used = $row["sum_space_used"];
		$load_total = $row["sum_load_total"];
		$load = $row["sum_load"];
	}
	$space_used_per = ($space_used / $space_total) * 100;
	$load_per = ($load / $load_total) * 100;

	$queryHealth = "select sm_ost.ost, count( sm_ost.id) from sm_ost inner join sm_volumes on sm_volumes.id = sm_ost.id group by sm_ost.ost order by sm_ost.ost;";
	$list = DB::select($queryHealth);
	$mapHealth = array();
	$sumHeathMap = 0;
	foreach ($list as $row)
	{
		$mapHealth[strtoupper($row["ost"])]=$row["count"];
		$sumHeathMap+=$row["count"];
	}
?>

    <td colspan="1">
      <img id ='skm_domain_img' src='./images/minus.gif' alt='list' onclick='showhide("domain_nodes","skm_domain_img","./images/minus.gif","./images/plus.gif");'>
      <?php /* i18n: ... */ echo __("STORAGE SYSTEM");?>
    </td>
    <td colspan="1">
    	<table>
    	  <tr>
            <td><?php /* i18n: parameter in STORAGE SYSTEM */ echo __("space");?> <table cellspacing="1" height="20" width="40"><tr><td bgColor="blue" width="<?=$space_used_per?>%"></td><td bgColor="violet"></td></tr></table></td>
            <td><?php /* i18n: parameter in STORAGE SYSTEM */ echo __("load");?> <table cellspacing="1" height="20" width="40"><tr><td bgColor="blue" width="<?=$load_per?>%"></td><td bgColor="violet"></td></tr></table></td>
            <td><?php /* i18n: parameter in STORAGE SYSTEM */ echo __("health");?>
            	<table cellspacing="1" height="20" width="40">
            	   <tr>
<?
			foreach($mapHealth as $opStatus=>$numOccurence)
			{
			 	echo "<td bgColor=\"" . getStatusColor($opStatus) . "\" width=\"" . (($numOccurence/$sumHeathMap)*100) . "\"></td>";
			}
?>
            	   </tr>
            	</table>
            </td>
        </tr>
      </table>
    </td>
    <td/>
  </tr> <!-- the end of the first / master row -->

  <tr id="domain_nodes"> <!-- the  start of the domain nodes -->
    <td/>
    <td colspan="1">
    	<table> <!--domain nodes -->

<?php

	$queryNodes = "select nodeid from sm_nodes;";
	$list = DB::select($queryNodes);
	$sizeNodes = 0;
	foreach ($list as $row)
	{
		$nodeIds[$sizeNodes++]=$row["nodeid"];
	}

	for ($indNodes=0; $indNodes<$sizeNodes; $indNodes++){
		$currentNodeId = $nodeIds[$indNodes];

		//$queryNodeTotals = "select sum(space_total) as sum_space_total, sum(space_used) as sum_space_used, sum(load_write_limit) as sum_load_total, sum (load_write) as sum_load from sm_stat where id in (select id in sm_volumes where nodeid = '${currentNodeId}')";
		$queryNodeTotals = "select sum(space_total) as sum_space_total, sum(space_used) as sum_space_used, sum(load_write_limit) as sum_load_total, sum (load_write) as sum_load from sm_stat inner join sm_volumes on sm_volumes.id = sm_stat.id where sm_volumes.nodeid = ?;";
		$list = DB::select($queryNodeTotals, array($currentNodeId));
		if (count($list) > 0)
		{
			$space_total = $row["sum_space_total"];
			$space_used = $row["sum_space_used"];
			$load_total = $row["sum_load_total"];
			$load = $row["sum_load"];
		}
		$space_used_per = ($space_used / $space_total) * 100;
		$load_per = ($load / $load_total) * 100;

		$queryStatusAgg = "select sm_ost.ost, count(sm_ost.id) from sm_ost inner join sm_volumes on sm_volumes.id = sm_ost.id where sm_volumes.nodeid = ? group by sm_ost.ost order by sm_ost.ost;";
		$list = DB::select($queryStatusAgg, array($currentNodeId));
		$sumStatesAgg = 0;
		$statusAggMap = array();
		foreach ($list as $row)
		{
			$statusAggMap[strtoupper($row["ost"])] = $row["count"];
			$sumStatesAgg += $row["count"];
		}
?>

	      <tr> <!-- the ith row of nodes -->
	      	<td>
	           <img id ='img_node_<?=$currentNodeId?>' src='./images/plus.gif' alt='list' onclick='showhide("vols_node_<?=$currentNodeId?>","img_node_<?=$currentNodeId?>","./images/minus.gif","./images/plus.gif");'>
	            	<?=$currentNodeId?>
	        </td>
	        <td>
	               	<table>
		    	  <tr>
		            <td><?php /* i18n: ... */ echo __("space");?> <table cellspacing="1" height="20" width="40"><tr><td bgColor="blue" width="<?=$space_used_per?>%"></td><td bgColor="violet"></td></tr></table></td>
		            <td><?php /* i18n: ... */ echo __("load");?> <table cellspacing="1" height="20" width="40"><tr><td bgColor="blue" width="<?=$load_per?>%"></td><td bgColor="violet"></td></tr></table></td>
		            <td><?php /* i18n: ... */ echo __("health");?>
		            	<table cellspacing="1" height="20" width="40">
		            		<tr>
<?
		            		foreach($statusAggMap as $opStatus=>$numOccurence)
					     {
						echo "<td bgColor=\"" . getStatusColor($opStatus) . "\" width=\"" . (($numOccurence/$sumStatesAgg)*100) . "\"></td>";
					     }
?>
		            		</tr>
		            	</table>
		            </td>
		            <td>
		            	<img id ="action_add_<?=$currentNodeId?>" src="./images/add.png" alt="add"
		            	 onclick="addClicked(this)" >
		            </td>
		            <td>
		            	<span id="edit_node_<?=$currentNodeId?>" style="display:none;">
		            		<img id="img_edit_node_<?=$currentNodeId?>" src="./images/edit.png" alt="edit" onclick="editUnsuedNode(this)">
		            	</span>
		            </td>
		        </tr>
		      </table>

	        </td>
	      </tr>

	      <tr id="vols_node_<?=$currentNodeId?>" style="display:none;"> <!-- the start of collapsible content of the nth row of nodes -->
	        <td/>
	      	<td>
	      	 <table> <!-- table for volume data -->

<?php
	$qeueryVolumes = "select sm_volumes.id, sm_cst.cst,sm_ost.ost, space_total, space_used, load_write_limit, load_write, sm_volumes.pool from sm_volumes left outer join sm_cst on sm_volumes.id = sm_cst.id left outer join sm_ost on sm_volumes.id = sm_ost.id left outer join sm_stat on sm_volumes.id = sm_stat.id where sm_volumes.nodeid = ?;";
	$list = DB::select($qeueryVolumes, array($currentNodeId));
	foreach ($list as $row)
	{
		$space_total = $row["space_total"];
		$space_used = $row["space_used"];
		$load_total = $row["load_write_limit"];
		$load = $row["load_write"];

		$space_used_per = ($space_used / $space_total) * 100;
		$load_per = ($load / $load_total) * 100;

		$volumeNameFull = $row["id"];
		$volumeName = $row["id"];
		$volumeName = substr($volumeName,0,3) . " - " . substr($volumeName,strlen($volumeName)-3,3);
		$cst = strtoupper($row["cst"]); //static state OFFLINE/ONLINE
		$ost = strtoupper($row["ost"]); //operational status  OFFLINE,ONLINE,DEGRADED,BROKEN
		$statusColor = getStatusColor($ost);
		$stateColor = getStateColor($cst);
		$statusText = getStatusText($ost);
		$actionHtml = getStateChangeAction($cst,$volumeNameFull);

		$pool = $row["pool"];

		if (strcasecmp($pool,"unused") != 0)
		{
?>
		    	  <tr>
		    	    <td><?php /* i18n: ... */ echo __("Volume");?> <?=$volumeName?> </td>
		            <td><?php /* i18n: ... */ echo __("space");?> <table cellspacing="1" height="20" width="40"><tr><td bgColor="blue" width="<?=$space_used_per?>%"></td><td bgColor="violet"></td></tr></table></td>
		            <td><?php /* i18n: ... */ echo __("load");?> <table cellspacing="1" height="20" width="40"><tr><td bgColor="blue" width="<?=$load_per?>%"></td><td bgColor="violet"></td></tr></table></td>
		            <td><?php /* i18n: ... */ echo __("status");?> <table cellspacing="1" height="20" width="20"><tr><td bgColor="<?=$statusColor?>"> <?=$statusText?> </td></tr></table></td>
		            <td><?php /* i18n: ... */ echo __("state");?><table cellspacing="1" height="20" width="20"><tr><td bgColor="<?=$stateColor?>"></td></tr></table></td>
		            <td><table><tr><td><?=$actionHtml?></td></tr></table></td>
		        </tr>

<?php
		}
		else //if unused
		{
		//add the edit to the container node too
?>
		<script>
			recordEditNode("edit_node_<?=$currentNodeId?>");
		</script>
		    	  <tr>
		    	    <td><?php /* i18n: ... */ echo __("Unused");?> <?=$volumeName?> </td>
		            <td><table cellspacing="1" height="20" width="40"><tr><td bgColor="gray"></td></tr></table></td>
		            <td colspan="3">
		            	<table cellspacing="2">
		            	  <tr>
			            <td>
			            	<img id="assign_unsused_<?=$volumeNameFull?>" src="./images/assign.png" alt="assign" onclick="assignUnsued(this)">
			            </td>
			            <td>
			            	<img id="edit_unsused_<?=$volumeNameFull?>" src="./images/edit.png" alt="edit" onclick="editUnsued(this)">
			            </td>
			            <td>
			            	<img id="remove_unsused_<?=$volumeNameFull?>" src="./images/trash.png" alt="remove" onclick="removeUnsued(this)">
			            </td>
			          </tr>
			        </table>
			    </td>
		        </tr>
<?
		}
	}


?>

		  </table> <!-- table for volume data -->
	        </td>
	      </tr>  <!-- the end of the  collapsible content of the nth row of nodes -->

<?php

		//echo ("<tr><td> $nodeIds[$indNodes] </td> <td>abebaw</td> </tr>");

	} //end of for ($indNodes=0; $indNodes<$sizeNodes; $indNodes++){
?>


        </table> <!--domain nodes -->
  </tr> <!-- the end of the domain nodes -->
</table>


</body>

</html>

<?php
//a utitilty function to return colors corresponding to statuses
function getStatusColor($status){
	$statusColor = "black";
	switch($status){
		case "OFFLINE" :
			$statusColor = "black";
			break;
		case "COFOUND" :
		case "ALIEN" :
		case "UNMARKED" :
		case "BROKEN" :
			$statusColor = "red";
			break;
		case "DEGRADED" :
			$statusColor = "yellow";
			break;
		case "STOP" :
		case "MOUNT" :
		case "START" :
			$statusColor = "gray";
			break;
		case "ONLINE" :
			$statusColor = "green";
			break;
	}
	return $statusColor;
}

function getStatusText($status){
	$statusText= "";
	switch($status){
		case "COFOUND" :
			$statusText = "C";
			break;
		case "ALIEN" :
			$statusText = "A";
			break;
		case "UNMARKED" :
			$statusText = "U";
			break;
		case "BROKEN" :
			$statusText = "B";
			break;
	}
	return $statusText;
}

//now for states
function getStateColor($state){
	$stateColor = "black";
	switch($state){
		case "OFFLINE" :
			$stateColor = "black";
			break;
		case "ONLINE" :
			$stateColor = "green";
			break;
	}
	return $stateColor;
}

//now for states
function getStateChangeAction($state,$volumeNameFull){
	$actionHtml = "";
	switch($state){
		case "OFFLINE" :
			$actionHtml = "<img id=\"action_switch_online_$volumeNameFull\" src=\"./images/sw_start.png\" alt=\"" . __("Switch Online") . "\" onclick=\"switchOnline(this)\">";
			$actionHtml = $actionHtml . "<td>" . "<img id=\"action_demote_$volumeNameFull\" src=\"./images/demote.png\" alt=\"" . __("Demote") . "\" onclick=\"demote(this)\">" . "</td>";
			break;
		case "ONLINE" :
			$actionHtml = "<img id=\"action_switch_offline_$volumeNameFull\" src=\"./images/sw_stop.png\" alt=\"" . __("Switch Offline") . "\" onclick=\"switchOffline(this)\">";
			break;
	}
	return $actionHtml;
}
