<?
/*
# $Id: set_role_res.php 6803 2006-12-13 21:08:54Z zlata $
#------------------------------------------------------------------------------
# Storage Management
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$sm_state = '';
$fname = $_SERVER['APL'] . '/var/sm/sm_status';
$sm_state = trim(file_get_contents($fname));
?>
<html>
<head>
	<meta charset="utf-8"/>
	<link title="global-css" href="/common/css/style.css" type="text/css" rel="stylesheet" >
	<meta http-equiv="refresh" content="10" />
</head>

<body >
	<div style='padding:20px'>
		<b>Storage Manager</b>
		<?php
		if ($sm_state)
			echo ("<p>Current operational state: <b>" . $sm_state . "</b></p>\n");
		switch ($sm_state) {
			case 'MISSING':
			?>
				<p>CIRRUS by videoNEXT requires dedicated disk with "va-cirrus" name for video-archiving.<br>
				Please do not try to allocate video-archive on the disk where your MAC OS X resides.<br>
				It must be separate internal or external (USB/FireWire) disk.<br>
				Please format it using Disk Utility accessible through Finder (Applications->Utilities) and give it "va-cirrus" name. It must be formatted using "Mac OS Extended (Journaled)" file system.<br>
				IMPORTANT NOTE: Windows-formatted (FAT) disks will not be recognized by the software</p>
		<?php
			break;
			case 'ONLINE':
			?>
				<p>Your system operates normally and does not require any additional attention.<br>
				Please be careful to avoid disconnecting external storage until software is not completely stopped and storage volume is not properly ejected using MAC OS X Finder.
				</p>
		<?php
			break;
			case 'BROKEN':
			?>
				<p>Please check that your "va-cirrus" storage volume is not disconnected (if you use USB or FireWire external storage).<br>
				Please go to Disk Utility accessible through Finder (Applications->Utilities) and do "Repair" in "First Aid" tab.<br>
				You may need to Erase it if it is broken beyond repair if such suggested by Disk Utility.
				</p>
		<?php
			break;
			case 'DEGRADED':
			?>
				<p>Your system experience too much load when writing data to video-archive.<br>
				You may need to reduce number of cameras and/or frame-rate/bit-rate to reduce the load.
				</p>
		<?php
			break;
			case 'STARTING':
			?>
				<p>Storage system is not available for archiving yet. Your va-cirrus disk will be checked for consistency Your va-cirrus disk will be switched to ONLINE as soon as consistency check is finished.
				</p>
		<?php
			break;
			case 'STOPPED':
			?>
				<p>Storage system is not available. Please startup CIRRUS by videoNEXT application.
				</p>
		<?php
			break;
			case 'FULL':
			?>
				<p>There is not space left on VA-CIRRUS disk. Please make sure that VA-CIRRUS disk is used for video archiving only.
				</p>
		<?php
			break;

		}
		?>
		<p>
		CIRRUS by videoNEXT does not allow for multiple storage volumes to be configured.
		You have to provide a storage volume with "va-cirrus" name and system will automatically recognize it.
		To enable this capability customization you will have to upgrade to STRATUS edition or higher.
		Please contact videoNEXT Sales at <a href="mailto:fsales@videonext.com" style="text-decoration:underline;">sales@videonext.com</a> for more information.
		</p>
	</div>
</body>

</html>
