<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>
<!DOCTYPE html>
<html>
<head>
<script src="/sdi/lib/js/jquery.js"></script>
<script src="/api/scripts/Gettext.js"></script>
<script src="/api/scripts/i18n.js"></script>
<script>
	var jsServerName = "<? print( $_SERVER['SERVER_NAME'] ); ?>";
	var jsServerPort = "<? print( $_SERVER['SERVER_PORT'] ); ?>";
	var jsSessionId = "<?=session_id();?>";
	var dateFormat = '<?=Identity::getAttribute("NLS_LONG_DATE_FORMAT");?>';
	var jsNS = null;
	var jsNodeOpen = null;
	var jsNodeAlive = 120000; // 2 min

	var jsFirstTime = true;
	var jsPoolTime = 3000; // every 4 sec

	var jsSpacerW = 10;
	var jsImageH = 16;

	var jsLogRows = 50;

	var jsTimeout = null;
	var jsVolumeSelect = null;

	var re_name = /[^a-z0-9_-]/i;
	var re_limit_write = /[^0-9]/;
	var re_target = /[^a-z0-9 +-@.]/i;
	var re_mount_options = /[^a-z0-9 +-@.]/i;

	function onLoad()
	{
		jsTimeout = window.setTimeout(function(){ sm_loop();}, 1);
	}


	function sm_loop()
	{
		try
		{
			var http = new XMLHttpRequest();
			var url = "/cxf/services/smservice/get_domain?token=" + getToken();
			http.open("GET", url, true);
			http.onreadystatechange = function()
			{
				if(http.readyState == 4 && http.status == 200)
				{
					sm_response(http.responseXML);
					jsTimeout = window.setTimeout(function(){ sm_loop();}, jsPoolTime);
				}
			};
			http.send(null);
		}
		catch (error)
		{
			alert(error.message);
			document.getElementById("busy").style.display = "none";
			return false;
		}
	}


	function sm_response(rXML)
	{
		var xml_domain = rXML.documentElement;
		if(!xml_domain.hasChildNodes()) {
			return false;
		}

		if (jsNS == null) {
			if (xml_domain.nodeName.indexOf(':') > 0) {
				jsNS = xml_domain.nodeName.split(":")[0] + ":";
			} else {
				jsNS = '';
			}
		}

		var xml_nodes = xml_domain.childNodes;

		var busyElement = document.getElementById("busy");
		if (busyElement != null) {
			busyElement.style.display = "none";
		}

		var body = document.getElementsByTagName("body")[0];
		if(body.hasChildNodes())
		{
			var body_cn = body.childNodes.length;
			for (var i=0; i < body_cn; i++)
			{
				if(body.hasChildNodes()) body.removeChild(body.firstChild);
			}
		}

//		s0 = '<div class="tabs"></div>';
		var div0 = document.createElement("div");
		div0.className = "tabs";
		div0.style.margin = "10px";

		var div_tabs_menu = document.createElement("div");
		div_tabs_menu.className = "tabs_menu";
		div_tabs_menu.innerHTML = "<div class='single_tab'><div class='tab_text'><?php print __('Storage Manager');?></div></div>";
		div0.appendChild(div_tabs_menu);


		var div_tabs_content = document.createElement("div");
		div_tabs_content.className = "tabs_content";
		div0.appendChild(div_tabs_content);

		var div_footer = document.createElement("div");
		div_footer.className = "tabs_footer";
		div0.appendChild(div_footer);
		body.appendChild(div0);



		var div_main_block = document.createElement("div");
		div_main_block.id = "main_block";
		div_main_block.style.margin = "0px";
		div_main_block.style.marginLeft = "10px";//paddingLeft
		div_tabs_content.appendChild(div_main_block);

		var tbl = document.createElement("table");
		tbl.id = "table";
		tbl.cellPadding = 3;
		tbl.cellSpacing = 0;
		tbl.width = "93%";

		var tbl_body = document.createElement("tbody");
		tbl.appendChild(tbl_body);
		div_main_block.appendChild(tbl);



		// Table Headers
		var tr = document.createElement("tr");
		var th = document.createElement("th");
		th.colSpan = 7;
		tr.appendChild(th);
		var th = document.createElement("th");
		var txt = document.createTextNode("<?php echo __("Size");?>");
		th.appendChild(txt);
		tr.appendChild(th);
		// Spacer
		var th = document.createElement("th");
		th.width = jsSpacerW;
		tr.appendChild(th);

		var th = document.createElement("th");
		var txt = document.createTextNode("<?php echo __("Load");?>");
		th.appendChild(txt);
		tr.appendChild(th);
		// Spacer
		var th = document.createElement("th");
		th.width = jsSpacerW;
		tr.appendChild(th);

		var th = document.createElement("th");
		var txt = document.createTextNode("<?php echo __("Status");?>");
		th.appendChild(txt);
		tr.appendChild(th);
		// Spacer
		var th = document.createElement("th");
		th.width = jsSpacerW;
		tr.appendChild(th);

		var th = document.createElement("th");
		//var txt = document.createTextNode("State");
		var txt = document.createTextNode(" ");
		th.appendChild(txt);
		tr.appendChild(th);
		// Spacer
		var th = document.createElement("th");
		th.width = jsSpacerW;
		tr.appendChild(th);

//TS
		var th = document.createElement("th");
		var txt = document.createTextNode(" ");
		th.colSpan = 6;
		th.appendChild(txt);
		tr.appendChild(th);
//TS

		tr.className = "darkgrayhead";
		tbl_body.appendChild(tr);

		// System Storage
		var tr = document.createElement("tr");
		tr.style.paddingBottom = 5;
		var td = document.createElement("td");
		td.colSpan = 6;
//		td.style.borderBottom = "1px solid gray";
		td.style.borderBottom = "solid #CCCCCC 2px";
		td.setAttribute("id", "dom");
		var txt = document.createTextNode("<?php echo __("Storage System");?>");
		td.appendChild(txt);
		tr.appendChild(td);
		addSpacer(tr, "#CCCCCC");

		// Size
		var td = document.createElement("td");
		td.style.borderBottom = "solid #CCCCCC 2px";
		td.id = "d_size";
		tr.appendChild(td);
		addSpacer(tr, "#CCCCCC");

		// Load
		var td = document.createElement("td");
		td.style.borderBottom = "solid #CCCCCC 2px";
		td.id = "d_load";
		tr.appendChild(td);
		// Spacer
		addSpacer(tr, "#CCCCCC");

		// Health
		var td = document.createElement("td");
		td.style.borderBottom = "solid #CCCCCC 2px";
		td.colSpan = 3;
		td.id = "d_health";
		tr.appendChild(td);
		addSpacer(tr, "#CCCCCC", 7);

		//tr.style.borderBottom = "solid #CCCCCC 2px";
		tbl_body.appendChild(tr);

		var domain_size = 0;
		var domain_free = 0;
		var domain_write = 0;
		var domain_limit_write = 0;
		var td_domain_health_img = new Array();

		var d_now = strToTime(xml_domain.getAttribute(jsNS+"now"));
		for (var i=0; i < xml_nodes.length; i++)
		{
			var n_alive = strToTime(xml_nodes[i].getAttribute(jsNS+"alive"));
			if(Math.abs(d_now - n_alive) > jsNodeAlive)
			{
				if(jsNodeOpen == i) jsNodeOpen = null;
				var tr = document.createElement("tr");
				tr.style.paddingTop = 30;
				tr.style.paddingBottom = 5;
				var td = document.createElement("td");
				td.colSpan = 19;

				td.innerHTML = "<font size='2' color='red'><i><?php /* i18n: Node XXXXX does not respond in a timely manner.*/ echo __("Node");?> <b>'"+xml_nodes[i].getAttribute(jsNS+"name")+"'</b> <?php echo __("does not respond in a timely manner.");?></i></font>";
				tr.appendChild(td);
				tbl_body.appendChild(tr);
			}
			else
			{
				var node_size = 0;
				var node_free = 0;
				var node_write = 0;
				var node_limit_write = 0;

				var td_node_health_img = new Array();

				// Node
				var tr = document.createElement("tr");
				tr.id = "n_"+i;
				tr.style.paddingTop = 30;
				tr.style.paddingBottom = 5;
				// +
				var td = document.createElement("td");
				td.style.borderBottom = "solid #CCCCCC 2px";

				var anc = document.createElement("a");
				anc.setAttribute("href", "JavaScript:node_open_close('"+i+"');");
				var img = document.createElement("img");
				img.setAttribute("id", "img_n_"+i);
				if(jsNodeOpen == i)
				{
					img.setAttribute("src", "images/ico/minus.png");
				}
				else
				{
					img.setAttribute("src", "images/ico/plus.png");
				}
				img.setAttribute("border", "0");
				anc.appendChild(img);

				td.appendChild(anc);
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC");

				// Name
				var td = document.createElement("td");
				td.colSpan = 4;
				td.style.borderBottom = "solid #CCCCCC 2px";
				td.setAttribute("id", ("n"+i));
				var txt = document.createTextNode(xml_nodes[i].getAttribute(jsNS+"name"));
				td.appendChild(txt);
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC");

				// Size
				var td = document.createElement("td");
				td.style.borderBottom = "solid #CCCCCC 2px";
				td.id = "n_size_"+i;
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC");

				// Load
				var td = document.createElement("td");
				td.style.borderBottom = "solid #CCCCCC 2px";
				td.id = "n_load_"+i;
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC");

				// Health
				var td = document.createElement("td");
				td.style.borderBottom = "solid #CCCCCC 2px";
				td.colSpan = 3;
				td.id = "n_health_"+i;
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC");

				// Node Log Icon
				var td = document.createElement("td");
				td.style.borderBottom = "solid #CCCCCC 2px";
				var img = document.createElement("img");
				img.id = "nlog_"+i;
				img.name = xml_nodes[i].getAttribute(jsNS+"nodeid");
				img.src = "images/ico/log_gray.gif";
				img.title = "<?php echo __("Node Log view");?>";
				img.width = 2*jsImageH;
				img.height = 2*jsImageH;
				img.onclick = getNodeLogInfo;

				td.appendChild(img);
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC");

			tr.style.borderBottom = "solid #CCCCCC 2px";
				tbl_body.appendChild(tr);

				// Node Graph icon
				var td = document.createElement("td");
				td.style.borderBottom = "solid #CCCCCC 2px";
				var img = document.createElement("img");
				img.id = "graph_"+i;

				img.name = xml_nodes[i].getAttribute(jsNS+"nodeid");
				img.src = "images/ico/chart.png";
				img.title = "<?php echo __("Storage Utilization");?>";
				img.width = 2*jsImageH;
				img.height = 2*jsImageH;
				img.onclick = viewGraph;

				td.appendChild(img);
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC");

			tr.style.borderBottom = "solid #CCCCCC 2px";
				tbl_body.appendChild(tr);


				// Node Scan
				var td = document.createElement("td");
				td.style.borderBottom = "solid #CCCCCC 2px";
				var img = document.createElement("img");

				var n_st = strToTime(xml_nodes[i].getAttribute(jsNS+"stime"));
				var n_et = strToTime(xml_nodes[i].getAttribute(jsNS+"cmd_end"));
				if(n_et < n_st)
				{
					img.src = "images/bigrotation2.gif";
				}
				else
				{
					img.src = "images/ico/node_scan.gif";
					img.name = xml_nodes[i].getAttribute(jsNS+"nodeid");
					img.onclick = nodeResourceScan;
				}
				img.id = "ns_"+i;
				img.title =  "<?php echo __("Node Scan");?>";
				img.setAttribute("border", "0");
				td.appendChild(img);
				tr.appendChild(td);
				addSpacer(tr, "#CCCCCC", 3);

				tbl_body.appendChild(tr);

				// Node Log div
				var tr = document.createElement("tr");
				tr.id = "ndiv_"+i;
				tr.style.paddingTop = 5;
				tr.style.paddingBottom = 10;
				var td = document.createElement("td");
				td.colSpan = 2;
				tr.appendChild(td);

				var td = document.createElement("td");
				td.colSpan = 17;
				var div = document.createElement("div");
				div.id = "ldiv_"+i;
				div.style.width = "100%";
				div.style.height = "150";
				div.style.overflowY = "auto";
				div.style.scrollbarBaseColor = "LightGrey";
				td.appendChild(div);
				tr.appendChild(td);
				tbl_body.appendChild(tr);

				var xml_volumes = xml_nodes[i].childNodes;
				for (var j=0; j < xml_volumes.length; j++)
				{
					// Volume
					var tr = document.createElement("tr");
					tr.id = "v_"+i+"_"+j;
					tr.style.paddingTop = 15;
					tr.style.paddingBottom = 5;

					// Node's +
					var td = document.createElement("td");
					tr.appendChild(td);

					var td = document.createElement("td");
					td.width = jsSpacerW;
					tr.appendChild(td);
					if(j == 0)
					{
						var td = document.createElement("td");
						td.rowSpan = 3 * xml_volumes.length;
						td.style.padding = 10;
						/*var img = document.createElement("img");
						img.setAttribute("src", "images/ico/tmp_pie_chart.jpg");
						td.appendChild(img);*/
						tr.appendChild(td);
					}
					var td = document.createElement("td");
					td.width = jsSpacerW;
					tr.appendChild(td);
					addSpacer(tr, "red", null, volumeSelect);

					// Name
					var td = document.createElement("td");
					td.setAttribute("id", ("n"+i+"_v"+j));
					var txt = document.createTextNode(xml_volumes[j].getAttribute(jsNS+"name"));
					td.appendChild(txt);
					td.onclick = volumeSelect;
					tr.appendChild(td);
					addSpacer(tr, "red", null, volumeSelect);

					// Size
					var td = document.createElement("td");

					var size = xml_volumes[j].getAttribute(jsNS+"size")*1;
					var free = xml_volumes[j].getAttribute(jsNS+"free")*1;
					if(size >= 0) node_size += size;
					if(free >= 0) node_free += free;
					var i_src = get_pictogram(size, free, false);
					var img = document.createElement("img");
					img.src = i_src[0];
					img.width = i_src[1];
					img.height = jsImageH;

					var sfree = Math.round (free / size * 100);
					var ssize = Math.round (size / 1024);
					img.setAttribute("title", "<?php /* i18n: Volume Size Pictogram \nSize: XXXXXX [MB]; \nFree Space: XXXXXX [MB] */ echo __("Volume Size Pictogram");?> \n<?php echo __("Size:");?>" + ssize + "[GB]; \n<?php echo __("Free Space:");?> "+sfree +"%" );
					td.appendChild(img);
					var img = document.createElement("img");
					img.src = "images/gray.jpg";
					img.width = 100 - i_src[1];
					img.height = jsImageH;
					img.setAttribute("title", "<?php /* i18n: Volume Size Pictogram \nSize: XXXXXX [MB]; \nFree Space: XXXXXX [MB] */ echo __("Volume Size Pictogram");?> \n<?php echo __("Size:");?> "+ssize+"[GB]; \n <?php echo __("Free Space:");?> "+sfree +"%" );
					td.appendChild(img);
					td.onclick = volumeSelect;
					tr.appendChild(td);
					addSpacer(tr, "red", null, volumeSelect);

					var pool = xml_volumes[j].getAttribute(jsNS+"pool").toLowerCase();
					if( pool == "wheels")
					{
						// Load pictogram
						var td = document.createElement("td");
						var limit_write = xml_volumes[j].getAttribute(jsNS+"limit_write")*1;
						var write = xml_volumes[j].getAttribute(jsNS+"write")*1;
						if(limit_write >= 0) node_limit_write += limit_write;
						if(write >= 0) node_write += write;

						var i_src = get_pictogram(limit_write, write, true);
						var img = document.createElement("img");
						img.src = i_src[0];
						img.width = i_src[1];
						img.height = jsImageH;
						img.setAttribute("title", "<?php /* i18n: Volume Load Pictogram \nLimit write: XXXXXX \nWrite: */ echo __("Volume Load Pictogram");?> \n<?php echo __("Limit write:");?> "+limit_write+"\n <?php echo __("Write:");?> "+write );
						td.appendChild(img);
						var img = document.createElement("img");
						img.src = "images/gray.jpg";
						img.width = 100 - i_src[1];
						img.height = jsImageH;
						img.setAttribute("title", "<?php /* i18n: Volume Load Pictogram \nLimit write: XXXXXX \nWrite: */ echo __("Volume Load Pictogram");?> \n<?php echo __("Limit write:");?> "+limit_write+"\n <?php echo __("Write:");?> "+write );
						td.appendChild(img);
						td.onclick = volumeSelect;
						tr.appendChild(td);
						addSpacer(tr, "red", null, volumeSelect);

						// Status
						var td = document.createElement("td");
						var ost = xml_volumes[j].getAttribute(jsNS+"ost");
						var img = document.createElement("img");
						img.src = "images/ico/"+ost+".gif";
						img.setAttribute("title", "<?php /* i18n: ... */ echo __("Volume Status:");?> "+ost );
						img.setAttribute("border", "0");
						td.appendChild(img);
						if(ost.toLowerCase() != xml_volumes[j].getAttribute(jsNS+"cst").toLowerCase())
						{
							var img = document.createElement("img");
							img.src = "images/ico/transparent.gif";
							img.width = Math.ceil(jsImageH/3);
							img.height = jsImageH;
							img.setAttribute("border", "0");
							td.appendChild(img);
							/*var img = document.createElement("img");
							img.src = "images/in_progress.gif";
							img.setAttribute("border", "0");
							td.appendChild(img);*/
						}
						td.onclick = volumeSelect;
						tr.appendChild(td);
						addSpacer(tr, "red", null, volumeSelect);

						// State
						var td = document.createElement("td");
						var cst = xml_volumes[j].getAttribute(jsNS+"cst");
						var ost = xml_volumes[j].getAttribute(jsNS+"ost");
						td.abbr = pool.toLowerCase()+"_"+cst.toLowerCase();

						td_node_health_img.push(ost);
						td_domain_health_img.push(ost);

						var img = document.createElement("img");

						if(cst.toUpperCase() == "ONLINE")
						{
							img.src = "images/ico/wheels_online.gif";
						}
						else if(cst.toUpperCase() == "OFFLINE")
						{
							img.src = "images/ico/wheels_offline.gif";
						}
						else if(cst.toUpperCase() == "SUSPEND")
						{
							img.src = "images/ico/wheels_suspend.gif";
						}
						else
						{
							//alert("Error: Unknown Volume Status.");
						}
						img.id = "cst_"+i+"_"+j;
						img.setAttribute("title", "<?php echo __("Volume State");?>: "+cst );
						img.setAttribute("border", "0");

						td.appendChild(img);
						td.onclick = volumeSelect;
						tr.appendChild(td);
						addSpacer(tr, "red", null, volumeSelect);
					}
					else
					{
						addSpacer(tr, "red", null, volumeSelect);
						addSpacer(tr, "red", null, volumeSelect);
						addSpacer(tr, "red", null, volumeSelect);
						addSpacer(tr, "red", null, volumeSelect);

						// State
						var td = document.createElement("td");
						td.abbr = pool.toLowerCase()+"_";

						var img = document.createElement("img");
						img.src = "images/ico/unused_init.gif";
						img.id = "cst_"+i+"_"+j;
						img.setAttribute("title", "<?php /* i18n: ... */ echo __("Volume State: UNUSED");?>");
						img.setAttribute("border", "0");
						td.appendChild(img);
						td.onclick = volumeSelect;
						tr.appendChild(td);
						addSpacer(tr, "red", null, volumeSelect);
					}

					// Log _ Confirm
					var td = document.createElement("td");
					td.abbr = xml_volumes[j].getAttribute(jsNS+"nodeid")+"___"+xml_volumes[j].getAttribute(jsNS+"id");
					var img = document.createElement("img");
					img.id = "log_"+i+"_"+j;
					img.src = "images/ico/log_gray.gif";
					img.title = "<?php /* i18n: ... */ echo __("Volume Log view");?>";
					img.width = 2*jsImageH;
					img.height = 2*jsImageH;
					td.appendChild(img);
					td.onclick = volumeSelect;
					tr.appendChild(td);
					addSpacer(tr, "red", null, volumeSelect);

					// Edit _ Cancel
					var td = document.createElement("td");
					td.abbr = 	xml_volumes[j].getAttribute(jsNS+"nodeid")+"___"+
								xml_volumes[j].getAttribute(jsNS+"id")+"___"+
								xml_volumes[j].getAttribute(jsNS+"pool");
					var img = document.createElement("img");
					img.id = "edit_"+i+"_"+j;
					if( pool == "wheels")
					{
						if(xml_volumes[j].getAttribute(jsNS+"ost").toLowerCase() == "offline")
						{
							img.src = "images/ico/edit_gray.gif";
							img.title = "<?php /* i18n: ... */ echo __("Edit volume parameters");?>";
						}
						else
						{
							img.src = "images/ico/transparent.gif";
							img.title = "";
						}
						img.name = pool+"___"+xml_volumes[j].getAttribute(jsNS+"ost")+"___"+xml_volumes[j].getAttribute(jsNS+"cst");
					}
					else
					{
						img.src = "images/ico/edit_gray.gif";
						img.title = "<?php /* i18n: ... */ echo __("Edit volume parameters");?>";
						img.name = pool+"___ ___ ";
					}
					img.width = 2*jsImageH;
					img.height = 2*jsImageH;
					td.appendChild(img);
					td.onclick = volumeSelect;
					tr.appendChild(td);
					addSpacer(tr, "red", null, volumeSelect);

					tbl_body.appendChild(tr);

					// volume div
					var tr = document.createElement("tr");
					tr.id = "vdiv_"+i+"_"+j;
					tr.style.paddingTop = 5;
					tr.style.paddingBottom = 10;
					var td = document.createElement("td");
					td.colSpan = 4;
					tr.appendChild(td);

					var td = document.createElement("td");
					td.colSpan = 15;
					var div = document.createElement("div");
					div.id = "div_"+i+"_"+j;
					div.style.width = "100%";
					div.style.height = "150";
					div.style.overflowY = "auto";
					div.style.scrollbarBaseColor = "LightGrey";
					td.appendChild(div);
					tr.appendChild(td);
					tbl_body.appendChild(tr);

					// volume Parameters Edit div
					var tr = document.createElement("tr");
					tr.id = "ediv_"+i+"_"+j;
					tr.style.paddingTop = 5;
					tr.style.paddingBottom = 10;
					var td = document.createElement("td");
					td.colSpan = 4;
					tr.appendChild(td);

					var td = document.createElement("td");
					td.colSpan = 15;
					var div = document.createElement("div");
					div.id = "tdiv_"+i+"_"+j;
					div.style.width = "100%";
					div.style.height = "100%";
					div.style.overflowY = "auto";
					//div.style.scrollbarBaseColor = "LightGrey";
					//div.style.backgroundColor = "gray";
					td.appendChild(div);
					tr.appendChild(td);
					tbl_body.appendChild(tr);
				}

				// Populate Node size pictogram
				var snode_free = Math.round (node_free / node_size * 100);
				var snode_size = Math.round (node_size / 1024);

				td = document.getElementById("n_size_"+i);
				var i_src = get_pictogram(node_size, node_free, false);
				var img = document.createElement("img");
				img.src = i_src[0];
				img.width = i_src[1];
				img.height = jsImageH;
				img.setAttribute("title", "<?php /* i18n: Node Size Pictogram \nSize: XXXXXX [MB]; \nFree Space: XXXXXX [MB] */ echo __("Node Size Pictogram");?> \n<?php echo __("Size:");?> "+snode_size+"[GB]; \n <?php echo __("Free Space:");?> "+snode_free +"%" );
				td.appendChild(img);
				var img = document.createElement("img");
				img.src = "images/gray.jpg";
				img.width = 100 - i_src[1];
				img.height = jsImageH;
				img.setAttribute("title", "<?php /* i18n: Node Size Pictogram \nSize: XXXXXX [MB]; \nFree Space: XXXXXX [MB] */ echo __("Node Size Pictogram");?> \n<?php echo __("Size:");?> "+snode_size+"[GB]; \n <?php echo __("Free Space:");?> "+snode_free +"%" );
				td.appendChild(img);
				if(node_size >= 0) domain_size += node_size;
				if(node_free >= 0) domain_free += node_free;

				// Populate Node load pictogram
				td = document.getElementById("n_load_"+i);
				var i_src = get_pictogram(node_limit_write, node_write, true);
				var img = document.createElement("img");
				img.src = i_src[0];
				img.width = i_src[1];
				img.height = jsImageH;
				img.setAttribute("title", "<?php /* i18n: Node Load Pictogram \nLimit Write: XXXXXX; \nWrite: XXXXXX */ echo __("Node Load Pictogram");?> \n<?php echo __("Limit Write:");?> "+node_limit_write+"\n <?php echo __("Write:");?> "+node_write);
				//img.setAttribute("title", "Node Load Pictogram \nLimit Write: "+node_limit_write+"; \nWrite: "+node_write);
				td.appendChild(img);
				var img = document.createElement("img");
				img.src = "images/gray.jpg";
				img.width = 100 - i_src[1];
				img.height = jsImageH;
				img.setAttribute("title", "<?php /* i18n: Node Load Pictogram \nLimit Write: XXXXXX; \nWrite: XXXXXX */ echo __("Node Load Pictogram");?> \n<?php echo __("Limit Write:");?> "+node_limit_write+"\n <?php echo __("Write:");?> "+node_write);
				td.appendChild(img);
				if(node_limit_write >= 0) domain_limit_write += node_limit_write;
				if(node_write >= 0) domain_write += node_write;

				// Populate Node Health pictogram
				td = document.getElementById("n_health_"+i);
				if(td_node_health_img.length > 0)
				{
					pict_w = Math.ceil(100.0/td_node_health_img.length);
					for(var k=0; k<td_node_health_img.length; k++)
					{
						var img = document.createElement("img");
						var p_ost = td_node_health_img[k].toLowerCase();
						if(p_ost == "online")
						{
							img.src = "images/green.jpg";
						}
						else if(p_ost == "start" || p_ost == "mount" || p_ost == "stop")
						{
							img.src = "images/gray.jpg";
						}
						else if(p_ost == "degraded" || p_ost == "full" || p_ost == "empty" || p_ost == "suspend" || p_ost == "unload")
						{
							img.src = "images/yellow.jpg";
						}
						else if(p_ost == "broken" || p_ost == "unmarked" || p_ost == "alien" || p_ost == "confound")
						{
							img.src = "images/red.jpg";
						}
						else if(p_ost == "offline")
						{
							img.src = "images/black.jpg";
						}
						else
						{
							//alert("Error: Unknown Volume Health Type");
						}
						img.width = pict_w;
						img.height = jsImageH;
						img.setAttribute("title", "<?php /* i18n: ... */ echo __("Node Health Status");?>");
						td.appendChild(img);
					}
				}
			}
		}

		// Populate Domain size pictogram
		var sdomain_free = Math.round (domain_free / domain_size * 100);
		var sdomain_size = Math.round (domain_size / 1024);
		td = document.getElementById("d_size");
		var i_src = get_pictogram(domain_size, domain_free, false);
		var img = document.createElement("img");
		img.src = i_src[0];
		img.width = i_src[1];
		img.height = jsImageH;
		img.setAttribute("title", "<?php /* i18n: Domain Size Pictogram \nSize: XXXXXX [MB]; \nFree Space: XXXXXX [MB] */ echo __("Domain Size Pictogram");?> \n<?php echo __("Size:");?> "+sdomain_size+"[GB]; \n <?php echo __("Free Space:");?> "+sdomain_free +"%" );
		//img.setAttribute("title", "Domain Size Pictogram \nSize: "+domain_size+" [MB]; \nFree Space: "+domain_free +" [MB]" );
		td.appendChild(img);
		var img = document.createElement("img");
		img.src = "images/gray.jpg";
		img.width = 100 - i_src[1];
		img.height = jsImageH;
		img.setAttribute("title", "<?php /* i18n: Domain Size Pictogram \nSize: XXXXXX [MB]; \nFree Space: XXXXXX [MB] */ echo __("Domain Size Pictogram");?> \n<?php echo __("Size:");?> "+sdomain_size+"[GB]; \n <?php echo __("Free Space:");?> "+sdomain_free +"%" );
		td.appendChild(img);

		// Populate Domain load pictogram
		td = document.getElementById("d_load");
		var i_src = get_pictogram(domain_limit_write, domain_write, true);
		var img = document.createElement("img");
		img.src = i_src[0];
		img.width = i_src[1];
		img.height = jsImageH;
		img.setAttribute("title", "<?php /* i18n: Domain Load Pictogram \nLimit Write: XXXXXX; \nWrite: XXXXXX */ echo __("Domain Load Pictogram");?> \n<?php echo __("Limit Write:");?> "+domain_limit_write+"\n <?php echo __("Write:");?> "+domain_write);
		//img.setAttribute("title", "Domain Load Pictogram \nLimit Write: "+domain_limit_write+"; \nWrite: "+domain_write);
		td.appendChild(img);
		var img = document.createElement("img");
		img.src = "images/gray.jpg";
		img.width = 100 - i_src[1];
		img.height = jsImageH;
		img.setAttribute("title", "<?php /* i18n: Domain Load Pictogram \nLimit Write: XXXXXX; \nWrite: XXXXXX */ echo __("Domain Load Pictogram");?> \n<?php echo __("Limit Write:");?> "+domain_limit_write+"\n <?php echo __("Write:");?> "+domain_write);
		td.appendChild(img);

		// Populate Domain Health pictogram
		td = document.getElementById("d_health");
		if(td_domain_health_img.length > 0)
		{
			pict_w = Math.ceil(100.0/td_domain_health_img.length);
			for(var k=0; k<td_domain_health_img.length; k++)
			{
				var img = document.createElement("img");
				var p_ost = td_domain_health_img[k].toLowerCase();
				if(p_ost == "online")
				{
					img.src = "images/green.jpg";
				}
				else if(p_ost == "start" || p_ost == "mount" || p_ost == "stop")
				{
					img.src = "images/gray.jpg";
				}
				else if(p_ost == "degraded" || p_ost == "full" || p_ost == "empty" || p_ost == "suspend" || p_ost == "unload")
				{
					img.src = "images/yellow.jpg";
				}
				else if(p_ost == "broken" || p_ost == "unmarked" || p_ost == "alien" || p_ost == "confound")
				{
					img.src = "images/red.jpg";
				}
				else if(p_ost == "offline")
				{
					img.src = "images/black.jpg";
				}
				else
				{
					//alert("Error: Unknown Domain Health Type");
				}
				img.width = pict_w;
				img.height = jsImageH;
				img.setAttribute("title", "<?php /* i18n: ... */ echo __("Domain Health Status");?>");
				td.appendChild(img);
			}
		}


		node_open_close(null);
	}

	function node_open_close(inode)
	{
		var t_rows = new Array();
		t_rows = document.getElementById("table").rows;

		if(inode != null)
		{
			if(jsTimeout == null) sm_loop();

			jsVolumeSelect = null;

			var imgs = document.getElementsByTagName("img");
			for (var i=0; i < imgs.length; i++)
			{
				img_id = imgs[i].id;
				if(img_id != "")
				{
					if(img_id.search("log") > -1)
					{
						imgs[i].src = "images/ico/log_gray.gif";
						imgs[i].title = "<?php /* i18n: ... */ echo __("Log view");?>";
					}
					else if(img_id.search("edit") > -1)
					{
						var tmp = new Array();
						tmp = imgs[i].name.toLowerCase().split("___");
						var pool = tmp[0];
						var ost = tmp[1];
						var cst = tmp[2];
						if( pool == "wheels")
						{
							if(ost == "offline")
							{
								imgs[i].src = "images/ico/edit_gray.gif";
								imgs[i].title = "<?php /* i18n: ... */ echo __("Edit volume parameters");?>";
							}
							else
							{
								imgs[i].src = "images/ico/transparent.gif";
								imgs[i].title = "";
							}
						}
						else
						{
							imgs[i].src = "images/ico/edit_gray.gif";
							imgs[i].title = "<?php /* i18n: ... */ echo __("Edit volume parameters");?>";
						}
					}
					else if(img_id.search("cst") > -1)
					{
						var tmp = new Array();
						tmp = imgs[i].parentNode.abbr.toLowerCase().split("_");
						var pool = tmp[0];
						var state = tmp[1];

						if(pool == "wheels")
						{
							if(state == "online")
							{
								imgs[i].src = "images/ico/wheels_online.gif";
								imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: ONLINE");?>";
							}
							else if(state == "offline")
							{
								imgs[i].src = "images/ico/wheels_offline.gif";
								imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: OFFLINE");?>";
							}
							else if(state == "suspend")
							{
								imgs[i].src = "images/ico/wheels_suspend.gif";
								imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: SUSPEND");?>";
							}
							else if(state == "demote")
							{
								imgs[i].src = "images/ico/wheels_demote.gif"
								imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: DEMOTE");?>";
							}
							else
							{
								alert("<?php /* i18n: ... */ echo __("Error: Unsupported Volume Status.");?>");
							}
						}
						else if(pool == "unused")
						{
							imgs[i].src = "images/ico/unused_init.gif"
							imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: UNUSED");?>";
						}
						else
						{
							alert("<?php /* i18n: ... */ echo __("Error: Unknown Pool Status");?>");
						}
					}
				}
			}

			var img_node = document.getElementById("img_n_"+inode);
			if(img_node.getAttribute("src").search("minus.png") > -1)
			{
				img_node.setAttribute("src", "images/ico/plus.png");
				jsNodeOpen = null;
			}
			else
			{
				if(jsNodeOpen != null) document.getElementById("img_n_"+jsNodeOpen).src = "images/ico/plus.png";
				img_node.setAttribute("src", "images/ico/minus.png");
				jsNodeOpen = inode;
			}
		}

		for (var i=0; i < t_rows.length; i++)
		{
			if(t_rows[i].id.search("vdiv_") > -1)
			{
				var ij = t_rows[i].id.split("vdiv_")[1];
				document.getElementById("div_"+ij).style.display = "none";
			}

			if(t_rows[i].id.search("ndiv_") > -1)
			{
				var ij = t_rows[i].id.split("ndiv_")[1];
				document.getElementById("ldiv_"+ij).style.display = "none";
			}

			if(t_rows[i].id.search("ediv_") > -1)
			{
				var ij = t_rows[i].id.split("ediv_")[1];
				document.getElementById("tdiv_"+ij).style.display = "none";
			}

			if(t_rows[i].id.search("v_") > -1)
			{
				if(jsNodeOpen != null)
				{
					if(t_rows[i].id.search(("v_"+jsNodeOpen)) > -1)
					{
						t_rows[i].style.display = "";
					}
					else
					{
						t_rows[i].style.display = "none";
					}
				}
				else
				{
					t_rows[i].style.display = "none";
				}
			}
		}
	}

	function nodeResourceScan(e)
	{
		var srcE = (e ? e.target : window.event.srcElement);
		srcE.src = "images/bigrotation2.gif";
		srcE.onclick = "";
		var nodeid = srcE.name;
		webServicesCall("node_scan?nid=" + nodeid + "&token=" + getToken());

		window.clearTimeout(jsTimeout);
		jsTimeout = null;
		jsVolumeSelect = null;
		sm_loop();
	}

	function nodeResourceScanButtonReset()
	{
		var imgs = document.getElementsByTagName("img");
		for (var i=0; i < imgs.length; i++)
		{
			if(imgs[i].id.toLowerCase().search("ns_") > -1)
			{
				imgs[i].src = "images/ico/node_scan.gif";
				imgs[i].onclick = nodeResourceScan;
			}
		}
	}

	function closeGraph()
	{
		$('body').css({'position': 'static', 'overflow': 'visible'});
		$('#overflower, #sm_graph_content').remove();
	}

	function viewGraph(e)
	{

		var srcE = (e ? e.target : window.event.srcElement);
		var n_id = srcE.name;
		var index = srcE.id.split("nlog_")[1];
		var nodeid = n_id;

		window.clearTimeout(jsTimeout);
		jsTimeout = -1;


			$('body').append(
				'<div id="overflower" style="width: 100%; height: 100%; position: absolute; top: 0; left: 0; opacity: 0.5; filter: alpha(opacity=50); background-color: white;"></div>' +
				'<iframe id="sm_graph_content" frameBorder="0" allowTransparency="true" src="/sdi/sm/index.php?nodename=' + nodeid + '&popup=true"></iframe>'
			);

			$('#sm_graph_content').css({
				'background-color': 'transparent',
				left: 0,
				top: '0px',
				width: '100%',
				height: $(window).height() - 50,
				position: 'absolute',
				'z-index': 10000,
				align: 'center',
				border: 'none'
			});
/*


		$('body').append(
			'<div id="overflower" style="width: 100%; height: 100%; position: absolute; top: 0; left: 0; opacity: 0.5; filter: alpha(opacity=50); background-color: white;"></div>' +
			'<iframe id="sm_graph_content" frameBorder="0" allowTransparency="true" src="/sdi/sm/index.php?nodeid=' + nodeid + '&popup=true"></iframe>'
		);

		$('#sm_graph_content').css({
			'background-color': 'transparent',
			left: left,
			top: '50px',
			width: '1250px',
			height: $(window).height() - 50,
			position: 'absolute',
			'z-index': 10000,
			align: 'center',
			border: 'none'
		});*/
	}

	function getNodeLogInfo(e)
	{
		var srcE = (e ? e.target : window.event.srcElement);
		var n_id = srcE.name;
		var index = srcE.id.split("nlog_")[1];
		window.clearTimeout(jsTimeout);
		jsTimeout = -1;

		if(jsNodeOpen != index)
		{
			node_open_close(index);
		}
		else
		{
			node_open_close(null);
		}

		nodeResourceScanButtonReset();

		if(jsVolumeSelect != null)
		{
			var row = document.getElementById("table").rows[jsVolumeSelect];
			for (var i=0; i < row.cells.length; i++)
			{
				row.cells[i].style.backgroundColor = "";
			}
			jsVolumeSelect = null;
		}

		document.getElementById("ldiv_"+index).style.display = "";

		var q_str = "nid=" + n_id + "&token=" + getToken() + "&" + "nrows=" + jsLogRows;
		try
		{
			var http = new XMLHttpRequest();
			var url = "/cxf/services/smservice/get_node_log_info?" + q_str;

			http.open("GET", url, true);

			http.onreadystatechange = function()
			{
				if(http.readyState == 4 && http.status == 200)
				{
					if(http.responseXML.documentElement.nodeName.toLowerCase() == "error")
					{
						//alert("Error: In Web Services Access.");
					}
					else
					{
						var div = document.getElementById("ldiv_"+index);
						if(div.childNodes.length > 0) div.removeChild(div.firstChild);

						var lines = http.responseXML.documentElement.childNodes;

						if(lines.length > 0)
						{
							div.style.height = 150;
							var tbl = document.createElement("table");
							tbl.cellPadding = 5;
							tbl.width = "100%";

							var tbl_body = document.createElement("tbody");
							tbl.appendChild(tbl_body);

							var tr = document.createElement("tr");
							tr.className = "darkgrayhead";
							var td = document.createElement("td");
							td.innerHTML = "<?php /* i18n: ... */ echo __("Time");?>";
							//td.className = "darkgrayhead";
							td.width = "20%";
							tr.appendChild(td);
							var td = document.createElement("td");
							td.innerHTML = "<?php /* i18n: ... */ echo __("Level");?>";
							//td.className = "darkgrayhead";
							td.width = "15%";
							tr.appendChild(td);
							var td = document.createElement("td");
							td.innerHTML = "<?php /* i18n: ... */ echo __("Note");?>";
							//td.className = "darkgrayhead";
							td.width = "65%";
							tr.appendChild(td);
							tbl_body.appendChild(tr);
							var i_bg = false;
							for(var i=0; i<lines.length; i++)
							{
								i_bg = !i_bg;
								var tr = document.createElement("tr");

								var td = document.createElement("td");
				                var logDateFormat = ts2date(lines[i].getAttribute(jsNS+'stime').split(".")[0]);
								td.innerHTML = "<font size='2'>"+logDateFormat+"</font>";
								if(i_bg) td.style.backgroundColor = "#DDDDDD";
								tr.appendChild(td);

								var td = document.createElement("td");
								td.innerHTML = "<font size='2'>"+lines[i].getAttribute(jsNS+'level')+"</font>";
								if(i_bg) td.style.backgroundColor = "#DDDDDD";
								tr.appendChild(td);

								var td = document.createElement("td");
								td.innerHTML = "<font size='2'>"+lines[i].getAttribute(jsNS+'note')+"</font>";
								if(i_bg) td.style.backgroundColor = "#DDDDDD";
								tr.appendChild(td);

								tbl_body.appendChild(tr);
							}
							div.appendChild(tbl);
						}
						else
						{
							div.style.height = 30;
							div.innerHTML = "<i><font ><?php /* i18n: ... */ echo __("There is not Log Info present.");?></font></i>";
						}
					}
				}
			}
			http.send(null);
		}
		catch (error)
		{
			alert(error.message);
			return false;
		}
	}

	function ts2date(ts){
		var date = new Date(ts*1);
        var logDateFormat = dateFormat + " " + "HH:II:SS";

        logDateFormat = logDateFormat.replace('YYYY', date.getFullYear());
        logDateFormat = logDateFormat.replace('YY', String(date.getFullYear()).substr(2));
        logDateFormat = logDateFormat.replace('MM', (date.getMonth() + 1 < 10) ? "0" + (date.getMonth() + 1) : date.getMonth() + 1);
        logDateFormat = logDateFormat.replace('DD', (date.getDate() < 10) ? "0" + date.getDate() : date.getDate());
        logDateFormat = logDateFormat.replace('HH', (date.getHours() < 10) ? "0" + date.getHours() : date.getHours());
        logDateFormat = logDateFormat.replace('II', (date.getMinutes() < 10) ? "0" + date.getMinutes() : date.getMinutes());
        logDateFormat = logDateFormat.replace('SS', (date.getSeconds() < 10) ? "0" + date.getSeconds() : date.getSeconds());
		return logDateFormat;
	}

	function getVolumeLogInfo(n_id, v_id, index)
	{
		params = "get_vol_log_info?" + "nid=" + n_id + "&vid=" + v_id  + "&token=" + getToken() + "&nrows=" + jsLogRows;
		try
		{
			var http = new XMLHttpRequest();
			var url = "/cxf/services/smservice/" + params;

			http.open("GET", url, true);

			http.onreadystatechange = function()
			{
				if(http.readyState == 4 && http.status == 200)
				{
					if(http.responseXML.documentElement.nodeName.toLowerCase() == "error")
					{
						//alert("Error: In Web Services Access.");
					}
					else
					{
						document.getElementById("tdiv_"+index).style.display = "none";

						var div = document.getElementById("div_"+index);
						if(div.childNodes.length > 0) div.removeChild(div.firstChild);

						var lines = http.responseXML.documentElement.childNodes;

						if(lines.length > 0)
						{
							div.style.height = 150;
							var tbl = document.createElement("table");
							tbl.cellPadding = 5;
							tbl.width = "100%";
							var tbl_body = document.createElement("tbody");
							tbl.appendChild(tbl_body);

							var tr = document.createElement("tr");
							var td = document.createElement("td");
							td.innerHTML = "<font size='2' ><i><?php /* i18n: ... */ echo __("Time");?></i></font>";
							td.width = "20%";
							tr.appendChild(td);
							var td = document.createElement("td");
							td.innerHTML = "<font size='2' ><i><?php /* i18n: ... */ echo __("Level");?></i></font>";
							td.width = "15%";
							tr.appendChild(td);
							var td = document.createElement("td");
							td.innerHTML = "<font size='2' ><i><?php /* i18n: ... */ echo __("Note");?></i></font>";
							td.width = "65%";
							tr.appendChild(td);
							tbl_body.appendChild(tr);
							var i_bg = false;
							for(var i=0; i<lines.length; i++)
							{
								i_bg = !i_bg;
								var tr = document.createElement("tr");

								var td = document.createElement("td");

				                var logDateFormat = ts2date(lines[i].getAttribute(jsNS+'stime').split(".")[0]);
								td.innerHTML = "<font size='2' >"+logDateFormat+"</font>";
								if(i_bg) td.style.backgroundColor = "#DDDDDD";
								tr.appendChild(td);

								var td = document.createElement("td");
								td.innerHTML = "<font size='2' >"+lines[i].getAttribute(jsNS+'level')+"</font>";
								if(i_bg) td.style.backgroundColor = "#DDDDDD";
								tr.appendChild(td);

								var td = document.createElement("td");
								td.innerHTML = "<font size='2' >"+lines[i].getAttribute(jsNS+'note')+"</font>";
								if(i_bg) td.style.backgroundColor = "#DDEEDD";
								if(i_bg) td.style.backgroundColor = "#DDDDDD";
								tr.appendChild(td);

								tbl_body.appendChild(tr);
							}
							//div.innerText = t_txt;
							div.appendChild(tbl);
						}
						else
						{
							div.style.height = 30;
							div.innerHTML = "<i><font ><?php /* i18n: ... */ echo __("There is not Log Info present.");?></font></i>";
						}
					}
				}
			}
			http.send(null);
		}
		catch (error)
		{
			alert(error.message);
			return false;
		}
	}

	function editVolumeParams(index, method, n_id, v_id, pool)
	{
		if(method.toLowerCase() == "get")
		{
			params = 	"get_vol_params?" +
						"nid=" + n_id +
						"&vid=" + v_id +
						"&token=" + getToken() +
						"&pool=" + pool;
		}
		else if(method.toLowerCase() == "set")
		{
			if(document.getElementById("nmP_"+index).value == "")
			{
				alert("<?php echo __("'Name' field can't be empty.");?> \n<?php echo __("Please enter the volume name.");?>");
				return;
			}
			if(document.getElementById("lwP_"+index).value == "")
			{
				alert("<?php echo __("'Limit Write' field can't be empty.");?> \n<?php echo __("Please enter the parameter value.");?>");
				return;
			}
			params = 	"set_vol_params?" +
						"nid=" + n_id +
						"&vid=" + v_id +
						"&token=" + getToken() +
						"&pool=" + pool +
						"&name=" + escape(document.getElementById("nmP_" + index).value) +
						"&limit_write=" + escape(document.getElementById("lwP_" + index).value) +
						"&target=" + escape(document.getElementById("taP_" + index).value) +
						"&mount_options=" + escape(document.getElementById("moP_" + index).value);
		}
		else { alert("<?php /* i18n: ... */ echo __("Error: Unknown 'method' parameter in the editVolumeParams() function.");?>"); return; }

		try
		{
			var http = new XMLHttpRequest();
			var url = "/cxf/services/smservice/" + params;

			http.open("GET", url, true);

			http.onreadystatechange = function()
			{
				if(http.readyState == 4 && http.status == 200)
				{
					if(http.responseXML.documentElement.nodeName.toLowerCase() == "error")
					{

						//alert("Error: In Web Services Access.");
					}
					else
					{
						if(method.toLowerCase() == "get")
						{
							document.getElementById("div_"+index).style.display = "none";

							var div = document.getElementById("tdiv_"+index);
							div.style.display = "";

							if(div.childNodes.length > 0) div.removeChild(div.firstChild);

							var result = http.responseXML.documentElement.firstChild;

							var p_name = result.getAttribute(jsNS+"name");
							if(p_name == null) p_name = "";
							var p_limit_write = result.getAttribute(jsNS+"limit_write");
							if(p_limit_write == null) p_limit_write = "";
							var p_target = result.getAttribute(jsNS+"target");
							if(p_target == null) p_target = "";
							var p_mount_options = result.getAttribute(jsNS+"mount_options");
							if(p_mount_options == null) p_mount_options = "";

							div.style.height = "100%";

							var tbl = document.createElement("table");
							tbl.cellPadding = 0;
							var tbl_body = document.createElement("tbody");
							tbl.appendChild(tbl_body);

							var tr = document.createElement("tr");
							var td = document.createElement("td");
							td.vAlign = "top";
							td.style.paddingLeft = "5pt";
							td.innerHTML = "<font size='2' ><i>Name:</i></font>";
							td.style.backgroundColor = "#DDDDDD";
							tr.appendChild(td);
							var td = document.createElement("td");
							var ta = document.createElement("textArea");
							ta.id = "nmP_"+index;
							ta.value = p_name;
							ta.cols = 50;
							ta.rows = 1;
							ta.style.overflow = "hidden";
							ta.title = " <?php /* i18n: Allowed charcters: [a-z], [A-Z], [0-9], _ */ echo __("Allowed charcters:");?> [a-z], [A-Z], [0-9], _";
							td.appendChild(ta);
							tr.appendChild(td);
							tbl_body.appendChild(tr);

							var tr = document.createElement("tr");
							var td = document.createElement("td");
							td.vAlign = "top";
							td.style.paddingLeft = "5pt";
							td.innerHTML = "<font size='2' ><i><?php /* i18n: ... */ echo __("Limit Write:");?></i></font>";
							td.style.backgroundColor = "#DDDDDD";
							tr.appendChild(td);
							var td = document.createElement("td");
							var ta = document.createElement("textArea");
							ta.id = "lwP_"+index;
							ta.value = p_limit_write;
							ta.cols = 50;
							ta.rows = 1;
							ta.style.overflow = "hidden";
							ta.title = " <?php /* i18n: ... */ echo __("Allowed charcters: ");?>[0-9]";
							td.appendChild(ta);
							tr.appendChild(td);
							tbl_body.appendChild(tr);

							var tr = document.createElement("tr");
							var td = document.createElement("td");
							td.vAlign = "top";
							td.style.paddingLeft = "5pt";
							td.innerHTML = "<font size='2' ><i><?php /* i18n: ... */ echo __("Target:");?></i></font>";
							td.style.backgroundColor = "#DDDDDD";
							tr.appendChild(td);
							var td = document.createElement("td");
							var ta = document.createElement("textArea");
							ta.id = "taP_"+index;
							ta.value = p_target;
							ta.cols = 50;
							ta.rows = 1;
							ta.style.overflow = "hidden";
							ta.title = " <?php /* i18n: ... */ echo __("Allowed charcters:");?> [a-z], [A-Z], [0-9], +-@(dot)(space)";
							td.appendChild(ta);
							tr.appendChild(td);
							tbl_body.appendChild(tr);

							var tr = document.createElement("tr");
							var td = document.createElement("td");
							td.vAlign = "top";
							td.style.paddingLeft = "5pt";
							td.innerHTML = "<font size='2' ><i><?php /* i18n: ... */ echo __("Mount Options:");?></i></font>";
							td.style.backgroundColor = "#DDDDDD";
							tr.appendChild(td);
							var td = document.createElement("td");
							var ta = document.createElement("textArea");
							ta.id = "moP_"+index;
							ta.value = p_mount_options;
							ta.cols = 50;
							ta.rows = 1;
							ta.style.overflow = "hidden";
							ta.title = " <?php /* i18n: ... */ echo __("Allowed charcters:");?> [a-z], [A-Z], [0-9], +-@(dot)(space)";
							td.appendChild(ta);
							tr.appendChild(td);
							tbl_body.appendChild(tr);

							// Confirm & Cancel
							var tr = document.createElement("tr");
							var td = document.createElement("td");
							tr.appendChild(td);

							var td = document.createElement("td");
							td.abbr = n_id+"___"+v_id+"___"+pool;
							var img = document.createElement("img");
							img.id = "eConfirm_"+index;
							img.src = "images/ico/confirm.gif";
							img.title = "<?php /* i18n: ... */ echo __("Confirm Changes");?>";
							img.width = 2*jsImageH;
							img.height = 2*jsImageH;
							img.onclick = submitVolParams;
							td.appendChild(img);
							var img = document.createElement("img");
							img.id = "eConfirm_"+index;
							img.src = "images/ico/cancel.gif";
							img.title = "<?php /* i18n: ... */ echo __("Cancel Changes");?>";
							img.width = 2*jsImageH;
							img.height = 2*jsImageH;
							img.onclick = cancelVolParams;
							td.appendChild(img);

							tr.appendChild(td);
							tbl_body.appendChild(tr);

							div.appendChild(tbl);
						}
						else if(method.toLowerCase() == "set")
						{
							cancelVolParams();
						}
					}
				}
			}
			http.send(null);
		}
		catch (error)
		{
			alert(error.message);
			return false;
		}
	}

	function submitVolParams(e)
	{
		var srcE = (e ? e.target : window.event.srcElement);

		var index = srcE.id.split("eConfirm_")[1];
		var nm = document.getElementById("nmP_"+index).value;
		var lw = document.getElementById("lwP_"+index).value;
		var ta = document.getElementById("taP_"+index).value;
		var mo = document.getElementById("moP_"+index).value;

		var ipass = false;

		if(re_name.test(nm))
		{
			ipass = true;
			document.getElementById("nmP_"+index).select();
		}
		else if(re_limit_write.test(lw))
		{
			ipass = true;
			document.getElementById("lwP_"+index).select();
		}
		else if(re_target.test(ta))
		{
			ipass = true;
			document.getElementById("taP_"+index).select();
		}
		else if(re_mount_options.test(mo))
		{
			ipass = true;
			document.getElementById("moP_"+index).select();
		}

		if(ipass)
		{
			alert("<?php echo __("Please enter correct input data in the selected field.");?>\n <?php echo __("(Look at the 'tooltip' for help)");?>");
			return;
		}

		// edit
		var tmp = new Array();
		tmp = srcE.parentNode.abbr.split("___");
		n_id = tmp[0];
		v_id = tmp[1];
		pool = tmp[2];

		editVolumeParams(index, "set", n_id, v_id, pool);
	}

	function cancelVolParams()
	{
		jsVolumeSelect = null;
		sm_loop();
	}

	function volumeSelect(e)
	{
		window.clearTimeout(jsTimeout);
		jsTimeout = null;

		nodeResourceScanButtonReset();

		var element = (e ? e.target : window.event.srcElement);
		//var element = window.event.srcElement;
		if(element.cellIndex >= 0)
		{
			cell = element;
		}
		else
		{
			cell = element.parentNode;
		}
		row = cell.parentNode;

		var index = row.id.split("v_")[1];

		document.getElementById("ldiv_"+index.split("_")[0]).style.display = "none";

		if(jsVolumeSelect == row.rowIndex)
		{
			if(element.id.search("cst") > -1)
			{
				document.getElementById("log_"+index).src = "images/ico/confirm.gif";
				document.getElementById("log_"+index).title = "<?php /* i18n: Button title */ echo __("Confirm");?>";
				document.getElementById("edit_"+index).src = "images/ico/cancel.gif";
				document.getElementById("edit_"+index).title = "<?php /* i18n: Button title */ echo __("Cancel");?>";
				document.getElementById("div_"+index).style.display = "none";
				document.getElementById("tdiv_"+index).style.display = "none";

				var tmp = new Array();
				tmp = element.parentNode.abbr.toLowerCase().split("_");
				var pool = tmp[0];
				var state = tmp[1];

				if(pool == "wheels")
				{
					if(state == "online")
					{
						if(element.src.search("wheels_online") > -1)
						{
							element.src = "images/ico/wheels_offline.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: OFFLINE");?>";
						}
						else if(element.src.search("wheels_offline") > -1)
						{
							element.src = "images/ico/wheels_suspend.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: SUSPEND");?>";
						}
						else if(element.src.search("wheels_suspend") > -1)
						{
							element.src = "images/ico/wheels_online.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: ONLINE");?>";
						}
					}
					else if(state == "offline")
					{
						if(element.src.search("wheels_online") > -1)
						{
							element.src = "images/ico/wheels_offline.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: OFFLINE");?>";
						}
						else if(element.src.search("wheels_offline") > -1)
						{
							element.src = "images/ico/wheels_suspend.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: SUSPEND");?>";
						}
						else if(element.src.search("wheels_suspend") > -1)
						{
							element.src = "images/ico/wheels_demote.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: DEMOTE");?>";
						}
						else if(element.src.search("wheels_demote") > -1)
						{
							element.src = "images/ico/wheels_online.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: ONLINE");?>";
						}
					}
					else if(state == "suspend")
					{
						if(element.src.search("wheels_online") > -1)
						{
							element.src = "images/ico/wheels_offline.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: OFFLINE");?>";
						}
						else if(element.src.search("wheels_offline") > -1)
						{
							element.src = "images/ico/wheels_suspend.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: SUSPEND");?>";
						}
						else if(element.src.search("wheels_suspend") > -1)
						{
							element.src = "images/ico/wheels_online.gif";
							element.title = "<?php /* i18n: ... */ echo __("Volume State: ONLINE");?>";
						}
					}
					else
					{
						alert("<?php /* i18n: ... */ echo __("Error: Unsupported Volume Status.");?>");
					}
				}
				else if(pool == "unused")
				{
					if(element.src.search("unused_assign") > -1)
					{
						element.src = "images/ico/unused_remove.gif";
						element.title = "<?php /* i18n: ... */ echo __("Volume State: REMOVE");?>";
					}
					else if( (element.src.search("unused_remove") > -1) || (element.src.search("unused_init") > -1) )
					{
						element.src = "images/ico/unused_assign.gif";
						element.title = "<?php /* i18n: ... */ echo __("Volume State: ASSIGN");?>";
					}
				}
				else
				{
					alert("<?php /* i18n: ... */ echo __("Error: Unknown Pool Status");?>");
				}
			}
			else if(element.id.search("log") > -1)
			{
				var tmp = new Array();
				tmp = element.parentNode.abbr.split("___");
				n_id = tmp[0];
				v_id = tmp[1];

				if(element.src.search("log") > -1)
				{
					// log
					document.getElementById("div_"+index).style.display = "";
					document.getElementById("tdiv_"+index).style.display = "none";
					getVolumeLogInfo(n_id, v_id, index);
				}
				else
				{
					// confirm
					var imgs = 	row.getElementsByTagName("img");

					for(var i=0; i<imgs.length; i++)
					{
						if(imgs[i].parentNode.abbr.length > 0)
						{
							var abbr = imgs[i].parentNode.abbr;
							if( (abbr.toLowerCase().search("wheels") > -1) ||
								(abbr.toLowerCase().search("unused") > -1) )
							{
								var tmp = new Array();
								tmp = abbr.split("_");
								pool = tmp[0].toLowerCase();
								cst = tmp[1].toLowerCase();
								break;
							}
						}
					}

					for(var i=0; i<imgs.length; i++)
					{
						if( (imgs[i].src.toLowerCase().search("wheels_") > -1) ||
							(imgs[i].src.toLowerCase().search("unused_") > -1) )

						{
							var tmp = new Array();
							tmp = imgs[i].src.split("_");
							cst_r = tmp[1].toLowerCase().split(".")[0];
							break;
						}
					}

					if(cst_r != cst)
					{
						var params = "";
						if(cst_r == "online")
						{
							params = 	"vol_wheels_cmd?"+
										"token=" + getToken() +
										"&vid="+v_id+
										"&cmd=ONLINE";
						}
						else if(cst_r == "offline")
						{
							params = 	"vol_wheels_cmd?"+
										"token=" + getToken() +
										"&vid="+v_id+
										"&cmd=OFFLINE";
						}
						else if(cst_r == "suspend")
						{
							params = 	"vol_wheels_cmd?"+
										"token=" + getToken() +
										"&vid="+v_id+
										"&cmd=SUSPEND";
						}
						else if(cst_r == "demote")
						{
							params = 	"vol_wheels_cmd?"+
										"token=" + getToken() +
										"&vid="+v_id+
										"&cmd=DEMOTE";
						}
						else if(cst_r == "assign")
						{
							params = 	"vol_unused_cmd?"+
										"token=" + getToken() +
										"&nid="+n_id+
										"&vid="+v_id+
										"&cmd=ASSIGN";
						}
						else if(cst_r == "remove")
						{
							params = 	"vol_unused_cmd?"+
										"token=" + getToken() +
										"&nid="+n_id+
										"&vid="+v_id+
										"&cmd=REMOVE";
						}
						else
						{
							alert("<?php /* i18n: ... */ echo __("Error: Unkonown volme cst status.");?>");
						}
						webServicesCall(params);
					}
					jsVolumeSelect = null;
					sm_loop();
				}
			}
			else if(element.id.search("edit") > -1)
			{
				if(element.src.search("edit") > -1)
				{
					// edit
					var tmp = new Array();
					tmp = element.parentNode.abbr.split("___");
					n_id = tmp[0];
					v_id = tmp[1];

					editVolumeParams(index, "get", n_id, v_id, element.name.split("___")[0]);
				}
				else
				{
					// cancel
					document.getElementById("div_"+index).style.display = "none";
					jsVolumeSelect = null;
					sm_loop();
				}
			}
			else
			{
				var row = document.getElementById("table").rows[jsVolumeSelect];
				for (var i=0; i < row.cells.length; i++)
				{
					row.cells[i].style.backgroundColor = "";
				}
				jsVolumeSelect = null;
				sm_loop();
			}
		}
		else
		{
			if(jsVolumeSelect != null)
			{
				var old_row = document.getElementById("table").rows[jsVolumeSelect];
				var old_index = old_row.id.split("v_")[1];

				for (var i=0; i < old_row.cells.length; i++)
				{
					old_row.cells[i].style.backgroundColor = "";
				}
				var imgs = old_row.getElementsByTagName("img");
				for (var i=0; i < imgs.length; i++)
				{
					img_id = imgs[i].id;
					if(img_id != "")
					{
						if(img_id.search("log") > -1)
						{
							imgs[i].src = "images/ico/log_gray.gif";
							imgs[i].title = "<?php /* i18n: ... */ echo __("Log view");?>";
						}
						else if(img_id.search("edit") > -1)
						{
							var tmp = new Array();
							tmp = imgs[i].name.toLowerCase().split("___");
							var pool = tmp[0];
							var ost = tmp[1];
							var cst = tmp[2];
							if( pool == "wheels")
							{
								if(ost == "offline")
								{
									imgs[i].src = "images/ico/edit_gray.gif";
									imgs[i].title = "<?php /* i18n: ... */ echo __("Edit volume parameters");?>";
								}
								else
								{
									imgs[i].src = "images/ico/transparent.gif";
									imgs[i].title = "";
								}
							}
							else
							{
								imgs[i].src = "images/ico/edit_gray.gif";
								imgs[i].title = "<?php /* i18n: ... */ echo __("Edit volume parameters");?>";
							}
						}
						else if(img_id.search("cst") > -1)
						{
							var tmp = new Array();
							tmp = imgs[i].parentNode.abbr.toLowerCase().split("_");
							var pool = tmp[0];
							var state = tmp[1];

							if(pool == "wheels")
							{
								if(state == "online")
								{
									imgs[i].src = "images/ico/wheels_online.gif";
									imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: ONLINE");?>";
								}
								else if(state == "offline")
								{
									imgs[i].src = "images/ico/wheels_offline.gif";
									imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: OFFLINE");?>";
								}
								else if(state == "suspend")
								{
									imgs[i].src = "images/ico/wheels_suspend.gif";
									imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: SUSPEND");?>";
								}
								else if(state == "demote")
								{
									imgs[i].src = "images/ico/wheels_demote.gif";
									imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: DEMOTE");?>";
								}
								else
								{
									alert("<?php /* i18n: ... */ echo __("Error: Unsupported Volume Status.");?>");
								}
							}
							else if(pool == "unused")
							{
								imgs[i].src = "images/ico/unused_init.gif";
								imgs[i].title = "<?php /* i18n: ... */ echo __("Volume State: UNUSED");?>";
							}
							else
							{
								alert("<?php /* i18n: ... */ echo __("Error: Unknown Pool Status");?>");
							}
						}
					}
				}
				document.getElementById("div_"+old_index).style.display = "none";
				document.getElementById("tdiv_"+old_index).style.display = "none";
			}

			jsVolumeSelect = row.rowIndex;
			var cntl = false;
			for (var i=0; i < row.cells.length; i++)
			{
				if(i < row.cells.length-1)
				{
					if(row.cells[i+1].id != "") cntl = true;
				}
				if(cntl) row.cells[i].style.backgroundColor = "#DDDDDD";
			}
		}
	}

	function get_pictogram(size, free, inverse)
	{
		var img_return = new Array();

		if( (size > 0) && (free >= 0) )
		{
			if(inverse)
			{
				var space = 100 - Math.round((size - free)*100/size);
			}
			else
			{
				var space = Math.round((size - free)*100/size);
			}
		}
		else
		{
			var space = -1;
		}

		var img_s = "";
		if( (space < 0) || (space > 100) )
		{
			img_s = "images/red.jpg";
		}
		else
		{
			if(space <= 85)
			{
				img_s = "images/green.jpg";
			}
			else if( (space > 85) && (space <= 95) )
			{
				img_s = "images/yellow.jpg";
			}
			else
			{
				img_s = "images/red.jpg";
			}
		}
		img_return[0] = img_s;
		img_return[1] = space;

		return img_return;
	}

	function strToTime(time_in)
	{
		var sar = time_in.split(".");
		t1 = sar[0].replace(/-/g, "/");
		t2 = sar[1].substring(0,3);
		return Date.parse(t1) + t2*1;
	}

	function webServicesCall(params)
	{
		try
		{
			var http = new XMLHttpRequest();
			var url = "/cxf/services/smservice/" + params;

			http.open("GET", url, true);

			http.onreadystatechange = function()
			{
				if(http.readyState == 4 && http.status == 200)
				{
					if(http.responseXML.documentElement.nodeName.toLowerCase() == "error")
					{
						//alert("Error: In Web Services Access.");
					}
				}
			};
			http.send(null);
		}
		catch (error)
		{
			alert(error.message);
			return false;
		}
	}

	function addSpacer(tr_object, color, col_span, click_ref)
	{
		var td = document.createElement("td");
		td.width = jsSpacerW;
		//td.style.borderBottom = "2px solid "+color;
		if(col_span != null) td.colSpan = col_span;
		if(click_ref != null) td.onclick = click_ref;
//		td.innerHTML = "<font color='#B9B5B5'>.</font>";
		td.innerHTML = "<font color='LightGrey'>.</font>";
		tr_object.appendChild(td);
	}

</script>


	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
</head>

<body onload="onLoad();" bgcolor="LightGrey"  topmargin="20" leftmargin="15" scroll="auto">
	<div id="busy">
		<img border="0" title="STRATUS" src="/sdi/global/img/ajax-loader_dark.gif" style="margin:10px;">
	</div>

</body>
</html>
