"use strict";

/**
 * @class graphs Incapsulates all logic related with editing graphs configuration
 * This functional closely connected with graphs schema (graphs/etc/graphs_schema.json)
 */
var TOP10 = 10;
var graphs = {

	loadAttempts: 0,
	defaultObjSize: 6553, // line size of newly created zone and line
	maxSize: 60000, // max value that x,y coordinates can have
	objid: null,  // id of camera being edited
	props: null,
	cameraAttributes: {}, // Attributes of current camera
	drawtype: null,
	nodeid: null,
	nodename: null,

	d1: [],
	d2: [],
	d3: [],
    stack: 0,
	bars: true,
	lines: false,
	steps: false,
	pre_graphArray: [],
	dateformat: "%om/%0d/%y",

	/**
	 *
	 * @param {Object} props array of init properties: objid and trackers on/off
	 */
	init: function(props) {
		this.props = props;
		this.drawtype = props['type'];

		if (typeof(props['dateformat']) != 'undefined'){
			this.dateformat = props['dateformat'];
		}

		switch (this.drawtype) {
			case "objid_bars":
				this.objid = props['objid'];
				this.drawObjid();
				break;
			case "nodeid_pie":
				this.nodeid = props['nodeid'];
				this.drawNodePie();
				break;
			case "nodeid_bars":
				this.nodeid = props['nodeid'];
				this.drawNodeBars();
				break;
			case "nodename_pie":
				this.nodename = props['nodename'];
				this.drawNodePie();
				break;
			case "nodename_bars":
				this.nodename = props['nodename'];
				this.drawNodeBars();
				break;
		}
	},

	drawObjid: function() {
		var self = this;
		var objList = [];
		objList.push(this.objid);

		$.when(
			$.ajax({
				async: true,
				url: '/api/call.php',
				dataType: "json",
				data: {'function': 'getStorageUsageSpread', 'objList': JSON.stringify(objList)}
			})
		).done(function(res_array) {
			var pre_graphArray = [];
			var policy_info = [];
			try {
				pre_graphArray = res_array.list;
			} catch (e) {
				self.retryInit(props);
			}
			//get obj Storage Policy, and Storage Policy attr
			$.when(
				$.ajax({
					async: true,
					url: '/api/call.php',
					dataType: "json",
					data: {'function': 'getObjStoragePolicyInfo', 'obj': self.objid}
				})
			).done(function(res_policy_info) {
				try {
					policy_info = res_policy_info.list;
				} catch (e) {
					self.retryInit(props);
				}
				var dayInSec = 24*60*60;
				var predate = 0;
				for (var obj in pre_graphArray){
					if (typeof(pre_graphArray[obj][0]) !== 'undefined'){
						var count = pre_graphArray[obj].length;
						predate = pre_graphArray[obj][0].timestamp;
						//d1 - yellow
						//d2 - green
						if (count>0){
							var maxdate = pre_graphArray[obj][count-1].timestamp;
							if ((policy_info.storagertntype == 1 || policy_info.storagertntype == 2) && maxdate - dayInSec * policy_info.preservedaysmin < predate){
								self.d2.push([pre_graphArray[obj][0].timestamp*1000, pre_graphArray[obj][0].storageUsage/1024]);
							}else{
								self.d1.push([pre_graphArray[obj][0].timestamp*1000, pre_graphArray[obj][0].storageUsage/1024]);
							}
							var i = 1;
							while (i< count && predate<=maxdate){
								if ((policy_info.storagertntype == 1 || policy_info.storagertntype == 2) && maxdate - dayInSec * policy_info.preservedaysmin <= predate){
									if (predate + dayInSec < pre_graphArray[obj][i].timestamp){
										self.d2.push([(predate + dayInSec)*1000, 0]);
										predate = predate + dayInSec;
									}else{
										self.d2.push([pre_graphArray[obj][i].timestamp*1000, pre_graphArray[obj][i].storageUsage/1024]);
										predate = pre_graphArray[obj][i].timestamp;
										i++;
									}
								}else{
									if (predate + dayInSec < pre_graphArray[obj][i].timestamp){
										self.d1.push([(predate + dayInSec)*1000, 0]);
										predate = predate + dayInSec;
									}else{
										self.d1.push([pre_graphArray[obj][i].timestamp*1000, pre_graphArray[obj][i].storageUsage/1024]);
										predate = pre_graphArray[obj][i].timestamp;
										i++;
									}
								}
							}
						}
					}
				}
				self.initGraph();
			});

			self.addEventHandlers();
		});
/*		.fail(function() {
			this.retryInit(props);
		});	*/
	},

	drawNodeBars: function() {
		var self = this;
		$.when(
			$.ajax({
				async: true,
				url: '/api/call.php',
				dataType: "json",
				data: {'function': 'getNodeStorageUsageTotal', 'nodeid': this.nodeid, 'nodename': this.nodename}
			})
		).done(function(res_array) {
			var pre_graphArray = [];
			var policy_info = [];
			try {
				pre_graphArray = res_array.list;
			} catch (e) {
				self.retryInit(props);
			}

			var dayInSec = 24*60*60;
			var predate = 0;
			var i=0;
			for (var obj in pre_graphArray){
				//TODO get obj Name
				self.d1.push({ label: obj,  data: [[Math.round(pre_graphArray[obj].totalStorageUsage/1024),i]]});
				i--;
			}
			self.drawBars();
		});
	},


	drawNodePie: function() {
		var self = this;
		$.when(
			$.ajax({
				async: true,
				url: '/api/call.php',
				dataType: "json",
				data: {'function': 'getNodeStorageUsageTotal', 'nodeid': this.nodeid, 'nodename': this.nodename}
			})
		).done(function(res_array) {
			var pre_graphArray = [];
			var policy_info = [];
			try {
				pre_graphArray = res_array.list;
			} catch (e) {
				self.retryInit(props);
			}
			self.pre_graphArray = [];
			self.pre_graphArray = pre_graphArray;
			var dayInSec = 24*60*60;
			var predate = 0;
			var i=0;
			var tmpd1 = [];
			for (var obj in pre_graphArray){
				//TODO get obj Name
				tmpd1.push({ label: obj,  data: Math.round(pre_graphArray[obj].totalStorageUsage/1024)});
			}
			var count = tmpd1.length;

			var tmp = null;
			for (var i=0; i<count; i++){
				for (var j=0; j<count; j++){
					if (tmpd1[i]['data']>tmpd1[j]['data']){
						tmp = tmpd1[i];
						tmpd1[i] = tmpd1[j];
						tmpd1[j] = tmp;
					}
				}
			}

			for (var i=0; i<count; i++){
				if (i>TOP10){
					self.d1[TOP10] = { label: 'Other',  data: Math.round(self.d1[TOP10]['data']) +  Math.round(tmpd1[i]['data']), color: "rgb(125, 125, 125)"};
				}else{
					self.d1[i] = tmpd1[i];
				}
			}
			self.drawPie();
		});
	},

    drawPie: function() {
		var self = this;
		$.plot($("#player"), this.d1,
		{
			series: {
				pie: {
					show: true,
					radius: 1,
					label: {
						show: true,
						radius: 3/4,
						formatter: function(label, series){
							if(typeof(self.pre_graphArray[series.label]) != 'undefined'){
								return "<div style='font-size:8pt;text-align:center;padding:2px;color:white;' onclick='viewPopupGraphObjid("+series.label+',"'+escapeHtml(escapeHtml(self.pre_graphArray[series.label].fullname))+'"'+")'>"+self.pre_graphArray[series.label].udid+', '+Math.round(series.percent)+'%</div>';
							}else{
								return '<div style="font-size:8pt;text-align:center;padding:2px;color:white;">'+series.label+', ' + Math.round(series.percent)+'%</div>';
							}
						},
						background: { opacity: 0.5 }
					}
				}
			},
			legend: {
				show: true,
				labelFormatter: function(label, series){
					if(typeof(self.pre_graphArray[series.label]) != 'undefined'){
						return "<div style='cursor:pointer;font-size: 130%;' onclick='viewPopupGraphObjid("+series.label+',"'+escapeHtml(escapeHtml(self.pre_graphArray[series.label].fullname))+'"'+")'>"+escapeHtml(self.pre_graphArray[series.label].fullname)+', '+series.data[0][1]+' MB, ' + Math.round(series.percent)+'%</div>';
					}else{
						return '<div style="font-size: 130%;">'+series.label+', '+series.data[0][1]+' MB, ' + Math.round(series.percent)+'%</div>';
					}
				}
			},
			grid: {
				hoverable: true,
				clickable: true
			}
		});
		$("#player").bind("plothover", pieHover);
		$("#player").bind("plotclick", pieClick);

		function pieHover(event, pos, obj)
		{
			if (!obj) return;
		}

		function pieClick(event, pos, obj)
		{
			if (!obj) return;
			if(typeof(self.pre_graphArray[obj.series.label]) != 'undefined'){
				viewPopupGraphObjid(obj.series.label, escapeHtml(self.pre_graphArray[obj.series.label].fullname));
			}
		}
    },

    drawBars: function() {
		$.plot($("#player"), this.d1,
		{
            series: {
                bars: { show: true, horizontal: true, align: "center",
						lineWidth: 1,
						fill: true,
						fillColor: { colors: [ { opacity: 1 }, { opacity: 0.7 } ] }
				}
            },

			legend: {
				show: true,
				labelFormatter: function(label, series){
					return '<a href="/sdi/sm/index.php?objid=' + series.label+'"><div>'+series.label+', '+series.data[0][0]+' MB</div></a>';
				}
			},
            xaxis: {tickFormatter:
				function (v,b) {
					return v + " MB";
				},
				position: "top"
			},
            yaxis: {tickLength: 1,  tickFormatter:
				function (v,b) {
					return '';
				}
			}
		});
    },

	initGraph: function() {
		this.plotWithOptions();
	},

    plotWithOptions: function() {
		var self = this;
		var t = 0;
		var stack = 0, bars = true, lines = false, steps = false;
		var dayInSec = 24*60*60;
        $.plot($("#player"),
		[
			{ data: this.d3},
			{ data: this.d1, label: "May be Wiped", color: "rgb(255, 255, 0)", bars: { show: true }},
			{ data: this.d2, label: "Guaranteed Storage", color: "rgb(20, 200, 20)", bars: { show: true } }

		],

		{
            series: {
                bars: { show: true, barWidth: dayInSec*1000, align: "left" }
            },
			legend: { position: 'ne' },
            xaxes: [ { 
				tickFormatter: function (v) {
					if(v == 0){
						v = "No data in storage";
					}
					else{
						v = $.plot.formatDate(new Date(v), self.dateformat, null);
					}
					return v; 
				},
				mode: 'time', 
				minTickSize: [1, "day"], 
				axisLabel: 'Date, UTC'
			} ],
			yaxis: { tickFormatter: function (v) { return v + " MB"; }, minTickSize: 1, axisLabel: 'Utilization, MB' }
        }
		);
    },

	/**
	 * Wait until player loads, then init zone configurator and calibrators
	 */
	initPlayer: function() {
		this.player = null;
	},

	/**
	 * Add callbacks to all needed UI events
	 */
	addEventHandlers: function() {

/*		$('#VAE_MOTION_PIXELNOISE').change(function() {
			graphs.player.mdcalibrator.pixelNoiseLevel = $('#VAE_MOTION_PIXELNOISE').val();
		});
*/
		//$("#tabs_menu").data('tabs').click('zones');
	},

	/**
	 * Close graphs iframe and return to admin GUI (works only if page was opened from graphs tab in admin GUI)
	 */
	close: function() {
		parent.$('body').css({'position': 'static', 'overflow': 'visible'});
		parent.$('#overflower, #graphs_content').remove();
	}};

	function closeGraph()
	{
		$('body').css({'position': 'static', 'overflow': 'visible'});
		$('#overflower_obj, #graph_obj').remove();
	}

	function viewPopupGraphObjid(objid, title)
	{
		if (typeof(title) == 'undefined'){ title='';}
		$('body').append(
			'<div id="overflower_obj" style="width: 100%; height: 100%; position: absolute; top: 0; left: 0; opacity: 0.5; filter: alpha(opacity=50); background-color: white;"></div>' +
			'<iframe id="graph_obj" frameBorder="0" allowTransparency="true" src="/sdi/sm/index.php?objid=' + objid + '&popup=true&title='+encodeURIComponent(title)+'"></iframe>'
		);

		$('#graph_obj').css({
			'background-color': 'transparent',
			left: 0,
			top: '0px',
			width: '100%',
			height: $(window).height() - 50,
			position: 'absolute',
			'z-index': 10000,
			align: 'center',
			border: 'none'
		});
	}

function escapeHtml(unsafe) {
  return unsafe
      .replace(/&/g, "&amp;")
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;")
      .replace(/"/g, "&quot;")
      .replace(/'/g, "&#039;");
}
