<?php
	require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
	SessionManager::isUserLoggedIn() or SessionManager::redirect();

	if (isset($_GET['objid'])){
		$objid = intval($_GET['objid']);
	}else if (isset($_GET['nodename'])){
		$nodename = $_GET['nodename'];
		if (isset($_GET['graphtype'])){
			$graphtype = $_GET['graphtype'];
		}else{
			$graphtype = 'pie';
		}
	}else if (isset($_GET['nodeid'])){
		$nodeid = intval($_GET['nodeid']);
		if (isset($_GET['graphtype'])){
			$graphtype = $_GET['graphtype'];
		}else{
			$graphtype = 'pie';
		}
	}
	$popup = false;
	if (isset($_GET['popup'])){
		if($_GET['popup'] == 'true'){ $popup = true;}
	}

	$title = '';
	if (isset($_GET['title'])){
		$title = $_GET['title'];
	}

	//get short data format
	$sysDateFormat = Identity::getAttribute("NLS_LONG_DATE_FORMAT");
	$dateformat = "%om/%0d/%y, UTC";
	$delimer = "/";
	$pos = strpos($sysDateFormat, "/");
	if ($pos !== false) $delimer = "/";
	$pos = strpos($sysDateFormat, "-");
	if ($pos !== false) $delimer = "-";
	$pos = strpos($sysDateFormat, ".");
	if ($pos !== false) $delimer = ".";
	$sysDFParts = explode($delimer, $sysDateFormat);
	$phpDFParts = array();
	for ($i=0; $i<count($sysDFParts); $i++){
		switch ($sysDFParts[$i]){
			case "D": $phpDFParts[] = "%d";	break;
			case "DD": $phpDFParts[] = "%0d";	break;
			case "M": $phpDFParts[] = "%m";	break;
			case "MM": $phpDFParts[] = "%0m";	break;
			case "YY": $phpDFParts[] = "%y";	break;
			case "YYYY": $phpDFParts[] = "%y";	break;
		}
	}
	if (count($phpDFParts) > 0)
		$dateformat = implode($delimer, $phpDFParts);



?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<title>Storage Utilization</title>
	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<!--link rel="stylesheet" href="/sdi/lib/css/jaoselect/style.css" type="text/css"/-->
	<link rel="stylesheet" href="style.css" type="text/css"/>
	<script type="text/javascript" src="/sdi/lib/js/jquery.js"></script>

	<script src='/sdi/lib/js/jquery-ui.min.js' type='text/javascript' ></script>
	<script src='/sdi/lib/js/jquery-ui-timepicker-addon.js' type='text/javascript' ></script>

	<script type="text/javascript" src="/sdi/lib/js/jquery.databind.js"></script>
	<script type="text/javascript" src="/sdi/lib/js/jquery.tools.js"></script>
	<script type="text/javascript" src="/sdi/lib/js/jquery.mask.js"></script>
	<!--[if lte IE 8]><script language="javascript" type="text/javascript" src="/sdi/lib/js/excanvas.min.js"></script><![endif]-->
    <script type="text/javascript" src="/sdi/lib/js/jquery.flot.js"></script>
    <script type="text/javascript" src="/sdi/lib/js/jquery.flot.pie.js"></script>
    <script type="text/javascript" src="/sdi/lib/js/jquery.flot.axislabels.js"></script>
	<script type="text/javascript" src="/sdi/sm/js/sm_graph.js"></script>
	<script type="text/javascript" src="/sdi/lib/js/log.js"></script>

	<script type="text/javascript">
		$(document).ready(function() {
			<?php if ($popup):?>
				$('.tabs_manage_buttons_wrapper').show();
				$('#button_close').click(function() {
					parent.closeGraph();
				});
			<?php else: ?>
				$('.tabs_manage_buttons_wrapper').show();
				$('#button_close').click(function() {
					parent.Validate.DEFAULT.SM_GRAPH_CLOSE();
				});
			<?php endif;?>

			<?php
			if (isset($objid)):?>
				// by Obj ID
				graphs.init({type: "objid_bars", objid: '<?=$objid;?>', dateformat: '<?=$dateformat;?>'});
			<?php else:
				// by Node ID
				if (isset($nodeid)):
					if (isset($nodeid) && $graphtype == 'bars'):?>
						graphs.init({type: "nodeid_bars", nodeid: '<?=$nodeid;?>'});
					<?php else: ?>
						graphs.init({type: "nodeid_pie", nodeid: '<?=$nodeid;?>'});
					<?php endif;?>
				// by Node Name
				<?php else:
					if (isset($nodename)):
						if (isset($nodename) && $graphtype == 'bars'):?>
							graphs.init({type: "nodename_bars", nodename: '<?=$nodename;?>'});
						<?php else: ?>
							graphs.init({type: "nodename_pie", nodename: '<?=$nodename;?>'});
						<?php endif;?>
					<?php endif;?>

				<?php endif;?>
			<?php endif;?>
		});

	</script>
</head>
<body style="background:transparent; width=100%" id="sm_graph">

	<div id="tabs" class="tabs">
		<div class="tabs_menu_header">
			Storage Utilization  <?=$title;?>
			<span id="camera_name"></span>
		</div>

		<div class="tabs_content">
			<div style="margin:10px;">Statistical data is approximate and may be delayed.</div>
			<div id="player" style="width: 95%; height: 500px;margin:10px;">
			</div>

			<div class="tabs_manage_buttons_wrapper">
				<!--button id="button_apply">Apply changes</button-->
				<button id="button_close" title="Close">Close</button>
			</div>

			<div class="tabs_footer"></div>

		</div>

	</div>
</body>
</html>
