/*
# $Id: object_script.js 18912 2010-07-02 16:25:18Z tsibulskiy $
#------------------------------------------------------------------------------
# Object editor
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

define("sensoreditor", ["module", "jquery", "editor", "log"], function(module){
	"use strict";

	var BACKHREF = module.config().BACKHREF;
	var SETID = module.config().SETID;
	var TEMPLATETYPE = module.config().TEMPLATETYPE;

	var Editor = require("editor");

	var modbus_id;
	var node_id = '';
	var create_next = '';
	var hw_model ='';
	var type_select_val = 1;
	var modbus_select_val = 1;

	var editor = null;

	var api = new API();

	$(document).ready(
		function()
		{
			init();
			addEvents();
			$('#node_list option:first').prop("selected", true);
			$("#node_list").trigger("change")
		}
	);

	function init()
	{
		$("div.tabs").show();

		if (editor){
			editor.destroy();
		}

		$("#object_parameters_edit").slideUp("fast");
		$("#sensore_type_select").show();
		$("#modbus_select").hide();
		fillSelectbyObjectList('node', "#node_list");

		$("#node_select").show();
		$('#master1_next').prop("disabled", true);

		if (TEMPLATETYPE == 'sensor_skm'){
			$("#sensor_select").show();
			$("#reley_select").hide();
		}
		if (TEMPLATETYPE == 'relay'){
			$("#sensor_select").hide();
			$("#reley_select").show();
		}
		if (TEMPLATETYPE == 'external'){
			$("#sensor_select").hide();
			$("#reley_select").hide();
		}
	}

	function fillSelectbyObjectList(type, contlolid)
	{
		$("#node_list").mask();

		api.getObjectList({type: type, 'withAttributes': true})
			.fail(function(code, message){
				$("#main_block").html('');
				Log.error(message);
			})
			.done(function(response){
				var objectList = response.list;

				$(contlolid).html("");
				var objectselect = '';
				for (var i = 0; i < objectList.length; i++)
				{
					if (type == 'node')
					{
						objectselect += '<option value="' + objectList[i]["obj"] + '">' + objectList[i]["attributes"]["HOST"] + '</option>';
					} else {
						objectselect += '<option value="' + objectList[i]["obj"] + '">' + objectList[i]["name"] + '</option>';
					}
				}

				$(contlolid).html(objectselect);
			})
			.always(function(){
				$("#node_list").unmask();
			});
	}

	function create_object(type, attributes,  params)// go_back, create_next)
	{
		//$("#object_parameters_edit").show();
		var create_next = params.create_next || '';
		var goback = params.goback || '';
		var name = params.name || '';
		var backname = params.backname || '';
		var backhref = params.backhref || '';

		var buttons = {remove: {show: false}};

		if (goback === '')
		{
			buttons = {remove: {show: false},back: {show: false}};
		}

		editor = new Editor({
			id: "body",
			setid: SETID,
			type: type,
			notReload: true,
			attributes: attributes,
			name: name,
			backname: backname,
			backhref: backhref
		});
		editor.setButtons(buttons);

		editor.onReload = function()
		{
		};
		editor.onSave = function(obj)
		{
			obj = obj || null;

			if (obj && obj > 0) {
				//alert("Saved");
				if (type == "external" && create_next != ''){
					var attributes = {NODE_ID: obj, MODELID: "MODBUS"};
					var parameters = {};
					create_object(create_next, attributes, parameters);
				}else{
					cancelbutton(true);
				}
			}else{

				alert("Don't saved!");
			}
		};
		editor.onCancel = function()
		{
			cancelbutton();
		};
		editor.onBack = function()
		{
			$("div.tabs").show("fast");
			$("#"+goback).show("fast");
			editor.destroy();
			editor = null;
		};

		editor.init();
	}

	function cancelbutton(doReload){
		doReload = doReload || false;
		modbus_id = '';
		create_next = '';
		if (BACKHREF && BACKHREF != ''){
			top.location.hash = BACKHREF;
			if (doReload){
				top.location.reload();
			}
		}else{
			init();
		}

	}
	function addEvents()
	{
		//starting setting some animation when the ajax starts and completes
		$(document).ajaxStart(
			function()
			{
				$(this).show();
			}
		).ajaxComplete(
			function()
			{
				$(this).hide();
			}
		);

		$("#master1_cancel").click(
			function()
			{
				cancelbutton();
			}
		);

		$("#master1_next").click(
			function()
			{
				if (
					TEMPLATETYPE == 'sensor_skm'
					&&
					(type_select_val == 1
					|| type_select_val == 2
					|| type_select_val == 3
					|| type_select_val == 5
					|| type_select_val == 6
					|| type_select_val == 9
					|| type_select_val == 10
					|| type_select_val == 7)
				){
					$("#modbus_select").slideUp("fast");
					$("#sensore_type_select").slideUp("fast");
					$("div.tabs").slideUp("fast");

					if (type_select_val == 1) hw_model = 'AXIS';
					if (type_select_val == 2) hw_model = 'ACTi';
					if (type_select_val == 3) hw_model = 'SONY';
					if (type_select_val == 5) hw_model = 'FILE';
					if (type_select_val == 6) hw_model = 'SpotterRF';
					if (type_select_val == 9) hw_model = 'Boomerang';
					if (type_select_val == 10) hw_model = 'Textron';
					if (type_select_val == 7) hw_model = 'SIMULATED';

					var attributes = {HW_MODEL: hw_model, NODE_ID: node_id, MODELID: "SKM"};
					var params = {goback: 'sensore_type_select', name: __("Add new Sensor")};
					create_object(TEMPLATETYPE, attributes, params);

					hw_model = '';
				} else
				if (TEMPLATETYPE == 'sensor_skm'
					&& type_select_val == 8)
				{
					$("#modbus_select").slideUp("fast");
					$("#sensore_type_select").slideUp("fast");
					$("div.tabs").slideUp("fast");

					var attributes = {NODE_ID: node_id, MODELID: "TASS"};
					var params = {goback: 'sensore_type_select', name: __("Add new Sensor")};
					create_object(TEMPLATETYPE, attributes, params);

					hw_model = '';
				} else
				if ( (TEMPLATETYPE == 'sensor_skm' && type_select_val == 4)  || (TEMPLATETYPE == 'relay' && type_select_val == 2) ){
					hw_model = '';
					$("#sensore_type_select").slideUp("fast");
					$("#modbus_select").show("fast");
					// create modbus list
					fillSelectbyObjectList('external', "#control_list");
				}else
				if ( (TEMPLATETYPE == 'relay' && type_select_val == 1) ){
					$("#modbus_select").slideUp("fast");
					$("#sensore_type_select").slideUp("fast");
					$("div.tabs").slideUp("fast");
					hw_model = '';
					var attributes = {NODE_ID: node_id, MODELID: "SKM"};
					var params = {goback: 'sensore_type_select', name: __("Add new Relay")};
					create_object(TEMPLATETYPE, attributes, params);
					//view_object_parameters_edit(null, 'D', 'R', 'simply', false);
				}
				if ( (TEMPLATETYPE == 'external' && type_select_val == 1) ){
					$("#sensore_type_select").slideUp("fast");
					$("div.tabs").slideUp("fast");
					create_next = '';
					var attributes = {NODE_ID: node_id};
					var params = {goback: 'sensore_type_select', name: __("Add new External device")};
					create_object(TEMPLATETYPE, attributes, params);
				}
			}
		);
		$("#master2_cancel").click(
			function()
			{
				cancelbutton();
			}
		);
		$("#master2_back").click(
			function()
			{
				$("#modbus_select").slideUp("fast");
				$("#sensore_type_select").show("fast");
				modbus_id = '';
				create_next = '';
			}
		);
		$("#master2_next").click(
			function()
			{
				$("#modbus_select").slideUp("fast");
				if (modbus_select_val == 1){
					modbus_id = '';
					create_next = '';
					if (TEMPLATETYPE == 'sensor_skm' && type_select_val == 4){
						create_next = 'sensor_skm';
					}
					if (TEMPLATETYPE == 'relay' && type_select_val == 2){
						create_next = 'relay';
					}
					$("div.tabs").slideUp("fast");
					var attributes = {NODE_ID: node_id};
					var params = {goback: 'modbus_select', create_next: create_next, name: __("Add new External device")};
					create_object("external", attributes, params);
					//view_object_parameters_edit(null, 'D', 'E', null, false);
				}else{
					$("div.tabs").slideUp("fast");
					create_next = '';

					if (TEMPLATETYPE == 'sensor_skm' && type_select_val == 4){
						var attributes = {NODE_ID: modbus_id, MODELID: "MODBUS"};
						var params = {goback: 'modbus_select', name: __("Add new Sensor")};
						create_object(TEMPLATETYPE, attributes, params);
						//view_object_parameters_edit(null, 'D', 'S', 'modbus', false);
					}else
					if (TEMPLATETYPE == 'relay' && type_select_val == 2){
						var attributes = {NODE_ID: modbus_id, MODELID: "MODBUS"};
						var params = {goback: 'modbus_select', name: __("Add new Relay")};
						create_object(TEMPLATETYPE, attributes, params);
						//view_object_parameters_edit(null, 'D', 'R', null, false);
					}else{
						modbus_id = '';
						init();
					}
				}
			}
		);

		$("#control_list").change(
			function()
			{
				$("#master2_next").prop("disabled", false);
				modbus_id = $("#control_list").val();
			}
		);

		$("#node_list").change(
			function()
			{
				$("#master1_next").prop("disabled", false);
				node_id = $("#node_list").val();
			}
		);

		$("input[name='type_s_select']").click(
			function()
			{
				if ($("input[name='type_s_select']:checked").val()){
					type_select_val = $(this).val();
					if (type_select_val == 4)
					{
						$("#node_select").hide("fast"); $("#master1_next").prop("disabled", false);
					} else {
						$("#node_select").show("fast");
						if (node_id == ''){
							$('#master1_next').prop("disabled", true);
						}
					}
				}else{
					type_select_val = 1;
				}
				$(this).blur();
			}
		);
		$("input[name='type_r_select']").click(
			function()
			{
				if ($("input[name='type_r_select']:checked").val()){
					type_select_val = $(this).val();
					if (type_select_val == 2)
					{
						$("#node_select").hide("fast"); $("#master1_next").prop("disabled", false);
					} else {
						$("#node_select").show("fast");
						if (node_id == ''){
							$('#master1_next').prop("disabled", true);
						}
					}
				}else{
					type_select_val = 1;
				}
				$(this).blur();
			}
		);

		$("input[name='modbus_select']").click(
			function()
			{
				modbus_select_val = $(this).val();
				if ($(this).val() == 1){
					$("#control_list").slideUp("fast");
					$("#master2_next").prop("disabled", false);
				}else{
					$("#control_list").show("fast");
					var selectedText = $('#control_list option:selected').text();
					//check is selected
					if (typeof selectedText === 'undefined'
						||
						selectedText == ''
					)
					{
						$('#master2_next').prop("disabled", true);
					} else {
						$("#master2_next").prop("disabled", false);
					}
				}
			}
		);
	}

});
