<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$user = new User();

// check special credentials
$scFullDevice = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "F");
$scDeviceSettings = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "f");
$scDevicePolicy = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "R");
$scDeviceAnalytics = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "E");

?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Object GUI');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>
	<link href="/sdi/global/editor.css" rel="stylesheet" type="text/css"/>

	<script>
	<?php
		$BACKHREF = '';
		if (isset($_GET['backhref']))
		{
			$BACKHREF = htmlentities($_GET['backhref'], ENT_QUOTES, 'UTF-8');
		}
		$SETID = "";
		if (isset($_GET["setid"]))
		{
			$SETID = htmlentities($_GET["setid"], ENT_QUOTES, 'UTF-8');
		}

		$OTYPE = 'D';
		if (isset($_GET['otype']))
		{
			$OTYPE = htmlentities($_GET['otype'], ENT_QUOTES, 'UTF-8');
		}

		$SUBTYPE = 'S';
		if (isset($_GET['subtype']))
		{
			$SUBTYPE = htmlentities($_GET['subtype'], ENT_QUOTES, 'UTF-8');
		}

		$TEMPLATETYPE = "sensor";
		if (isset($_GET['template'])) {
			$TEMPLATETYPE = htmlentities($_GET['template'], ENT_QUOTES, 'UTF-8');
		}else{
			if ($OTYPE == 'D' && $SUBTYPE == 'S') $TEMPLATETYPE = "sensor_skm";
			if ($OTYPE == 'D' && $SUBTYPE == 'R') $TEMPLATETYPE = "relay";
			if ($OTYPE == 'D' && $SUBTYPE == 'E') $TEMPLATETYPE = "external";
		}
		if ($TEMPLATETYPE == "sensor_skm") $WIN_HEADER = __('Add new Sensor');
		if ($TEMPLATETYPE == "relay") $WIN_HEADER = __('Add new Relay');
		if ($TEMPLATETYPE == "external") $WIN_HEADER = __('Add new External');
	?>
	</script>
	<script>
		var scFullDevice = <?=$scFullDevice ? "true" : "false";?>;
		var scDeviceSettings = <?=$scDeviceSettings ? "true" : "false";?>;
		var scDevicePolicy = <?=$scDevicePolicy ? "true" : "false";?>;
		var scDeviceAnalytics = <?=$scDeviceAnalytics ? "true" : "false";?>;

		var require = {
			config: {
				sensoreditor: {
					BACKHREF: "<?=Purifier::clean($BACKHREF)?>",
					SETID: "<?=Purifier::clean($SETID)?>",
					TEMPLATETYPE: "<?=Purifier::clean($TEMPLATETYPE)?>"
				}
			},
			paths: {
				sensoreditor: "js/sensor_script"
			}
		};
	</script>
	<script src="/sdi/lib/js/require.js" data-main="sensoreditor"></script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?=Purifier::clean($WIN_HEADER);?>
				</div>
			</div>
		</div>
		<div class="tabs_content">

			<div id="main_block">
				<span id="loading" style="display:none; position:absolute; width:16px; height:16px; right:16px; top:16px;"><img src="img/ajax-loader.gif" alt="Loading"/></span>
				<div id="object_parameters_edit" style="clear: both; display:none;">
					<!--div class="darkgrayhead">Edit information for object</div-->
					<div id="object_parameters"></div>
				</div>

				<div id="sensore_type_select" style="clear: both;">
					<div id="sensor_select" class='tablestyle' style="display:none;">
						<div class="darkgrayhead" ><?php /* i18n: ... */ echo __("Select sensor type");?></div>
						<input type="radio" name="type_s_select" value="1" tabindex="1" checked="true" /><?php /* i18n: ... */ echo __("AXIS sensor");?><br/>
						<input type="radio" name="type_s_select" value="2" tabindex="2" /><?php /* i18n: ... */ echo __("ACTi sensor");?><br/>
						<input type="radio" name="type_s_select" value="3" tabindex="3" /><?php /* i18n: ... */ echo __("SONY sensor");?><br/>
						<!-- 2.7.1 Hide MODBUS functionality-->
						<!--input type="radio" name="type_s_select" value="4" tabindex="4" /><?php /* i18n: ... */ echo __("MODBUS sensor");?><br/-->
						<input type="radio" name="type_s_select" value="5" tabindex="5" /><?php /* i18n: ... */ echo __("FILE sensor");?><br/>
						<input type="radio" name="type_s_select" value="6" tabindex="6" /><?php /* i18n: ... */ echo __("SpotterRF sensor");?><br/>
						<input type="radio" name="type_s_select" value="9" tabindex="9" /><?php /* i18n: ... */ echo __("Boomerang sensor");?><br/>
						<input type="radio" name="type_s_select" value="10" tabindex="10" /><?php /* i18n: ... */ echo __("Textron sensor");?><br/>
						<input type="radio" name="type_s_select" value="7" tabindex="7" /><?php /* i18n: ... */ echo __("Simulated Radar sensor");?><br/>
						<? clearstatcache(); if (is_file(APL_VAR_PATH . "/lts/ACTIVATED")): ?>
						<input type="radio" name="type_s_select" value="8" tabindex="8" /><?php /* i18n: ... */ echo __("TASS sensor");?><br/>
						<? endif; ?>
					</div>
					<div id="reley_select" class='tablestyle' style="display:none;">
						<div class="darkgrayhead" ><?php /* i18n: ... */ echo __("Select relay type");?></div>
						<input type="radio" name="type_r_select" value="1" tabindex="1" checked="true" /><?php /* i18n: ... */ echo __("Relay");?><br/>
						<!-- 2.7.1 Hide MODBUS functionality-->
						<!--input type="radio" name="type_r_select" value="2" tabindex="2" /><?php /* i18n: ... */ echo __("MODBUS relay");?><br/-->
					</div>
					<div id="node_select" class='tablestyle' style="clear: both;display:none;">
						<div class="darkgrayhead" ><?php /* i18n: ... */ echo __("Select node");?></div>
						<select id="node_list" size="6" class="tablestyle" style="margin-left: 20px; width:300px;">
						</select>
					</div>
					<div class="objectlist_buttons" style="padding: 5px">
						<input class="button" onmouseout="this.className='button'" onmouseover="this.className='button_over'" type="button" value="<?php echo __("Cancel");?>" id="master1_cancel"/>
						<input class="button" onmouseout="this.className='button'" onmouseover="this.className='button_over'" type="button" value="<?php echo __("Next");?>" id="master1_next"/>
					</div>
				</div>

				<!-- 2.7.1 Hide MODBUS functionality-->
				<!--div id="modbus_select" style="clear: both;display:none;">
					<div class="darkgrayhead" ><?php /* i18n: ... */ echo __("MODBUS unit");?></div>
					<div id="select2" class='tablestyle'>
						<input type="radio" name="modbus_select" value="1" title="nnname1" tabindex="1" checked="true" /><?php /* i18n: ... */ echo __("Create new");?><br/>
						<input type="radio" name="modbus_select" value="2" title="nnname22" tabindex="2" /><?php /* i18n: ... */ echo __("Select from list");?><br/>

						<select id="control_list" size="6" class="tablestyle" style="margin-left: 20px; width:300px; display:none;">
						</select>
					</div>
					<div class="objectlist_buttons" style="padding: 5px">
						<input class="button" onmouseout="this.className='button'" onmouseover="this.className='button_over'" type="button" value="Cancel" id="master2_cancel"/>
						<input class="button" onmouseout="this.className='button'" onmouseover="this.className='button_over'" type="button" value="Back" id="master2_back"/>
						<input class="button" onmouseout="this.className='button'" onmouseover="this.className='button_over'" type="button" value="Next" id="master2_next"/>
					</div>
				</div-->
			</div>
		</div> <!--eof tabs_content -->
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
