/**
 * @version $Id: test.js 32504 2015-06-01 22:36:38Z astarostin $
 * ------------------------------------------------------------------------------
 * Media Player test
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2012
 * ------------------------------------------------------------------------------
 */

define("playerTest", ["jquery", "log", "i18n", "utils", "api", "mediaplayer"], function(){
	"use strict";

	$(document).ready(function(){

		var players = {};

		$.ajax({
			dataType: "json",
			url: "/api/call.php" ,
			data: {
				"function": "getObjectList",
				type: "camera"
			}
		}).done(function(result){
			if (result.error != "")
			{
				Log.error(result.error);
				return;
			}

			$(".players")
				.on("click", "button.play", function(){
					var obj = $(this).data("obj");
					players[obj].player.play();
				})
				.on("click", "button.pause", function(){
					var obj = $(this).data("obj");
					players[obj].player.pause();
				})
				.on("click", "button.stop", function(){
					var obj = $(this).data("obj");
					players[obj].player.stop();
					players[obj].player.printErrorMessage(__("Stop"));
				});

			for (var i = 0; i < result.list.length; i++)
			{
				var camera = result.list[i];

				var obj = camera.obj;
				players[obj] = {
					player: null
				};

				players[obj].player = new MediaPlayer();

				var wrapper =
					'<div id="player_' + obj + '" class="player">' +
						'<button class="play" data-obj="' + obj + '">&#9658;</button>' +
						'<button class="pause" data-obj="' + obj + '"><b>||</b></button>' +
						'<button class="stop" data-obj="' + obj + '">&#9632;</button>' +
						'<span class="timestamp"></span>' +
						'<div class="video"></div>' +
					'</div>';

				$(".players")
					.append(wrapper);

				(function(obj){
					players[obj].player
						.init("#player_" + obj + " .video")
						.done(function(){
							this.subscribe("frame", function(timestamp, width, height){
								var date = new Date();
								date.setTime(timestamp);
								$("#player_" + obj + " .timestamp").text(date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getMilliseconds());
							}, "player");

							this.play(obj);
						});
				})(obj);
			}
		});
	});

});
