/**
 * @version $Id: matrix.js 32641 2015-06-23 10:42:58Z astarostin $
 * ------------------------------------------------------------------------------
 * matrix lite
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2013
 * ------------------------------------------------------------------------------
 */

define("matrix", ["jquery", "api", "mediaplayer", "timeline", "i18n", "log"], function(){
	"use strict";

	var TimeLine = require("timeline");

	window.players = {};
	var api = new API();

	$(document).ready(function(){
		api.getObjectList({
			type: "camera",
			// setid: 119,
			withAttributes: true
		})
			.fail(function(error){
				Log.error(error);
			})
			.done(function(result){
				//createSyncedPlayers(result.list);
				createIndependentPlayers(result.list);
			});
	});

	function createIndependentPlayers(cameraList)
	{
		$(".players")
			.on("click", "button.play", function(){
				var obj = $(this).data("obj");
				players[obj].player.play();
			})
			.on("click", "button.pause", function(){
				var obj = $(this).data("obj");
				players[obj].player.pause();
			})
			.on("click", "button.stop", function(){
				var obj = $(this).data("obj");
				players[obj].player.stop();
				players[obj].player.printErrorMessage(__("Stop"));
			})
			.on("click", "button.close", function(){
				var obj = $(this).data("obj");
				$("#player_" + obj).remove();
			});

		$(".timeline").css({width: "1280px"});
		$("#timeline_id").css({position: "static", width: "1280px"});

		for (var i = 0; i < cameraList.length; i++)
		{
			var camera = cameraList[i];

			var obj = camera.obj;
			players[obj] = {
				player: null,
				timeline: null
			};

			players[obj].player = new MediaPlayer();
			var timeline_id = "timeline_" + obj;
			players[obj].timeline = new TimeLine({
				id: "#" + timeline_id,
				variableName: "window.players[" + obj + "].timeline",
				isDebug: false
			});

			var wrapper =
				'<div id="player_' + obj + '" class="player">' +
					'<div class="timeline"><div id="' + timeline_id + '"></div></div>' +
					'<div class="name">[' + camera.udid + '] ' + camera.name + '</div>' +
					'<button class="play" data-obj="' + obj + '">&#9658;</button>' +
					'<button class="pause" data-obj="' + obj + '"><b>||</b></button>' +
					'<button class="stop" data-obj="' + obj + '">&#9632;</button>' +
					'<span class="timestamp"></span>' +
					'<button class="close" data-obj="' + obj + '">X</button>' +
					'<div class="video"></div>' +
				'</div>';

			$(".players")
				.append(wrapper);

			players[obj].timeline.init();

			(function(obj){
				var timeline = players[obj].timeline;
				var player = players[obj].player;

				timeline.onLoad = function(){
					timeline.setParameters({
						selection: {fixed: false, visible: false},
						scale: {granularity: "min"}
					});
					timeline.setTime(Date.now(), true);

					timeline.onGetData = function(line, beginTime, endTime, granularity){
						var start = new Date();
						start.setTime(beginTime);
						var end = new Date();
						end.setTime(endTime);
						console.log("get data " + start.getHours() + ":" + start.getMinutes() + ":" + start.getSeconds() + " " + end.getHours() + ":" + end.getMinutes() + ":" + end.getSeconds());

						granularity = "chunk";
						var streamNumber = -1;
						$.ajax({
							url: "/storage/coverage",
							type: "GET",
							dataType: "json",
							cache: false,
							data: {
								obj: obj,
								startTime: Math.round(beginTime / 1000),
								endTime: Math.round(endTime / 1000),
								granularity: granularity,
								streamNumber: streamNumber
							},
							error: function(jqXHR){
								var code = jqXHR.status;
								var message = jqXHR.statusText;
								Log.error(message);
							},
							success: function(result){
								if (result.code == 200)
								{
									var list = [];

									var objList = Object.keys(result.list);
									if (objList.length > 0)
									{
										if (granularity == "chunk")
										{
											var getRow = function(timeStampList, color, borderColor)
											{
												var row = {list: {}, color: color, borderColor: borderColor};

												var min, max;
												var min = max = timeStampList[0];
												for (var i = 0; i < timeStampList.length; i++)
												{
													var timestamp = timeStampList[i];
													row.list[timestamp + '000'] = {
														percentage: 100
													};

													if (timestamp < min)
													{
														min = timestamp;
													}
													if (timestamp > max)
													{
														max = timestamp;
													}
												}

												var start = new Date();
												start.setTime(min * 1000);
												var end = new Date();
												end.setTime(max * 1000);
												console.log("set data " + start.getHours() + ":" + start.getMinutes() + ":" + start.getSeconds() + " " + end.getHours() + ":" + end.getMinutes() + ":" + end.getSeconds());

												return row;
											};

											// low resolution, blue
											list.push(getRow(result.list[objList[0]][0], 0x2e6fab, 0x2e6fab)); // 0x6785b4));
											// high resolution, red
											list.push(getRow(result.list[objList[0]][1], 0x9f2c35, 0x9f2c35)); // 0xcd2813));
										} else {
											var row = {list: {}, color: 0x83382f, borderColor: 0xcd2813};
											var percentageList = result.list[objList[0]];
											for (var timestamp in percentageList)
											{
												row.list[timestamp + '000'] = {
													percentage: percentageList[timestamp]
												};
											}
											list.push(row);
										}
									}

									timeline.setData(line, list);
								} else {
									Log.error(result.error);
								}
							}
						});
					};

					timeline.onTimeChange = function(time){
						player.pause();
						player.play(obj, time);
					};
				};

				player
					.init("#player_" + obj + " .video")
					.done(function(){
						this.subscribe("play", function(){
							$("#player_" + obj + " .timeline object").css({position: "static"});

							$("#player_" + obj + " .play").hide();
							$("#player_" + obj + " .pause").show();
						}, "player");

						this.subscribe("pause", function(code){
							$("#player_" + obj + " .play").show();
							$("#player_" + obj + " .pause").hide();
						}, "player");

						this.subscribe("frame", function(timestamp, width, height){
							var date = new Date();
							date.setTime(timestamp);
							$("#player_" + obj + " .timestamp").text(date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getMilliseconds());

							var isTimeSetted = timeline.setTime(timestamp, false);
							// maybe we set time not in user selection (if defined)
							if (!isTimeSetted)
							{
								player.pause();
							}
						}, "player");

						this.subscribe("imageclick", function(width, height, x, y){
							Log.info("Click " + obj + " " + width + "x" + height + " (" +  (x|0) + "," + (y|0) + ")");
						}, "zoom");

						this.play(obj);
					});
			})(obj);
		}
	}

	function createSyncedPlayers(cameraList)
	{
		var group = new MediaPlayerGroup();

		/**
        var isTimeSetted = timeline.setTime(timestamp, false);
        // maby we set time not in user selection (if defined)
        if (!isTimeSetted)
        {
            player.pause();
        }
 		 */

		$(".players")
			.on("click", "button.play", function(){
				group.play();
			})
			.on("click", "button.pause", function(){
				group.pause();
			})
			.on("click", "button.stop", function(){
				group.stop();
				group.printErrorMessage(__("Stop"));
			})
			.on("click", "button.close", function(){
				var obj = $(this).data("obj");
				$("#player_" + obj).remove();
				group.remove(obj);
			});

		var timeline_id = "timeline_id";

		window.timeline = new TimeLine({
			id: "#" + timeline_id,
			variableName: "window.timeline",
			isDebug: false
		});

		var timeline = window.timeline;
		timeline.init();
		timeline.onLoad = function(){
			timeline.setParameters({
				selection: {fixed: false, visible: false},
				scale: {granularity: "min"}
			});
			timeline.setTime(Date.now(), true);

			timeline.onTimeChange = function(time){
				group.pause();
				group.play(time);
			};
		};

		$(".timeline").css({width: "1280px"});
		$("#timeline_id").css({position: "static", width: "1280px"});

		for (var i = 0; i < cameraList.length; i++)
		{
			var camera = cameraList[i];

			var obj = camera.obj;
			players[obj] = {
				player: null
			};

			players[obj].player = new MediaPlayer();

			var wrapper =
				'<div id="player_' + obj + '" class="player">' +
					'<div class="name">[' + camera.udid + '] ' + camera.name + '</div>' +
					'<button class="play" data-obj="' + obj + '">&#9658;</button>' +
					'<button class="pause" data-obj="' + obj + '"><b>||</b></button>' +
					'<button class="stop" data-obj="' + obj + '">&#9632;</button>' +
					'<span class="timestamp"></span>' +
					'<button class="close" data-obj="' + obj + '">X</button>' +
					'<div class="video"></div>' +
				'</div>';

			$(".players")
				.append(wrapper);

			(function(obj){
				var player = players[obj].player;

				player
					.init("#player_" + obj + " .video")
					.done(function(){
						group.add(obj, this);

						this.subscribe("play", function(){
							$("#player_" + obj + " .play").hide();
							$("#player_" + obj + " .pause").show();
						}, "player");

						this.subscribe("pause", function(code){
							$("#player_" + obj + " .play").show();
							$("#player_" + obj + " .pause").hide();
						}, "player");

						this.subscribe("frame", function(timestamp, width, height){
							var date = new Date();
							date.setTime(timestamp);
							$("#player_" + obj + " .timestamp").text(date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + "." + date.getMilliseconds());
						}, "player");

						this.subscribe("imageclick", function(width, height, x, y){
							Log.info("Click " + obj + " " + width + "x" + height + " (" +  (x|0) + "," + (y|0) + ")");
						}, "zoom");

						this.play(obj);
					});
			})(obj);
		}
	}

});
