/**
 * @version $id:$
 * ------------------------------------------------------------------------------
 * evenlog test page
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

(function(window){
	"use strict";

	$(document).ready(function(){
		$("#pushMe").click(function(){
			window.eventLogClient = new EventLogClient();
			eventLogClient.init(".eventlog", {SESSION: "", MaxQueueSize: 40})
				.fail(function(){
					Log.error("Cannot init eventlog client");
				})
				.done(function(){
					eventLogClient.setEventFilter(0, false, -1, -1, "", "", 0, 0, 0, 0);

					eventLogClient.subscribe("objectchange", function(){
						Log.info("objectchange " + JSON.stringify(arguments));
					}, "eventLog");
					eventLogClient.subscribe("objectaction", function(){
						Log.info("objectaction " + JSON.stringify(arguments));
					}, "eventLog");
					eventLogClient.subscribe("elogaction", function(){
						Log.info("elogaction " + JSON.stringify(arguments));
					}, "eventLog");
					eventLogClient.subscribe("log", function(){
						console.log(arguments);
					}, "eventLog");
				});
		});
	});

})(window);
