<?php
/**
 * @version $Id: template.php 28114 2013-03-13 13:40:54Z astarostin $
 * ------------------------------------------------------------------------------
 * Interface template
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2013
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$position = isset($_GET["position"]) ? $_GET["position"] : "null";
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Map');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="/sdi/lib/css/smoothness/jquery-ui-1.10.4.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>
	<link href="map.css" rel="stylesheet" type="text/css"/>

	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/leaflet.draw.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/l.geosearch.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/MarkerCluster.Default.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/MarkerCluster.css" />

	<script>
		var require = {
			config: {
				map: {
					obj: null,
					position: <?=$position;?>
				}
			},
			paths: {
				"map": "js/map"
			}
		};
	</script>
	<script src="/sdi/lib/js/require.js" data-main="map"></script>
</head>
<body>
	<div id="camera" title="">
		<div class="player"></div>
	</div>

	<div id="buttons">
		<button class="targetList">Targets</button>
	</div>
	<div id="map_zone_manager">
		<div id="map_wrapper"><div class="map"></div></div>
		<div class="wrapper">
			<button class="pantocamera">Pan to camera</button>
			<div id="target_list">
				Target list<br/>
				<select multiple="multiple"></select>
				<button class="hide">Hide</button>
				<button class="show">Show</button>
			</div>
		</div>
	</div>
</body>
</html>
