/**
 * @version $Id: map.js 33095 2015-09-17 23:08:05Z astarostin $
 * ------------------------------------------------------------------------------
 * Map camera calibration tool
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2013
 * ------------------------------------------------------------------------------
 */

define("map", ["module", "jquery", "jquery.mask", "map2d"], function(module){
	"use strict";

	var Map2D = require("map2d");
	var cameraObj = module.config().obj;
	var position = module.config().position;

	$(document).ready(function(){
		$("#target_zone_manager").mask();

		var map = new Map2D(".map");

		window.map = map;

		map.init(position)
			.done(function(){
				$("#target_list select").click(function(){
					var obj = $(this).find("option:selected").data("obj");
					var id = $(this).find("option:selected").data("targetid");

					if (obj && id)
					{
						map.lockTarget(obj, id);
					}
				});

				$("#target_list button.hide").click(function(){
					var obj = $("#target_list select option:selected").data("obj");
					var id = $("#target_list select option:selected").data("targetid");

					if (obj && id)
					{
						map.hideTarget(obj, id);
					}
				});

				$("#target_list button.show").click(function(){
					var obj = $("#target_list select option:selected").data("obj");
					var id = $("#target_list select option:selected").data("targetid");

					if (obj && id)
					{
						map.showTarget(obj, id);
					}
				});

				$("#buttons button.targetList").click(function(){
					if ($("#target_list:visible").length > 0)
					{
						$("#map_wrapper").css("margin", "0 0 0 0");
						$(".wrapper").hide();
						map.getMap().invalidateSize();
					} else {
						$("#map_wrapper").css("margin", "0 150px 0 0");
						$(".wrapper").show();
						map.getMap().invalidateSize();
					}
				});
			})
			.always(function(){
				$("#map_zone_manager").unmask();
			});
	});

});
