<?php
/**
 * @version $Id: template.php 28114 2013-03-13 13:40:54Z astarostin $
 * ------------------------------------------------------------------------------
 * Interface template
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2013
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Monitoring zones configuration');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/leaflet.draw.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/l.geosearch.css" />

	<script>
		var require = {
			config: {
				map: {
					obj: <?=intval(Purifier::clean($_GET["obj"]));?>
				}
			},
			paths: {
				"map": "js/map"
			}
		};
	</script>
	<script src="/sdi/lib/js/require.js" data-main="map"></script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php print __("Monitoring zones configuration");?>
				</div>
			</div>
		</div>
		<div class="tabs_content">
            <div class="buttons">
                <button class="back">Back</button>
                <button class="cancel">Cancel</button>
                <button class="apply">Apply</button>
            </div>
			<div id="target_zone_manager">
				<div class="wrapper">
					<div id="camera"></div>
					<button class="pantocamera">Pan to camera</button>
					<div id="target_list">Target list<br/><select multiple="multiple"></select></div>
				</div>
				<div id="map_wrapper"><div class="map"></div></div>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
