<?php
/**
 * @version $Id: template.php 28114 2013-03-13 13:40:54Z astarostin $
 * ------------------------------------------------------------------------------
 * Interface template
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2013
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Map configuration');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="/sdi/lib/css/smoothness/jquery-ui-1.10.4.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>
	<link href="geozoneconfigurator.css" rel="stylesheet" type="text/css"/>

	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/leaflet.draw.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/l.geosearch.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/MarkerCluster.Default.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/MarkerCluster.css" />

	<script>
		var require = {
			config: {
				geozoneconfigurator: {
					obj: <?=intval(Purifier::clean($_GET["obj"]));?>
				}
			},
			paths: {
				geozoneconfigurator: "js/geozoneconfigurator"
			}
		};
	</script>
	<script src="/sdi/lib/js/require.js" data-main="geozoneconfigurator"></script>
</head>
<body>
	<div id="camera" title="">
		<div class="player"></div>
	</div>

	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text"><?=__("Map configuration");?></div>
			</div>
		</div>
		<div class="tabs_content">
            <div class="buttons">
                <button class="back">Back</button>
                <button class="cancel">Cancel</button>
                <button class="apply">Apply</button>
            </div>
			<div id="target_zone_manager">
				<div class="wrapper">
					<div id="camera"></div>
					<button class="pantocamera">Pan to camera</button>
					<div class="panel">
						<div id="target_list" class="element">
							<div class="header">Target list</div>
							<div class="content">
								<select multiple="multiple"></select>
							</div>
						</div>
						<div id="object_list" class="element">
							<div class="header">Building list</div>
							<div class="content">
								<div id="building_list">
									<button class="add">Add building</button><br/>
									<label>Name </label><input class="name" type="text" value=""/><br/>
									<select multiple="multiple"></select><br/>
									<button class="remove">Remove</button>
								</div>

								<div id="floor_list" class="hidden">
									<div>Floor list</div>
									<div class="content">
										<button class="add">Add floor</button><br/>
										<input type="file" id="block" name="block"><br/>
										<label>Name </label><input class="name" type="text" value=""/><br/>
										<select multiple="multiple"></select><br/>
										<button id="up_floor" class="hidden">Up</button>
										<button id="down_floor" class="hidden">Down</button>
										<button id="remove_floor">Remove</button>
									</div>
								</div>
							</div>
						</div>
						<div class="zoneList element">
							<div class="header">Zone list</div>
							<div class="content">
								<div class="zoneType">
									Zone type<br/>
									<input type="radio" name="zoneType" value="include" checked/> Include<br/>
									<input type="radio" name="zoneType" value="exclude"/> Exclude<br/>
								</div>
								<select multiple="multiple"></select>
							</div>
						</div>
					</div>
				</div>
				<div id="map_wrapper"><div class="map"></div></div>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
