<?php
/**
 * @version $Id:$
 * ------------------------------------------------------------------------------
 * PTZ Camera placement tool
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2013
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$obj = 0;
if (!empty($_GET["obj"]))
{
	$obj = Purifier::clean($_GET["obj"]);
}
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('PTZ Camera placement tool');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>
	<link href="geocalibrator.css" rel="stylesheet" type="text/css"/>
	<link href="geoCalibratorPTZ.css" rel="stylesheet" type="text/css"/>

	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/leaflet.draw.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/l.geosearch.css" />

	<script src="/sdi/lib/js/require.js"></script>
	<script>
		require(["geocalibratorptz"], function(){
			var GEOCalibratorPTZ = require("geocalibratorptz");
			window.GEOCalibratorPTZ = null;
			$(document).ready(function(){
				window.GEOCalibratorPTZ = new GEOCalibratorPTZ();
				window.GEOCalibratorPTZ.init(<?=$obj?>);
			});
		});
	</script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php print __("PTZ Camera placement tool");?>
				</div>
			</div>
		</div>
		<div class="tabs_content">
			<div class="buttons">
				<button class="back">Back</button>
				<button class="cancel">Cancel</button>
				<button class="apply">Apply</button>
			</div>
			<div id="helpMessage"></div>
			<div id="attribute_wrapper">
				<label data-attr="CAM_GEO_LAT">Latitude [&deg;]</label><div class="attribute" data-attr="CAM_GEO_LAT"></div><br/>
				<label data-attr="CAM_GEO_LONG">Longitude [&deg;]</label><div class="attribute" data-attr="CAM_GEO_LONG"></div><br/>
				<label data-attr="CAM_GEO_ALT">Altitude [m]</label><div class="attribute" data-attr="CAM_GEO_ALT"></div><br/>
				<label data-attr="CAM_GEO_NORTH_OFFSET">North offset angle [&deg;]</label><div class="attribute" data-attr="CAM_GEO_NORTH_OFFSET"></div><br/>
			</div>
			<div class="players">
				<div class="player">
					<div class="video"></div>
					<input class="timestamp" readonly/>
					<div class="click"></div>
					<div class="pointList">
						<div>
							<button class="camera">Place camera</button>
							<button class="marker">Place marker</button>
						</div>
					</div>
				</div>
				<div class="player">
					North offset:
					<button class="north_offset_minus_20">-20&deg;</button>
					<button class="north_offset_minus_5">-5&deg;</button>
					<button class="north_offset_minus_05">-0.5&deg;</button>
					<button class="north_offset_plus_05">+0.5&deg;</button>
					<button class="north_offset_plus_5">+5&deg;</button>
					<button class="north_offset_plus_20">+20&deg;</button>
					<br/>
					Tilt:
					<button class="tilt_minus_5">-5&deg;</button>
					<button class="tilt_minus_05">-0.5&deg;</button>
					<button class="tilt_plus_05">+0.5&deg;</button>
					<button class="tilt_plus_5">+5&deg;</button>
					<div class="map"></div>
				</div>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
