<?php
/**
 * @version $Id: geoCalibrator.php 33091 2015-09-16 23:14:01Z astarostin $
 * ------------------------------------------------------------------------------
 * Camera placement tool
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2013
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$obj = 0;
if (!empty($_GET["obj"]))
{
	$obj = Purifier::clean($_GET["obj"]);
}
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Camera placement tool');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>
	<link href="geocalibrator.css" rel="stylesheet" type="text/css"/>

	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/leaflet.draw.css" />
	<link rel="stylesheet" href="/sdi/lib/js/3rdparty/leaflet/leaflet-plugins/css/l.geosearch.css" />

	<script src="/sdi/lib/js/require.js"></script>
	<script>
		require(["geocalibrator"], function(){
			var GEOCalibrator = require("geocalibrator");
			window.geoCalibrator = null;
			$(document).ready(function(){
				window.geoCalibrator = new GEOCalibrator();
				window.geoCalibrator.init(<?=$obj?>);
			});
		});
	</script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php print __("Camera placement tool");?>
				</div>
			</div>
		</div>
		<div class="tabs_content">
			<div class="buttons">
				<button class="back">Back</button>
				<button class="cancel">Cancel</button>
				<button class="apply">Apply</button>
			</div>
			<div class="players">
				Review the camera view projection rectangle in "Test mode" and test projection accurateness with mouse-click on the video.<br/>
				If camera view projection figure is wrong, try correcting your calibration points.<br/>
				To set more precise point point position, you can use digital zoom with mouse wheel.<br/>
				<div class="player">
					<p>Click, to create new point</p>
					<div class="video"></div>
					<input class="timestamp" readonly/>
					<div class="click"></div>
					<div class="pointList">
						<fieldset>
							<legend>Point list</legend>
							<div>
								<button class="edit">Edit mode</button>
								<button class="test">Test mode</button>
								<button class="camera">Place camera</button>
							</div>
							<select class="list" multiple="multiple"></select>
							<div>
								<button class="remove">Remove</button>
							</div>
						</fieldset>
					</div>
				</div>
				<div class="player">
					<p>Choose position for selected point</p>
					<div class="map"></div>
				</div>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
