<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

$reason = "";
if (isset($_GET["reason"]))
{
	$reason = $_GET["reason"];
}

if (!SessionManager::isUserLoggedIn())
{
	if ($reason == "") $reason = "SESSION_EXPIRED";
} else {
	$correctCSRF = true;
	if (Identity::getAttribute("CHECK_CSRFTOKEN") == "yes"
		&&
		isset($_SERVER["HTTP_X_TOKEN"]) && !SessionManager::checkCSRFToken($_SERVER["HTTP_X_TOKEN"])
	)
	{
		$correctCSRF = false;
		$reason = "INCORRECT_REQUEST";
	}

	if (isset($_SESSION[SESSION_USERNAME]) && $correctCSRF)
	{
		$sessionId = session_id();
		$userId = $_SESSION[SESSION_USERID];
		SessionManager::closeSession();

		Audit::addRecordVArg(3, null, $userId,
			Audit::attrValueEntity('IP', $_SERVER['REMOTE_ADDR']),
			Audit::attrValueEntity('SessionId', $sessionId));
	}
}

$logout_message = array(
	""                      => __("Your session has been closed"),
	"SESSION_EXPIRED"       => __("Your session has expired"),
	"SESSION_TERMINATED"    => __("Your session was forcefully terminated"),
	"COOKIE_SETTINGS_ERROR" => __("Cookie settings not found"),
	"INCORRECT_REQUEST"     => __("Incorrect request"),
	"INCORRECT_FLASH"       => __("You do not have Flash Player or Flash Player versions earlier than 9.0. Please install Flash Player version 9.0 or higher."),
	"INCORRECT_JAVA"        => __("Your browser does not support Java, or your Java version less then 1.6. Please download last version of JRE for your platform")
);
$message = $logout_message[$reason];

?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Logout');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>
</head>
<body>
	<div class="wrapper">
		<div class="centered">
			<div class="frame_wrapper">
				<div class="tabs">
					<div class="tabs_menu">
						<div class="single_tab">
							<div class="tab_text">
								<?php print __("Logout");?>
							</div>
						</div>
					</div>
					<div class="tabs_content" align="center">
						<table width="100%" border="0" align="center">
							<tr align="center">
								<td align="center"><br><div align="center"><strong><?=htmlentities($message, ENT_QUOTES, "UTF-8");?></strong><br></div></td>
							</tr>
							<tr>
								<td align="center" valign="middle"><br><div align="center"><a href="/sdi/login/index.php"><?php /* i18n: ... */ echo __("Please click here to login");?></a></div><br></td>
							</tr>
						</table>
					</div>
					<div class="tabs_footer"></div>
				</div>
			</div>
			<div class="footer">
				<div class="copyright">
					<?php include $_SERVER['APL'] . '/sdi/html/global/copyright.php';?>
				</div>
			</div>
		</div>
	</div>
</body>
</html>
