(function(window){
	"use strict";

	var loginTTL = 5;

	var LDAP_AUTHENTICATION = false;
	var bannerInclude = window.bannerInclude;
	var isWarning = window.isWarning;
	var message = window.message;
	var pki_dn_login = window.pki_dn_login;
	var encryptionKey = "";

	$(document).ready(
		function()
		{
			if (bannerInclude){
				$('#login_tabs').hide();
				$('#banner').show();
			}else{
				$('#login_tabs').show();
				$('#banner').hide();
			}

			$("#ok_banner").click(function()
			{
				$('#login_tabs').show();
				$('#banner').hide();
			});

			$("#cancel_banner").click(function()
			{
				logout();
			});

			if (isWarning)
			{
				return;
			}

			showLabels({'username':'', 'password':''});
			checkBrowserType();
			setLoginTimeout();

			if (message.length > 0)
			{
				displayMessage(message);
			}

			var api = new API();
			api.getLoginInfo()
				.done(function (response) {
					encryptionKey = response.loginInfo.encryptionKey;
					loginTTL = parseInt(response.loginInfo.loginTTL, 10);
					LDAP_AUTHENTICATION = response.loginInfo.LDAP_AUTHENTICATION;

					if (LDAP_AUTHENTICATION)
					{
						$.ajax({
							url: "/api/ntlm_auth_request.php",
							dataType: 'json'
						})
							.always(function(response, textStatus, jqXHR){
								if (textStatus == "success")
								{
									var userName = response.user;

									if (userName != "")
									{
										$("label[for='username']").hide();
										$("#username")
											.prop("disabled", true)
											.val(userName);

										$("label[for='password']").hide();
										$("#password").hide();
									}
								} else {
									displayMessage(response.statusText);
								}

								addEvents();

								$("#login").prop("disabled", false);
							});
					} else {
						addEvents();

						$("#login").prop("disabled", false);
					}
				});
		}
	);

	function addEvents()
	{
		$("#language").change(function()
		{
		    if (location.protocol === 'https:') {
			    setCookie("language", $("#language").val(), 365 * 60 * 60 * 24, "/", "", "1");
			} else {
				setCookie("language", $("#language").val(), 365 * 60 * 60 * 24, "/");
			}
			window.location.reload();
		});

		$("#username, #password").keydown(function(event){
			if (event.which == 13) {
				event.preventDefault();

				$("#login").click();
			}
		});

		$("#login").click(function()
		{
			var username = $("#username").val().trim();
			var password = $("#password").val().trim();

			if (username.length === 0 || (password.length === 0 && !pki_dn_login))
			{
				if (username.length === 0)
				{
					displayMessage('Missing username');
					$("#username").focus();
				} else {
					displayMessage('Missing password');
					$("#password").focus();
				}
				setLoginTimeout();
			} else {
				var tmpHash = CryptoJS.SHA512(password).toString(CryptoJS.enc.Hex);
				var passwordHash = CryptoJS.SHA512(encryptionKey + tmpHash + encryptionKey).toString(CryptoJS.enc.Hex);

				var credentials = passwordHash;

				var data = {
					name: username,
					credentials: credentials
				};

				if (LDAP_AUTHENTICATION)
				{
					data.password = password;
				}

				var api = new API();
				api.login(data)
					.fail(function(code, message){
						displayMessage(__('Error') + ': [' + code + '] ' + message);
						$("#password").val('');
						$("#password").focus();
					})
					.done(function(response){
						if (location.protocol === 'https:') {
							setCookie("language", $("#language").val(), 365 * 60 * 60 * 24, "/", "", "1");
						} else {
							setCookie("language", $("#language").val(), 365 * 60 * 60 * 24, "/");
						}

						var redirectLocation = "/sdi/login/check.php";

						var redirect = getGETParameter("redirect");
						if (redirect != null && redirect.charAt(0) == "/")
						{
							redirectLocation = redirect;
						}
						window.location = redirectLocation + "?" + Date.now();
					});
			}
		});
	}

	function getGETParameter(val)
	{
		var result = null, tmp = [];
		location.search
			//.replace("?", "")
			.substr(1)
			.split("&")
			.forEach(function (item) {
				tmp = item.split("=");
				if (tmp[0] === val)
				{
					result = decodeURIComponent(tmp[1]);
				}
			});
		return result;
	}

	var timer = null;

	function setLoginTimeout()
	{
		if (loginTTL > 0)
		{
			if (timer != null)
			{
				clearTimeout(timer);
			}
			timer = setTimeout(logout, loginTTL * 60 * 1000);
		}
	}

	function clearLoginTimeout()
	{
		if (timer != null)
		{
			clearTimeout(timer);
		}
	}

	function logout()
	{
		window.location.href = '/sdi/login/logout.php?token=' + getToken();
	}

	function displayMessage(msg)
	{
		document.getElementById('message').innerHTML = msg;
	}

	function checkBrowserType()
	{
		var ua = window.navigator.userAgent.toLowerCase();
		var platform = window.navigator.platform.toLowerCase();

		var IE = (ua.indexOf("msie") != -1 && ua.indexOf("opera") == -1);
		var Opera = (ua.indexOf("opera") != -1);
		var Gecko = (ua.indexOf("gecko") != -1);
		var Chrome = (ua.indexOf("chrome") != -1);
		var Safari = (ua.indexOf("safari") != -1);
		var iPhone = (ua.indexOf("iphone") != -1);
		var Konqueror = (ua.indexOf("konqueror") != -1);

		var notify = false;
		var message = "";
		if (IE)
		{
			var uaVers = parseFloat(ua.substr(window.navigator.userAgent.indexOf("MSIE") + 5, 3));
			if (uaVers < 10)
			{
				message = "Internet Explorer " + uaVers;
			}
		}
		else if (iPhone)
		{
			message = /* i18n: do not translate <be /> and other tags */ __('Web application is not compatible with iPhone.<be />Please go to <a href="http://cavu.me/">CAVU.me</a> for iPhone application.');
		}
		else if (Safari && !Chrome)
		{
			//message = "Safari";
			// May be we need to check for Safari and version in future
			var regffver = ua.match(/Version\/(\d*.\d*)/ig);
			var uaVers = regffver[0].replace("version/", "");

			if (uaVers < 4 || platform.indexOf("mac") == -1)
			{
				message = "Safari " + uaVers;
			}
		}
		else if (Chrome)
		{
			message = "Google Chrome";
		}
		else if (Gecko)
		{
			message = "Mozilla/Fixefox";
			//mozilla/5.0 (windows nt 6.1; wow64; rv:5.0) gecko/20100101 firefox/5.0
			var regffver = ua.match(/firefox\/(\d*.\d*)/ig);
			var uaVers = regffver ? regffver[0].replace("firefox/", "") : "";
			message = "Mozilla/Fixefox " + uaVers;
		}
		else if (Opera)
		{
			message = "Opera";
		}
		else if (Konqueror)
		{
			message = "Konqueror";
		}
		else
		{
			message = window.navigator.userAgent;
		}

		//if need notification
		if (message != "")
		{
			//if iPhone
			if (!iPhone)
			{
				message = Gettext.strargs(__("Browser [%1] was detected.<br />Please use Safari 7+ (Mac) or Internet Explorer 10+ (Windows) for the best user experience"), [message + '-' + window.navigator.platform]);
			}
			document.getElementById("browser_type").innerHTML = message;
		}
	}

	function showLabels(inputs)
	{
		if (typeof(inputs) != "object") return;
		function inputValueSH(someinput)
		{
			if (someinput.value) pSib(someinput).style.top = '-9999px';
			else pSib(someinput).style.top = '0';
		}
		function pSib(obj)
		{
			while (obj = obj.previousSibling)
			if (obj.nodeType != 3)
				return obj;
			return null;
		}
		for (var i in inputs)
		{
			var obj = document.getElementById(i);
			if(obj !== null){
				obj.onblur = function(){ inputValueSH(this);};
				obj.onfocus = function(){ pSib(this).style.top = '-9999px';	};
				inputValueSH(obj);
			}
		}
	}

})(window);
