/**
 * @version $Id: check.js 33599 2016-02-16 16:02:02Z astarostin $
 * ------------------------------------------------------------------------------
 * check configuration
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require(["jquery", "password_editor", "api", "swfobject", "i18n", "jquery.mask", "utils"], function(){
	"use strict";

	var PasswordEditor = require("password_editor");

	var nextPageURL = window.nextPageURL;
	var isShowLicense = window.isShowLicense;
	var servoffset = window.servoffset;
	var servdst = window.servdst;
	var isWarning = window.isWarning;
	var curd = window.curd;
	var api = new API();

	$(document).ready(
		function()
		{
			var check = function()
			{
				checkIsLicenseAccepted(function(){
					checkSystem();
				});
			};

			var passwordEditor = new PasswordEditor();
			var result = passwordEditor.init({
				selector: "#password_editor",
				success: function(){
					check();
				}
			});

			if (!result)
			{
				check();
			}
		}

	);

	function checkSystem()
	{
		/*
		var sessionManager = new SessionManager();
		sessionManager.init("#session_manager .tabs_content");
		sessionManager.fillSessionList(function(){
			$("#session_manager .tabs_content .object_list").treeview({
				animated: "fast",
				collapsed: true,
				unique: true
			});
			$("#session_manager .tabs_content .object_list").delegate(".clickable_area", "click", function (e){
				$(this).parent().children("div.hitarea").trigger("click");
			});
		});
		*/

		$("#nextPage").click(
			function()
			{
				window.location.href = nextPageURL;
			}
		);

		$("#warning_wrapper").mask();

		var isFlash = checkFlash();
		var reason = "";

		if (!isFlash)
		{
			reason = "INCORRECT_FLASH";

			var html = "<ul>"
				+ "<li>ALERT: Your browser does not appear to have the correct version of Flash plugin installed! This will prevent you from controlling archive video and using some system features! <a href=\"http://get.adobe.com/flashplayer/\">Download Flash</a>.</li>"
				+ "</ul>";
			$('.warning').prepend(html);
			isWarning = true;
		}

		$("#nextPage").prop("disabled", false);

		$.when(
			Utils.checkPlugin("/sdi/player/manifest.json", "Video Player"),
			Utils.checkPlugin("/ptz/manifest.json", "Hardware Joystick"),
			Utils.checkPlugin("/matrix/manifest.json", "MatrixCore"),
			compareTimezone()
		)
			.fail(function(){
				isWarning = true;
			})
			.done(function(){
				// go to the next page;
				if (!isWarning)
				{
					window.location.href = nextPageURL;
				}
			})
			.always(function(){
				$("#warning_wrapper").unmask();
			});
	}

	function compareTimezone()
	{
		var deferred = $.Deferred();

		api.getServerTime()
			.done(function(response){
				var TZcompare = true;
				var localTZattr = getTimeZoneAttr();
				if (servoffset == localTZattr[1] && servdst == localTZattr[2]){
					TZcompare = false;
				}
				var timeCompare = Math.round(Math.abs(response.servertime - localTZattr[0]));
				if (timeCompare <= 5) timeCompare = 0;

				var html = "";
				if (TZcompare){
					html += "<li>" + __("WARNING: Your browser time zone setting is different from the server time zone.") +"<br/>" + __("Please ask your Administrator to check application settings: Settings -> Identity -> Time Zone") + "</li>";
				}
				if (timeCompare){
					html += "<li>" + Gettext.strargs(__("WARNING: Time shift between your client station and server was identified and it is %1 seconds."), timeCompare) + "<br/>" + __("Please make sure to synchronize your time as this may affect your user experience.") + "</li>";
				}
				if (html != "")
				{
					$('.warning').append("<ul>" + html + "</ul>");
					isWarning = true;

					deferred.reject();
				} else {
					deferred.resolve();
				}
			});

		return deferred.promise();
	}

	function getTimeZoneAttr()
	{
		var rightNow = new Date();
		var jan1 = new Date(rightNow.getFullYear(), 0, 1, 0, 0, 0, 0);
		var temp = jan1.toGMTString();
		var jan2 = new Date(temp.substring(0, temp.lastIndexOf(" ") - 1));
		var std_time_offset = (jan1 - jan2) / (1000);

		var june1 = new Date(rightNow.getFullYear(), 6, 1, 0, 0, 0, 0);
		temp = june1.toGMTString();
		var june2 = new Date(temp.substring(0, temp.lastIndexOf(" ") - 1));
		var daylight_time_offset = (june1 - june2) / (1000);
		var dst;
		if (std_time_offset == daylight_time_offset)
		{
			dst = "0"; // daylight savings time is NOT observed
		} else {
			dst = "1"; // daylight savings time is observed
		}

		var timestamp = curd.getTime() / 1000;
		return [timestamp, std_time_offset, dst];
	}

	/**
	 * check for correct flash configuration
	 *
	 * @returns {Boolean}
	 */
	function checkFlash()
	{
		return typeof swfobject === "undefined" ? false : swfobject.hasFlashPlayerVersion("9.0.0");
	}

	/**
	 * check is user accepted "License Agreement"
	 *
	 * @param {function} callback
	 * @returns {boolean}
	 */
	function checkIsLicenseAccepted(callback)
	{
		if (!isShowLicense)
		{
			callback();
			return true;
		}

		var content = $("body div").not('#session_manager');
		content.hide();

		var licenseHTML = '' +
			'<div class="tabs license">' +
				'<div class="tabs_menu">' +
					'<div class="single_tab">' +
						'<div class="tab_text">' + __("License Agreement")+'</div>' +
					'</div>' +
				'</div>' +
				'<div class="tabs_content" align="center">' +
					'<div id="license_frame">' +
						'<iframe scrolling="auto" height="450" align="left" src="/common/sla.htm"></iframe>' +
					'</div>' +
					'<button id="license_acknowledge">' + __('Acknowledge') + '</button>' +
				'</div>' +
				'<div class="tabs_footer"></div>' +
			'</div>';

		$('body').prepend(licenseHTML);

		$('#license_acknowledge').on('click', function(){
			api.acceptLicense()
				.done(function(response){
					$('div.license').remove();
					content.show();

					callback();
				})
				.fail(function(code, message){
					Log.error(__("License Agreement acknowledge connection error: " + message));
				});
		});

		return false;
	}
});
