<?php
/**
 * @version $Id: index.php 34752 2016-05-19 17:53:10Z astarostin $
 * ------------------------------------------------------------------------------
 * login screen
 * ------------------------------------------------------------------------------
 * @author
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

# Direct login to node is forbidden
if (!Node::isMaster()) {
    header("location: login2node.php");
}

$systemStatus = Node::getSystemStatus();
$warningMessage = Node::getWarningFormattedMessage();
/**
 * @var string
 */
$isWarning = in_array($systemStatus["status"], array("OFFLINE", "BROKEN"));

$isConnected = true;
if (!DB::checkConnection()){
	$isConnected = false;
	$isWarning = true;
	$warningMessage = __("Unable to connect to SQL server.");
	$warningMessage = '<ul><li>' . $warningMessage . '</li></ul>';
}

$_REQUEST['init'] = 1;

$message = "";
$title = "";
$brand = "";

$sessionManager = new SessionManager();
if (!in_array($systemStatus["status"], array("OFFLINE", "BROKEN")) && $isConnected)
{
	if (SessionManager::isUserLoggedIn())
	{
		$redirectLocation = "/sdi/login/check.php";
		if (!empty($_GET["redirect"]) && $_GET["redirect"][0] == "/")
		{
			$redirectLocation = $_GET["redirect"];
		}
		SessionManager::redirect($redirectLocation);
	} else {
		$sessionManager->startTempSession();
	}

	$title = Identity::getAttribute('NAME');

	$nodeInfo = Node::getInfo();
	$brandName = "STRATUS";
	$edition = $nodeInfo['edition'] != "" ? $nodeInfo['edition'] : $brandName;
	if($edition == ""){
		$edition = $nodeInfo['brand'];
	}
	$brand = $edition . " by videoNEXT";
}

$bannerContent = '';
$bannerExists = file_exists($_SERVER['APL'] . '/sdi/html/login/banner-large.htm');
if ($bannerExists) $bannerContent = file_get_contents($_SERVER['APL'] . '/sdi/html/login/banner-large.htm');

$PKI_DN_LOGIN = false;
if(isset($_SERVER['SSL_CLIENT_VERIFY']) && $_SERVER['SSL_CLIENT_VERIFY'] == "SUCCESS"){
	$PKI_DN_USERS = $sessionManager->getUsersWithPKIDN($_SERVER['SSL_CLIENT_S_DN']);
	$PKI_DN_LOGIN = true;
}

// load AdminUI configuration
$UICfg = Node::getAdminUIConfig();

header("Cache-Control: no-cache, no-store");
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php print $title; ?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link rel="shortcut icon" href="/sdi/login/favicon.ico" type="image/x-icon" />

	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<link rel="stylesheet" href="style.css" type="text/css" />

	<script>
		// with no js you see labels
		document.write('<style type="text/css">label {position: absolute; top: -9999px;}<\/style>');

		// deny open in iframe
		if (top.location != self.location)
		{
			top.location = self.location;
		}
	</script>
	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/es5-shim.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="/sdi/lib/js/cryptojs.sha512.js"></script>
	<script src="/sdi/lib/js/sha1.js"></script>
	<script src="/sdi/lib/js/api.js"></script>
	<script>
		var pki_dn_login = "<?=$PKI_DN_LOGIN ? "true" : "false";?>";

		var message = '<?=$message;?>';
		var brand = '<?=$brand;?>';

		var isWarning = <?=$isWarning ? "true" : "false";?>;
		var bannerInclude = <?=$bannerExists ? "true" : "false";?>;
	</script>
	<script src="js/login_script.js"></script>
</head>
<body>
	<div class="wrapper">
		<div class="frame_wrapper" style='width:500px;'>
		    <noscript>
		        <P style="font-size:28px;font-weight:bold;text-align:center;">You must enable JavaScript<br>to access this system.</P>
		    </noscript>
			<div class="tabs" id="banner" style='width:500px;display:none;'>
				<div class="tabs_menu">
					<div class="single_tab">
						<div class="tab_text"></div>
					</div>
				</div>
				<div class="tabs_content" style="padding:0px 15px 15px 15px;">
					<?php print $bannerContent; ?>
					<div style="text-align:center;margin-top:20px;">
						<input id="ok_banner" type="button" value="<?php echo __("Ok");?>" style="width: 100px; margin-right:40px;">
						<input id="cancel_banner" type="button" value="<?php echo __("Cancel");?>"  style="width: 100px;">
					</div>
				</div>
				<div class="tabs_footer"></div>
			</div>
		</div>
		<div class="centered">
			<div class="frame_wrapper">

				<div class="tabs" id="login_tabs" style='display:none;'>
<!-- CLARE_REPLACE_LOGIN_ID001_BEGIN -->
					<div class="tabs_menu">
						<div class="single_tab">
							<div class="tab_text"></div>
						</div>
					</div>
<!-- CLARE_REPLACE_LOGIN_ID001_END -->
<!-- CLARE_REPLACE_LOGIN_ID002_BEGIN -->
					<div class="tabs_content">
<!-- CLARE_REPLACE_LOGIN_ID002_END -->
						<?php if (in_array($systemStatus["status"], array("OFFLINE", "BROKEN")) || !$isConnected): ?>
							<div class="warning" id='login_warning'>
								<?php print $warningMessage; ?>
							</div>
						<?php elseif ($PKI_DN_LOGIN && count($PKI_DN_USERS) == 0): ?>
							<div class="warning" id='login_warning' style="margin: 0px 10px">
								<p style="margin-bottom:15px;margin-top:0px;"><strong>AUTHORIZATION DENIED for:</strong></p>
								<p style="font-size: .8em"><?php print str_replace(",", "<br>",$_SERVER['SSL_CLIENT_S_DN']); ?></p>
							</div>
						<?php else: ?>
							<img src="/sdi/global/img/logo.png" id="login_img_logo" style="margin-top:-5px;padding-bottom:3px;" />
							<? if(isset($UICfg['Login.ProductShortname.show']) && $UICfg['Login.ProductShortname.show'] == "yes"){ ?>
								<div id="brand"><?=$edition;?></div>
							<? } ?>
							<p id="message"></p>
							<form action="#" method="post" onsubmit="return false" autocomplete="off">
								<?php if($PKI_DN_LOGIN): ?>
									<div class="label_input">
										<label for="username"><?php /* i18n: username on login screen*/ echo __("Username");?></label>
										<select style="width:250px" name="username" size="1" id="username" tabindex="3" class="textfield">
											<?php for ($i=0; $i<count($PKI_DN_USERS); $i++): ?>
											<option <?php if($i == 0){ print 'selected="true"'; } ?> value="<?php print $PKI_DN_USERS[$i]; ?>"><?php print $PKI_DN_USERS[$i]; ?></option>
											<?php endfor ?>
										</select>
									</div>
								<?php else: ?>
									<div class="label_input">
										<label for="username"><?php /* i18n: username on login screen*/ echo __("Username");?></label>
										<input type="text" name="username" id="username"/>
									</div>
									<div class="label_input">
										<label for="password"><?php /* i18n: password on login screen*/ echo __("Password");?></label>
										<input type="password" name="password" id="password"/>
									</div>
								<?php endif ?>
								<div class="label_input">
									<label for="language"><?php /* i18n: language selector on login screen*/ echo __("Language");?></label>
									<select style="width:250px" name="language" size="1" id="language" tabindex="3" class="textfield">
									<?php $default_lang = isset($_COOKIE["language"]) ? $_COOKIE["language"] : Identity::getAttribute('SYSTEM_LANGUAGE'); ?>
									<?php foreach (getLanguageList() as $lang => $lang_descr): ?>
										<?php if ($default_lang == $lang): ?>
											<option selected="true" value="<?php print $lang; ?>"><?php print __($lang_descr['name']); ?></option>
										<?php else: ?>
											<option value="<?php print $lang; ?>"><?php print __($lang_descr['name']); ?></option>
										<?php endif ?>
									<?php endforeach ?>
									</select>
								</div>
								<input type="submit" value="<?php /* i18n: Login button on login screen*/ echo __("Login");?>" id="login" disabled>
							</form>
						<?php endif ?>
					</div>
					<div class="tabs_footer"></div>
				</div>
			</div>
			<div id="browser_type"></div>
			<div class="footer">
				<div class="copyright">
					<?php include $_SERVER['APL'] . '/sdi/html/global/copyright.php';?>
				</div>
			</div>
		</div>
	</div>
</body>
</html>
