<?php
/*
# $Id: gui_list.php 31894 2015-03-09 14:49:38Z atsybulnik $
#------------------------------------------------------------------------------
# GUI selector screen to be shown after login
#------------------------------------------------------------------------------
# Author: Andriy Baranetskiy / Andriy Fomenko
# Edited by: Andrey Starostin
# QA by:?
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$userId = $_SESSION[SESSION_USERID];
$userName = $_SESSION[SESSION_USERNAME];

$user = new User();
$guis = $user->getGuis($userId);

$str1 = __("Control Panel");
$str2 = __("System parameters");
$str3 = __("Matrix");
$str4 = __("Operator screens");

if (count($guis) == 1)
{
	print '<html> <meta http-equiv="refresh" content="0;url=\''. $guis[0]["attributes"]['URL'] . '\'"></html>';
	exit;
}
$title = Identity::getAttribute('NAME');
?>

<!DOCTYPE html>
<html>
<head>
	<title><?php print $title; ?> <?php /* i18n: Selector of application */ echo __("GUI Selector");?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<link rel="stylesheet" href="style.css" type="text/css" />

	<script data-main="js/gui_list.js" src="/sdi/lib/js/require.js"></script>
</head>
<body>
	<div class="logout">
		<a href="/sdi/login/logout.php?token=<?=SessionManager::getCSRFToken();?>"><?php /* i18n: Logout */ echo __("Logout");?></a>
	</div>
	<div class="wrapper">
		<div class="centered">
			<div class="frame_wrapper">
				<div class="tabs">
					<div class="tabs_menu">
						<div class="single_tab">
							<div class="tab_text"><?php /*List of interfaces*/print __("Interfaces");?></div>
						</div>
					</div>
					<div class="tabs_content">
						<?php foreach($guis as $gui): ?>
							<div class="list_element" data-url="<?php print $gui["attributes"]['URL']; ?>">
								<div class="content">
									<div class="arrow">
										<img src="/sdi/global/img/arrow_right.png"/>
									</div>
									<div class="text">
										<p class="link"><?php print __($gui['name']); ?></p>
										<p class="description"><?php print __($gui['description']); ?></p>
									</div>
								</div>
							</div>
						<?php endforeach ?>
					</div>
					<div class="tabs_footer"></div>
				</div>
			</div>
			<div class="footer">
				<div class="copyright">
					<?php include $_SERVER['APL'] . '/sdi/html/global/copyright.php';?>
				</div>
			</div>
		</div>
	</div>
</body>
</html>
