<?php
/**
 * @version $Id: check.php 33107 2015-09-24 22:07:50Z astarostin $
 * ------------------------------------------------------------------------------
 * check configuration
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::isUserLoggedIn(SessionManager::SESSION_STATUS_PASSWORD_EXPIRED) or SessionManager::redirect();

$proto = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';

$nextPageUrl = "/sdi/login/gui_list.php";
if (isset($_GET['form']) && isset($_GET['snapshotid'])
	&& $_GET['form'] == 'evu' && intval($_GET['snapshotid']) > 0)
{
	$nextPageUrl = "/sdi/evu/eventlist.php?snapshotid=" . intval($_GET['snapshotid']);
}

$servtimezone = Identity::getAttribute('TIME_ZONE');
date_default_timezone_set($servtimezone);
$year = date('Y');

$dateTimeZoneCurr = new DateTimeZone($servtimezone);
$dateTimeZoneUTC = new DateTimeZone("UTC");

$janDateCurr = new DateTime($year . '-01-01', $dateTimeZoneCurr);
$janDateUTC = new DateTime($year . '-01-01', $dateTimeZoneUTC);
$std_time_offset = $dateTimeZoneCurr->getOffset($janDateUTC);

$junDateCurr = new DateTime($year . '-06-06', $dateTimeZoneCurr);
$junDateUTC = new DateTime($year . '-06-06', $dateTimeZoneUTC);
$summ_time_offset = $dateTimeZoneCurr->getOffset($junDateUTC);

if ($std_time_offset == $summ_time_offset)
{
	$servdst = "0";
} else {
	$servdst = "1";
}
$servoffset = $std_time_offset;
$servtime = time();

$warningMessage = Node::getWarningFormattedMessage();

/**
 * get message if Maintence Expire date more then current date
 * @static
 * @return string
 */
function getMaintenceExpireMessage()
{
	return !va_me() ? __('WARNING: Maintenance period expired. Please update your license.') : "";
}

$maintenceExpireMessage = getMaintenceExpireMessage();
if ($maintenceExpireMessage != "")
{
	$warningMessage .= "<ul><li>$maintenceExpireMessage</li></ul>";
}

$userid = $_SESSION[SESSION_USERID];
$user = new User();
$roleid = intval($user->getAttribute($userid, 'DEFAULT_ROLE'));
if (!isset($roleid) || $roleid == '' || $roleid == 0)
{
	$roleid = 0;
	$roles = $user->getRoles($userid);
	if (isset($roles[0])) $roleid = $roles[0]['obj'];
}

// check for disabling warnings (except license expiration)
$WARN_SUPPRESSION = false;
if ($roleid > 0)
{
	$role = new Role();
	$WARN_SUPPRESSION = Template::boolVal($user->getAttribute($roleid, 'WARN_SUPPRESSION'));
	if ($WARN_SUPPRESSION)
	{
		$warningMessage = "";
	}
}

// check for password expiration
if ($user->isPasswordExpired($userid))
{
	$warningMessage = "<ul><li>" . __("WARNING: Password expired") . '<div id="password_editor"></div>' . "</li></ul>"
	                  . $warningMessage;
}

$isWarning = $warningMessage == "";

$isLicenseAccepted = $user->isLicenseAccepted($userid);
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Check configuration');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="/sdi/lib/css/jquery.treeview/jquery.treeview.css" rel="stylesheet" type="text/css" />
	<link href="/sdi/lib/css/password_editor.css" rel="stylesheet" type="text/css"/>

	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script>
		var servtimezone = '<?=$servtimezone;?>';
		var curd = new Date();
		var servoffset = <?=$servoffset;?>;
		var servdst = <?=$servdst;?>;

		var nextPageURL = '<?=$nextPageUrl;?>';
		var isWarning = <?=$isWarning ? "true" : "false";?>;

		var isShowLicense = <?=$isLicenseAccepted ? "false" : "true";?>;
	</script>

	<script data-main="js/check.js" src="/sdi/lib/js/require.js"></script>
</head>
<body>
	<div class="logout">
		<a href="/sdi/login/logout.php?token=<?=SessionManager::getCSRFToken();?>"><?php /* i18n: Logout */ echo __("Logout");?></a>
	</div>
	<div class="wrapper">
		<div class="centered">
			<div id="session_manager" class="tabs">
				<div class="tabs_menu">
					<div class="single_tab">
						<div class="tab_text">
							<?php print __("Session manager");?>
						</div>
					</div>
				</div>
				<div class="tabs_content">
				</div>
				<div class="tabs_footer"></div>
			</div>
			<div class="frame_wrapper">
				<div class="tabs">
					<div class="tabs_menu">
						<div class="single_tab">
							<div class="tab_text">
								<?php print __("Check configuration");?>
							</div>
						</div>
					</div>
					<div class="tabs_content">
						<div id="warning_wrapper">
							<div class="warning">
								<?php
									print $warningMessage;
								?>
							</div>
							<div class="tabs_manage_buttons_wrapper">
								<input type="button" value="Next" id="nextPage" disabled/>
							</div>
						</div>
					</div>
					<div class="tabs_footer"></div>
				</div>
			</div>
			<div class="footer">
				<div class="copyright">
					<?php include $_SERVER['APL'] . '/sdi/html/global/copyright.php';?>
				</div>
			</div>
		</div>
	</div>
</body>
</html>
