/**
 * @version $id:$
 * ------------------------------------------------------------------------------
 * different additional functions
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

/*
var Foo = function () {alert('Foo');};

Foo.prototype.a = function () { alert('1'); };

var Bar = function () {alert('Bar');};
Utils.inherit(Bar, Foo);

Bar.prototype.a = function () {
Bar.superproto.a.call(this);
alert('2');
};

var bar = new Bar();

bar.a();
*/

(function(window){
	"use strict";

	window.Utils = {
		/**
		 *
		 * @param child
		 * @param parent
		 * @returns {*}
		 */
		inherit: function (child, parent) {
			function F() {}
			F.prototype = parent.prototype;
			child.prototype = new F();
			child.prototype.constructor = child;
			child.superproto = parent.prototype;
			return child;
		},

		/**
		 * add event listener
		 *
		 * @param {HTMLElement|EventTarget} obj
		 * @param {String} eventName
		 * @param {Function} callback
		 */
		addEvent: function(obj, eventName, callback)
		{
			// IE11
			if (((navigator.appName == 'Netscape') && (new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})").exec(navigator.userAgent) != null)))
			{
				obj["on" + eventName] = callback;
			} else
			// IE
			if ($.browser.msie)
			{
				obj.attachEvent("on" + eventName, callback);
			} else {
				obj.addEventListener(eventName, callback, false);
			}
		},

		/**
		 * remove event listener
		 *
		 * @param {HTMLElement|EventTarget} obj
		 * @param {String} eventName
		 * @param {Function} callback
		 */
		removeEvent: function(obj, eventName, callback)
		{
			// IE
			if ($.browser.msie)
			{
				obj.detachEvent("on" + eventName, callback);
			} else {
				obj.removeEventListener(eventName, callback, false);
			}
		},

		/**
		 *
		 * @param {[Number, Number, Number]} point
		 * @param {Number} width
		 * @param {Number} height
		 * @returns {[Number, Number, Number]}
		 */
		normalize: function(point, width, height)
		{
			var N = [
				[2 / width, 0,          -1],
				[0,         2 / height, -1],
				[0,         0,           1]
			];

			return this.multiply(N, point);
		},

		/**
		 *
		 * @param {[Number, Number, Number]} point
		 * @param {Number} width
		 * @param {Number} height
		 * @returns {[Number, Number, Number]}
		 */
		denormalize: function(point, width, height)
		{
			var dN = [
				[width / 2, 0,          width / 2],
				[0,         height / 2, height / 2],
				[0,         0,          1]
			];

			return this.multiply(dN, point);
		},

		/**
		 *
		 * @param {Array} m
		 * @param {[Number, Number, Number]} v
		 * @returns {[Number, Number, Number]}
		 */
		multiply: function(m, v)
		{
			var result = [];

			result[0] = m[0][0] * v[0] + m[0][1] * v[1] + m[0][2] * v[2];
			result[1] = m[1][0] * v[0] + m[1][1] * v[1] + m[1][2] * v[2];
			result[2] = m[2][0] * v[0] + m[2][1] * v[1] + m[2][2] * v[2];

			return result;
		},

		/**
		 * check for correct vnMPlayer configuration
		 *
		 * @param {string} url
		 * @param {string} name
		 */
		checkPlugin: function(url, name)
		{
			var deferred = $.Deferred();

			$.ajax({
				url: url,
				cache: false,
				dataType: "json"
			})
				.fail(function(){
					Log.error(__("Cannot connect to server"));
				})
				.done(function(manifest){
					var platform = "";
					if (navigator.appVersion.indexOf("Win") != -1)
					{
						platform = "win32";
					} else
					if (navigator.appVersion.indexOf("Mac") != -1)
					{
						platform = "macos";
					}

					if (typeof manifest.platform[platform] != "undefined")
					{
						var mime = manifest.platform[platform].mime;

						// ex: mime = "application/x-vnmplayer";
						var id = "test_Plugin_" + Date.now() + "_" + Math.round(Math.random() * 1000);
						var html = '<object id="' + id + '" type="' + mime + '" width="1" height="1"></object>';
						$("body").append(html);
					}

					var plugin = document.getElementById(id);
					var isOK = plugin && typeof plugin.version != "undefined";

					if (isOK)
					{
						deferred.resolve();
					} else {
						var message = name + " for your system is not supported, use Windows or Mac only";

						var platform = "";
						if (navigator.appVersion.indexOf("Win") != -1)
						{
							platform = "win32";
						} else
						if (navigator.appVersion.indexOf("Mac") != -1)
						{
							platform = "macos";
						}

						if (typeof manifest.platform[platform] != "undefined")
						{
							var path = manifest.platform[platform] ? manifest.platform[platform].url : "";
							if (path != "")
							{
								message = name + ' plugin is not installed or broken. <a href="' + path + '">Download installer</a>, run it and restart your browser.';
							}
						}

						var html =
							"<ul>"
								+ "<li>ALERT: " + message + "</li>"
							+ "</ul>";
						$('.warning').prepend(html);

						deferred.reject();
					}
				});

			return deferred.promise();
		}
	};

})(window);
