/**
 * @version $Id: systemobject.js 28444 2013-04-23 15:42:10Z astarostin $
 * ------------------------------------------------------------------------------
 * SystemObject
 * Used for edit, get parameters of system objects
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

function SystemObject(type)
{
	this.type = type || "DEFAULT";

	this.functions = {
		type: {
			DEFAULT: {
				create: "addObject",
				remove: "deleteObject",
				setAttributes: "setAttributes",
				getAttribute: "getAttribute",
				getAttributes: "getAttributes",
				getBlocksURL: "getBlocksURL",
				getTemplates: "getTemplates"
			},
			identity: {
				create: null,
				remove: null,
				setAttributes: "setIdentityAttributes",
				getAttribute: "getIdentityAttribute",
				getAttributes: "getIdentityAttributes"
			}
		}
	};

	this.getFunction = function(name)
	{
		var func = null;

		if (this.functions.type[this.type] && this.functions.type[this.type][name])
		{
			func = this.functions.type[this.type][name];
		} else {
			func = this.functions.type.DEFAULT[name];
		}

		return func;
	};

	this.create = function(params)
	{
		params.type = params.type || null;
		params.attributes = params.attributes || null;
		params.nodeid = params.nodeid || null;
		params.setid = params.setid || null;
		params.callback = params.callback || null;

		var data = {
			"function": this.getFunction("create"),
			attributes: JSON.stringify(params.attributes),
			type: params.type
		};

		if (params.nodeid) data.nodeid = params.nodeid;
		if (params.setid) data.setid = params.setid;

		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: true,
			type: "POST",
			data: data,
			success: function(json)
			{
				if ($.isFunction(params.callback))
					params.callback(json);
			},
			error: function()
			{
			}
		});
	};

	this.remove = function(params)
	{
		params.obj = params.obj || null;
		params.objList = params.objList || [];
		params.callback = params.callback || null;

		if (params.objList.length == 0)
		{
			params.objList.push(params.obj);
		}

		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: true,
			type: "POST",
			data: {
				"function": this.getFunction("remove"),
				objList: JSON.stringify(params.objList)
			},
			success: function(json)
			{
				if ($.isFunction(params.callback))
					params.callback(json);
			},
			error: function()
			{
			}
		});
	};

	this.setAttributes = function(params)
	{
		params.obj = params.obj || null;
		params.attributes = params.attributes || null;
		params.callback = params.callback || null;

		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: true,
			type: "POST",
			data: {
				"function": this.getFunction("setAttributes"),
				obj: params.obj,
				attributes: JSON.stringify(params.attributes)
			},
			success: function(json)
			{
				if ($.isFunction(params.callback))
					params.callback(json);
			},
			error: function()
			{
			}
		});
	};

	this.getAttributes = function(params)
	{
		params.obj = params.obj || null;
		params.callback = params.callback || null;

		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: true,
			cache: false,
			data: {
				"function": this.getFunction("getAttributes"),
				obj: params.obj
			},
			success: function(json)
			{
				if ($.isFunction(params.callback))
					params.callback(json);
			},
			error: function()
			{
			}
		});
	};

	this.getAttribute = function(params)
	{
		params.obj = params.obj || null;
		params.attribute = params.attribute || null;
		params.callback = params.callback || null;

		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: true,
			cache: false,
			data: {
				"function": this.getFunction("getAttribute"),
				obj: params.obj,
				attribute: params.attribute
			},
			success: function(json)
			{
				if ($.isFunction(params.callback))
					params.callback(json);
			},
			error: function()
			{
			}
		});
	};

	this.getTemplates = function(params)
	{
		params.obj = params.obj || null;
		params.setid = params.setid || null;
		params.nodeid = params.nodeid || null;
		params.attributes = params.attributes || null;
		params.callback = params.callback || null;

		var data = {
			"function": this.getFunction("getTemplates")
		};

		if (params.obj) {
			data.objList = JSON.stringify([params.obj]);
			if ((params.type || null) && params.type=='virtualposture') {
				data.type = params.type;
			}
		}else
		if (params.setid)
		{
			data.setid = params.setid;
			if (params.type)
				data.type = params.type;
		}
		else
		if (params.nodeid)
		{
			data.nodeid = params.nodeid;
			if (params.type)
				data.type = params.type;
		}
		else
			data.type = this.type;

		if (params.attributes) data.attributes = JSON.stringify(params.attributes);

		$.ajax({
			url: "/api/call.php",
			dataType: "json",
			async: true,
			cache: false,
			data: data,
			success: function(json)
			{
				if ($.isFunction(params.callback))
					params.callback(json);
			},
			error: function()
			{
			}
		});
	};
}
